/*
** VGA240.H
**
** Various functions for working in the 320x240 "tweaked" mode of the VGA
**
** Documentation is in VGA240.DOC
**
*/

/* This next line is for compiling with a C++ compiler */
#ifdef __cplusplus
extern "C"
{
#endif

#define asmdecl extern void cdecl

/* Initialization routine and deinitialization routine
*/
asmdecl graphinit(int width,int psize);

/* Graphics primitives
*/
asmdecl line(int x1,int y1,int x2,int y2,int c);
asmdecl box(int x1,int y1,int x2,int y2,int c);
asmdecl hline(int x1,int x2,int y,int c);
asmdecl vline(int x1,int y1,int y2,int c);
asmdecl hbar(long addr,unsigned int count,int c);

/* Palette routines
*/
asmdecl setDAC(char cval,char red,char green,char blue);

/* Page routines
*/
asmdecl copypage(int src,int dest);
asmdecl usepage(int p);
asmdecl showpage(int p);
asmdecl clearpage(int c);
asmdecl flippage(void);
asmdecl copyregion(int spage,int sx1,int sy1,int sx2,int sy2,int dx1,int dy1);

/* Video buffer start selecting routine
*/
asmdecl setstart(int addr);

/* Video mode selecting routine
*/
asmdecl textmode(int modenum);

/* Font displaying routine (monochrome bitmap really)
**
**
** fontdata points to the following information:
** *(fontdata+0)   : Font height in pixels.
** *(fontdata+1)   : Font width in pixels.
** *(fontdata+2+n) : Font bitmap. Stored as a series of complete bytes,
**                   the number of which should be (width+7)/8 per row.
*/
asmdecl writechar2(int x,int y,int c,char far *fontdata);


/* Bitmap routines
*/
asmdecl putblock(void far *buffer);
asmdecl getblock(int x1,int y1,int sizex,int sizey,void far *buffer);

asmdecl mcopyregion(int page, int sx1,int sy1,int sx2,int sy2,
			char far *mask,int dx1,int dy2);
asmdecl genbmask(char far *source,char far *mask,char transp);
asmdecl cnvbmask(char far *mask,int size);
asmdecl putimage(int x,int y, char far *image);
#ifdef __cplusplus
}
#endif
