
#include <stdlib.h>
#include <stdio.h>
#include <dos.h>
#include <math.h>
#include <mem.h>
#include <alloc.h>
#include <io.h>
#include <fcntl.h>
#include <string.h>
#include "vga240.h"

#define KEYBD  0x9    /* INTERRUPT 9 */

#define RIGHT_ARROW_PRESSED   77
#define RIGHT_ARROW_RELEASED  205
#define UP_ARROW_PRESSED      72
#define UP_ARROW_RELEASED     200
#define LEFT_ARROW_PRESSED    75
#define LEFT_ARROW_RELEASED   203
#define DOWN_ARROW_PRESSED    80
#define DOWN_ARROW_RELEASED   208
#define CONTROL_PRESSED	      29
#define CONTROL_RELEASED      157
#define ESCAPE		      1
#define HOME_PRESSED	      71
#define HOME_RELEASED	      199
#define PGUP_PRESSED	      73
#define PGUP_RELEASED	      201
#define PGDN_PRESSED	      81
#define PGDN_RELEASED	      209
#define END_PRESSED	      79
#define END_RELEASED	      207
#define PLUS_PRESSED	      78
#define PLUS_RELEASED	      206
#define MINUS_PRESSED	      74
#define MINUS_RELEASED	      202

volatile unsigned char scanCode;

struct{
    int rightArrow;
    int leftArrow;
    int upArrow;
    int downArrow;
    int home;
    int pgup;
    int pgdn;
    int end;
    int control;
    int alt;
    int plus;
    int minus;
    int escape;
}keyBoard;

char numLockKeyStatus;

void interrupt (*oldvec)();
void interrupt myInt();

void DrawLine(int,int,int,int,int);
void SetPixel(int,int,int);
void DspString(int,int,char *,int);
void SetVmode(int);
void keyCheck(void);

	long	LastX1;
	long	LastY1;
	int	LastPosn;
	int	PageNum;
	FILE	*dfp;


/* Map of walls. This array is used to build the xRay and yRay grids */
/* when checking the x and y vectors */

unsigned char	Grid[] = {2,6,4,3,6,5,8,9,2,3,
			  3,0,0,0,4,0,0,0,0,4,
			  4,0,0,0,6,0,0,0,0,5,
			  3,0,0,0,5,0,3,4,3,6,
			  2,0,0,0,0,0,0,0,0,5,
			  9,6,5,8,9,0,4,3,6,8,
			  8,0,0,0,0,0,0,0,0,9,
			  5,0,0,0,6,0,0,0,0,2,
			  6,0,0,0,5,0,0,0,0,3,
			  3,4,3,2,9,8,5,6,3,4
			};



#define GRID_WIDTH  10
#define GRID_HEIGHT 10
#define GRID_MAX    GRID_WIDTH * GRID_HEIGHT
#define GRID_XSTEP  64				/* X distance between walls */
#define GRID_YSTEP  64				/* Y distance between walls */
#define GRID_XMAX   GRID_XSTEP * GRID_WIDTH
#define GRID_YMAX   GRID_YSTEP * GRID_HEIGHT

#define BITMAP_HEIGHT	64
#define BITMAP_WIDTH	64

#define ANGLE_0		0			/* Angles used for lookup */
#define ANGLE_30	171			/*  tables...		  */
#define ANGLE_45	256
#define ANGLE_60	341
#define ANGLE_90	512
#define ANGLE_180	1024
#define ANGLE_270	1536
#define ANGLE_360	2048

#define DEC_FACTOR	15			/* Shift factor for fixed pt */
#define DEC_MULT	32768			/* 1 << DEC_FACTOR	     */

#define ULPTR		long far *

unsigned    char    xGrid[(GRID_WIDTH+2) * (GRID_HEIGHT+2)];
unsigned    char    yGrid[(GRID_WIDTH+2) * (GRID_HEIGHT+2)];

	long far    *cTable;			/* Cosine table	 */
	long far    *sTable;			/* Sine table	 */
	long far    *tTable;			/* Tangent table */

	long far    *nxTable;			/* Next X offset per angle */
	long far    *nyTable;			/* Next Y offset per angle */

	long	    DstTable[3072];		/* Distance to height table */

	int	    fv[360];			/* Filter view angles	   */


/****************************************************************************
** Allocate tables							   **
****************************************************************************/
void GetTables(void)
{

cTable = (ULPTR)farmalloc(sizeof(long) * ANGLE_360);
sTable = (ULPTR)farmalloc(sizeof(long) * ANGLE_360);
tTable = (ULPTR)farmalloc(sizeof(long) * ANGLE_360);
nxTable = (ULPTR)farmalloc(sizeof(long) * ANGLE_360);
nyTable = (ULPTR)farmalloc(sizeof(long) * ANGLE_360);

}

/****************************************************************************
** Check int 9 scancode and set appropriate bit in kbd structure	   **
****************************************************************************/
void keyCheck(void)
{
  if(scanCode==RIGHT_ARROW_PRESSED)keyBoard.rightArrow=1;
  if(scanCode==RIGHT_ARROW_RELEASED)keyBoard.rightArrow=0;
  if(scanCode==UP_ARROW_PRESSED)keyBoard.upArrow=1;
  if(scanCode==UP_ARROW_RELEASED)keyBoard.upArrow=0;
  if(scanCode==LEFT_ARROW_PRESSED)keyBoard.leftArrow=1;
  if(scanCode==LEFT_ARROW_RELEASED)keyBoard.leftArrow=0;
  if(scanCode==DOWN_ARROW_PRESSED)keyBoard.downArrow=1;
  if(scanCode==DOWN_ARROW_RELEASED)keyBoard.downArrow=0;
  if(scanCode==CONTROL_PRESSED)keyBoard.control=1;
  if(scanCode==CONTROL_RELEASED)keyBoard.control=0;
  if(scanCode==HOME_PRESSED)keyBoard.home=1;
  if(scanCode==HOME_RELEASED)keyBoard.home=0;
  if(scanCode==END_PRESSED)keyBoard.end=1;
  if(scanCode==END_RELEASED)keyBoard.end=0;
  if(scanCode==PGUP_PRESSED)keyBoard.pgup=1;
  if(scanCode==PGUP_RELEASED)keyBoard.pgup=0;
  if(scanCode==PGDN_PRESSED)keyBoard.pgdn=1;
  if(scanCode==PGDN_RELEASED)keyBoard.pgdn=0;
  if(scanCode==ESCAPE)keyBoard.escape=1;
  if(scanCode==PLUS_PRESSED)keyBoard.plus = 1;
  if(scanCode==PLUS_RELEASED)keyBoard.plus = 0;
  if(scanCode==MINUS_PRESSED)keyBoard.minus = 1;
  if(scanCode==MINUS_RELEASED)keyBoard.minus = 0;



}


/****************************************************************************
** Called during an int 9 (keyboard interrupt)				   **
****************************************************************************/
void interrupt myInt()
{
  register char x;
  scanCode = inp(0x60); // read keyboard data port
  x = inp(0x61);
  outp(0x61, (x | 0x80));
  outp(0x61, x);
  outp(0x20, 0x20);
  keyCheck();
}

/****************************************************************************
**									   **
****************************************************************************/
void keyBoardReset(void)
{
  pokeb(0x0040,0x0017,numLockKeyStatus);   // return old keyboard status
}

/****************************************************************************
** Clear kbd structure and hold onto old numlock status			   **
**				   (Not really needed for this app)	   **
****************************************************************************/
void keyBoardInit(void)
{
  int value=0;
  keyBoard.rightArrow=0;
  keyBoard.upArrow=0;
  keyBoard.leftArrow=0;
  keyBoard.downArrow=0;
  keyBoard.control=0;
  keyBoard.escape=0;
  value=peekb(0x0040,0x0017);
  if(value & 32){
    numLockKeyStatus=value;
    pokeb(0x0040,0x0017,0);   // turn off num lock key temporarly
  }
  else
    numLockKeyStatus=0;
}

/****************************************************************************
** Check for a hit within the Y wall grid				   **
****************************************************************************/
int CheckHitY(long x,long y)
{
    long    x1,y1;

if (x < 0 || y < 0 || x > GRID_XMAX || y > GRID_YMAX)
    return(0);

x1 = x >> 6;	/* Divide by 64 */
y1 = y >> 6;	/* Divide by 64 */

y1 *= GRID_WIDTH;
return(yGrid[y1+x1]);
}

/****************************************************************************
** Check for a hit within the X wall grid				   **
****************************************************************************/
int CheckHitX(long x,long y)
{
    long    x1,y1;

if (x < 0 || y < 0 || x > GRID_XMAX || y > GRID_YMAX)
    return(0);

x1 = x >> 6;	/* Divide by 64 */
y1 = y >> 6;	/* Divide by 64 */

y1 *= GRID_WIDTH;
return(xGrid[y1+x1]);
}


/****************************************************************************
** Check for a hit within the master grid (used during movement)	   **
****************************************************************************/
int CheckHit(long x,long y)
{
    int	    gPosn;

if (x < 0 || y < 0 || x > GRID_XMAX || y > GRID_YMAX)
    return(0);

gPosn = ((y >> 6) * GRID_WIDTH) + (x >> 6);

if (gPosn < 0 || gPosn > GRID_MAX)
    return(0);

LastPosn = gPosn;

return(Grid[gPosn]);
}


/****************************************************************************
** Return the square root of a long value				   **
****************************************************************************/
long long_sqrt(long v)
{
    int		i;
    unsigned	long result,tmp;
    unsigned	long low,high;

if (v <= 1L) return((unsigned)v);

low = v;
high = 0L;
result = 0;

for (i = 0; i < 16; i++)
    {
    result += result;
    high = (high << 2) | ((low >>30) & 0x3);
    low <<= 2;

    tmp = result + result + 1;
    if (high >= tmp)
	{
	result++;
	high -= tmp;
	}
    }

return(result);
}

/****************************************************************************
** Cast a ray along the X walls to see if a hit occurs			   **
**									   **
** General flow:							   **
**  1) Determine the border of the current grid square to start from. This **
**     will be based on the angle facing.				   **
**									   **
**  2) Calculate the amount to add to the Y coordinate for every step made **
**     through the X walls. The X amount will be constant once we start	   **
**     from the border in step 1.					   **
**									   **
**  3) Check for a color value in the X grid. If non-zero then a wall is   **
**     present so set our global values for X1 and Y1 and return the color.**
**									   **
**  4) Add the calculated amounts to both X and Y (X is constant at 64 or  **
**     -64 based on the angle) and go back to step 3 looping until a wall  **
**     is hit or we go beyond the edges of the map grid.		   **
**									   **
**									   **
**									   **
****************************************************************************/
char xRay(long x,long y,int CurAng)
{
    long    x1,y1;
    int	    xbeg;
    int	    posn;
    long    Adj,nx,ny;
    long    tvalue;
    char    ch;

if (CurAng == ANGLE_90 || CurAng == ANGLE_270)	/* Don't check vertical lines */
    return(0);

xbeg = x & 0xFFC0;		/* Same as (X / 64) * 64 to get upper left X */
tvalue = tTable[CurAng];

ny = nyTable[CurAng];

if (!CurAng)
    {
    x1 = xbeg + GRID_XSTEP;
    y1 = 0;
    nx = GRID_XSTEP;
    ny = 0;
    }
else
    {
    if (CurAng > ANGLE_270 || CurAng < ANGLE_90)
	{
	x1 = xbeg + GRID_XSTEP;
	Adj = x1 - x;
	y1 = (long)(tvalue * Adj) >> DEC_FACTOR;
	nx = GRID_XSTEP;
	}
    }


if (CurAng == ANGLE_180)
    {
    x1 = xbeg;
    y1 = 0;
    nx = -GRID_XSTEP;
    ny = 0;
    }
else
    {
    if (CurAng > ANGLE_90 && CurAng < ANGLE_270)
	{
	x1 = xbeg;
	Adj = x1 - x;
	y1 = (long)(tvalue * Adj) >> DEC_FACTOR;
	nx = -GRID_XSTEP;
	}
    }

if (CurAng > ANGLE_180)
    ny = -ny;

y1 += y;

while (1)
    {
    if (x1 > GRID_XMAX || y1 > GRID_YMAX ||
	x1 < 0 || y1 < 0)
	break;

    posn = ((y1 >> 6) * GRID_WIDTH) + (x1 >> 6);
    ch = xGrid[posn];
    if (ch)
	{
	LastX1 = x1;
	LastY1 = y1;
	return(ch);
	}

    x1 += nx;
    y1 += ny;
    }

return(0);
}


/****************************************************************************
** Cast a ray along the Y walls to see if a hit occurs			   **
**									   **
** General flow:							   **
**  1) Determine the border of the current grid square to start from. This **
**     will be based on the angle facing.				   **
**									   **
**  2) Calculate the amount to add to the X coordinate for every step made **
**     through the Y walls. The Y amount will be constant once we start	   **
**     from the border in step 1.					   **
**									   **
**  3) Check for a color value in the Y grid. If non-zero then a wall is   **
**     present so set our global values for X1 and Y1 and return the color.**
**									   **
**  4) Add the calculated amounts to both X and Y (Y is constant at 64 or  **
**     -64 based on the angle) and go back to step 3 looping until a wall  **
**     is hit or we go beyond the edges of the map grid.		   **
**									   **
**									   **
****************************************************************************/
char yRay(long x,long y,int CurAng)
{
    long    x1,y1;
    int	    ybeg;
    int	    posn;
    long    Opp,nx,ny;
    long    tvalue;
    char    ch;

if (CurAng == 0 || CurAng == ANGLE_180)	    /* No need to check horiz lines */
    return(0);

ybeg = y & 0xFFC0;	    /* Same as (Y / 64) * 64 to get upper left Y */

tvalue = tTable[CurAng];    /* Tangent value for the current angle  */

nx = nxTable[CurAng];	    /* X amount for the current angle	    */

if (CurAng == ANGLE_90)
    {
    x1 = 0;
    y1 = ybeg + GRID_YSTEP;
    ny = GRID_YSTEP;
    nx = 0;
    }
else
    {
    if (CurAng > 0 && CurAng < ANGLE_180)
	{
	y1 = ybeg + GRID_YSTEP;
	Opp = y1 - y;
	Opp <<= DEC_FACTOR;
	x1 = Opp / tvalue;
	ny = GRID_YSTEP;
	}
    }

if (CurAng == ANGLE_270)
    {
    x1 = 0;
    y1 = ybeg;
    ny = -GRID_YSTEP;
    nx = 0;
    }
else
    {
    if (CurAng > ANGLE_180)
	{
	y1 = ybeg;
	Opp = y1 - y;
	Opp <<= DEC_FACTOR;
	x1 = Opp / tvalue;
	ny = -GRID_YSTEP;
	}
    }

if (CurAng > ANGLE_90 && CurAng < ANGLE_270)
    nx = -nx;

x1 += x;

while (1)
    {
    if (x1 > GRID_XMAX || y1 > GRID_YMAX ||
	x1 < 0 || y1 < 0)
	break;

    posn = ((y1 >> 6) * GRID_WIDTH) + (x1 >> 6);
    ch = yGrid[posn];
    if (ch)
	{
	LastX1 = x1;
	LastY1 = y1;
	return(ch);
	}

    x1 += nx;
    y1 += ny;
    }

return(0);
}

/****************************************************************************
** Display an entire screen worth of walls.				   **
** General flow:							   **
**  1) Fill in sky and floor colors.					   **
**  2) Begin looping from left side of screen to right side (320 width)	   **
**  3) Cast a ray along the X walls to see if a hit, returns wall color.   **
**  4) If a hit calc the xDistance using c2 = a2 + b2			   **
**  5) Cast a ray along the Y walls to see if a hit, returns wall color.   **
**  6) If a hit calc the yDistance using c2 = a2 + b2			   **
**  7) If xDistance less or equal then yDistance then use xColor and xDist **
**     else use yColor and yDistance.					   **
**  8) Use the Cosine of the starting angle minus the current angle to	   **
**     adjust the distance for a flat view.				   **
**  9) Get the height from the distance table.				   **
**  10) Draw a vertical line using the height and color.		   **
**  11) Go back to set 3 until full screen is painted.			   **
**									   **
** NOTE: This routine needs ALOT of optimizing yet, just trying to get	   **
**	 the basics down for now.					   **
**									   **
****************************************************************************/
void DrawView(long x,long y,long angle)
{
    int	    i,CurAng,CalcAng;
    char    color,xcolor,ycolor;
    long    xDst,yDst,dst,deltax,deltay;
    long    ht,ty,ty1,vx,vy;

for (i = 0; i < 120; i++)		/* Fill in sky on upper half	*/
    hline(0,319,i,1);

for (i = 120; i < 240; i++)		/* Fill in floor on lower half	*/
    hline(0,319,i,21);

for (i = 0; i < 320; i++)
    {

    CurAng = angle + fv[i+20];
    if (CurAng < 0)
	CurAng = ANGLE_360 + CurAng;
    if (CurAng >= ANGLE_360)
	CurAng = CurAng - ANGLE_360;

    CalcAng = abs(angle - CurAng);
    if (CalcAng < 0)
	CalcAng = ANGLE_360 + CalcAng;
    if (CalcAng >= ANGLE_360)
	CalcAng = CalcAng - ANGLE_360;


    xDst = yDst = 1000000L;	    /* Set to wild distance for later compare */

    xcolor = xRay(x,y,CurAng);
    if (xcolor)			    /* A hit on an X wall */
	{
	deltax = labs(LastX1 - x);
	deltay = labs(LastY1 - y);
	xDst = long_sqrt((deltax * deltax) + (deltay * deltay));
	}

    ycolor = yRay(x,y,CurAng);
    if (ycolor)			    /* A hit on a Y wall */
	{
	deltax = labs(LastX1 - x);
	deltay = labs(LastY1 - y);
	yDst = long_sqrt((deltax * deltax) + (deltay * deltay));
	}

    if (xcolor || ycolor)
	{

	if (xDst <= yDst)
	    {
	    color = xcolor;
	    dst = xDst;
	    }
	else
	    {
	    color = ycolor;
	    dst = yDst;
	    }

	vx = cTable[CalcAng];
	if (vx)
	    {
	    vy = dst * vx;
	    dst = vy >> DEC_FACTOR;
	    }

	if (dst > 3071)
	    dst = 3071;

	ht = DstTable[dst];

	ty = 120 - (ht/2);
	ty1 = ty + ht;

	if (ty < 0) ty = 0;
	if (ty1 > 239) ty1 = 239;


	vline(i,(int)ty,(int)ty1,color);
	}

    }

flippage();
PageNum ^= 1;
usepage(PageNum);
}

/****************************************************************************
** Another approach to displaying a screen worth of walls.		   **
** Use this method by specifying -O on the command line when starting	   **
****************************************************************************/
void OldDrawView(long x,long y,long angle)
{
    int	    i,color,j,xcolor,ycolor,LastColor;
unsigned    int	    ht,ty,ty1,wt;
    int	    voff,vnext;
    long    vx,vy;
unsigned    long    deltax,deltay,dst;
    int	    aBias;
    int	    CurAng,RealAngle,CalcAng;
    long    Opp,Hyp;
    long    yDst,xDst,LastDst;
    long    gx,gy,nextx,nexty,xoff,yoff,xbeg,ybeg;


for (i = 0; i < 120; i++)		/* Fill in sky on upper half	*/
    hline(0,319,i,1);

for (i = 120; i < 240; i++)		/* Fill in floor on lower half	*/
    hline(0,319,i,21);

ybeg = y & 0xFFC0;			/* Get upper left corner of current */
xbeg = x & 0xFFC0;			/* grid square we are in	    */


for (i = 0; i < 320; i++)		/* Draw screen width		*/
    {

    CurAng = angle + fv[i+20];		/* Get the next angle to use	*/
    if (CurAng < 0)
	CurAng = ANGLE_360 + CurAng;
    if (CurAng >= ANGLE_360)
	CurAng = CurAng - ANGLE_360;

    CalcAng = abs(angle - CurAng);	/* Get the angle to calc distance */
    if (CalcAng < 0)
	CalcAng = ANGLE_360 + CalcAng;
    if (CalcAng >= ANGLE_360)
	CalcAng = CalcAng - ANGLE_360;


/* Get setup to cast a ray on the Y walls */

    if (CurAng > ANGLE_180)
	{
	Opp = ybeg - y;
	gy = ybeg;
	nexty = -64;
	}
    else
	{
	Opp = (ybeg + 64L) - y;
	gy = ybeg + 64;
	nexty = 64;
	}

    Opp <<= DEC_FACTOR;
    vy = tTable[CurAng];
    if (!vy)
	vy = tTable[CurAng+1];	    /* Fudge.....???? */

    if (!vy)
	{
	nextx = nxTable[CurAng+1];
	gx = x - xbeg;
	}
    else
	{
	nextx = nxTable[CurAng];
	gx = Opp / vy;
	if (Opp - (gx * gy) >= (vy/2))
	    gx++;
	}

    if (CurAng > ANGLE_90 && CurAng < ANGLE_270)
	nextx = -nextx;

    if (!CurAng || CurAng == ANGLE_180)
	nexty = 0;


    vx = gx + x;	    /* Initial X posn to check */
    vy = gy;		    /* Initial Y posn to check */
    ycolor = 0;
    yDst = 0;

    while (nexty)
	{
	if (vx < 0 || vy < 0 || vx > GRID_XMAX || vy > GRID_YMAX)
	    break;

	ycolor = CheckHitY(vx,vy);
	if (ycolor)	    /* Got a hit so exit loop to calc distance */
	    break;

	vx += nextx;
	vy += nexty;

	}

    if (ycolor)
	{
	deltax = labs(vx - x);
	deltay = labs(vy - y);

	dst = (deltax * deltax) + (deltay * deltay);

	yDst = long_sqrt(dst);

	if (dst - (yDst * yDst) > yDst)
	    yDst++;
	}

    if (CurAng > ANGLE_90 && CurAng < ANGLE_270)
	{
	vx = xbeg - x;
	nextx = -64;
	gx = xbeg;
	}
    else
	{
	vx = (xbeg + 64) - x;
	nextx = 64;
	gx = xbeg + 64;
	}

    gy = (vx * tTable[CurAng]) >> DEC_FACTOR;
    nexty = nyTable[CurAng];

    vx = gx;
    vy = gy + y;

    if (CurAng == ANGLE_90 || CurAng == ANGLE_270)
	nextx = 0L;

    if (CurAng > ANGLE_180)
	nexty = -nexty;

    xcolor = 0;
    xDst = 0;

    while (nextx)
	{

	if (vx < 0 || vy < 0 || vx > GRID_XMAX || vy > GRID_YMAX)
	    break;

	xcolor = CheckHitX(vx,vy);
	if (xcolor)
	    break;

	vx += nextx;
	vy += nexty;

	}

    if (xcolor)
	{
	deltax = labs(vx - x);
	deltay = labs(vy - y);

	dst = (deltax * deltax) + (deltay * deltay);

	xDst = long_sqrt(dst);

	if (dst - (xDst * xDst) > xDst)
	    xDst++;

	}



    if (xcolor || ycolor)
	{
	if (yDst == 0L || xDst <= yDst)
	    {
	    dst = xDst;
	    color = xcolor;

	    if (xDst == 0L)
		{
		dst = yDst;
		color = ycolor;
		}
	    }
	else
	    {
	    dst = yDst;
	    color = ycolor;
	    }

	vx = cTable[CalcAng];
	if (vx)
	    {
	    vy = (unsigned long)((unsigned long)dst * (unsigned long)vx);
	    dst = vy >> DEC_FACTOR;
	    }

	if (dst > 3071)
	    dst = 3071;

	ht = DstTable[dst];
	j = ht / 2;

	ty = 120 - j;
	ty1 = ty + ht;

	if (ty > 120) ty = 0;

	if (ty1 > 239) ty1 = 239;
	vline(i,(int)ty,(int)ty1,color);
	}

    }

flippage();
PageNum ^= 1;
usepage(PageNum);
}


/****************************************************************************
** Wolfenstein style engine.						   **
** General flow:							   **
**  1) Allocate and intialize trig tables and X and Y offset tables.	   **
**  2) Build X and Y wall grids from the master grid.			   **
**  3) Setup keyboard intercept and switch to VGA 240 line mode (mode X)   **
**  4) Initialize player X,Y and view angle.				   **
**  5) Draw the initial screen of walls.				   **
**  6) Wait for keyboard action. Escape key exits.			   **
**  7) Move forward or back or turn viewing angle based on key.		   **
**  8) Draw new screen full of walls and go to step 6.			   **
**									   **
****************************************************************************/
void main(int argc,char *argv[])
{
    int	    done;
    int	    dflag,vflag;
    long   x,y,x1,y1,angle,opang;
    unsigned int key;
    float   ang,ca;



done = open("f.dat",O_RDWR|O_BINARY);
if (done < 1)
    {
    puts("Unable to open f.dat");
    exit(1);
    }

read(done,fv,720);
close(done);

vflag = 0;
if (argc > 1)
    {
    if (!(stricmp(argv[1],"-O")))
	{
	vflag = 1;
	}
    }

GetTables();

y1 = 12000L;

DstTable[0] = y1;
for (done = 1; done < 3072; done += 1)
    {
    x1 = y1 / done;

    if (y1 - (x1 * done) > (done / 2))
	x1++;

    DstTable[done] = x1;
    }

ang = 0;
ca = 6.283185307 / ANGLE_360;

for (x = 0; x < ANGLE_360; x++)
    {
    tTable[x] = (long)(tan(ang) * DEC_MULT);
    cTable[x] = (long)(cos(ang) * DEC_MULT);
    sTable[x] = (long)(sin(ang) * DEC_MULT);

    nxTable[x] = 64L;
    if (tTable[x])
	nxTable[x] = labs((64L << DEC_FACTOR) / tTable[x]);

    y = 64L * tTable[x];
    nyTable[x] = labs(y >> DEC_FACTOR);

    ang += ca;
    }

y1 = (GRID_WIDTH+1) * (GRID_HEIGHT+1);
memset(xGrid,0,y1);
memset(yGrid,0,y1);

for (y = 0; y < GRID_HEIGHT; y++)
    {
    for (x = 0; x < GRID_WIDTH; x++)
	{
	y1 = (y * GRID_WIDTH) + x;
	done = Grid[(y * GRID_WIDTH) + x];
	if (done)
	    {
	    xGrid[y1] = done;
	    xGrid[y1+1] = done;
	    yGrid[y1] = done;
	    yGrid[y1+GRID_WIDTH] = done;
	    }
	}
    }

keyBoardInit();
oldvec=getvect(KEYBD);
setvect(KEYBD,myInt);

graphinit(0,0);
PageNum = 1;
usepage(PageNum);

x = 96;
y = 96;
angle = 0;
done = 0;

if (!vflag)
    DrawView(x,y,angle);
else
    OldDrawView(x,y,angle);

dflag = 0;

while (!done)
    {

    if(keyBoard.escape)
	break;

    if(keyBoard.rightArrow)
	{
	if (keyBoard.control)
	    angle += ANGLE_45;
	else
	    angle += 4;

	dflag = 1;
	if (angle >= ANGLE_360)
	    angle = angle - ANGLE_360;
	}

    if(keyBoard.leftArrow)
	{
	if (keyBoard.control)
	    angle -= ANGLE_45;
	else
	    angle -= 4;

	if (angle < 0)
	    angle = ANGLE_360 + angle;
	dflag = 1;
	}

    if(keyBoard.upArrow)
	{
	x1 = x + (cTable[angle] * 2) / DEC_MULT;
	y1 = y + (sTable[angle] * 2) / DEC_MULT;
	if (CheckHit(x1,y1))
	    break;
	x = x1;
	y = y1;
	dflag = 1;
	}

    if (keyBoard.home)
	{
	for (dflag = 0; dflag < 64; dflag++)
	    {
	    x1 = x + (cTable[angle] * 2) / DEC_MULT;
	    y1 = y + (sTable[angle] * 2) / DEC_MULT;
	    if (CheckHit(x1,y1))
		break;
	    x = x1;
	    y = y1;
	    }
	dflag = 1;
	}

    if (keyBoard.pgup)
	{
	for (dflag = 0; dflag < 10; dflag++)
	    {
	    x1 = x + (cTable[angle] * 2) / DEC_MULT;
	    y1 = y + (sTable[angle] * 2) / DEC_MULT;
	    if (CheckHit(x1,y1))
		break;
	    x = x1;
	    y = y1;
	    }
	dflag = 1;
	}

    if (keyBoard.end)
	{
	opang = angle + ANGLE_180;
	if (opang >= ANGLE_360)
	    opang = opang - ANGLE_360;
	for (dflag = 0; dflag < 64; dflag++)
	    {
	    x1 = x + (cTable[opang] * 2) / DEC_MULT;
	    y1 = y + (sTable[opang] * 2) / DEC_MULT;
	    if (CheckHit(x1,y1))
		break;
	    x = x1;
	    y = y1;
	    }
	dflag = 1;
	}

    if (keyBoard.pgdn)
	{
	opang = angle + ANGLE_180;
	if (opang >= ANGLE_360)
	    opang = opang - ANGLE_360;
	for (dflag = 0; dflag < 10; dflag++)
	    {
	    x1 = x + (cTable[opang] * 2) / DEC_MULT;
	    y1 = y + (sTable[opang] * 2) / DEC_MULT;
	    if (CheckHit(x1,y1))
		break;
	    x = x1;
	    y = y1;
	    }
	dflag = 1;
	}

    if (dflag)
	{
	dflag = 0;
	if (!vflag)
	    DrawView(x,y,angle);
	else
	    OldDrawView(x,y,angle);
	}

    }

textmode(3);
setvect(KEYBD,oldvec);
keyBoardReset();

}

