#include <fastgraf.h>
#include <stdio.h>
#include <stdlib.h>
#ifdef __TURBOC__
#include <alloc.h>
#else
#include <malloc.h>
#endif

#define WIDTH  1000
#define HEIGHT   50

void main(void);

void main()
{
   int handle;
   int old_mode;
   int x;
#ifdef FG32
   char *buffer;
#else
   char huge *buffer;
#endif

   /* initialize the video environment */

   fg_initpm();
   old_mode = fg_getmode();
   fg_setmode(20);
   fg_vbinit();

   /* fill the screen with light blue pixels */

   fg_setcolor(9);
   fg_fillpage();

   /* set up the virtual buffer */

#ifdef FG32
   buffer = (char *)malloc(WIDTH*HEIGHT);
#elif defined(__TURBOC__)
   buffer = (char huge *)farmalloc((long)WIDTH*(long)HEIGHT);
#else
   buffer = (char huge *)halloc((long)WIDTH*(long)HEIGHT,1);
#endif
   if (buffer == NULL)
   {
      fg_setmode(old_mode);
      fg_reset();
      printf("Could not create the virtual buffer.\n");
      exit(1);
   }
   handle = fg_vbdefine(buffer,WIDTH,HEIGHT);
   fg_vbopen(handle);

   /* fill the virtual buffer with a series of narrow rectangles */

   for (x = 0; x < WIDTH; x++)
   {
      fg_setcolor(x);
      fg_rect(x,x,0,HEIGHT-1);
   }

   /* scroll the virtual buffer through a 100x50 window on the */
   /* visual page, such that the top half scrolls left and the */
   /* bottom half scrolls right */

   for (x = 0; x < WIDTH-99; x++)
   {
      fg_vbpaste(x,x+99,0,24,110,99);
      fg_vbpaste(WIDTH-100-x,WIDTH-1-x,25,49,110,124);
   }
   fg_waitkey();

   /* close the virtual buffer */

   fg_vbclose();

   /* restore original video mode and exit */

   fg_setmode(old_mode);
   fg_reset();
}
