#include <fastgraf.h>
#include <stdio.h>
#include <stdlib.h>

void main(void);

void main()
{
   int i, j;
   int mode, status;
   int minx, maxx, miny, maxy;
   unsigned char PCXpal[768];
   unsigned char header[128];

   fg_initpm();
   status = fg_pcxhead("CORAL.PCX",header);
   if (status == -1)
   {
      printf("Can't open CORAL.PCX.\n");
      exit(1);
   }
   else if (status == -2)
   {
      printf("CORAL.PCX is not a PCX file.\n");
      exit(1);
   }

   mode = fg_pcxmode(header);
   printf("Optimal display mode is %d.\n",mode);

   fg_pcxrange(header,&minx,&maxx,&miny,&maxy);
   printf("Image size is %d by %d pixels.\n",maxx-minx+1,maxy-miny+1);

   fg_pcxpal("CORAL.PCX",PCXpal);
   printf("First 16 palette values are:\n");
   j = 0;
   for (i = 0; i < 16; i++)
   {
      printf("  color %2d: R=%2d G=%2d B=%2d\n",
         i,PCXpal[j],PCXpal[j+1],PCXpal[j+2]);
      j += 3;
   }
}
