$INCLUDE: 'C:\FG\FASTGRAF.FI'

      PROGRAM MAIN

      INTEGER VISUAL, HIDDEN
      PARAMETER (VISUAL=0)
      PARAMETER (HIDDEN=1)

      INTEGER XMIN(0:11), YMAX(0:11)
      INTEGER NEW_MODE, OLD_MODE
      INTEGER FRAME, OFFSET
      INTEGER I, X, Y
      INTEGER STATUS
      INTEGER FG_ALLOCATE, FG_BESTMODE, FG_FREEPAGE, FG_GETMODE

      DATA XMIN / 0, 96,192,  0, 96,192,  0, 96,192,  0, 96,192/
      DATA YMAX /49, 49, 49, 99, 99, 99,149,149,149,199,199,199/

C  initialize the video environment

      CALL FG_INITPM
      NEW_MODE = FG_BESTMODE(320,200,2)
      IF (NEW_MODE .LT. 0 .OR. NEW_MODE .EQ. 12) THEN
         STOP 'This program requires a 320 x 200 color graphics mode.'
      END IF
      OLD_MODE = FG_GETMODE()
      CALL FG_SETMODE(NEW_MODE)
      STATUS = FG_ALLOCATE(HIDDEN)

C  draw the background in the upper left corner

      CALL FG_SETPAGE(HIDDEN)
      CALL FG_SETCOLOR(1)
      CALL FG_RECT(0,95,0,49)
      CALL FG_SETCOLOR(15)
      CALL FG_MOVE(48,25)
      CALL FG_ELLIPSE(20,20)

C  display the animated object against each background

      CALL FG_SETCOLOR(10)
      OFFSET = -10
      DO 10 I = 1,11
         X = XMIN(I)
         Y = YMAX(I)
         CALL FG_TRANSFER(0,95,0,49,X,Y,HIDDEN,HIDDEN)
         CALL FG_SETCLIP(X,X+95,0,199)
         CALL FG_CLPRECT(X+OFFSET,X+OFFSET+19,Y-29,Y-20)
         OFFSET = OFFSET + 10
10    CONTINUE

C  slide the object across the background three times

      DO 20 I = 0,35
         FRAME = MOD(I,12)
         X = XMIN(FRAME)
         Y = YMAX(FRAME)
         CALL FG_TRANSFER(X,X+95,Y-49,Y,112,124,HIDDEN,VISUAL)
         CALL FG_WAITFOR(2)
20    CONTINUE

C  restore the original video mode and return to DOS

      STATUS = FG_FREEPAGE(HIDDEN)
      CALL FG_SETMODE(OLD_MODE)
      CALL FG_RESET

      STOP ' '
      END
