VERSION 4.00
Begin VB.Form Form1 
   BackColor       =   &H00FFFFFF&
   Caption         =   "Fastgraph Fish Tank"
   ClientHeight    =   4140
   ClientLeft      =   1140
   ClientTop       =   1515
   ClientWidth     =   6690
   Height          =   4545
   Left            =   1080
   LinkTopic       =   "Form1"
   ScaleHeight     =   4140
   ScaleWidth      =   6690
   Top             =   1170
   Width           =   6810
   Begin VB.CommandButton Command1 
      Caption         =   "Begin"
      Height          =   375
      Left            =   2760
      TabIndex        =   0
      Top             =   3600
      Width           =   1215
   End
End
Attribute VB_Name = "Form1"
Attribute VB_Creatable = False
Attribute VB_Exposed = False

'*****************************************************************************
'                                                                            *
'  FISHTANK.FRM                                                              *
'                                                                            *
'  This program shows how to perform simple animation using Fastgraph for    *
'  Windows. Several types of tropical fish swim back and forth against a     *
'  coral reef background. The background image and fish sprites are stored   *
'  in standard pixel run (SPR) files.                                        *
'                                                                            *
'  The application window is initially set to 320x200 pixels, the same size  *
'  as the CORAL.SPR image. When the window size changes, the image is scaled *
'  to fill the window.                                                       *
'                                                                            *
'*****************************************************************************

Const nFish = 11           ' total number of fish sprites

Dim FishX(6) As Long       ' location of fish (x)
Dim FishY(6) As Long       ' location of fish (y)
Dim FishWidth(6) As Long   ' size of fish: width
Dim FishHeight(6) As Long  ' size of fish: height
Dim FishOffset(6) As Long  ' bitmap offsets into Fishes() array

' The Fishes array holds the bitmaps for all 6 kinds of fish

Dim Fishes(56 * 25 + 54 * 38 + 68 * 26 + 56 * 30 + 62 * 22 + 68 * 36) As Byte

' There are 11 fish total, and 6 different kinds of fish. These
' arrays keep track of what kind of fish each fish is, and how each
' fish moves:

Dim Fish(nFish) As Long    ' which fish bitmap applies to this fish?
Dim X(nFish) As Long       ' starting x coordinate
Dim Y(nFish) As Long       ' starting y coordinate
Dim xMin(nFish) As Long    ' how far left (off screen) the fish can go
Dim xMax(nFish) As Long    ' how far right (off screen) the fish can go
Dim xInc(nFish) As Long    ' how fast the fish goes left and right
Dim Dir(nFish) As Long     ' starting direction for each fish
Dim yMin(nFish) As Long    ' how far up this fish can go
Dim yMax(nFish) As Long    ' how far down this fish can go
Dim yInc(nFish) As Long    ' how fast the fish moves up or down
Dim yCount(nFish) As Long  ' counter to compare to yturn
Dim yTurn(nFish) As Long   ' how long fish can go in the vertical direction
                           ' before stopping or turning around
Dim hPal As Long
Dim hvb1 As Long, hvb2 As Long
Dim cxClient As Long, cyClient As Long

Private Sub Command1_Click()
   Command1.Visible = False
   Do
      Call GoFish
   Loop While DoEvents > 0
End Sub

Private Sub Form_Activate()
   Call fg_realize(hPal)
   Refresh
End Sub

Private Sub Form_Load()
   ScaleMode = 3
   Call fg_setdc(hDC)

   ' use the default logical palette
   hPal = fg_defpal()
   Call fg_realize(hPal)

   ' create two 320x200 virtual buffers
   Call fg_vbinit
   hvb1 = fg_vballoc(320, 200)
   hvb2 = fg_vballoc(320, 200)

   ' display the coral background in virtual buffer #2 (which
   ' will always contain a clean copy of the background image)
   Call fg_vbopen(hvb2)
   Call fg_vbcolors
   Call fg_move(0, 199)
   Call fg_showspr(CurDir + "\CORAL.SPR", 320)

   ' get the fish bitmaps
   Call GetFish
End Sub

Private Sub Form_Paint()
   Call fg_vbscale(0, fg_getmaxx(), 0, fg_getmaxy(), 0, cxClient - 1, 0, cyClient - 1)
End Sub

Private Sub Form_Resize()
   cxClient = ScaleWidth
   cyClient = ScaleHeight
   Refresh
End Sub

Private Sub Form_Unload(Cancel As Integer)
   Call fg_vbclose
   Call fg_vbfree(hvb1)
   Call fg_vbfree(hvb2)
   Call fg_vbfin
End Sub

Private Function Max(A As Long, B As Long)
   If A > B Then
      Max = A
   Else
      Max = B
   End If
End Function

Private Function Min(A As Long, B As Long)
   If A < B Then
      Min = A
   Else
      Min = B
   End If
End Function

'*****************************************************************************
'                                                                            *
'  GetFish                                                                   *
'                                                                            *
'  Fill the fish bitmap arrays.                                              *
'                                                                            *
'*****************************************************************************

Private Sub GetFish()

   Dim I As Integer, J As Integer

   FishX(1) = 0
   FishX(2) = 64
   FishX(3) = 128
   FishX(4) = 200
   FishX(5) = 0
   FishX(6) = 80

   FishY(1) = 199
   FishY(2) = 199
   FishY(3) = 199
   FishY(4) = 199
   FishY(5) = 150
   FishY(6) = 150

   FishWidth(1) = 56
   FishWidth(2) = 54
   FishWidth(3) = 68
   FishWidth(4) = 56
   FishWidth(5) = 62
   FishWidth(6) = 68

   FishHeight(1) = 25
   FishHeight(2) = 38
   FishHeight(3) = 26
   FishHeight(4) = 30
   FishHeight(5) = 22
   FishHeight(6) = 36

   Fish(1) = 2
   Fish(2) = 2
   Fish(3) = 3
   Fish(4) = 4
   Fish(5) = 4
   Fish(6) = 1
   Fish(7) = 1
   Fish(8) = 6
   Fish(9) = 5
   Fish(10) = 3
   Fish(11) = 4

   X(1) = -100
   X(2) = -150
   X(3) = -450
   X(4) = -140
   X(5) = -200
   X(6) = 520
   X(7) = 620
   X(8) = -800
   X(9) = 800
   X(10) = 800
   X(11) = -300

   Y(1) = 40
   Y(2) = 60
   Y(3) = 150
   Y(4) = 80
   Y(5) = 70
   Y(6) = 190
   Y(7) = 180
   Y(8) = 100
   Y(9) = 30
   Y(10) = 130
   Y(11) = 92

   xMin(1) = -300
   xMin(2) = -300
   xMin(3) = -800
   xMin(4) = -200
   xMin(5) = -200
   xMin(6) = -200
   xMin(7) = -300
   xMin(8) = -900
   xMin(9) = -900
   xMin(10) = -900
   xMin(11) = -400

   xMax(1) = 600
   xMax(2) = 600
   xMax(3) = 1100
   xMax(4) = 1000
   xMax(5) = 1000
   xMax(6) = 750
   xMax(7) = 800
   xMax(8) = 1200
   xMax(9) = 1400
   xMax(10) = 1200
   xMax(11) = 900

   xInc(1) = 2
   xInc(2) = 2
   xInc(3) = 8
   xInc(4) = 5
   xInc(5) = 5
   xInc(6) = -3
   xInc(7) = -3
   xInc(8) = 7
   xInc(9) = -8
   xInc(10) = -9
   xInc(11) = 6

   Dir(1) = 0
   Dir(2) = 0
   Dir(3) = 0
   Dir(4) = 0
   Dir(5) = 0
   Dir(6) = 1
   Dir(7) = 1
   Dir(8) = 0
   Dir(9) = 1
   Dir(10) = 1
   Dir(11) = 0

   yMin(1) = 40
   yMin(2) = 60
   yMin(3) = 120
   yMin(4) = 70
   yMin(5) = 60
   yMin(6) = 160
   yMin(7) = 160
   yMin(8) = 80
   yMin(9) = 30
   yMin(10) = 110
   yMin(11) = 72

   yMax(1) = 80
   yMax(2) = 100
   yMax(3) = 170
   yMax(4) = 110
   yMax(5) = 100
   yMax(6) = 199
   yMax(7) = 199
   yMax(8) = 120
   yMax(9) = 70
   yMax(10) = 150
   yMax(11) = 122

   yTurn(1) = 50
   yTurn(2) = 30
   yTurn(3) = 10
   yTurn(4) = 30
   yTurn(5) = 20
   yTurn(6) = 10
   yTurn(7) = 10
   yTurn(8) = 10
   yTurn(9) = 30
   yTurn(10) = 20
   yTurn(11) = 10

   For I = 1 To nFish
      yCount(I) = 0
      yInc(I) = 0
   Next I

   ' get the fish bitmaps from an SPR file
   Call fg_vbopen(hvb1)
   Call fg_vbcolors
   Call fg_move(0, 199)
   Call fg_showspr(CurDir + "\FISH.SPR", 320)

   J = 1
   For I = 1 To 6
      Call fg_move(FishX(I), FishY(I))
      Call fg_getimage(Fishes(J), FishWidth(I), FishHeight(I))
      FishOffset(I) = J
      J = J + FishWidth(I) * FishHeight(I)
   Next I

   Call fg_erase
End Sub

'*****************************************************************************
'                                                                            *
'  GoFish                                                                    *
'                                                                            *
'  Make the fish swim around.                                                *
'                                                                            *
'*****************************************************************************

Private Sub GoFish()

   Dim I As Integer

   ' copy the background to the workspace
   Call fg_copypage(hvb2, hvb1)

   ' put all the fish in their new positions
   For I = 1 To nFish
      yCount(I) = yCount(I) + 1
      If yCount(I) > yTurn(I) Then
         yCount(I) = 0
         yInc(I) = Int(Rnd() * 3 - 1)
      End If
      Y(I) = Y(I) + yInc(I)
      Y(I) = Min(yMax(I), Max(Y(I), yMin(I)))

      If X(I) >= -72 And X(I) < 320 Then
         Call PutFish(Fish(I), X(I), Y(I), Dir(I))
      End If

      X(I) = X(I) + xInc(I)
      If X(I) <= xMin(I) Or X(I) >= xMax(I) Then
         xInc(I) = -xInc(I)
         Dir(I) = 1 - Dir(I)
      End If
   Next I

   ' scale the workspace image to fill the client area
   Call fg_vbscale(0, 319, 0, 199, 0, cxClient - 1, 0, cyClient - 1)
End Sub

'*****************************************************************************
'                                                                            *
'  PutFish                                                                   *
'                                                                            *
'  Draw one of the six fish anywhere you want.                               *
'                                                                            *
'*****************************************************************************

Private Sub PutFish(FishNum As Long, X As Long, Y As Long, FishDir As Long)

   Dim I As Integer

   ' move to position where the fish will appear
   Call fg_move(X, Y)

   ' draw a left- or right-facing fish, depending on FishDir
   I = FishOffset(FishNum)
   If FishDir = 0 Then
      Call fg_flpimage(Fishes(I), FishWidth(FishNum), FishHeight(FishNum))
   Else
      Call fg_clpimage(Fishes(I), FishWidth(FishNum), FishHeight(FishNum))
   End If
End Sub

