/****************************************************************************\
*                                                                            *
*  FASTGRAF.H                                                                *
*                                                                            *
*  This file contains the C and C++ function prototypes for Fastgraph V4.03. *
*                                                                            *
*  Copyright (c) 1991-1995 Ted Gruber Software.  All rights reserved.        *
*                                                                            *
\****************************************************************************/

#ifndef __FASTGRAF_H

#define __FASTGRAF_H
#define FG_CDECL

#ifdef __BORLANDC__        /* Borland C++ (32-bit) */
#ifdef __CONSOLE__
#define FG32
#endif
#endif

#ifdef __HIGHC__           /* MetaWare High C/C++ */
#pragma Global_aliasing_convention("_%r")
#define FG32
#endif

#ifdef _MSC_VER            /* Microsoft Visual C++ 32-bit Edition */
#if _M_IX86 >= 300
#define FG32
#endif
#endif

#ifdef __WATCOMC__         /* WATCOM C/C++ (16-bit and 32-bit versions) */
#undef  FG_CDECL
#define FG_CDECL __cdecl
#ifdef __386__             /* WATCOM C/C++ (32-bit) */
#define FG32
#endif
#endif

#ifdef FG32                /* data types for 32-bit environments */
#define farptr  char *
#define hugeptr char *
#else                      /* data types for 16-bit environments */
#define farptr  char far *
#ifdef __ZTC__
#define hugeptr char far *
#else
#define hugeptr char huge *
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

int    FG_CDECL fg_allocate (int);
int    FG_CDECL fg_alloccms (int);
int    FG_CDECL fg_allocems (int);
int    FG_CDECL fg_allocxms (int);
int    FG_CDECL fg_automode (void);

int    FG_CDECL fg_bestmode (int, int, int);
void   FG_CDECL fg_box (int, int, int, int);
void   FG_CDECL fg_boxdepth (int, int);
void            fg_boxw (double, double, double, double);
void   FG_CDECL fg_boxx (int, int, int, int);
void            fg_boxxw (double, double, double, double);
int    FG_CDECL fg_button (int);

int    FG_CDECL fg_capslock (void);
void   FG_CDECL fg_chgattr (int);
void   FG_CDECL fg_chgtext (char *, int);
void   FG_CDECL fg_circle (int);
void   FG_CDECL fg_circlef (int);
void            fg_circlefw (double);
void            fg_circlew (double);
void   FG_CDECL fg_clipmap (char *, int, int);
void   FG_CDECL fg_clipmask (char *, int, int);
void   FG_CDECL fg_clpimage (char *, int, int);
void   FG_CDECL fg_clprect (int, int, int, int);
void            fg_clprectw (double, double, double, double);
int    FG_CDECL fg_colors (void);
void   FG_CDECL fg_copypage (int, int);
void   FG_CDECL fg_cursor (int);

void   FG_CDECL fg_dash (int, int, int);
void   FG_CDECL fg_dashrel (int, int, int);
void            fg_dashrw (double, double, int);
void            fg_dashw (double, double, int);
void   FG_CDECL fg_defcolor (int, int);
void   FG_CDECL fg_defpages (int, int);
void   FG_CDECL fg_dispfile (char *, int, int);
void   FG_CDECL fg_display (char *, int, int);
void   FG_CDECL fg_displayp (char *, int, int);
void   FG_CDECL fg_draw (int, int);
void   FG_CDECL fg_drawmap (char *, int, int);
void   FG_CDECL fg_drawmask (char *, int, int);
void   FG_CDECL fg_drawrel (int, int);
void   FG_CDECL fg_drawrelx (int, int);
void            fg_drawrw (double, double);
void            fg_drawrxw (double, double);
void            fg_draww (double, double);
void   FG_CDECL fg_drawx (int, int);
void            fg_drawxw (double, double);
void   FG_CDECL fg_drect (int, int, int, int, char *);
void            fg_drectw (double, double, double, double, char *);
void   FG_CDECL fg_drwimage (char *, int, int);

int    FG_CDECL fg_egacheck (void);
void   FG_CDECL fg_ellipse (int, int);
void   FG_CDECL fg_ellipsef (int, int);
void            fg_ellipsew (double, double);
void            fg_ellipsfw (double, double);
void   FG_CDECL fg_erase (void);

void   FG_CDECL fg_fadein (int);
void   FG_CDECL fg_fadeout (int);
void   FG_CDECL fg_fillpage (void);
int    FG_CDECL fg_findpage (void);
void   FG_CDECL fg_flicdone (char *);
int    FG_CDECL fg_flichead (char *, char *);
int    FG_CDECL fg_flicmode (char *);
int    FG_CDECL fg_flicopen (char *, char *);
int    FG_CDECL fg_flicplay (char *, int, int);
void   FG_CDECL fg_flicsize (char *, int *, int *);
int    FG_CDECL fg_flicskip (char *, int);
void   FG_CDECL fg_flipmask (char *, int, int);
void   FG_CDECL fg_flood (int, int);
void            fg_floodw (double, double);
void   FG_CDECL fg_flpimage (char *, int, int);
void   FG_CDECL fg_fontsize (int);
int    FG_CDECL fg_freepage (int);

int    FG_CDECL fg_getaddr (void);
int    FG_CDECL fg_getattr (int, int);
void   FG_CDECL fg_getbanks (int *, int *);
void   FG_CDECL fg_getblock (farptr, int, int, int, int);
int    FG_CDECL fg_getchar (int, int);
void   FG_CDECL fg_getclip (int *, int *, int *, int *);
long   FG_CDECL fg_getclock (void);
int    FG_CDECL fg_getcolor (void);
void   FG_CDECL fg_getdacs (int, int, char *);
void   FG_CDECL fg_getentry (int, int *, int *);
int    FG_CDECL fg_gethpage (void);
void   FG_CDECL fg_getimage (char *, int, int);
int    FG_CDECL fg_getindex (int);
void   FG_CDECL fg_getkey (unsigned char *, unsigned char *);
int    FG_CDECL fg_getlines (void);
void   FG_CDECL fg_getmap (char *, int, int);
int    FG_CDECL fg_getmaxx (void);
int    FG_CDECL fg_getmaxy (void);
int    FG_CDECL fg_getmode (void);
int    FG_CDECL fg_getpage (void);
int    FG_CDECL fg_getpixel (int, int);
void   FG_CDECL fg_getrgb (int, int *, int *, int *);
void   FG_CDECL fg_getview (int *, int *, int *, int *, int *, int *, int *, int *);
int    FG_CDECL fg_getvpage (void);
void            fg_getworld (double *, double *, double *, double *);
int    FG_CDECL fg_getxbox (void);
int    FG_CDECL fg_getxjoy (int);
int    FG_CDECL fg_getxjust (void);
int    FG_CDECL fg_getxpos (void);
int    FG_CDECL fg_getybox (void);
int    FG_CDECL fg_getyjoy (int);
int    FG_CDECL fg_getyjust (void);
int    FG_CDECL fg_getypos (void);
int    FG_CDECL fg_gifhead (char *, char *);
int    FG_CDECL fg_gifmode (char *);
int    FG_CDECL fg_gifpal (char *, char *);
void   FG_CDECL fg_gifrange (char *, int *, int *, int *, int *);

void   FG_CDECL fg_hush (void);
void   FG_CDECL fg_hushnext (void);

void   FG_CDECL fg_imagebuf (farptr, unsigned);
long   FG_CDECL fg_imagesiz (int, int);
int    FG_CDECL fg_initems (void);
int    FG_CDECL fg_initjoy (int);
void   FG_CDECL fg_initpm (void);
void            fg_initw (void);
int    FG_CDECL fg_initxms (void);
int    FG_CDECL fg_inside (int *, int, int, int);
void   FG_CDECL fg_intjoy (int, char *, char *);
void   FG_CDECL fg_intkey (unsigned char *, unsigned char *);
void   FG_CDECL fg_invert (char *, int, int);

void   FG_CDECL fg_justify (int, int);

void   FG_CDECL fg_kbinit (int);
int    FG_CDECL fg_kblast (void);
void   FG_CDECL fg_kbreset (void);
int    FG_CDECL fg_kbtest (int);

int    FG_CDECL fg_loadpcx (char *, int);
void   FG_CDECL fg_locate (int, int);

int    FG_CDECL fg_makegif (int, int, int, int, char *);
int    FG_CDECL fg_makepcx (int, int, int, int, char *);
int    FG_CDECL fg_makeppr (int, int, int, int, char *);
int    FG_CDECL fg_makespr (int, int, int, int, char *);
int    FG_CDECL fg_maprgb (int, int, int);
int    FG_CDECL fg_measure (void);
long   FG_CDECL fg_memavail (void);
int    FG_CDECL fg_memory (void);
void   FG_CDECL fg_mouse256 (char *, int, int);
void   FG_CDECL fg_mousebut (int, int *, int *, int *);
void   FG_CDECL fg_mousecur (int, int);
void   FG_CDECL fg_mousefin (void);
int    FG_CDECL fg_mouseini (void);
void   FG_CDECL fg_mouselim (int, int, int, int);
void   FG_CDECL fg_mousemov (int, int);
void   FG_CDECL fg_mousepos (int *, int *, int *);
void   FG_CDECL fg_mouseptr (short *, int, int);
void   FG_CDECL fg_mousespd (int, int);
void   FG_CDECL fg_mousevis (int);
void   FG_CDECL fg_move (int, int);
void   FG_CDECL fg_moverel (int, int);
void            fg_moverw (double, double);
void            fg_movew (double, double);
void   FG_CDECL fg_music (char *);
void   FG_CDECL fg_musicb (char *, int);

int    FG_CDECL fg_numlock (void);

void   FG_CDECL fg_pack (char *, char *, int, int);
long   FG_CDECL fg_pagesize (void);
void   FG_CDECL fg_paint (int, int);
void            fg_paintw (double, double);
void   FG_CDECL fg_palette (int, int);
void   FG_CDECL fg_palettes (int *);
void   FG_CDECL fg_pan (int, int);
void            fg_panw (double, double);
void   FG_CDECL fg_pattern (int, int);
int    FG_CDECL fg_pcxhead (char *, char *);
int    FG_CDECL fg_pcxmode (char *);
int    FG_CDECL fg_pcxpal (char *, char *);
void   FG_CDECL fg_pcxrange (char *, int *, int *, int *, int *);
int    FG_CDECL fg_playing (void);
void   FG_CDECL fg_point (int, int);
void            fg_pointw (double, double);
void   FG_CDECL fg_pointx (int, int);
void            fg_pointxw (double, double);
void   FG_CDECL fg_polyedge (int);
void   FG_CDECL fg_polyfill (int *, int *, int);
void   FG_CDECL fg_polygon (int *, int *, int);
void            fg_polygonw (double *, double *, int);
void   FG_CDECL fg_polyline (int *, int);
void   FG_CDECL fg_polyoff (int, int);
void   FG_CDECL fg_print (char *, int);
void   FG_CDECL fg_printc (char *, int);
void   FG_CDECL fg_putblock (farptr, int, int, int, int);
void   FG_CDECL fg_putimage (char *, int, int);

void   FG_CDECL fg_quiet (void);

void   FG_CDECL fg_rect (int, int, int, int);
void            fg_rectw (double, double, double, double);
void   FG_CDECL fg_reset (void);
void   FG_CDECL fg_resize (int, int);
void   FG_CDECL fg_restore (int, int, int, int);
void            fg_restorew (double, double, double, double);
void   FG_CDECL fg_resume (void);
void   FG_CDECL fg_revimage (char *, int, int);
void   FG_CDECL fg_revmask (char *, int, int);

void   FG_CDECL fg_save (int, int, int, int);
void            fg_savew (double, double, double, double);
void   FG_CDECL fg_scale (char *, char *, int, int, int, int);
int    FG_CDECL fg_scrlock (void);
void   FG_CDECL fg_scroll (int, int, int, int, int, int);
void            fg_setangle (double);
void   FG_CDECL fg_setattr (int, int, int);
void   FG_CDECL fg_setbanks (int, int);
void   FG_CDECL fg_setcaps (int);
void   FG_CDECL fg_setclip (int, int, int, int);
void            fg_setclipw (double, double, double, double);
void   FG_CDECL fg_setcolor (int);
void   FG_CDECL fg_setdacs (int, int, char *);
void   FG_CDECL fg_setentry (int, int, int);
void   FG_CDECL fg_setfunc (int);
void   FG_CDECL fg_sethpage (int);
void   FG_CDECL fg_setlines (int);
void   FG_CDECL fg_setmode (int);
void   FG_CDECL fg_setnum (int);
void   FG_CDECL fg_setpage (int);
void            fg_setratio (double);
void   FG_CDECL fg_setrgb (int, int, int, int);
void            fg_setsize (int);
void            fg_setsizew (double);
void   FG_CDECL fg_setview (int, int, int, int, int, int, int, int);
void   FG_CDECL fg_setvpage (int);
void            fg_setworld (double, double, double, double);
void   FG_CDECL fg_shear (char *, char *, int, int, int, int);
int    FG_CDECL fg_showflic (char *, int, int);
int    FG_CDECL fg_showgif (char *, int);
int    FG_CDECL fg_showpcx (char *, int);
int    FG_CDECL fg_showppr (char *, int);
int    FG_CDECL fg_showspr (char *, int);
void   FG_CDECL fg_sound (int, int);
void   FG_CDECL fg_sounds (int *, int);
void   FG_CDECL fg_split (int);
void   FG_CDECL fg_stall (int);
void   FG_CDECL fg_suspend (void);
int    FG_CDECL fg_svgainit (int);
int    FG_CDECL fg_svgastat (void);
void   FG_CDECL fg_svgaver (int *, int *);
void            fg_swchar (char *, int, int);
double          fg_swlength (char *, int);
void            fg_swtext (char *, int, int);

void   FG_CDECL fg_tcdefine (int, int);
void   FG_CDECL fg_tcmask (int);
void   FG_CDECL fg_tcxfer (int, int, int, int, int, int, int, int);
int    FG_CDECL fg_testmode (int, int);
void   FG_CDECL fg_text (char *, int);
void   FG_CDECL fg_textc (char *, int);
void   FG_CDECL fg_transfer (int, int, int, int, int, int, int, int);

void   FG_CDECL fg_unpack (char *, char *, int);

long   FG_CDECL fg_vbaddr (int);
int    FG_CDECL fg_vballoc (int, int);
void   FG_CDECL fg_vbclose (void);
void   FG_CDECL fg_vbcopy (int, int, int, int, int, int, int, int);
void   FG_CDECL fg_vbcut (int, int, int, int, int, int);
int    FG_CDECL fg_vbdefine (hugeptr, int, int);
void   FG_CDECL fg_vbfree (int);
int    FG_CDECL fg_vbhandle (void);
void   FG_CDECL fg_vbinit (void);
int    FG_CDECL fg_vbopen (int);
void   FG_CDECL fg_vbpaste (int, int, int, int, int, int);
void   FG_CDECL fg_vbtccopy (int, int, int, int, int, int, int, int);
void   FG_CDECL fg_vbtcxfer (int, int, int, int, int, int);
void   FG_CDECL fg_vbundef (int);
void   FG_CDECL fg_version (int *, int *);
void   FG_CDECL fg_vgastate (int);
void   FG_CDECL fg_voice (int, int, int, int);
void   FG_CDECL fg_voices (int *, int);

void   FG_CDECL fg_waitfor (int);
void   FG_CDECL fg_waitkey (void);
void   FG_CDECL fg_waitvr (int);
void   FG_CDECL fg_where (int *, int *);

int    FG_CDECL fg_xalpha (int);
int    FG_CDECL fg_xconvert (int);
int             fg_xscreen (double);
int    FG_CDECL fg_xview (int);
double          fg_xworld (int);

int    FG_CDECL fg_yalpha (int);
int    FG_CDECL fg_yconvert (int);
int             fg_yscreen (double);
int    FG_CDECL fg_yview (int);
double          fg_yworld (int);

#ifdef __HIGHC__           /* MetaWare High C/C++ */
#pragma Global_aliasing_convention()
#endif

#ifdef __cplusplus
}
#endif

#endif                     /* of #ifndef __FASTGRAF_H */
