Program Demo08;

{ SPX library - GUI demo Copyright 1994 Scott D. Ramsay  }

{$X+ }  { Enable extended syntax }

Uses crt,spx_vga,spx_gui,spx_fnc,spx_sfn,spx_mos;

var
  i      : Tobjlist;           { Data structure to hold objects }
  cradio : integer;            { variable to keep track of which }
                               { radio button is enabled }

{ Initalize variables and create buttons, scrollers, etc }
procedure setbuttons;
var
  p : pbutton;
begin
  i.init;      { init object structure }
  cradio := 5; { Set radios to Default }
  with i do
    begin
     { create buttons }
      addobject(new(pbutton,init(20,20,65,20,1,#27,false,'|ESC| Quit')));
      addobject(new(pbutton,init(20,40,65,20,2,'2',false,'Button 2')));
     { create radio and check buttons }
      addobject(new(pradio,init(90,20,65,20,5,1,'5',false,'Default |5|',cradio=5)));
      addobject(new(pradio,init(90,40,65,20,6,1,'6',false,'Sienna |6|',cradio=6)));
      addobject(new(pradio,init(90,60,65,20,7,1,'7',false,'Random |7|',cradio=7)));
      addobject(new(pcheck,init(20,60,65,20,4,'4',false,'Chk box |4|',false)));
     { create scrollers }
      addobject(new(pscroll,init(20,100,100,15,8,1,100,1,50,true)));
      addobject(new(pscroll,init(160,20,15,100,9,1,100,2,50,false)));
     { create pick box }
      addobject(new(ppbox,init(180,20,100,10,10,'Pick Box')));
     { create string input boxes }
      addobject(new(pstring,init(20,80,100,20,3,'3',false,'String','Scott',6)));
      pstring(p)^.objectx := right;
      p := addobject(new(pstring,init(20,120,40,18,11,#0,false,'','50',3)));
     { modify horizontal placement of string in object }
      pstring(p)^.objectx := center;
    end;
end;


{ Setup program }
procedure setup;
begin
  openmode(2);   { open graphics mode with 1 virtual page }
  randomize;     { set random seed }
  cls(cl[1]);    { clear screen to desktop color }
  setbuttons;    { set object buttons }
  mousereset;    { init mouse routines }
  setdefptr;     { Set the default mouse pointer shape }
  mouseon;       { Make the mouse pointer visible }
end;


{ Redraw the screen and objects: Draw on page 2 then update to }
{ reduce redrawing flicker }
procedure redrawscreen;
begin
  setpageactive(2);     { set to page 2 }
  cls(cl[1]);           { clear the screen }
  i.showall;            { draw all objects }
  mouseoff;             { hide the mouse }
  pcopy(2,1);           { update the visual page }
  mouseon;              { turn the mouse back on }
  setpageactive(1);     { set page 1 as the active page }
end;


{ Check the return handle values and does the button's functions }
procedure CheckButtons(pr:integer;p:pbutton);
{ pr:integer;  Handle number of the object that was activated }
{ p:pbutton;   pointer to the activated object }
var
  s            : string;
  randomcolors : wcolortypes;
  t            : integer;
begin
  with i do
    case pr of
     { button - call disk dialog box }
      2 : begin
            s := diskdo(24,10,'','*','Enter file name to load',true);
            if s<>''
              then message('File is '+s,true);
          end;
     { check box - add an item to the pick box if the box is checked }
      4 : if pcheck(p)^.tchk
            then
              begin
               { get a pointer to the pick box object }
                p := retobject(10);
               { add a string to the pick box }
                ppbox(p)^.additem('scott '+lz(ppbox(p)^.getcount+1,3),0,true);
               { clear keyboard buffer and mouse presses }
                clearbuffer;
              end;
     { radio buttons - changes color only if random radio is selected or }
     {  the radio was not selected }
      5,6,7 : if (cradio<>pr) or (pr=7)
                then
                  begin
                    cradio := pr; { set the new radio button as selected }
                    case pr of
                      5 : menucolors := defaultcolors; { set default colors }
                      6 : menucolors := burntsienna;   { set burnt color }
                      7 : begin                        { set random colors }
                            for t := 0 to 7 do
                              with randomcolors[t] do
                                begin
                                  red := random(63);
                                  green := random(63);
                                  blue := random(63);
                                end;
                            menucolors := randomcolors;
                          end;
                    end;
                    adjustmenupalette; { try to match sys colors with the }
                                       {  current palette }
                    redrawscreen;      { Redraw the screen with the new }
                                       {  colors }
                  end;
     { Vertical scroller - update the string object }
      9 : begin
            t := pscroll(p)^.bpos; { grab the scroller position }
            p := retobject(11);    { get a pointer to the string object }
           { change the string value if the scroller value has changed }
            if vl(pstring(p)^.tstr)<>t
              then
                begin
                  pstring(p)^.tstr := st(t); { change the string data to the }
                                             {  scroller value }
                  mouseoff;                  { hide mouse }
                  p^.drawitemobject;         { redraw string object }
                  mouseon;                   { display mouse }
                end;
          end;
     { pick box - display string picked }
      10 : message('"Pick Box": '+ppbox(p)^.lhstr,true);
     { string object - validate text entry, and update scroller }
      11 : begin
             t := vl(pstring(p)^.tstr);  { grab text string }
             if not between(t,1,100)     { check for legal values }
               then
                 begin
                  { bad value? Set the string to the current scroller pos }
                   pstring(p)^.tstr := st(pscroll(retobject(9))^.bpos);
                   mouseoff;
                   p^.drawitemobject; { draw string object }
                   mouseon;
                 end
              else
                 begin
                  { good value. }
                   p := retobject(9); { get a pointer to the scroller }
                   pscroll(p)^.bpos := t; { change the scroller position }
                   mouseoff;
                   p^.drawitemobject;     { redraw the scroller }
                   mouseon;
                 end;
           end;
    end;
end;


{ Event loop }
procedure eventloop;
var
  pr : integer; { keeps track of return handles }
  p  : pbutton; { pointer to any activated objects }
begin
  redrawscreen; { draw screen }
  with i do
    repeat
      inkey;                 { grab, keyboard and mouse values }
      pr := CheckPress(p);   { scan, objects for actvation }
      if pr<>0               { if CHECKPRESS returns a non-zero val, }
                             { then an object was pressed or activated }
        then CheckButtons(pr,p); { handle object }
    until (pr=1) and yes('Quit SPXGUI test?'); { ask if want to quit. }
end;


{ do some clean up }
procedure cleanup;
begin
  i.done;    { deallocate object variables }
  closemode; { close graphics mode }
end;


procedure showit;
var
  i : tObjList;
begin
  clrscr;
  writeln('SPX library - GUI demo');
  writeln('Copyright 1993 Scott D. Ramsay');
  writeln;
  writeln('Use mouse or keyboard to pick selections');
  writeln(' Press the ESC or Click on Quit button to exit');
  writeln;
  write('Press SPACE to continue.');
  i.init;
  with i.io^ do
    begin
      clearbuffer;
      repeat
        inkey;
      until (ch=' ') and not funct;
    end;
  i.done;
end;


begin
  showit;
  setup;
  eventloop;
  cleanup;
end.
