Program Demo3;

{ SPX library - Sprite demo 2  Copyright 1994 Scott D. Ramsay  }

Uses crt,spx_vga,spx_vsp,spx_key,spx_obj,spx_img,spx_tim,spx_sfn,spx_fnc;

const
  path = '';
  max  = 10;
  framerate  : integer = 20;    { NOT in fps! }

type
  Pballs = ^Tballs;
  Tballs = object(Tobjs)
             width,height,              { dimension of sprite }
             kind,                      { sprite number }
             ox,oy,                     { old position }
             x,y,                       { new position }
             lvl,                       { ball level number }
             dx,dy : integer;           { direction }
             constructor init(nx,ny,k,l:integer);
             procedure drawitemobject;virtual;
             procedure eraseitemobject;virtual;
             procedure updateitemobject;virtual;
             procedure calcitemobject;virtual;
           end;

var
  balls : array[0..2] of pointer;
  pal   : RGBlist;
  head,
  tail  : plist;

procedure setup;
var
  p : plist;
  d : integer;
begin
  openmode(5);
  randomize;
  setpageactive(5);
  loadpcx(path+'virt1.pcx');
  setpageactive(3);
  loadpcx(path+'virt2.pcx');
  loadvsp(path+'balls.vsp',balls);
  loadcolors(path+'balls.pal',pal);
  head := nil; tail := nil;
  for d := 1 to max do
    begin
      new(p);
      p^.item := new(Pballs,init(random(320),random(200),d mod 3,d shl 1));
      p^.item^.powner := p;
      addp(head,tail,p);
    end;
  fsetcolors(zdc);  { all black palette }
  pcopy(5,4);       { copy virt page }
  pcopy(3,2);       { copy to work page }
  pcopy(3,1);       { copy to visual }
  fadein(40,pal);
end;


procedure placespeed(mode:objmode);
begin
  case mode of
    dDraw   : begin
               putletter(5,5,5,st(framerate));
               putletter(4,4,255,st(framerate));
             end;
    dErase  : CopyRect(4,4,50,12,pages[3]^,pages[2]^);
    dUpdate : CopyRect(4,4,50,12,pages[2]^,pages[1]^);
  end;
end;


procedure animate;
var
  p : pointer;
begin
  setpageactive(2);
  setrate(1000);
  repeat
    f_clk[0] := framerate;
    if key[KEY_PLUS] and (framerate<60)
      then inc(framerate)
      else
        if key[KEY_MINUS] and (framerate>0)
          then dec(framerate);
    doallitems(head,dErase);
    placespeed(dErase);
    if not key[KEY_SPACE]
      then doallitems(head,dCalc);
    doallitems(head,dDraw);
    placespeed(dDraw);
    doallitems(head,dUpdate);
    placespeed(dUpdate);
    if key[KEY_ENTER]
      then
        begin
          pcopy(4,1);
          repeat until not key[KEY_ENTER];
          pcopy(3,1);
        end;
    repeat until (f_clk[0]=0);
  until key[KEY_ESC];
end;

(**) { Tballs methods }

constructor Tballs.init(nx,ny,k,l:integer);
begin
  Tobjs.init;
  kind := k;
  lvl := l;
  x := nx; y := ny; 
  ox := x; oy := y;
  repeat
    dx := random(7)-3;
    dy := random(7)-3;
  until (dx<>0) and (dy<>0);
  imagedims(balls[kind]^,width,height);
end;


procedure Tballs.eraseitemobject;
begin
  CopyRect(x,y,x+width-1,y+height-1,pages[5]^,pages[4]^);
  CopyRect(ox,oy,ox+width-1,oy+height-1,pages[3]^,pages[2]^);
  CopyRect(x,y,x+width-1,y+height-1,pages[3]^,pages[2]^);
end;


procedure Tballs.updateitemobject;
begin
  CopyRect(ox,oy,ox+width-1,oy+height-1,pages[2]^,pages[1]^);
  CopyRect(x,y,x+width-1,y+height-1,pages[2]^,pages[1]^);
end;


procedure Tballs.drawitemobject;
begin
  displayer(x,y,balls[kind]^,pages[4]^,lvl);
  dispvirt(x,y,balls[kind]^,pages[4]^,lvl);
end;


procedure Tballs.calcitemobject;
begin
  ox := x; oy := y;
  inc(x,dx); inc(y,dy);
  if (x<0) or (x>320-width)
    then dx := -dx;
  if (y<0) or (y>199-height)
    then dy := -dy;
  ifix(x,0,320-width);
  ifix(y,0,200-height);
end;


procedure showit;
begin
  clrscr;
  writeln('SPX library - Sprite demo 2');
  writeln('Copyright 1993 Scott D. Ramsay');
  writeln;
  writeln('Keys:');
  writeln(' ESC          - quit demo');
  writeln(' +/-          - change frame speed');
  writeln(' SPACE        - pause ');
  writeln(' ENTER        - view sprite level page');
  writeln;
  write('Press SPACE to continue.');
  clearbuffer;
  repeat until key[KEY_SPACE];
end;


begin
  showit;
  setup;
  animate;
  clean_plist(head,tail);
  closemode;
end.
