
; Tiny 320x200x256 gfx library, ASM function calls

    IDEAL
    MODEL   small
    CODESEG
    LOCALS
    P386

    PUBLIC putpixel,getpixel,mode320,modetext,vline,hline,vlinedata,hlinedata
    PUBLIC clr320,drawbitmap,getbitmap,wait4vrt,bline,getpal,putpal,getpalcol
    PUBLIC putpalcol,fillbox

; void putpixel(int x, int y, char col);
; void mode320(void);
; void modetext(void);
; char getpixel(int x, int y);
; void bline(int sx, int sy, int ex, int ey, char col);
; void blinedata(int sx, int sy, int ex, int ey, char far *data);
; void hline(int y, char col);
; void hlinedata(int y, char far *data);
; void vline(int x, char col);
; void vlinedata(int x, char far *data);
; void clr320(char col);
; void drawbitmap(int x, int y, int xlen, int ylen, char far *data);
; void getbitmap(int x, int y, int xlen, int ylen, char far *data);
; void wait4vrt(void);
; void putpalcol(int col, char red, char green, char blue);
; void getpolcol(int col, char far *red, char far *green, char far *blue);
; void getpal(int startcol, char far *pal);
; void putpal(int startcol, char far *pal);
; int  getoffset(int x, int y);
; void circle(int x, int y, int rad, char col);
; void fillbox(int x, int y, int xlen, int ylen, char col);

;---------------------------------------------------------------------------
; PutPixel      Writes a pixel
;---------------------------------------------------------------------------
; INPUT: AX - X
;        DX - Y
;        BL - Colour
; REGISTERS: DI
PROC    putpixel
        mov     di,ax
        mov     ax,dx
        shl     dx,8
        shl     ax,6
        add     ax,dx
        add     di,ax
        mov     al,bl
        stosb                               ;write pixel
        ret
ENDP    putpixel

;---------------------------------------------------------------------------
; Mode320       Sets mode 13h
;---------------------------------------------------------------------------
; REGISTERS: AX
PROC    mode320                             ;get into mode 13h
        mov     ax,13h
        int     10h
        ret
ENDP    mode320

;---------------------------------------------------------------------------
; ModeText      Sets standard text mode (3)
;---------------------------------------------------------------------------
; REGISTERS: AX
PROC    modetext                            ;get into mode 3 (text)
        mov     ax,3
        int     10h
        ret
ENDP    modetext

;---------------------------------------------------------------------------
; GetPixel      Gets a pixel from screen
;---------------------------------------------------------------------------
; INPUT:    AX - X
;           DX - Y
; OUTPUT:   AL - Color
; REGISTERS: SI
PROC    getpixel
        push    ds
        mov     si,ax
        mov     ax,es
        mov     ds,ax                       ;set es to VGA seg
        mov     ax,dx
        shl     ax,6
        shl     dx,8
        add     ax,dx
        add     si,ax
        lodsb
        pop     ds
        ret
ENDP    getpixel
;---------------------------------------------------------------------------
; HLine         Draws a horizontal line
;---------------------------------------------------------------------------
; INPUT:    AL - Colour
;           DX - Y
; REGISTERS: BX DI CX
PROC    hline
        mov     bx,dx
        shl     bx,6
        shl     dx,8
        add     bx,dx
        mov     di,bx
        mov     cx,160
        mov     ah,al
        cld
        rep     stosw                       ;fill line with col
        ret
ENDP    hline
;---------------------------------------------------------------------------
; VLine         Draws a vertical line
;---------------------------------------------------------------------------
; INPUT: AX - X
;        BL - Colour
; REGISTERS: CX DX DI
PROC    vline
        mov     di,ax                       ;set correct row
        mov     al,bl
        mov     cx,200
@@Line:
        stosb                               ;draw pixel
        add     di,319                      ;just 319, since stosb incs di
        dec     cx
        ja      SHORT @@Line
        ret
ENDP    vline
;---------------------------------------------------------------------------
; HLineData     Draws a filled horizontal line
;---------------------------------------------------------------------------
; INPUT:    DX - Y
;           DS:SI - pointer to 200 bytes of data
; REGISTERS: CX DI
PROC    hlinedata
        mov     ax,dx
        shl     ax,6
        shl     dx,8
        add     ax,dx
        mov     di,ax
        mov     cx,160
        cld
        rep     movsw                       ;mov from ds:si to es:di
        ret
ENDP    hlinedata
;---------------------------------------------------------------------------
; VLineData     Draws a filled vertical line
;---------------------------------------------------------------------------
; INPUT:    AX - X
;           DS:SI - pointer to 320 bytes of data
; REGISTERS: DI CX
PROC    vlinedata
        mov     di,ax                       ;es:di -> x,y
        mov     cx,200
@@Row:  movsb
        add     di,319
        dec     cx
        jb      SHORT @@Row
        ret
ENDP    vlinedata
;---------------------------------------------------------------------------
; Clr320        Clears a 320 screen
;---------------------------------------------------------------------------
; INPUT:    AL - Color
; REGISTERS: EAX CX DI
PROC    clr320
        mov     ah,al
        mov     cx,ax
        rol     eax,10h
        mov     ax,cx
        mov     cx,16000
        sub     di,di
        cld
        rep     stosd                       ;fill a000 with col
        ret
ENDP    clr320
;---------------------------------------------------------------------------
; DrawBitmap    Draws a section of data to screen
;---------------------------------------------------------------------------
; INPUT:    AX - X
;           DX - Y
;           CX - XLEN
;           BX - YLEN
;           DS:SI - pointer to data
; REGISTERS: DI GS
PROC   drawbitmap
        mov     gs,ax
        mov     di,ax
        mov     ax,dx
        shl     ax,6
        shl     dx,8
        add     ax,dx
        add     di,ax                       ;es:di -> x,y
        mov     ax,gs
        add     ax,320
        sub     ax,cx
        mov     dx,gs
        sub     ax,dx                      ;find length between x+xlen and x+320
@@Draw:
        rep     movsb                       ;move line
        add     di,ax                       ;next line
        dec     bx
        ja      SHORT @@Draw
        ret
ENDP    drawbitmap
;---------------------------------------------------------------------------
; GetBitmap     Reads a bitmap from screen
;---------------------------------------------------------------------------
; INPUT:    AX - X
;           DX - Y
;           CX - Xlen
;           BX - Ylen
;           DS:SI - pointer to save buffer
; REGISTERS: DI GS ES
PROC    getbitmap
        mov     gs,ax
        push    ds
        mov     ax,es
        mov     ds,ax                       ;set ds to VGA seg
        pop     es                          ;set es to buffer
        mov     si,gs
        mov     ax,dx
        shl     ax,6
        shl     dx,8
        add     ax,dx
        add     si,ax                       ;ds:si -> x,y
        mov     ax,gs
        add     ax,320
        sub     ax,cx
        mov     dx,gs
        sub     ax,dx                      ;find length between x+xlen & x+320
        mov     gs,cx
@@Draw:
        rep     movsb                       ;move line
        add     si,ax
        mov     cx,gs
        dec     bx
        ja      SHORT @@Draw
        ret
ENDP    getbitmap
;---------------------------------------------------------------------------
; Wait4Vrt      Wait for Vertical Retrace
;---------------------------------------------------------------------------
; REGISTERS: AX DX
PROC    wait4vrt
        mov     dx,3dah
@@VRT:  in      al,dx                   ;Wait for VRT to start
        test    al,8
        jnz     @@VRT
@@NoVRT:in      al,dx                   ;Wait for VRT to stop
        test    al,8
        jz      @@NoVRT
        ret
ENDP    wait4vrt
;---------------------------------------------------------------------------
; PutPalCol     Puts a color into the palette
;---------------------------------------------------------------------------
; INPUT:    AL  - Color Number
;           EBX - Color values (BL=Red, BH=Green, EBL=Blue)
; REGISTERS: DX
PROC    putpalcol
        mov     dx,3c8h
        out     dx,al
        inc     dx
        mov     al,bl
        out     dx,al
        mov     al,bh
        out     dx,al
        ror     ebx,10h
        mov     al,bl
        out     dx,al
        ret
ENDP    putpalcol
;---------------------------------------------------------------------------
; GetPalCol     Get palette color
;---------------------------------------------------------------------------
; INPUT:    AL - Color number
; OUTPUT:   EBX - color (see PutPalCol)
PROC    getpalcol
        mov     dx,3c8h
        out     dx,al
        inc     dx
        in      al,dx
        mov     bl,al
        in      al,dx
        mov     bh,al
        in      al,dx
        rol     ebx,10h
        mov     bl,al
        rol     ebx,10h
        ret
ENDP    getpalcol
;---------------------------------------------------------------------------
; GetPal        Get the entire palette
;---------------------------------------------------------------------------
; INPUT:    AL - Start color
;           ES:DI - pointer to 768 bytes of save space
; REGISTERS: CX DX
PROC    getpal
        mov     dx,3c8h
        out     dx,al
        inc     dx
        mov     cx,768
        sub     cl,al
        rep     insb
        ret
ENDP    getpal
;---------------------------------------------------------------------------
; PutPal        Puts the palette to VGA card
;---------------------------------------------------------------------------
; INPUT:    AL - start color
;           ES:DI - pointer to color palette
; OUTPUT:
PROC    putpal
        mov     dx,3c8h
        out     dx,al
        inc     dx
        mov     cx,768
        sub     cl,al
        rep     outsb
        ret
ENDP    putpal

;---------------------------------------------------------------------------
; BLine         Draws a Bresenham's Line
;---------------------------------------------------------------------------
; INPUT     AX - Start X
;           DX - Start Y
;           CX - End X
;           BX - End Y
;           DI - Color
; REGISTERS:
PROC    bline
        LOCAL   deltax:WORD, deltay:WORD, col:WORD,sx:WORD,sy:WORD
        push    bp si
        mov     bp,sp                       ;Setup Local Stack Frame
        sub     bp,16                       ;Add space for LOCALS (actually 10)
        mov     [sx],ax
        mov     [sy],dx
        mov     [col],di
        sub     cx,ax                       ;d(elta)x = ex-sx
        sub     bx,dx                       ;cx(deltay) =ey-sy

        mov     ax,bx

        cmp     cx,0
        je      SHORT @@checky              ;deltax is 0
        mov     bx,OFFSET cs:@@Xinc
;------------TESTING CX (end X)
        bt      cx,0fh
        jc      SHORT @@decx                ;deltax is negative
@@incx:
        ;inc     bl                          ;dx is horizontal to the right
        mov     [WORD cs:bx],046FFh
        mov     [BYTE cs:bx+02],0F8h          ;set incx to inc [bp-08]
        jnc     SHORT @@checky
@@decx:
        ;dec     bl
        mov     [WORD cs:bx],04EFFh
        mov     [BYTE cs:bx+02],0F8h          ;set incx to dec [bp-08]
@@checky:

;-------------TESTING AX (end Y)
        cmp     ax,0
        je      SHORT @@InvX
        mov     bx,OFFSET @@Yinc
        bt      ax,0fh
        jc      SHORT @@decy
@@incy:
        ;inc     bh
        mov     [WORD cs:bx],046FFh
        mov     [BYTE cs:bx+02],0F6h          ;set incy to inc [bp-0A]
        jnc     SHORT @@InvX
@@decy:
        ;dec     bh
        mov     [WORD cs:bx],04EFFh
        mov     [BYTE cs:bx+02],0F6h          ;set incy to dec [bp-0A]
@@InvY:
        neg     ax                           ;inverse sign
@@InvX:                                     ;inverse sign
        cmp     cx,0
        jns     SHORT @@CheckDist
        neg     cx
@@CheckDist:
        mov     si,ax                       ;set distance to deltaY
        cmp     cx,ax
        jbe     SHORT @@disty               ;
        mov     si,cx                       ;no, correct to deltaX
@@disty:
        mov     [deltax],cx
        mov     [deltay],ax
        mov     cx,si                       ;loopcount
        xor     bx,bx
        xor     dx,dx
;DrawLoop
@@DrawLoop:
        add     bx,[deltax]                 ;xerr+=deltax
        add     dx,[deltay]                 ;yerr+=deltay
        cmp     bx,si                       ;if(xerr > distance)
        jbe     SHORT @@ContinueX
        sub     bx,si                       ;xerr-=distance
@@Xinc: nop
        nop
        nop                                 ;here goes the inc/dec [bp+04]
@@ContinueX:
@@PastXSave:
        cmp     dx,si                       ;if(yerr > distance)
        jbe     SHORT @@ContinueY
        sub     dx,si                       ;yerr-=distance
@@Yinc: nop
        nop
        nop                                 ;here goes the inc/dec [bp+06]
@@ContinueY:
        mov     ax,[sy]
        rol     edx,10h
        mov     dx,ax
        shl     ax,6
        shl     dx,8
        add     ax,dx
        add     ax,[sx]
        mov     di,ax                       ;es:di -> pixel
        mov     ax,[col]                    ;put pixel in al
        stosb                               ;write pixel
        ror     edx,10h
        dec     cx
        cmp     cx,0
        ja      SHORT @@DrawLoop
@@GoHome:
        pop     si bp
        ret
ENDP    bline

;---------------------------------------------------------------------------
; FillBox       Draws a filled box to screen
;---------------------------------------------------------------------------
; INPUT:    AX - left
;           BX - top
;           CX - right
;           DX - bottom
;           DI - color
; REGISTERS: gs
PROC    fillbox
        push    di
        mov     gs,ax
        mov     di,ax                           ;StartX
        mov     ax,bx
        shl     ax,8
        shl     bx,6
        add     ax,bx
        add     di,ax                           ;+StartY
        shr     bx,6                            ;Restore reg
        sub     dx,bx                           ;# line
        mov     bx,gs
        add     bx,320
        sub     bx,cx                           ;len between lines
        mov     ax,gs
        sub     cx,ax                           ;Line length
        mov     gs,cx
        pop     ax                              ;get color
@@HLoop:
        rep     stosb
        add     di,bx
        mov     cx,gs                           ;Line length
        dec     dx
        ja      @@HLoop
        ret
ENDP    fillbox
        END
