
; Tiny 320x200x256 gfx library, C function calls

; Note worx only with TASM 2.0 - 3.1 !!

        IDEAL
        MODEL small
        STACK  100h
        CODESEG
        LOCALS
        P386

; void putpixel(int x, int y, char col);
; void mode320(void);
; void modetext(void);
; char getpixel(int x, int y);
; void bline(int sx, int sy, int ex, int ey, char col);
; void blinedata(int sx, int sy, int ex, int ey, char far *data);
; void hline(int y, char col);
; void hlinedata(int y, char far *data);
; void vline(int x, char col);
; void vlinedata(int x, char far *data);
; void clr320(char col);
; void drawbitmap(int x, int y, int xlen, int ylen, char far *data);
; void getbitmap(int x, int y, int xlen, int ylen, char far *data);
; void wait4vrt(void);
; void putpalcol(int col, char red, char green, char blue);
; void getpolcol(int col, char far *red, char far *green, char far *blue);
; void getpal(int startcol, char far *pal);
; void putpal(int startcol, char far *pal);
; int  getoffset(int x, int y);
; void circle(int x, int y, int rad, char col);
; void fillbox(int x, int y, int xlen, int ylen, char col);

PUBLIC  putpixel
PROC C  putpixel
        ARG     x:WORD, y:WORD, c:BYTE
        push    di
        mov     ax,0a000h
        mov     es,ax                       ;set es to VGA segment
        mov     di,[x]
        mov     dx,[y]
        mov     ax,dx
        shl     dx,8
        shl     ax,6
        add     ax,dx
        add     di,ax
        mov     al,[c]
        stosb                               ;write pixel
        pop     di
        ret
ENDP    putpixel

PUBLIC  mode320
PROC C  mode320                          ;get into mode 13h
        mov     ax,13h
        int     10h
        ret
ENDP    mode320

PUBLIC  modetext
PROC C  modetext                          ;get into mode 3 (text)
        mov     ax,3
        int     10h
        ret
ENDP    modetext

PUBLIC  getpixel
PROC C  getpixel
        ARG     x:WORD, y:WORD
        push    si
        mov     bx,ds
        mov     ax,0a000h
        mov     ds,ax                       ;set es to VGA seg
        mov     si,[x]
        mov     dx,[y]
        mov     ax,dx
        shl     ax,6
        shl     dx,8
        add     ax,dx
        add     si,ax
        lodsb
        xor     ah,ah
        mov     ds,bx
        pop     si
        ret
ENDP    getpixel

PUBLIC  hline
PROC C  hline
        ARG     line:WORD,col:BYTE
        mov     ax,0a000h
        mov     es,ax                       ;set es to VGA seg
        mov     dx,[line]
        mov     ax,dx
        shl     ax,6
        shl     dx,8
        add     ax,dx
        mov     di,ax
        mov     cx,160
        mov     al,[col]
        mov     ah,al
        cld
        rep     stosw                       ;fill line with col
        ret
ENDP    hline
PUBLIC  vline
PROC C  vline
        ARG     row:WORD, c:BYTE
        mov     ax,0a000h
        mov     es,ax                       ;set es to VGA seg
        mov     di,[row]                    ;set correct row
        mov     al,[c]
        mov     cx,200
        cld
@@Line:
        stosb                               ;draw pixel
        add     di,319                      ;just 319, since stosb incs di
        dec     cx
        cmp     cx,0
        ja      SHORT @@Line
        ret
ENDP    vline
PUBLIC  hlinedata
PROC C  hlinedata
        ARG     line:WORD, data:DWORD
        push    ds
        mov     ax,0a000h
        mov     es,ax                       ;set es to VGA seg
        mov     ax,[line]
        mov     dx,ax
        shl     ax,6
        shl     dx,8
        add     ax,dx
        mov     di,ax
        lds     si,[data]
        mov     cx,160
        cld
        rep     movsw                       ;mov from ds:si to es:di
        pop     ds
        ret
ENDP    hlinedata
PUBLIC  vlinedata
PROC C  vlinedata
        ARG     row:WORD,data:DWORD
        push    ds
        mov     ax,0a000h
        mov     es,ax
        mov     di,[row]                    ;es:di -> x,y
        lds     si,[data]                   ;ds:si -> bitmap
        mov     cx,200
@@Row:  movsb
        add     di,319
        dec     cx
        cmp     cx,200
        jb      SHORT @@Row
        pop     ds
        ret
ENDP    vlinedata
PUBLIC  clr320
PROC C  clr320
        ARG     col:BYTE
        push    di
        mov     ax,0a000h
        mov     es,ax
        mov     cx,16000
        mov     al,[col]
        mov     ah,al
        push    ax
        shl     eax,16
        pop     ax
        sub     di,di
        cld
        rep     stosd                       ;fill a000 with col
        pop     di
        ret
ENDP    clr320
PUBLIC  drawbitmap
PROC C  drawbitmap
        ARG     x:WORD, y:WORD, xlen:WORD, ylen:WORD, bitmap:DWORD
        push    ds
        push    di
        mov     ax,0a000h
        mov     es,ax                       ;set es to VGA seg
        mov     di,[x]
        mov     ax,[y]
        mov     dx,ax
        shl     ax,6
        shl     dx,8
        add     ax,dx
        add     di,ax                       ;es:di -> x,y
        mov     dx,[ylen]
        lds     si,[bitmap]                 ;ds:si -> bitmap
        mov     ax,[x]
        add     ax,320
        sub     ax,[xlen]
        sub     ax,[x]                      ;find length between x+xlen and x+320
        cld
@@Draw:
        mov     cx,[xlen]
        rep     movsb                       ;move line
        add     di,ax                       ;next line
        dec     dx
        cmp     dx,0
        ja      SHORT @@Draw
        pop     di
        pop     ds
        ret
ENDP    drawbitmap

PUBLIC  getbitmap
PROC C  getbitmap
        ARG     x:WORD, y:WORD, xlen:WORD, ylen:WORD, bitmap:DWORD
        push    ds
        push    si
        push    di
        les     di,[bitmap]
        mov     ax,ds
        mov     es,ax                       ;es:di -> bitmap
        mov     ax,0a000h
        mov     ds,ax                       ;set es to VGA seg
        mov     si,[x]
        mov     ax,[y]
        mov     dx,ax
        shl     ax,6
        shl     dx,8
        add     ax,dx
        add     si,ax                       ;ds:si -> x,y
        mov     dx,[ylen]
        mov     ax,[x]
        add     ax,320
        sub     ax,[xlen]
        sub     ax,[x]                      ;find length between x+xlen & x+320
        cld
@@Draw:
        mov     cx,[xlen]
        rep     movsb                       ;move line
        add     si,ax
        dec     dx
        cmp     dx,0
        ja      SHORT @@Draw
        pop     di
        pop     si
        pop     ds
        ret
ENDP    getbitmap

PUBLIC  wait4vrt
PROC C  wait4vrt
        mov     dx,3dah
@@VRT:  in      al,dx                   ;Wait for VRT to start
        test    al,8
        jnz     @@VRT
@@NoVRT:in      al,dx                   ;Wait for VRT to stop
        test    al,8
        jz      @@NoVRT
        ret
ENDP    wait4vrt

PUBLIC  putpalcol
PROC C  putpalcol
        ARG     colnum:BYTE, red:BYTE, green:BYTE, blue:BYTE
        mov     dx,3c8h
        mov     al,[colnum]
        out     dx,al
        inc     dx
        mov     al,[red]
        out     dx,al
        mov     al,[green]
        out     dx,al
        mov     al,[blue]
        out     dx,al
        ret
ENDP    putpalcol

PUBLIC	getpalcol
PROC C  getpalcol
        ARG     colnum:BYTE, red:DWORD, green:DWORD, blue:DWORD
        mov     dx,3c8h
        mov     al,[colnum]
        out     dx,al
        inc     dx
        in      al,dx
        mov     [BYTE PTR red],al
        in      al,dx
        mov     [BYTE PTR green],al
        in      al,dx
        mov     [BYTE PTR blue],al
        ret
ENDP    getpalcol

PUBLIC  getpal
PROC C  getpal
        ARG     colnum:BYTE, data:DWORD
        mov     dx,3c8h
        mov     al,[colnum]
        out     dx,al
        inc     dx
        push    es
        mov     ax,ds
        mov     es,ax
        les     di,[data]
        mov     cx,768
        sub     cl,[colnum]
        rep     insb
        ret
ENDP    getpal
PUBLIC  putpal
PROC C  putpal
        ARG     colnum:BYTE, data:DWORD
        push    ds
        push    si
        mov     dx,3c8h
        mov     al,[colnum]
        out     dx,al
        inc     dx
        push    es
        mov     ax,ds
        mov     es,ax
        lds     si,[data]
        add     si,4
        mov     cx,768
        sub     cl,[colnum]
        rep     outsb
        pop     si
        pop     ds
        ret
ENDP    putpal

PUBLIC  bline
PROC C  bline
        ARG     sx:WORD, sy:WORD, ex:WORD, ey:WORD, col:BYTE
        LOCAL   deltax:WORD, deltay:WORD
        push    di si

        mov     ax,0a000h
        mov     es,ax                           ;es -> 0a000h VGA seg
        mov     al,[col]
        mov     gs,ax                           ;save col into GS

        mov     dx,[ex]
        mov     cx,[ey]
        sub     dx,[sx]                         ;d(elta)x = ex-sx
        sub     cx,[sy]                         ;cx(deltay) =ey-sy

        cmp     dx,0
        je      SHORT @@checky                  ;deltax is 0

        mov     bx,OFFSET cs:@@Xinc
        js      SHORT @@decx                    ;deltax is negative
@@incx:
        ;inc     bl                             ;dx is horizontal to the right
        mov     [WORD cs:bx],046FFh
        mov     [BYTE cs:bx+02],04              ;set incx to inc [bp+04]
        jmp     SHORT @@checky
@@decx:
        ;dec     bl
        mov     [WORD cs:bx],04EFFh
        mov     [BYTE cs:bx+02],04              ;set incx to dec [bp+04]
        neg     dx
@@checky:
        cmp     cx,0
        je      SHORT @@comealong
        mov     bx,OFFSET @@Yinc
        jns     SHORT @@incy                    ;CX is negative
        jmp     SHORT @@decy
@@incy:
        ;inc     bh
        mov     [WORD cs:bx],046FFh
        mov     [BYTE cs:bx+02],06              ;set incy to inc [bp+06]
        jmp     SHORT @@comealong
@@decy:
        ;dec     bh
        mov     [WORD cs:bx],04EFFh
        mov     [BYTE cs:bx+02],06              ;set incy to dec [bp+06]
        neg     cx
@@comealong:
@@CheckDist:
        mov     si,cx                           ;set distance to deltaY
        cmp     dx,cx
        jbe     SHORT @@disty                   ;
        mov     si,dx                           ;no, correct to deltaX
@@disty:
        mov     [deltax],dx
        mov     [deltay],cx
        mov     cx,si                           ;loopcount
        xor     bx,bx
        xor     dx,dx

;DrawLoop
@@DrawLoop:
        add     bx,[deltax]                     ;xerr+=deltax
        add     dx,[deltay]                     ;yerr+=deltay
        cmp     bx,si                           ;if(xerr > distance)
        jbe     SHORT @@ContinueX
        sub     bx,si                           ;xerr-=distance
@@Xinc: nop
        nop
        nop                                     ;here goes the inc/dec [bp+04]
@@ContinueX:
@@PastXSave:
        cmp     dx,si                           ;if(yerr > distance)
        jbe     SHORT @@ContinueY
        sub     dx,si                           ;yerr-=distance
@@Yinc: nop
        nop
        nop                                     ;here goes the inc/dec [bp+06]
@@ContinueY:
        mov     ax,[sy]
        mov     di,ax
        shl     ax,6
        shl     di,8
        add     di,ax
        add     di,[sx]
        mov     ax,gs                           ;put color in al
        stosb                                   ;write pixel
        dec     cx                              ;since add ax,[sx] will never
        ja      SHORT @@DrawLoop                ; set carry flag (in 320x200)
@@GoHome:
        pop     si di
        ret
ENDP    bline

PUBLIC  blinedata
PROC C  blinedata
        ARG     sx:WORD, sy:WORD, ex:WORD, ey:WORD, data:DWORD
        LOCAL   deltax:WORD, deltay:WORD, dist:WORD
        push    di
        push    si
        push    ds
        cld
        lds     si,[data]
        mov     ax,0a000h
        mov     es,ax                       ;es -> 0a000h VGA seg
        mov     dx,[ex]
        mov     cx,[ey]
        sub     dx,[sx]                     ;d(elta)x = ex-sx
        sub     cx,[sy]                     ;cx(deltay) =ey-sy
;COMPUTE DIRECTION OF THE INCREMENT
        cmp     dx,0
        je      SHORT @@eqx                 ;deltax is 0
        bt      dx,0fh
        jc      SHORT @@decx                ;deltax is negative
@@incx: mov     bl,1                        ;dx is horizontal to the right
        jnc     SHORT @@checky              ;MODIFIED !!!!!!!
@@decx: mov     bl,-1                       ;dx is horizontal to the left
        jc      SHORT @@checky              ;MODIFIED !!!!!!
@@eqx:  sub     bl,bl                       ;dx is vertical
@@checky:
        cmp     cx,0
        je      SHORT @@eqy                 ;deltay is 0
        bt      cx,0fh
        jc      SHORT @@decy                ;deltay is negative
@@incy: mov     bh,1                        ;cx is vertical downwards
        jnc     SHORT @@comealong           ;MODIFIED !!!!!!!
@@decy: mov     bh,-1                       ;cx is vertical upwards
        jc      SHORT @@comealong           ;MODIFIED
@@eqy:  sub     bh,bh                       ;cx is horizontal
;ABS BOTH DELTA VARIABLES
@@comealong:
        bt      dx,0fh
        jnc     SHORT @@AbsY                ;if sign bit is on
        neg     dx                          ; turn it off
@@AbsY:
        bt      cx,0fh
        jnc     SHORT @@CheckDist
        neg     cx
@@CheckDist:
;CHECK WHICH DISTANCE IS GREATER
        cmp     dx,cx
        jbe     SHORT @@disty               ;disty is longer set dist to cx
        mov     [dist],dx                   ;disx is longer, set distance to
        jae     SHORT @@patsy               ; deltaX
@@disty:
        mov     [dist],cx                   ;set distance to deltaY
@@patsy:
        mov     [deltax],dx
        mov     [deltay],cx
        mov     cx,[dist]                   ;loopcount
        xor     ax,ax
        xor     dx,dx
;DRAW THE PIXELS
@@DrawLoop:
        add     ax,[deltax]                 ;xerr+=deltax
        add     dx,[deltay]                 ;yerr+=deltay
        cmp     ax,[dist]                   ;if(xerr > distance)
        jbe     SHORT @@ContinueX
        sub     ax,[dist]                   ;xerr-=distance
        rol     eax,10h
        mov     al,bl
        cbw
        add     [WORD sx],ax                ;sx+=incx
        jmp     SHORT @@PastXSave
@@ContinueX:
        rol     eax,10h
@@PastXSave:
        cmp     dx,[dist]                   ;if(yerr > distance)
        jbe     SHORT @@ContinueY
        sub     dx,[dist]                   ;yerr-=distance
        mov     al,bh
        cbw
        add     [WORD sy],ax                ;sy+=incy
@@ContinueY:
        mov     ax,[sy]
        rol     edx,10h
        mov     dx,ax
        shl     ax,6
        shl     dx,8
        add     ax,dx
        ror     edx,10h
        add     ax,[sx]
        mov     di,ax                       ;es:di -> pixel
        mov     ax,cx
        mov     cx,1
        movsb                               ;write pixel
        mov     cx,ax
        ror     eax,16
        dec     cx
        cmp     cx,0
        ja      SHORT @@DrawLoop
@@GoHome:
        pop     ds
        pop     si
        pop     di
        ret
ENDP    blinedata

PUBLIC  getoffset
PROC C  getoffset
        ARG     x:WORD, y:WORD
        mov     ax,[y]
        mov     dx,ax
        shl     ax,6
        shl     dx,8
        add     ax,dx
        add     ax,[x]
        ret
ENDP    getoffset

PUBLIC  fillbox
PROC C  fillbox
        ARG     x:WORD, y:WORD, xlen:WORD; ylen:WORD, col:BYTE
        push    di si ds

        mov     di,[y]
        mov     ax,di
        shl     ax,6
        shl     di,8
        add     di,ax
        add     di,[x]

        mov     bx,[ylen]
        dec     bx
@@looper:
        mov     al,[col]
        mov     cx,[xlen]
        rep     stosb
        dec     bx
        jns     @@looper

        pop     ds si di
        ret
ENDP    fillbox

PUBLIC  bcircle
PROC C  bcircle
        ARG     cnx:WORD, cny:WORD, rad:WORD, col:BYTE
        LOCAL   x:WORD, y:WORD, d:WORD,flag:BYTE
        push    di
        push    si

        mov     ax,0a000h
        mov     es,ax

        mov     [flag],0

        mov     [d],3
        mov     cx,[rad]
        mov     bx,cx
        shl     bx,1
        sub     [d],bx                  ;d=3-(2*rad)
        mov     bx,0                    ;x=0
@@loop:
        mov     ax,[cnx]                ;4
        add     ax,bx                   ;7
        mov     dx,[cny]                ;4
        add     dx,cx                   ;7 = 22 clocks
        call    _putpixel              ;centerx+x, centery+y

        mov     ax,[cnx]                ;4
        add     ax,bx                  ;7
        mov     dx,[cny]                ;4
        sub     dx,cx                   ;7 = 22 clocks
        call    _putpixel              ;centerx+x, centery-y

        mov     ax,[cnx]                ;4
        sub     ax,bx                  ;7
        mov     dx,[cny]                ;4
        add     dx,cx                   ;7 = 22 clocks
        call    _putpixel              ;centerx-x, centery+y

        mov     ax,[cnx]                ;4
        sub     ax,bx                  ;7
        mov     dx,[cny]                ;4
        sub     dx,cx                   ;7 = 22 clocks
        call    _putpixel              ;centerx-x, centery-y

        cmp     [flag],1
        jae     @@C0

        inc     [flag]
        xchg    bx,cx
        jmp     @@loop                  ;draw other half

@@C0:                                   ;bx = x, cx = y
        mov     [flag],0
        xchg    bx,cx

        mov     si,bx

        cmp     [d],32768
        jb      @@C1                    ;if(d<0)
        shl     si,2
        add     si,6
        add     [d],si                  ;d=d+(4*x)+6
        jmp     SHORT @@C2

@@C1:                                   ;else {
        mov     si,bx
        sub     si,cx                   ;x-y
        jns		@@NoSign
        neg     si
        shl     si,2
        neg     si                      ;*4
        jmp		SHORT @@SignSet
@@NoSign:
        shl     si,2                    ;*4
@@SignSet:
        add     si,10
        add     [d],si                  ;d=d+4*(x-y)+10
        dec     cx                      ;y--
@@C2:                                   ;}
        inc     bx                      ;x++
        cmp     bx,cx
        jbe     @@loop                  ;while x!=y

@@C3:   pop     si
        pop     di
        ret

; ax - x , dx - y
PROC    _putpixel
        mov     di,dx
        shl     dx,8
        shl     di,6
        add     di,ax                   ;y coord
        add     di,dx
        mov     al,[col]
        stosb
        ret
ENDP    _putpixel
ENDP    bcircle
        END
