/*
 * joystick.c - joystick polling routine.
 *
 * DESCRIPTION
 * Polls the joystick and fills in the external Joystick variables
 *
 * USAGE
 *
 * NOTES
 * Joystick read from joystick module in YakIcons by Victor Putz
 * Detection routine from joystick.pasby Ronny Wester, ronny@rat.se
 *
 * REVISION HISTORY
 * Date         Reason
 * 27 Jun 95    Initial Release
 * 17 Jul 95    changed to joystick - removed xlib specifics
 *  3 Sep 95    added detect_joystick() and calibrate_joystick()
 *
 */

#include <stdio.h>
#include <dos.h>
#include "defines.h"

int read_joystick();
BOOLEAN detect_joystick();
BOOLEAN calibrate_joystick();

/* Must decklare these as external in calling module */
int JoystickRange;
int JoystickSense;
int Joystick1X;
int Joystick1Y;
int Joystick2X;
int Joystick2Y;
int JoystickCenterX;
int JoystickCenterY;


/* for assembly routine */
static int button_status;

int read_joystick()
{
  asm ("
    pushl       %eax
    pushl       %ebx
    pushl       %ecx
    pushl       %edx

    movw        $0x201, %dx
    outb        %al, %dx        /* start timer */
    xorl        %eax, %eax
    movl        %eax, _Joystick1X
    movl        %eax, _Joystick1Y
    movl        %eax, _Joystick2X
    movl        %eax, _Joystick2Y
    movl        _JoystickRange, %ecx
jrangeloop:
    movl        _JoystickSense, %ebx
jdelay:
    inb         %dx, %al
    decl        %ebx
    jnz         jdelay

    shrb        $1, %al
    adcl        %ebx, _Joystick1X
    shrb        $1, %al
    adcl        %ebx, _Joystick1Y
    shrb        $1, %al
    adcl        %ebx, _Joystick2X
    shrb        $1, %al
    adcl        %ebx, _Joystick2Y
    loop        jrangeloop

    notb        %al
    andl        $0x0f, %eax
    movl        %eax, _button_status
    popl        %edx
    popl        %ecx
    popl        %ebx
    popl        %eax
  ");
  return(button_status);
}


BOOLEAN detect_joystick()
{
  BYTE b, mask;
  int laps;

  mask = 3;             /* check for joystick 1 - 12 for jstk 2 */

  laps = 0;
  outportb(0x201, 0xff);        /* start timer */
  
  while (laps < 60000)
  {
    b = inportb(0x201);
    if ((b & mask) == 0)
      break;
    laps ++;
  } 

  if (laps >= 60000)
    return(FALSE);
  else
    return(TRUE);
}

BOOLEAN calibrate_joystick()
{
  int minx, miny, maxx, maxy, midx, midy;
  
  if (!detect_joystick())
    return(FALSE);

  JoystickSense = 1;
  JoystickRange = 10000;        /* start with a huge range to make sure
                                ** we don't miss the max value on a fast
                                ** machine
                                */

  printf("Move joystick to upper-left corner and press a button\n");
  while (!read_joystick());
  minx = Joystick1X;
  miny = Joystick1Y;
  delay(50);                    /* debounce button */
  while (read_joystick())
    delay(5);

  printf("Move joystick to lower-right corner and press a button\n");
  while (!read_joystick());
  maxx = Joystick1X;
  maxy = Joystick1Y;
  delay(50);                    /* debounce button */
  while (read_joystick())
    delay(5);

  printf("Return joystick to center and press a button\n");
  while (!read_joystick());
  midx = Joystick1X;
  midy = Joystick1Y;
  delay(50);                    /* debounce button */
  while (read_joystick())
    delay(5);

  JoystickCenterX = midx;
  JoystickCenterY = midy;
  
  /* Set margin, add a small overhead*/
  if (maxx > maxy)
    JoystickRange = maxx + 30;
  else
    JoystickRange = maxy + 30;

  return(TRUE);
}
