/*
 * xtext.s - low level text drawing functions
 *
 * DESCRIPTION
 * Routine to draw black and white text characters.  Color characters
 * are drawn using XPutPBMMasked() (see xbm.s).
 *
 * USAGE
 *
 * NOTES
 * Based on xlib60 for BC by Themie Goumas
 *
 * REVISION HISTORY
 * Date         Reason
 * 27 Jun 95    Initial Release
 * 17 Aug 95    Now returns font width
 * 30 Aug 95    Optimized variable ordering, routine
 * 31 Aug 95    Add x_char_put_clipxy
 *
 */
 
        .data
        .align  4
ScreenInc:              .long   0
Hold:                   .long   0
xmin:                   .long   0
xmax:                   .long   0
ymin:                   .long   0
ymax:                   .long   0
ClipMask:               .long   0
FirstChar:              .word   0
Height:                 .byte   0
Width:                  .byte   0
VarWid:                 .byte   0

        .text
        .globl  _x_char_put
        .globl  _x_char_put_clipxy
        .extern _ScrnLogicalByteWidth
        .extern _XClipMin
        .extern _XClipMax
        .extern _YClipMin
        .extern _YClipMax
        .extern _core_select

/*int x_char_put(int X,int Y,int PageBase,int Color,char *font,BYTE Char);*/
/*       %ebp+    8      12      16          20      24        28       */
        .align  4
_x_char_put:
        pushl   %ebp
        movl    %esp, %ebp
        pushl   %esi
        pushl   %edi
        pushl   %ebx
        pushl   %ecx
        pushl   %edx
        pushw   %es
        
        movl    _ScrnLogicalByteWidth, %eax
        movl    %eax, %ebx
        subl    $3, %ebx
        movl    %ebx, ScreenInc
        imul    12(%ebp), %eax
        movl    8(%ebp), %edi
        movl    %edi, %ecx
        shrl    $2, %edi
        addl    %eax, %edi
        addl    16(%ebp), %edi
        addl    $0xa0000, %edi
        movw    _core_select, %ax
        movw    %ax, %es
        
        andl    $0x03, %ecx
        xorl    %eax, %eax
        movl    24(%ebp), %esi          /* load font bitmap to esi */
/* first char */
        lodsw
        movw    %ax, FirstChar
        xorl    %eax, %eax
/* get height */
        lodsb
        movb    %al, %ch
        movb    %al, Height
/* get width */
        lodsb
        movb    %al, Width
        cmpb    $0, %al
        jne     NoWidthByte
        movb    %ch, %al
        incb    %al
        movb    %al, Height
NoWidthByte:
        xorl    %ebx, %ebx
        movb    Height, %al
        movb    28(%ebp), %bl
        subw    FirstChar, %bx
        imul    %ebx, %eax

        addl    %eax, %esi
        movw    $0x3c4, %dx
MainLoop:
        xorl    %eax, %eax
        movb    (%esi), %al
        incl    %esi
        orb     %al, %al
        jz      NoCharPixels
DontMirror:
        xorb    %ah, %ah
        shll    %cl, %eax
        movl    %eax, Hold
        
        movb    %al, %ah
        andb    $0x0f, %ah
        jnz     p1
        incl    %edi
        jmp     SecondNibble
p1:
        movb    $0x02, %al
        outw    %ax, %dx
        movb    20(%ebp), %al
        stosb
SecondNibble:
        movl    Hold, %eax
        shll    $4, %eax
        andb    $0x0f, %ah
        jnz     p2
        incl    %edi
        jmp     ThirdNibble
p2:
        movb    $0x02, %al
        outw    %ax, %dx
        movb    20(%ebp), %al
        stosb
ThirdNibble:
        movl    Hold, %eax
        andb    $0x0f, %ah
        jnz     p3
        incl    %edi
        jmp     NextCharRow
p3:
        movb    $0x02, %al
        outw    %ax, %dx
        movb    20(%ebp), %al
        stosb
NextCharRow:
        addl    ScreenInc, %edi
        decb    %ch
        jnz     MainLoop
Done:
        xorl    %eax, %eax
        movb    Width, %al
        orb     %al, %al                # width for fixed font
        jnz     FixedSpacing
        movb    (%esi), %al             # width byte at end in var. font
FixedSpacing:
        popw    %es
        popl    %edx
        popl    %ecx
        popl    %ebx
        popl    %edi
        popl    %esi
        popl    %ebp
        ret
NoCharPixels:
        addl    $3, %edi
        addl    ScreenInc, %edi
        decb    %ch
        jnz     MainLoop
        jmp     Done


# int x_char_put_clipxy(int X,int Y,int PageBase,int Color,char *font,BYTE Char);
#        %ebp+              8    12       16          20         24         28
#
# This routine is not fast as it inserts 3 compare/jump combinations into
# the inner row loop.

        .align  4
_x_char_put_clipxy:
        pushl   %ebp
        movl    %esp, %ebp
        pushl   %esi
        pushl   %edi
        pushl   %ebx
        pushl   %ecx
        pushl   %edx
        pushw   %es
        
        movl    $0, xmin
        movl    $0, xmax
        movl    $0, ymin
        movl    $0, ymax

        movl    24(%ebp), %esi          # load font bitmap to esi
        movl    12(%ebp), %ebx
        cmpl    %ebx, _YClipMin
        jle     cxy1
        movl    _YClipMin, %edi
        subl    %ebx, %edi
        movl    %edi, ymin
        xorl    %eax, %eax
        movb    2(%esi), %al
        cmpl    %eax, %edi
        jl      cxy2
        xorl    %eax, %eax              # width doesn't matter since
        jmp     cFixedSpacing           # whole string is obscured
cxy1:
        xorl    %eax, %eax
        cmpl    %ebx, _YClipMax
        jl      cFixedSpacing           # whole string is obscured
        movb    2(%esi), %al
        addl    %ebx, %eax
        cmpl    %eax, _YClipMax
        jge     cxy2
        subl    _YClipMax, %eax
        movl    %eax, ymax
        # We'll do the x-clipping later so we can get the variable
        # font width first.
cxy2:
        movl    _ScrnLogicalByteWidth, %eax
        movl    %eax, %ebx
        subl    $3, %ebx
        movl    %ebx, ScreenInc
        movl    12(%ebp), %edx
        addl    ymin, %edx
        imul    %edx, %eax
        movl    8(%ebp), %edi
        movl    %edi, %ecx
        shrl    $2, %edi
        addl    %eax, %edi
        addl    16(%ebp), %edi
        addl    $0xa0000, %edi
        movw    _core_select, %ax
        movw    %ax, %es
        
        andl    $0x03, %ecx
        xorl    %eax, %eax
/* first char */
        lodsw
        movw    %ax, FirstChar
        xorl    %eax, %eax
/* get height */
        lodsb
        movb    %al, %ch
        movb    %al, Height
/* get width */
        lodsb
        movb    %al, Width
        cmpb    $0, %al
        jne     cNoWidthByte
        movb    %ch, %al
        incb    %al
        movb    %al, Height
cNoWidthByte:
        xorl    %ebx, %ebx
        movb    Height, %al
        movb    28(%ebp), %bl
        subw    FirstChar, %bx
        imul    %ebx, %eax

        addl    %eax, %esi
        xorl    %edx, %edx
        movb    Height, %dl
        movb    -1(%esi, %edx), %al     # grab this in case it's var width
        movb    %al, VarWid             # (-1 because height was adjusted)
                                        # save this since we might skip
                                        # some of the font data with clipping
        
        # Check the x-clipping here.  Unlike y-clipping, the font width
        # is important.
        # The 3 font nibbles are checked separately for clipping since
        # the x-clipping rectangle is aligned on plane (4-pixel) bounderies.

        # left clip check
        movl    8(%ebp), %ebx
        shrl    $2, %ebx
        movl    _XClipMin, %eax
        subl    %ebx, %eax
        jle     CheckRight              # all 3 nibbles show on left side
        movl    $1, %ebx
        decl    %eax
        jz      DrawIt                  # 1 nibble clipped
        addl    $2, %ebx
        decl    %eax
        jz      DrawIt                  # 2 nibbles clipped
        jmp     cDone                   # all 3 nibbles are obscured

CheckRight:
        movl    _XClipMax, %eax
        subl    %ebx, %eax
        jl      cDone                   # totally clipped on right
        movl    $6, %ebx
        orl     %eax, %eax
        jz      DrawIt                  # 2 nibbles clipped
        subl    $2, %ebx
        subl    $1, %eax
        jz      DrawIt                  # 1 nibble clipped
        xorl    %ebx, %ebx              # no clipping on right
        
DrawIt:
        movl    %ebx, ClipMask
        movl    ymin, %edx
        addl    %edx, %esi
        addl    ymax, %edx
        subb    %dl, %ch
        movw    $0x3c4, %dx
cMainLoop:
        xorl    %eax, %eax
        movb    (%esi), %al
        incl    %esi
        orb     %al, %al
        jz      cNoCharPixels
cDontMirror:
        xorb    %ah, %ah
        shll    %cl, %eax
        movl    %eax, Hold
        
        movl    ClipMask, %ebx
        andl    $1, %ebx
        jnz     cskip1
        movb    %al, %ah
        andb    $0x0f, %ah
        jnz     cp1
cskip1:
        incl    %edi
        jmp     cSecondNibble
cp1:
        movb    $0x02, %al
        outw    %ax, %dx
        movb    20(%ebp), %al
        stosb
cSecondNibble:
        movl    ClipMask, %ebx
        andl    $2, %ebx
        jnz     cskip2
        movl    Hold, %eax
        shll    $4, %eax
        andb    $0x0f, %ah
        jnz     cp2
cskip2:
        incl    %edi
        jmp     cThirdNibble
cp2:
        movb    $0x02, %al
        outw    %ax, %dx
        movb    20(%ebp), %al
        stosb
cThirdNibble:
        movl    ClipMask, %ebx
        andl    $4, %ebx
        jnz     cskip3
        movl    Hold, %eax
        andb    $0x0f, %ah
        jnz     cp3
cskip3:
        incl    %edi
        jmp     cNextCharRow
cp3:
        movb    $0x02, %al
        outw    %ax, %dx
        movb    20(%ebp), %al
        stosb
cNextCharRow:
        addl    ScreenInc, %edi
        decb    %ch
        jnz     cMainLoop
cDone:
        xorl    %eax, %eax
        movb    Width, %al
        orb     %al, %al                # width for fixed font
        jnz     cFixedSpacing
        movb    VarWid, %al
cFixedSpacing:
        popw    %es
        popl    %edx
        popl    %ecx
        popl    %ebx
        popl    %edi
        popl    %esi
        popl    %ebp
        ret
cNoCharPixels:
        addl    $3, %edi
        addl    ScreenInc, %edi
        decb    %ch
        jnz     cMainLoop
        jmp     cDone
