.model tiny
.286
.stack 100h
dataseg

rndseed dw 12345
maLi    db 'code: maLi/DarkSiDe$',13,10
vscreen dw ?
seed    dw ?
palette db 786 dup (?)
firemem db 80*50 dup (?)
firetmp db 80*50 dup (?)

codeseg

fire:
      mov      ax,@data
      mov      ds,ax
      mov      ax,0013h
      int      10h

      mov      ax,4a00h
      mov      bx,4000
      int      21h
      mov      ax,4800h
      mov      bx,4000
      int      21h
      mov      word ptr vscreen,ax
      ;clear up both fire arrays
      mov      cx,80*50
      mov      si,offset firemem
      mov      di,offset firetmp
      xor      al,al
      mov      al,1
clear_fire_array:
      mov      ds:[si],al
      mov      ds:[di],al
      loop     clear_fire_array
      mov      si,offset palette
      xor      cl,cl
      xor      al,al
pal_red:
      mov      ds:[si],cl
      mov      ds:[si+1],al
      mov      ds:[si+2],al
      add      si,3
      inc      cl
      cmp      cl,63
      jbe      pal_red
      mov      al,63
      xor      cl,cl
      xor      dl,dl
pal_yellow:
      mov      ds:[si],al
      mov      ds:[si+1],cl
      mov      ds:[si+2],dl
      add      si,3
      inc      cl
      cmp      cl,63
      jbe      pal_yellow

      call     set_palette

fire_loop:
      call     clear_page
      call     setup_fire
      call     calc_fire
      call     copy_fire
      mov      di,0*320
      call     draw_fire
      call     vretrace
      call     flip_page
      mov      ax,100h
      int      16h
      jz       fire_loop

      mov      ax,4800h
      mov      es,word ptr vscreen
      int      21h

      mov      ax,0003h
      int      10h
      mov      ax,900h
      mov      dx,offset maLi
      int      21h
      mov      ax,4c00h
      int      21h

setup_fire proc near
           mov      cl,18
setup_loop:
           mov      ax,80
           call     random
           mov      si,ax
           mov      ds:[firemem+si+3840],255
           mov      ds:[firemem+si+3920],255
           loop     setup_loop
           ret
setup_fire endp

calc_fire proc near
          mov      cx,80*51
          xor      si,si
calc_loop:
          xor      bx,bx
          xor      ah,ah
          mov      al,byte ptr [firemem+si-81]
          add      bx,ax
          mov      al,byte ptr [firemem+si-80]
          add      bx,ax
          mov      al,byte ptr [firemem+si-79]
          add      bx,ax
          mov      al,byte ptr [firemem+si-1]
          add      bx,ax
          mov      al,byte ptr [firemem+si+1]
          add      bx,ax
          mov      al,byte ptr [firemem+si+79]
          add      bx,ax
          mov      al,byte ptr [firemem+si+80]
          add      bx,ax
          mov      al,byte ptr [firemem+si+81]
          add      bx,ax
          shr      bx,3
          cmp      bl,10
          jb       d
          dec      bl
          d:
          mov      byte ptr [firetmp+si-80],bl
          inc      si
          loop     calc_loop
          ret
calc_fire endp

copy_fire proc near
          push     ds
          pop      es
          mov      cx,2000
          mov      di,offset firemem
          mov      si,offset firetmp
          rep      movsw
          ret
copy_fire endp

draw_fire proc near
          mov      si,offset firetmp
          mov      ax,word ptr vscreen
          mov      es,ax
          mov      cx,45
draw_y:
          mov      bl,80
draw_x:
          mov      al,byte ptr ds:[si]
          mov      ah,al
          stosw
          stosw
          push     di
          add      di,316
          stosw
          stosw
          add      di,316
          stosw
          stosw
          add      di,316
          stosw
          stosw
          pop      di
          inc      si
          dec      bl
          jnz      draw_x
          add      di,960
          loop     draw_y
          ret
draw_fire endp

flip_page proc near
          push     ds
          mov      ax,word ptr vscreen
          mov      ds,ax
          push     0a000h
          pop      es
          xor      si,si
          xor      di,di
          mov      cx,32000
          rep      movsw
          pop      ds
          ret
flip_page endp

clear_page proc near
           mov      ax,word ptr vscreen
           mov      es,ax
           mov      cx,32000
           xor      di,di
           xor      ax,ax
           rep      stosw
           ret
clear_page endp

set_palette proc near
            mov dx,3c8h
            xor ax,ax
            out dx,al
            inc dx
            lea si,palette
            mov cx,768
            rep outsb
            ret
set_palette endp

vretrace proc near
         mov dx,3dah
vr:
         in al,dx
         and al,8
         jnz vr
vnr:
         in al,dx
         and al,8
         jz vnr
         ret
vretrace endp

include random.inc

end fire
