{****************************************************************************}
{* UNIT GFX including:                                                      *}
{* -mode x                                                                  *}
{* -bios mode $13                                                           *}
{* -palette                                                                 *}
{* -sprites                                                                 *}
{* -some 3d routnies                                                        *}
{* -pictures                                                                *}
{*                                                                          *}
{* Copyright (c) 1995/96 by FiNeSSe                                         *}
{*                                                                          *}
{* Rewrited by maLi/FiNeSSe in december 1995                                *}
{* E-mali: igo.gruden@uni-lj.si                                             *}
{*                                                                          *}
{* NOTE: Some routines are not well optimized!!!                            *}
{****************************************************************************}
{$G+}
unit gfx;
interface

const minx=0;
      miny=0;
      maxx=319;
      maxy=199;

type point2d=record
               x,y:integer;
               c:byte;
             end;

     point3d=record
               x,y,z:integer;
               c:byte;
             end;

     block=record
                r,g,b:byte;
              end;

     palette=array[0..255] of block;

     spriteheader=record
                    x,y:word;
                    active:boolean;
                    version:byte;
                  end;

     virtual=array[1..64000] of byte;
     vrtptr=^virtual;

var vrtscr1:vrtptr;
    vrtscr2:vrtptr;
    vaddr1:word;
    vaddr2:word;

{ PALETTE ROUTINES INTERFACE }

procedure waitdisplay;
procedure waitretrace;
procedure loadpalette(s:string;var p:palette);
procedure savepalette(s:string;p:palette);
procedure setcolor(c,r,g,b:byte);
procedure getcolor(c:byte;var r,g,b:byte);
procedure setpalette(p:palette);
procedure getpalette(var p:palette);

{ MODE $13 ROUTINES INTERFACE }

procedure init(mode:byte);
procedure shutdown;
procedure putpixel(x,y:integer;c:byte;addr:word);
procedure hline(x1,x2,y:word;c:byte;addr:word);
procedure vline(y1,y2,x:word;c:byte;addr:word);
procedure line(x1,y1,x2,y2:integer;c:byte;addr:word);
procedure rectangle(x1,y1,x2,y2:integer;c:byte;addr:word);
procedure box(x,y,xx,yy:integer;color:byte);
procedure poly(x1,y1,x2,y2,x3,y3,x4,y4:integer;color:byte;addr:word);
procedure screenoff;
procedure screenon;
procedure flip(source,dest:word);
procedure delniflip(source,dest,start,size:word);
procedure filladdr(c:byte;addr:word);
procedure delnifilladdr(c:byte;addr,start,size:word);

{ 3D ROUTINES INTERFACE }

procedure convert3dto2d(a:point3d;var b:point2d;dist:integer);
procedure convert3dto2dcentered(a:point3d;var b:point2d;dist:integer);
procedure rotatex3d(var a:point3d;angle:real);
procedure rotatey3d(var a:point3d;angle:real);
procedure rotatez3d(var a:point3d;angle:real);

procedure loadscr(s:string;vscr:pointer);
procedure savescr(s:string;vscr:pointer);

implementation

{ PALETTE ROUTINES IMPLEMENTATION }

procedure waitdisplay; assembler;
asm
  mov dx,$3da
  @vd:
  in al,dx
  test al,8
  jz @vd
end;

procedure waitretrace; assembler;
asm
  mov dx,$3da
  @vr:
  in al,dx
  test al,8
  jz @vr
end;

procedure loadpalette(s:string;var p:palette);
var f:file;
begin
  assign(f,s);
  {$I-}
  reset(f,1);
  if ioresult<>0 then exit;
  blockread(f,p,sizeof(palette));
  close(f);
  {$I+}
end;

procedure savepalette(s:string;p:palette);
var f:file;
begin
  assign(f,s);
  {$I-}
  rewrite(f,1);
  if ioresult<>0 then exit;
  blockwrite(f,p,sizeof(palette));
  close(f);
  {$I+}
end;

procedure setcolor(c,r,g,b:byte); assembler;
asm
  mov dx,3c8h
  mov al,c
  out dx,al
  inc dx
  mov al,r
  out dx,al
  mov al,g
  out dx,al
  mov al,b
  out dx,al
end;

procedure getcolor(c:byte;var r,g,b:byte);
var a,rr,gg,bb:byte;
begin
  asm
    mov dx,03c7h
    mov al,c
    out dx,al
    add dx,2
    xor ah,ah
    in al,dx
    mov rr,al
    in al,dx
    mov gg,al
    in al,dx
    mov bb,al
  end;
  r:=rr;
  g:=gg;
  b:=bb;
end;

procedure setpalette(p:palette); assembler;
asm
  push ds
  mov  dx,$3c8
  sub  al,al
  out  dx,al
  mov  ds,word ptr p+2
  mov  si,word ptr p
  mov  cx,$300
  inc  dx
  rep  outsb
  pop  ds
end;

procedure getpalette(var p:palette); assembler;
asm
  mov  dx,$3c7
  sub  al,al
  out  dx,al
  mov  es,word ptr p+2
  mov  di,word ptr p
  mov  cx,$300
  add  dx,2
  rep  insb
end;

{ MODE $13 ROUTINES IMPLEMENTATION }

procedure init(mode:byte);
var vp:byte;
begin
  vp:=0;
  if memavail>sizeof(virtual) then begin
    new(vrtscr1);
    vaddr1:=seg(vrtscr1^);
    fillchar(vrtscr1^,sizeof(virtual),0);
    inc(vp);
  end;
  if memavail>sizeof(virtual) then begin
    new(vrtscr2);
    vaddr2:=seg(vrtscr2^);
    fillchar(vrtscr2^,sizeof(virtual),0);
    inc(vp);
  end;
  asm
    mov al,mode
    xor ah,ah
    int 10h
  end;
end;

procedure shutdown;
begin
  freemem(vrtscr1,sizeof(virtual));
  freemem(vrtscr2,sizeof(virtual));
  asm
    mov al,3
    xor ah,ah
    int 10h
  end;
end;

procedure putpixel(x,y:integer;c:byte;addr:word); assembler;
asm
  push    ds
  push    es
  mov     ax,[addr]
  mov     es,ax
  mov     si,[x]
  mov     dx,[y]
  mov     di,dx
  shl     di,2
  add     di,dx
  shl     di,6
  add     di,si
  xor     al,al
  mov     ah,[c]
  mov     es:[di],ah
  pop     es
  pop     ds
end;

procedure vline(y1,y2,x:word;c:byte;addr:word); assembler;
asm
	push es
	mov ax,addr
	mov es,ax
	mov bx,y1
	shl bx,6
	mov ax,bx
	shl ax,2
	add bx,ax
	mov ax,x
	add bx,ax
	mov di,bx
	mov cx,y2
	mov ax,y1
	sub cx,ax
	mov al,c
  @zanka:
	mov es:[di],al
	add di,320
	dec cx
	jnz @zanka
	pop es
end;

procedure hline(x1,x2,y:word;c:byte;addr:word); assembler;
asm
  mov   ax,addr
  mov   es,ax
  mov   di,y
  mov   si,di
  shl   di,2
  add   di,si
  shl   di,6
  add   di,x1
  mov   al,c
  mov   ah,al
  mov   cx,x2
  sub   cx,x1
  shr   cx,1
  jnc   @start
  stosb
@start :
  rep   stosw
end;

procedure line(x1,y1,x2,y2:integer;c:byte;addr:word);
var j,steps,sx,sy,dx,dy,e:integer;
    steep:boolean;

procedure swap(var a,b:integer);
begin
  a:=a+b;
  b:=a-b;
  a:=a-b;
end;

function sgn(a:integer):integer; assembler;
asm
  mov ax,[a]
  sar ax,$0e
  and al,$fe
  inc ax
end;

begin
  dx:=abs(x2-x1);
  sx:=sgn(x2-x1);
  dy:=abs(y2-y1);
  sy:=sgn(y2-y1);
  steep:=(dy>dx);
  if steep then begin
    swap(x1,y1);
    swap(dx,dy);
    swap(sx,sy);
  end;
  e:=2*dy-dx;
  for j:=1 to dx do begin
    if steep then putpixel(y1,x1,c,addr) 
    else putpixel(x1,y1,c,addr);
    while e>= 0 do begin
      inc(y1,sy);
      dec(e,2*dx);
    end;
    inc(x1,sx);
    inc(e,2*dy);
  end;
  putpixel(x2,y2,c,addr);
end;

procedure rectangle(x1,y1,x2,y2:integer;c:byte;addr:word);
begin
  line(x1,y1,x2,y1,c,addr);
  line(x1,y1,x1,y2,c,addr);
  line(x1,y2,x2,y2,c,addr);
  line(x2,y1,x2,y2,c,addr);
end;

procedure box(x,y,xx,yy:integer;color:byte); assembler;
asm
	mov ax,x
	mov bx,xx
	cmp ax,bx
	je @error   {x=xx -> ni potrebno risati}
	jb @next    {x>xx -> zamenjaj x in xx}
	xchg ax,bx
	mov x,ax
	mov xx,bx
  @next:
	mov ax,y
	mov bx,yy
	cmp ax,bx
	je @error   {y=yy -> ni potrebno risati}
	jb @draw    {y>yy -> zamenjaj y in yy}
	xchg ax,bx
	mov y,ax
	mov yy,bx
  @draw:
	push es
	mov ax,sega000
	mov es,ax

	mov bx,y
	shl bx,6
	mov di,bx
	shl bx,2
	add di,bx
	add di,x      {es:di kaze na levi zgornji kot box-a}
	mov al,color  {nastavimo barvo}
	mov ah,al

	mov bx,y
	mov cx,yy
	sub cx,bx  {zracunamo visino}
	mov dx,cx  {shranimo v dx}

	mov bx,x
	mov cx,xx
	sub cx,bx  {zracunamo sirino}
	mov bx,cx  {shranimo v bx}
	cld        {clear direction flag}
  @loop1:
	mov cx,bx
	rep stosb
	add di,320
	sub di,bx
	dec dx
	jnz @loop1
	pop es
  @error:
end;

procedure poly(x1,y1,x2,y2,x3,y3,x4,y4:integer;color:byte;addr:word);
var x,mny,mxy,mnx,mxx,yc,mul1,div1,mul2,div2,mul3,div3,mul4,div4:integer;
begin
  mny:=y1; mxy:=y1;
  if y2<mny then mny:=y2;
  if y2>mxy then mxy:=y2;
  if y3<mny then mny:=y3;
  if y3>mxy then mxy:=y3;
  if y4<mny then mny:=y4;
  if y4>mxy then mxy:=y4;

  if mny<miny then mny:=miny;
  if mxy>maxy then mxy:=maxy;
  if mny>maxy then exit;
  if mxy<miny then exit;

  mul1:=x1-x4; div1:=y1-y4;
  mul2:=x2-x1; div2:=y2-y1;
  mul3:=x3-x2; div3:=y3-y2;
  mul4:=x4-x3; div4:=y4-y3;

  for yc:=mny to mxy do begin
      mnx:=320;
      mxx:=-1;
      if (y4>=yc) or (y1>=yc) then
      if (y4<=yc) or (y1<=yc) then
      if not(y4=y1) then begin
        x:=(yc-y4)*mul1 div div1+x4;
        if x<mnx then mnx:=x;
        if x>mxx then mxx:=x;
      end;
      if (y1>=yc) or (y2>=yc) then
      if (y1<=yc) or (y2<=yc) then
      if not(y1=y2) then begin
        x:=(yc-y1)*mul2 div div2+x1;
        if x<mnx then mnx:=x;
        if x>mxx then mxx:=x;
      end;
      if (y2>=yc) or (y3>=yc) then
      if (y2<=yc) or (y3<=yc) then
      if not(y2=y3) then begin
        x:=(yc-y2)*mul3 div div3+x2;
        if x<mnx then mnx:=x;
        if x>mxx then mxx:=x;
      end;

      if (y3>=yc) or (y4>=yc) then
      if (y3<=yc) or (y4<=yc) then
      if not(y3=y4) then begin
        x:=(yc-y3)*mul4 div div4+x3;
        if x<mnx then mnx:=x;
        if x>mxx then mxx:=x;
      end;
      if mnx<minx then mnx:=minx;
      if mxx>maxx then mxx:=maxx;
      if mnx<=mxx then hline(mnx,mxx,yc,color,addr);
    end;
end;

procedure screenon; assembler;
asm
  mov ax,$1200
  mov bl,$36
  int $10
end;

procedure screenoff; assembler;
asm
  mov ax,$1201
  mov bl,$36
  int $10
end;

procedure flip(source,dest:word); assembler;
asm
  push    ds
  mov     ax,[dest]
  mov     es,ax
  mov     ax,[source]
  mov     ds,ax
  xor     si,si
  xor     di,di
  mov     cx,32000
  rep     movsw
  pop     ds
end;

procedure delniflip(source,dest,start,size:word); assembler;
asm
  push    ds
  mov     ax,[dest]
  mov     es,ax
  mov     ax,[source]
  mov     ds,ax

  mov     si,start
  mov     di,start

  mov     cx,size
  shr     cx,1
  rep     movsw
  pop     ds
end;

procedure filladdr(c:byte;addr:word); assembler;
asm
  push    es
  mov     cx,32000;
  mov     es,[addr]
  xor     di,di
  mov     al,[c]
  mov     ah,al
  rep     stosw
  pop     es
end;

procedure delnifilladdr(c:byte;addr,start,size:word); assembler;
asm
  push    es
  mov     cx,size
  shr     cx,1
  mov     es,[addr]
  mov     di,start
  mov     al,[c]
  mov     ah,al
  rep     stosw
  pop     es
end;

{ 3D ROUTINES IMPLEMENTATION }

procedure convert3dto2d(a:point3d;var b:point2d;dist:integer);
begin
  if a.z-dist<>0 then begin
    b.x:=(a.x*dist) div (a.z-dist);
    b.y:=(a.y*dist) div (a.z-dist);
  end;
end;

procedure convert3dto2dcentered(a:point3d;var b:point2d;dist:integer);
begin
  if a.z-dist<>0 then begin
    b.x:=160+(a.x*dist) div (a.z-dist);
    b.y:=100+(a.y*dist) div (a.z-dist);
  end;
end;

procedure rotatex3d(var a:point3d;angle:real);
var tmp:point3d;
begin
  tmp.x:=a.x;
  tmp.y:=a.y;
  tmp.z:=a.z;
  a.y:=round(tmp.y*cos(angle)-tmp.z*sin(angle));
  a.z:=round(tmp.y*sin(angle)+tmp.z*cos(angle));
end;

procedure rotatey3d(var a:point3d;angle:real);
var tmp:point3d;
begin
  tmp.x:=a.x;
  tmp.y:=a.y;
  tmp.z:=a.z;
  a.x:=round(tmp.x*cos(angle)-tmp.z*sin(angle));
  a.z:=round(tmp.x*sin(angle)+tmp.z*cos(angle));
end;

procedure rotatez3d(var a:point3d;angle:real);
var tmp:point3d;
begin
  tmp.x:=a.x;
  tmp.y:=a.y;
  tmp.z:=a.z;
  a.x:=round(tmp.x*cos(angle)-tmp.y*sin(angle));
  a.y:=round(tmp.x*sin(angle)+tmp.y*cos(angle));
end;

{ PICTURE ROUTINES IMPLEMENTATION }

procedure loadscr(s:string;vscr:pointer);
var f:file;
begin
  assign(f,s);
  reset(f,1);
  blockread(f,vscr^,64000);
  close(f);
end;

procedure savescr(s:string;vscr:pointer);
var f:file;
begin
  assign(f,s);
  rewrite(f,1);
  blockwrite(f,vscr^,64000);
  close(f);
end;

begin
end.
