/*
 *
 *  CREATANG.C
 *
 *  (Simon Hern, 1994)
 *
 *  Create table of sines of angles for use in MATRIX program
 *  Table outputted to file ANGSINES.ASM in assembler format
 *
 */

#include <stdio.h>
#include <math.h>


#define PI 3.1415926536
#define FILE_NAME "ANGSINES.ASM"
#define ANGLES 1024


#define WORDS_PER_LINE 8
void dump_word(FILE * f, int w) {
    static int mmm = 0;
    if ( mmm == 0 ) fprintf(f, "\n    dw  0%04xh", w);
    else fprintf(f, ", 0%04xh", w);
    if ( ++mmm == WORDS_PER_LINE ) mmm = 0;
}


int main() {

    FILE * file;
    int i;
    int sval;

    file = fopen(FILE_NAME, "wt");
    if ( file == NULL ) {
        printf("Error: Cannot open %s for output\n", FILE_NAME);
        return 1;
    }

    fprintf(file, "\n_Data SEGMENT WORD PUBLIC \'Data\'\n\n");
    fprintf(file, "_AngleSines:\n");

    for ( i = 0 ; i < ANGLES ; i++ ) {
        sval = 32767.0 * sin(2*PI * (double)i/ANGLES);
        dump_word(file, sval);
    }

    fprintf(file, "\n\n_Data ENDS\n\n");

    fclose(file);
    return 0;
}


