// palette.cpp
// blend, map, and set palette.
// Author: Karl Lager
// 76752,2243@compuserve.com
// 14 Jan 97
//
// This code was written using Borland C++, and may need modifications to run
// on another compiler.  All of this code has been tested out, but some
// sections have been tested more than others.  I leave it to you to you to
// make certain that the code works for your purposes.
// I'm pretty certain there isn't anything here that hasn't been re-invented
// a few dozen times before, so feel free to use and modify this code as
// you see fit.

#include <stdio.h>
#include <alloc.h>
#include <values.h>


struct weightedColor{
	unsigned char r,g,b,w;
	};

unsigned long weightedpal[512]; // rgb weight

unsigned char palindex[256]; // palette map



 // load the palette only
int loadpcxpalette( char *filename, char *palette ){
	FILE *f;
	int bytes;

	f=fopen( filename, "rb" );
	if( f == NULL ) return -1;
	else{
		fseek( f, -768L, SEEK_END );
		bytes = fread( palette, 1, 768, f );
		fclose( f );
		return 768 - bytes;   // if >0, file was too short
	}
}
// this should also work with a 768 byte palette file.


void chromakey( int r, int g, int b ){
     int i;
     unsigned long *index;
     char *wp;

     index = weightedpal;
     wp = (unsigned char*) weightedpal;
     *wp++ = r;
     *wp++ = g;
     *wp++ = b;
     *wp++ = 255;
	index++;

	for( i = 1; i<256; i++, index++ ){
		*index = 0;
	}
}


// blend the palette *pal into the blend palette.
// if pal = NULL, initialize
void blendpalette( char *pal ){
	int i,j,k;
	int count;
	int weight, weight1, weight2;
	unsigned long *index,*index2;
	long temp;
	char *palptr;
	unsigned char *wp;

	if( pal == NULL ){   // initialize palette
		for( i = 0, index = weightedpal; i<256; i++, index++ ){
			*index = 0;
		}
		return;
	}
	// else
	index = weightedpal + 256;
	palptr = pal;
	for( i=0; i<256; i++ ){
		*index = ( *(long*)palptr & 0x00FFFFFF ) + 0x01000000;
		index++;
		palptr += 3;
	}
	// collapse palette
	count = 512;
	for( i=0; i<256; i++ ){
		index = ( unsigned long* )weightedpal+i;
		for( j = i + 1; j < count; j++ ){
			index2 = weightedpal + j;
			if( ( *index & 0x00FFFFFF ) == ( *index2 & 0x00FFFFFF ) ){
				*index += *index2 & 0xFF000000; // this can overflow
				for ( k= j + 1; k < count; k++){
					*index2 = *( index2 + 1 );
					index2++;
				}
				count--;
			}
		}
	}
	// sort palette
	for( i = 1; i < count-1; i++ ){      // sort colors 1-255
		index = weightedpal + i;
		index2 = index;
		for( j = i + 1; j < count; j++ ){
			index2++;
			// sort by green
			if( ( *index & 0x0000FF00 ) > ( *index2 & 0x0000FF00 ) ){
				temp = *index;
				*index = *index2;
				*index2 = temp;
			}
		}
	}
	// reduce palette to 256
	while( count > 255 ){
		long min = MAXLONG;
		int mini, minj;
		for( i = 1; i< count-1; i++ ){  // blend colors 1-255;
			index = weightedpal+i;     // color 0 stays the same for
			index2 = index;            // transparency.
			int dgreen2 = 0;
			for(j=i+1; j<count && dgreen2<min; j++){
               	index2++;
               	long d = (*index & 0x000000FF)    	 // red
					- (*index2 & 0x000000FF);
                    long distance = d*d;
                    d = ((*index >> 8) & 0x000000FF)    // green
					- ((*index2 >> 8) & 0x000000FF);
                    dgreen2 = d*d;
                    distance += dgreen2;
                    d = ((*index >> 16) & 0x000000FF)   // blue
					- ((*index2 >> 16) & 0x000000FF);
                    distance += d*d;
                    // assuming you want to blend to nearest RGB value;
                    // you may want to calculate the distance differently
                    // to give more weight to tint & color

                    // weighted distance = ab/(a+b)
				distance = distance * ( *index >> 24 ) * ( *index2 >> 24 )
					/( ( *index >> 24) + ( *index2 >> 24 ) );
				if( distance < min ){
					mini = i;
					minj = j;
					min = distance;
				}
			}
		}
		// blend colors
		index = weightedpal+mini;
		index2 = weightedpal+minj;
		weight1 = *index >> 24;          // this probably could be
		weight2 = *index2 >> 24;         // done more efficiently
		weight = weight1+weight2;        // with a union
		int r, g, b;
		r = ( ( *index & 0x000000FF ) * weight1
			+ ( *index2 & 0x000000FF ) * weight2 ) / weight;
		g = ( ( ( *index >> 8 ) & 0x000000FF ) * weight1
			+ ( ( *index2 >> 8 ) & 0x000000FF ) * weight2 ) / weight;
		b = ( ( ( *index >> 16 ) & 0x000000FF ) * weight1
			+ ( ( *index2 >> 16 ) & 0x000000FF ) * weight2 ) / weight;
		if( weight > 255 ) weight = 255;
		wp = (unsigned char*) index;
		*(wp++) = r;
		*(wp++) = g;
		*(wp++) = b;
          *(wp++) = weight;
		for( k = minj + 1; k < count; k++ ){
			*index2 = *( index2 + 1 );
               index2++;
               }
		count--;
	}
}

// possible optimizations:
//
// Check the distance immediatly after computing the green and
// branch to the end of the loop if it is greater than min
//
// Rather than find just the minimum distance, make an array
// with the 256 closest distances.  Then just check distances to
// the new color against this array.
//
// Rather than reference the indices, use a long variable or a union
// long/weightedColor to manipulate data.
//
// Compute the square root of the minimum distance and compare
// the color difference to this before multiplying.
//
// The inner loop of the reduce palette section takes most of the time
// (for j=i+1; j<count && dgreen2 < min...), so optimize this area first
//
// For better accuracy, re-sort the array after blending a color
// (just move the new color to its proper place)
//
// When collapsing the palette, use an int to sum the weights
// and make 255 the maximum value.


// return blended palette
void get_blendpal( char *pal ){
     char *wp, *palptr;
     int i;

     wp = (char*) weightedpal;
     palptr = pal;
     for( i=0; i<256; i++ ){
     	*palptr = *wp;
          palptr++;
		wp++;
     	*palptr = *wp;
          palptr++;
		wp++;
     	*palptr = *wp;
          palptr++;
		wp += 2;
	}
}


void mappalette( unsigned char *pal, unsigned char *blendpal ){
// global  char palindex[256];
// generate palindex based on blendpal, pal
	int i, j;
	long distance, d, min;
	int r,g,b;
	unsigned char *bp;

	for(i = 0;i<256; i++){
		r = *(pal++);
		g = *(pal++);
		b = *(pal++);
		bp = blendpal;
		for( j = 0, min = 1000000L; j < 256; j++ ){
			d = r - *(bp++); // red
			distance = d*d;
			d = g - *(bp++); // green
			if( distance < min ){
				distance += d*d;
			}
			d = b - *(bp++); //blue;
			if( distance < min ){
				distance += d*d;
				if( distance < min ){
					palindex[i] = ( unsigned char ) j;
					min = distance;
				}
			}
		}
	}
}


void mappalette_t( unsigned char *pal, unsigned char *blendpal ){
// preserve transparency
// global char palindex[256];
// generate palindex based on blendpal, pal
	int i,j;
	long distance, d,min;
	int r,g,b;
	unsigned char *bp;

	for( i = 0; i < 256; i++ ){
		r = *(pal++);
		g = *(pal++);
		b = *(pal++);
		bp = blendpal;
		for( j = 0, min = 1000000L; j < 256; j++ ){
			d = r - *(bp++); // red
			distance = d*d;
			d = g - *(bp++); // green
			if( distance < min ){
				distance += d*d;
			}	
			d = b - *(bp++); //blue;
			if( distance < min ){
				distance += d*d;
				if( distance < min && 
				    ( j > 0 || distance == 0 ) ){
					palindex[i] = (unsigned char)j;
					min = distance;
				}
			}
		}
	}
}


void mapimage( void *p ){
	int xsize,ysize;
	unsigned size, i;
	unsigned char *p2;

	xsize = *(int*)p + 1;
	ysize = *((int*)p + 1) + 1;
	size = xsize * ysize + 4;
	p2 = (unsigned char*)p + 4;

	for( i = 4; i < size; i++ ){
		*p2 = *(palindex + *p2);
		p2++;
	}
}


void reducepalette( char *pal ){
	int i;
	char *color;

	for(i = 0, color = pal; i<768; i++, color++){
 		*color >>= 2;
	}
}

/*_____________________________________________________________________

                  vga get & set 256 color palette functions           */


void getpalette(char *pal){          // char pal[768]
    asm{
        les di, pal
        mov dx, 3c7h             //read color index = 0;
        mov al, 0
        out dx, al
        mov dx, 3c9h
        mov cx, 768
        cld
        rep insb
    }
}

void setpalette(char *pal){
    asm{
        // wait for refresh needs to be added only if snow is present
        lds si, pal
        mov dx, 3c8h
        mov al, 0               // start with color 0
        out dx, al
        inc dx
        mov cx, 768
        cld
        rep outsb
    }
}


//*********************************************************************
//
// pcx image functions

struct PCX_format // basic PCX format
     {
     char headerstuff[4];
     unsigned left,top,right,bottom;   // image dimentions
     char morestuff[116];              // pcx header = 128 bytes
     unsigned char *data;		    // not used
     unsigned char palette[768];
     } pcx;      	// this is all you need to read a file that is
				// known to be a proper 256 color pcx file.
                    // (assuming the bytes per line is the same as the width)

void *loadpcx(char *filename)  // 16-bit assembled
{ void *p;                     // a 32 bit version of this will probably
  char *p1;                    // handle full-screen images.
  char buf[256];
  int bufptr;
  unsigned i,runlength;
  unsigned width,height,size;
  FILE *f;

  unsigned char chr;

  f=fopen(filename,"rb");
  if (f == NULL)
   {// printf(" file '%s' not found\n",filename);
     p = NULL; return p;
   }
  fread(pcx.headerstuff,1,128,f);
  width=pcx.right - pcx.left + 1;
  height=pcx.bottom - pcx.top + 1;
//  width= pcx.right + 1;
//  height= pcx.bottom + 1;
  size=width*height+6;
  p=malloc(size);
  if (p == NULL)
   { printf (" not enough memory available to load %s\n",filename);
     return p;
   }
  *(int *)p = width-1;
  *((int *)p+1) = height-1;
  p1 = (char *)p+4;
  // read in data
  fread (buf,1, 256,f);
  bufptr = 0;
  for (i = 0; i< size-6;)
       {
       //fread (&ch,1,1,f);
       chr = buf[bufptr++];
       if (bufptr >= 256)
        { fread (buf,1, 256,f);
          bufptr = 0;
        }

       if (chr < 192) p1[i++] = chr;
       else
            {
            runlength = chr-192;
            //fread(&ch,1,1,f);
            chr = buf[bufptr++];
            if (bufptr >= 256)
             { fread (buf,1, 256,f);
               bufptr = 0;
             }

            //for(j=0; j<runlength && i<size;j++)
            if (runlength > size-i) runlength = size-i;
             asm {
                 mov cx, runlength
                 mov al, chr;
                 les di, p1;
                 add di, i;
                 cld
            //     p1[i++] = chr;
                 rep stosb;
                 }
             i += runlength;
            }
       }
  fseek(f,-768L,SEEK_END);
  fread(pcx.palette,1,768,f);
  fclose(f);
  return p;

}
