//A fast C polygon drawing demonstration (Borland code)

//note: no clipping

#include "string.h"

#include "dos.h"

#include "mem.h"

#include "conio.h"



int polyx[200][2];//stores left & right edge coordinates of polygon

int points[4][2]={10,10, 40,20, 50,40, 5,70};//polygon data

unsigned char far *vgascreen=MK_FP(0xa000,0);//pointer to VGA screen



char drawpoly(int np,int *iptr,unsigned char col);

char pline(int x1,int y1,int x2,int y2);

void SetVGA(void);

void SetTXT(void);





void main(void)

{

  int a,b;



  SetVGA();



  for(a=0; a<256; a+=6) {

    for(b=0; b<4; b++) points[b][0]+=6;

    drawpoly(4,*points,a);

  }



  getch();



  SetTXT();

}



//draws a polygon to VGA, the points must be in clockwise order

//(excuse the messy pointer stuff)

char drawpoly(int np,int *iptr,unsigned char col)

{

  int top=199,bottom=0;

  int a,b,x1,y1,x2,y2;

  unsigned char far *vga;



  //go through polygon lines and calculate x values

  np--;

  for(a=0; a<np; a++) {//do up to last line



    b=a*2;

    x1=iptr[b]; y1=iptr[b+1];

    if (y1<top) top=y1;

    if (y1>bottom) bottom=y1;



    pline(x1,y1,iptr[b+2],iptr[b+3]);

  }

    //do last line

  x1=iptr[np*2]; y1=iptr[(np*2)+1];

  if (y1<top) top=y1;

  if (y1>bottom) bottom=y1;

  pline(x1,y1,iptr[0],iptr[1]);



  if (bottom<top) return(0);//error



  vga=vgascreen+(top*320);



  //loop from top to bottom of polygon, drawing lines

  for(a=top; a<bottom+1; a++)

  {

    if (polyx[a][0]>polyx[a][1]) {vga=vga+320; continue;}//error

    memset(vga+polyx[a][0],col,polyx[a][1]-polyx[a][0]+1);

    vga=vga+320;

  }



  return(1);

}



char pline(int x1,int y1,int x2,int y2)

{

  char xu;

  int offset;

  int yd=y2-y1,yd2;

  int xd=x2-x1;

  int err=0;

  int X=x1,Y;



  if (y1==y2) return(0);//horizontal line



  if (yd<0) yd=-yd;



  if (xd<0) {xd=-xd; xu=-1;}

  else xu=1;



  //this line makes some edge lines better

  //not essential

  if (yd>xd) err=yd>>1;



  //record x values along line

  yd2=yd-1;



  if (xu==1) {



    if (y1>y2) {

      for (Y=y1; Y>y2-1; Y--)

      {

	polyx[Y][0]=X;

	err+=xd;

	if (err>yd2) do{err-=yd; X++;}while(err>=yd);

      }

      return(0);

    }

    else {

      for (Y=y1; Y<y2+1; Y++)

      {

	polyx[Y][1]=X;

	err+=xd;

	if (err>yd2) do{err-=yd; X++;}while(err>=yd);

      }

      return(0);

    }



  }



  else {



    if (y1>y2) {

      for (Y=y1; Y>y2-1; Y--)

      {

	polyx[Y][0]=X;

	err+=xd;

	if (err>yd2) do{err-=yd; X--;}while(err>=yd);

      }

      return(0);

    }

    else {

      for (Y=y1; Y<y2+1; Y++)

      {

	polyx[Y][1]=X;

	err+=xd;

	if (err>yd2) do{err-=yd; X--;}while(err>=yd);

      }

    }



  }



  return(0);

}



void SetVGA(void)

{

  union REGS regs;

  regs.h.al = 0x13;

  regs.h.ah = 0x00;

  int86(0x10, &regs, &regs);

}



void SetTXT(void)

{

  union REGS regs;

  regs.h.al = 0x03;

  regs.h.ah = 0x00;

  int86(0x10, &regs, &regs);

}



