;
;
; This file was intended for learning purposes and it accompanies the package
; about 320x400x256 xmode made by The Bitripper.
;
; You're ofcourse allowed to modify this code as much as you like, but please,
; when you spread the package, spread it in whole and unmodified, so others
; don't encounter any problems. Thnx.
;
; Also, I'd like to be greeted. Don't bother about it, you don't have to,
; but it's kinda polite. Then again, who wants to be polite ;) ? Well, see for
; yarselves. Whatever it'll be, I promise, I won't get mad at you :).
;
; Compile with TASM, just start MAKE.EXE.
;
; If you don't have MAKE.EXE (shame on you!) then, you can also compile this by
; typing the following at the command line:
;
; TASM /m XMODE.ASM  <
; TLINK /x XMODE.OBJ <
;
; I don't know MASM, so I don't know if it will compile.. Anyway, Borland rulez!
;
;

.MODEL SMALL                                    ; Small memory model is enough

.STACK 200h                                     ; Little out of proportion, but
                                                ; that doesn't matter for now


.DATA        ; The DATA segment starts here

Crt_C           equ     3d4h                    ; Constants for easily using the
Max_Scan_Line   equ     9h                      ; ports and keeping the source
Underline_Loc   equ     14h                     ; clear and understandable
Mode_Control    equ     17h

Seq_C           equ     3c4h
Map_Mask        equ     2h
Memory_Mode     equ     4h

Gfx_C           equ     3ceh
Graphics_Mode   equ     5h
Miscellaneous   equ     6h

Palette         LABEL   BYTE                    ; Palette of picture to show
                INCLUDE PALETTE.INC

Picture         LABEL   BYTE                    ; Picture to show (it is shown
                INCLUDE PICTURE.INC             ; two times to show 400 lines)






.CODE        ; The CODE segment starts here

;
; Use the 'Select' macro to choose a new controller and indexed register.
;
; Input  : Controller port adress, Register index number
; Output : Current value for chosen register in AL
;

Select          MACRO   Controller, Register
                mov     dx,controller           ; Select address register
                mov     al,register             ; to put register index number
                out     dx,al
                inc     dx                      ; Select data register
                in      al,dx                   ; Input current value to AL
                ENDM

;
; Use the 'Other' macro to choose another register, indexed through the same
; controller.
;
; Input  : Register index number for current controller
; Output : Current value for chosen register in AL
;

Other           MACRO   Register
                dec     dx                      ; Select address register
                mov     al,register             ; to put register index number
                out     dx,al
                inc     dx                      ; Select data register
                in      al,dx                   ; Input current value to AL
                ENDM

;
; Use the 'Put' macro to set the new value to the chosen register in the chosen
; controller.
;
; Input  : Value to set current register within the current controller in AL
; Output : none
;

Put             MACRO
                out     dx,al                   ; Save value of AL to register
                ENDM




                mov     ax,dgroup               ; Initialize DS and ES to
                mov     ds,ax                   ; datasegment
                mov     es,ax

                mov     ax,13h                  ; 320x200x256
                int     10h

                mov     ax,1012h                ; Load palette for picture
                xor     bx,bx
                mov     cx,255
                mov     dx,offset palette
                int     10h

                select  seq_c,memory_mode
                and     al,00000011b            ; Clear & preserve lowest 2 bits
                or      al,00000100b            ; Chain4 & Odd/Even mode off
                put

                select  gfx_c,graphics_mode     ; Set linear mode
                and     al,11101111b
                put

                other   miscellaneous           ; Set linear mode
                and     al,11111101b
                put

                select  crt_c,underline_loc     ; Double-word mode off
                and     al,10111111b
                put

                other   mode_control            ; Word mode off, byte mode on
                or      al,01000000b
                put

                other   max_scan_line           ; 320x400x256
                and     al,01110000b
                put

                select  seq_c,map_mask          ; All planes on for writing
                or      al,00001111b
                put

                mov     ax,0a000h               ; Set ES to VGA segment (0a000h)
                mov     es,ax
                xor     di,di                   ; and DI to offset 0000h
                mov     cx,08000h               ; The number of words is 32768
                xor     ax,ax                   ; Put a zero word 32768 times to
                rep     stosw                   ; ES:DI

                xor     di,di                   ; Start at offset 0000h

                mov     cx,2                    ; Do 2 pictures (200 lines each)
Two_Pictures:   push    cx

                mov     si,offset picture       ; Set source to picture data
                mov     cx,64000                ; Picture length = 320x200 bytes

                mov     bl,1                    ; Set plane 0 to start at
Do_All_Pixels:  select  seq_c,map_mask          ; Select plane to write to
                and     al,11110000b
                or      al,bl
                put

                movsb                           ; Copy byte from source to
                dec     di                      ; target and keep offset thesame

                shl     bl,1                    ; Next plane to set pixel to
                cmp     bl,8                    ; Plane number above 3 ?
                jna     plane_ok                ; No, it's between plane 0 to 3
                mov     bl,1                    ; Yes, start at plane 0 again
                inc     di                      ; Increment the target offset

Plane_Ok:       dec     cx                      ; All bytes of picture done ?
                jnz     do_all_pixels           ; No, do them all

                pop     cx
                dec     cx                      ; All pictures done ?
                jnz     two_pictures            ; No, do them all
                
                xor     ah,ah                   ; Wait for a keypress
                int     16h

                mov     ax,3                    ; 80x25x16 text mode
                int     10h

                mov     ax,4c00h                ; Terminate and back to DOS
                int     21h
END
