//--------------------------------------------
// PIXELS - Barny Mercer 29/7/95 @ 1:48am
//
// Demonstrates 3 different methods of writing
// pixels to a VGA screen.
//--------------------------------------------

#include <conio.h>
#include <stdio.h>
#include <memory.h>
#include <stdlib.h>

#define VID_320x200	0x0013
#define VID_TEXT        0x0003

void VidMode( int Mode );
void PutINTPixel( int X, int Y, unsigned char Colour );
void PutDMAPixel( int X, int Y, unsigned char Colour );
void PutASMPixel( int X, int Y, unsigned char Colour );
void Intro(void);
void Outtro(void);

unsigned char *vga = (unsigned char *)0xA0000000;

void main(void)
{
	// make sure we're in text mode first for intro message
	VidMode( VID_TEXT );

	Intro();

        // select video mode
        VidMode( VID_320x200 );

	printf( "Interupt Pixels..." );
	getch();

	for (int loops=0; loops<9; loops++)
	{
	    for (int Tmp=0; Tmp<200; Tmp++)
	    {
		 for (int Tmp2=0; Tmp2<320; Tmp2++)
		     PutINTPixel( Tmp2, Tmp, rand() );
	    }
	}

	getch();

	// use video mode to clear screen
	VidMode( VID_320x200 );
	printf( "DMA Pixels....." );
	getch();

	for (loops=0; loops<9; loops++)
	{
	    for (int Tmp=0; Tmp<200; Tmp++)
	    {
		 for (int Tmp2=0; Tmp2<320; Tmp2++)
		     PutDMAPixel( Tmp2, Tmp, rand() );
	    }
	}

	VidMode( VID_320x200 );
	printf( "Assembly Pixels....." );
	getch();

	for (loops=0; loops<9; loops++)
	{
	    for (int Tmp=0; Tmp<200; Tmp++)
	    {
		 for (int Tmp2=0; Tmp2<320; Tmp2++)
		     PutASMPixel( Tmp2, Tmp, rand() );
	    }
	}

        getch();        // wait for keypress

        // return to text mode
	VidMode( VID_TEXT );

	Outtro();
}

//------------------------------------------------------
// VidMode - Uses BIOS to switch to video mode specified
//------------------------------------------------------

void VidMode( int Mode )
{
        _asm
        {
                mov ax, [Mode]
                int 10h
        }
}

//---------------------------------------------------------
// PutDMAPixel - Uses Direct Memory Access to place a pixel
//               at X, Y
//---------------------------------------------------------

void PutDMAPixel( int X, int Y, unsigned char Colour )
{
    memset(vga+(Y*320)+X, Colour, 1);	// on-the-fly version
}

//------------------------------------------------------
// PutINTPixel - Uses BIOS interrupts to place a pixel
//               at X, Y
//------------------------------------------------------

void PutINTPixel( int X, int Y, unsigned char Colour )
{
        _asm
        {
                mov ah,  0x0C       ; specify apropriate function
                mov al,  [Colour]   ; put required colour in low byte
                mov cx,       [X]   ; X coordinate
                mov dx,       [Y]   ; Y coordinate
                mov bx, 0x01        
                int 10h             ; execute interrupt
        }
}

//------------------------------------------------------
// PutASMPixel - Uses assembly code to place a pixel
//		 at X, Y directly to memory
//------------------------------------------------------

void PutASMPixel( int X, int Y, unsigned char Colour )
{
      _asm
      {
	  mov ax, 0xA000   ; point AX to video memory
	  mov es, ax	   ; move segment pointer to ES
			   ; (actual pointer)
	  mov bx, [Y]
	  mov dx, bx	   ; register to register is faster by 1 clock

	  mov dh, dl	   ; dx=y*256 + y
	  xor dl, dl	   ; clear lower byte of DX

	  shl bx, 6	   ; bx=y*64
	  add bx, dx	   ; bx=y*320

	  add bx, [X]	   ; bx=(y*320)+x
	  mov di, bx	   ; move video pointer to correct place

	  mov al, [Colour]
	  mov es:[di], al  ; move colour to memory
      }
}

void Intro()
{
    printf( "This program aims to demonstrate 3 ways of writing pixels to the screen.\n\n" );
    printf( "1. Interrupt pixels - This routine uses Int. 10h to place a pixel (part ASM)\n" );
    printf( "2. DMA pixels       - These pixels are placed on screen by writing directly\n");
    printf( "                      to memory.\n" );
    printf( "3. ASM pixels       - This PutPixel routine was written in assembler for speed.\n\n");
    printf( "These routines loop 10 times each to demonstrate the speed differences.\n" );

    getch();
}

void Outtro()
{
    printf( "Goodbye.....\n\n" );
    printf( "Barny Mercer - 29/7/95 @ 12:39am\n" );
    printf( "barny.mercer@zetnet.co.uk\n" );

    getch();
}
