#include "..\include\vgafunc.h"
#include <conio.h>
#include <string.h>

void GetAllPalette( unsigned char *Pal )
{
    int nTmp = 0;

    for (int nIndex=0; nIndex<256; nIndex++)
    {
	// output nIndex to port 0x3C7
	outp( 0x3C7, nIndex );

	// read values into array
	Pal[nTmp++] = inp(0x3C9);
	Pal[nTmp++] = inp(0x3C9);
	Pal[nTmp++] = inp(0x3C9);
    }
}

void SetAllPalette( unsigned char *Pal )
{
    int nPalPoint=0;

    // WaitVerticalRetrace();

    for (int nIndex=0; nIndex<256; nIndex++)
    {
	// output nIndex to port 0x3C7
	outp( 0x3C7, nIndex );

	// output values to VGA
	outp( 0x3C9, Pal[nPalPoint++] );
	outp( 0x3C9, Pal[nPalPoint++] );
	outp( 0x3C9, Pal[nPalPoint++] );
    }
}

void SetPalToBlack()
{
    int nPalPoint=0;

    for (int nIndex=0; nIndex<256; nIndex++)
    {
	// output nIndex to port 0x3C7
	outp( 0x3C7, nIndex );

	// output values to VGA
	outp( 0x3C9, 0);
	outp( 0x3C9, 0);
	outp( 0x3C9, 0);
    }
}

void FadePalToBlack( unsigned char *Pal, unsigned char nStep )
{
    int nTmp;	// loop counter

    static unsigned short TempPal[768];

    // make a copy of palette - use fixed point to improve accuracy but
    // retain speed
    for (nTmp=0; nTmp<768; nTmp++)
	TempPal[nTmp] = (Pal[nTmp]<<10);

    for (nTmp=0; nTmp<nStep; nTmp++)
    {
	// calculate values
	for (int nIndex=0; nIndex<768; nIndex++)
	{
	    if (TempPal[nIndex] > 0)
		TempPal[nIndex] -= (Pal[nIndex]<<3);
	}
    }

    // fill old palette with new data
    for (nTmp=0; nTmp<768; nTmp++)
	Pal[nTmp]=(TempPal[nTmp]>>10);
}

void FadePalFromBlack( unsigned int *Current, unsigned char *ToPal, int nStep )
{
    int nTmp;	// loop counter

    for (nTmp=0; nTmp<nStep; nTmp++)
    {
	// calculate values
	for (int nIndex=0; nIndex<768; nIndex++)
	{
	    if (Current[nIndex] <  (ToPal[nIndex]<<10))
		Current[nIndex] += (ToPal[nIndex]<<3);
	}
    }
}

void FadePalToPal( unsigned char *FromPal, unsigned char *ToPal )
{
    int nTmp;	// loop counter

    int nPalPoint;
    int nDiff;

    static unsigned short TempPal[768];

    // make copy of palette
    for (nTmp=0; nTmp < 768; nTmp++)
	TempPal[nTmp] = (FromPal[nTmp]<<10);

    for (nTmp=0; nTmp<128; nTmp++)
    {
	// calculate new values
	for (int nIndex=0; nIndex<768; nIndex++)
	{
	    // only modify values that are not equal yet
	    if (TempPal[nIndex] != (ToPal[nIndex]<<10) )
	    {
		if (TempPal[nIndex] < (ToPal[nIndex]<<10) )
		    TempPal[nIndex] += ((ToPal[nIndex] - FromPal[nIndex])<<3);
		else
		    TempPal[nIndex] -= ((FromPal[nIndex] - ToPal[nIndex])<<3);
	    }
	}

	nPalPoint=0;

	for (nIndex=0; nIndex<256; nIndex++)
	{

	    // output nIndex to port 0x3C7
	    outp( 0x3C7, nIndex );

	    // output values to VGA
	    outp( 0x3C9, (TempPal[nPalPoint++]>>10) );
	    outp( 0x3C9, (TempPal[nPalPoint++]>>10) );
	    outp( 0x3C9, (TempPal[nPalPoint++]>>10) );
	}
    }
}

void MakeGradPal( GradPal *Data, int NumValues, unsigned char *Pal )
{
    int nDist=0;
    int nChgRed, nChgGrn, nChgBlu;

    int nCurrentIndex=0;

    // 16 bit temporary palette
    static unsigned int TempPal[3] = {0};

    // clear palette array
    for (int Tmp=0; Tmp<768; Tmp++)
	Pal[Tmp]=0;

    // loop through number of values
    for (Tmp=0; Tmp<NumValues; Tmp++)
    {
	// find distance
	nDist = (Data[Tmp+1].Index - Data[Tmp].Index);

	// kludge to ensure no DIV/0 errors
	if (nDist==0)
	    nDist=1;

	// find colour change over whole
	nChgRed = ( ( (Data[Tmp+1].Red<<9)   - (Data[Tmp].Red<<9)  ) / nDist);
	nChgGrn = ( ( (Data[Tmp+1].Green<<9) - (Data[Tmp].Green<<9)) / nDist);
	nChgBlu = ( ( (Data[Tmp+1].Blue<<9)  - (Data[Tmp].Blue<<9) ) / nDist);

	// starting point
	TempPal[0] = (Data[Tmp].Red<<9	);
	TempPal[1] = (Data[Tmp].Green<<9);
	TempPal[2] = (Data[Tmp].Blue<<9 );

	// loop through range provided by data structure
	for (int nIndex=Data[Tmp].Index;
		 nIndex<Data[Tmp+1].Index;
		 nIndex++)
	{
	    // write values to palette
	    Pal[nCurrentIndex++] = (TempPal[0]>>9);
	    Pal[nCurrentIndex++] = (TempPal[1]>>9);
	    Pal[nCurrentIndex++] = (TempPal[2]>>9);

	    // increment values for next loop
	    TempPal[0] += nChgRed;
	    TempPal[1] += nChgGrn;
	    TempPal[2] += nChgBlu;
	}
    }
}

void PalCycle( unsigned char *Pal, int Number, int nStart, int nFinis )
{
    int nTmp;

    int nStartInd = (nStart*3);
    int nFinisInd = (nFinis*3);
    int nRange	  = (nFinisInd-nStartInd);

    if (nRange<0)
	nRange =- nRange;

    // holds a copy of the palette
    unsigned char Temp[3];

    if (Number>0)
    {
	for (int nLoop=0; nLoop<Number; nLoop++)
	{
	    // store last colour
	    memmove( Temp, &Pal[nFinisInd], 3 );

	    // move palette up 1
	    memmove( &Pal[nStartInd+3], &Pal[nStartInd], nRange );

	    // place highest colour in 1st index
	    memmove( &Pal[nStartInd], Temp, 3 );
	}
    }
    else
    {
	for (int nLoop=0; nLoop>Number; nLoop--)
	{
	    // store first colour
	    memmove( Temp, &Pal[0], 3 );

	    // move palette down 1
	    memmove( &Pal[0], &Pal[3], 762);

	    // place first colour into second last palette index
	    memmove( &Pal[762], Temp, 3 );
	}
    }
}

void CopyPalette( unsigned char *OrigPal, unsigned char *NewPal )
{
    for (int Tmp=0; Tmp<768; Tmp++)
	NewPal[Tmp] = OrigPal[Tmp];
}

void WaitVerticalRetrace(void)
{
  // wait for vertical retrace to begin

  _asm
  {
    mov dx, 0x03DA

    t1:
      in  al, dx
      and al, 0x08
      jz t1

    t2:
      in  al, dx
      and al, 0x08
      jnz t2
  }
}
