#include "..\include\vgafunc.h"
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>

void DrawScreen(void);
void Intro(void);
void Outro(void);
void FadeNRotate(unsigned char *, unsigned char *);

unsigned char *Screen = (unsigned char *)0xA0000000;

// 
// VGA Tutorial III - The Palette
//
// Barny Mercer - 1995
// 

void main(void)
{
    // gradient array - fade from black to red to yellow to white to black
    GradPal BarsData[5] = { {  0,  0,  0,   0},
			    { 63,  0,  0,  64},
			    { 63, 63,  0, 128},
			    { 63, 63, 63, 192},
			    {  0,  0,  0, 255},
			  };

    static unsigned char BarsPal[768];

    // black to blue to white
    GradPal BlueSkyData[4] ={ {	 0,  0,  0,   0},
			      {  0,  0, 63,  32},
			      { 63, 63, 63,  96},
			      {	 0,  0,	 0, 255},
			    };

    static unsigned char BlueSkyPal[768];

    // ZEBRA
    // black to white to black..... (you get the idea)
    GradPal ZebraData[11] ={ {	0,  0,	0,   0},
			     { 63, 63, 63,  25},
			     {	0,  0,	0,  50},
			     { 63, 63, 63,  75},
			     {	0,  0,	0, 100},
			     { 63, 63, 63, 125},
			     {	0,  0,	0, 150},
			     { 63, 63, 63, 175},
			     {	0,  0,	0, 200},
			     { 63, 63, 63, 225},
			     {	0,  0,	0, 255},
			   };

    static unsigned char ZebraPal[768];
    static unsigned char CurPal[768] = {0};	// current working palette

    // create new palettes to be used later
    MakeGradPal( BarsData, 5, BarsPal );
    MakeGradPal( BlueSkyData, 4, BlueSkyPal );
    MakeGradPal( ZebraData, 11, ZebraPal );

    // say 'Hello' to all the boys & girls
    VidMode( VID_TEXT );
    Intro();

    VidMode( VID_320x200 );

    // set entire palette to black so that we can draw on the screen
    // without being seen
    SetPalToBlack();
    DrawScreen();

    FadeNRotate( CurPal, ZebraPal );

    // morph palettes
    FadePalToPal( ZebraPal, BlueSkyPal );

    // clear keyboard buffer
    getch();

    // cycle palette
    while (!_kbhit())
    {
	PalCycle( BlueSkyPal, -1, 0, 254 );
	SetAllPalette( BlueSkyPal );
    }

    // morph palettes again
    FadePalToPal( BlueSkyPal, BarsPal );

    // cycle palette fo a while....
    for (int Tmp=0; Tmp<200; Tmp++)
    {
	PalCycle( BarsPal, 1, 0, 254);
	SetAllPalette( BarsPal );
    }

    // begin fade out
    for (Tmp=0; Tmp<128; Tmp++)
    {
	// give palette a twist
	PalCycle( BarsPal, 1, 0, 254);

	// fade palette closer to correct value
	FadePalToBlack( BarsPal, 1 );

	// plunk palette down
	SetAllPalette( BarsPal );
    }

    getch();

    // reset video mode
    VidMode( VID_TEXT );
    Outro();
}

void DrawScreen(void)
{
    float nColour = 1;

    for (int Tmp=0; Tmp<320; Tmp++)
    {
	DrawLine( 160, 100, Tmp, 0, (int)(nColour += 0.246), Screen );
	if (nColour>255)
	    nColour=1;
    }

    for (Tmp=0; Tmp<200; Tmp++)
    {
	DrawLine( 160, 100, 319, Tmp, (int)(nColour += 0.246), Screen );
	if (nColour>255)
	    nColour=1;
    }

    for (Tmp=319; Tmp>=0; Tmp--)
    {
	DrawLine( 160, 100, Tmp, 199, (int)(nColour += 0.246), Screen );
	if (nColour>255)
	    nColour=1;
    }

    for (Tmp=199; Tmp>=0; Tmp--)
    {
	DrawLine( 160, 100, 0, Tmp, (int)(nColour += 0.246), Screen );
	if (nColour>255)
	    nColour=1;
    }
}

void Intro(void)
{
    printf( "Hi there and welcome to this decidedly belated VGA programming tutorial\n");
    printf( "This tutorial concerns it's self with the VGA palette.\n\n" );
    printf( "This program illustrates several palette manipulations.\n" );
    printf( "Have fun......" );

    getch();
}

void Outro(void)
{
    printf( "Now that certainly looks much nicer than anything we've done so far :)\n\n" );
    printf( "Keep an eye out for tutorial IV which will focus on drawing filled polygons\n\n");
    printf( "Happy coding...... \n\n" );
    printf( "Barny Mercer :  barny.mercer@zetnet.co.uk " );

    getch();
}

// this bit fades in the screen while rotating the palette to give a nice
// intro.  Notice that the fade isn't very smooth.  Using the method
// described in the tutorial will make things nicer.

void FadeNRotate(unsigned char *CurPal, unsigned char *ZebraPal)
{
    while( !_kbhit() )
    {
	// give palettes a twist
	PalCycle( CurPal, 1, 0, 254);
	PalCycle( ZebraPal, 1, 0, 254 );    // we must cycle zebrapal too
					    // so that the colours stay in line
	// fade palette closer to correct value
	FadePalFromBlack( CurPal, ZebraPal, 1 );

	// plunk palette down
	WaitVerticalRetrace();	    // wait for a vertical screen retrace to end
	SetAllPalette( CurPal );
    }
}
