// Persistence of Vision Ray Tracer Scene Description File
// File: theFile.pov
// Vers: 3
// Desc: 
// Date: mm dd 1997
// Auth: hans-joerg ruediger 100540.3177@compuserve.com


#include "colors.inc"
#include "finish.inc"
#include "shapes.inc"
#include "shapes2.inc"

#version 3.0
global_settings { assumed_gamma 1.0 }

camera {
	location  <0, 4,-10>
	direction <0, 0,  1>
    up        <0,  1,  0>
    right     <1, 0,  0>
    look_at   <0, 0, 0>
    }


background { color Black }


light_source {<50, 50, -100> color White }
light_source {<-20, 100, -50> color White }


#declare headTex = 
texture{
		pigment{color rgb<.5, .7, .2>}
        finish {
         ambient 0.75
         diffuse 0.3
         phong 1
         phong_size 200
        } // finish
      }	//tex



#declare numFrames = 150
#declare wormL = 8

#declare cylRadius = .33
#declare headRad = .5
#declare amp = 3
#declare increment = pi/(numFrames)
#declare filterInc = 1/(wormL)
#declare filterVal = 0

// frequency modulated funcs

#declare modI = 2
#declare freqR = 1.5
// loop init
 	#declare Count = -pi + (2*(clock * (numFrames) * increment)) // skip every other step
	
	#declare lastX = amp*sin(Count*pi + modI*sin(freqR*Count*pi))
	#declare lastZ = amp*cos(Count*pi + modI*cos(freqR*Count*pi))
	#declare lastY = 1*Count
// one step further	
	#declare Count = Count + increment

#declare theLoop =
blob{
	threshold .5
   #while (Count <= -pi + ((2*(clock * (numFrames) * increment)) + (wormL*increment)))
	#declare X = amp*sin(Count*pi + modI*sin(freqR*Count*pi))
    #declare Z = amp*cos(Count*pi + modI*cos(freqR*Count*pi))
	#declare Y = 1*Count
    cylinder { <lastX, lastY, lastZ>,<X,Y,Z>, cylRadius , 1
      texture{
			// increasing (in tail direction) filter for pseudo motion blur
			pigment{color rgbf<abs(X)/amp, .3, .8, (1-filterVal)>} 
			finish{ambient .2 diffuse .6
					phong 1 phong_size 75
				}
     	 	}	//tex
    	}	//cyl

	#declare lastX = X
	#declare lastY = Y
	#declare lastZ = Z
    #declare Count = Count + increment
	#declare filterVal = filterVal + filterInc

  #end
	sphere { <X, Y, Z>, headRad, 1
			texture{headTex}
			}
}

#declare traceLight =
light_source{
	<-10, 10, -10>
	color White
	spotlight
	point_at <X, Y, Z>
	radius 5
	tightness 50
	falloff 10
}

#declare theRod =
object{Disk_Y scale <.1, 5,.1>
	texture{
		finish{ambient .7 diffuse .3 specular 1 roughness .005 metallic reflection 1}
		}
}

union{
	object{theLoop rotate -0*x }
	object{traceLight}

	object{theRod pigment{color rgbf<.5,.5,.95,.3>} rotate 6*z translate -.7 * x}
	object{theRod pigment{color rgbf<.5,.8,.5,.7>} translate .6667 * x} 
	object{theRod pigment{color rgbf<.9,.2,.9,.6>} rotate <-90, 60, 0> translate <0,-1,0>}
	object{theRod pigment{color rgbf<.7,.5,.1,.4>} rotate <-40, 0, 45> translate <1,.8,2>}
	object{theRod pigment{color rgbf<.2,.6,.8,.3>} rotate <25, 0, 30> translate <-1.0,-2.7,-2.8>}
	object{theRod pigment{color rgbf<.5,.7,.2,.2>} rotate <-8, 0, -8> translate <1,0,-2.25>}

	rotate <-45, 0,0>
}
