/****************************************************************************
*                   lathe.h
*
*  This module contains all defines, typedefs, and prototypes for LATHE.C.
*
*  from Persistence of Vision(tm) Ray Tracer
*  Copyright 1996 Persistence of Vision Team
*---------------------------------------------------------------------------
*  NOTICE: This source code file is provided so that users may experiment
*  with enhancements to POV-Ray and to port the software to platforms other
*  than those supported by the POV-Ray Team.  There are strict rules under
*  which you are permitted to use this file.  The rules are in the file
*  named POVLEGAL.DOC which should be distributed with this file. If
*  POVLEGAL.DOC is not available or for more info please contact the POV-Ray
*  Team Coordinator by leaving a message in CompuServe's Graphics Developer's
*  Forum.  The latest version of POV-Ray may be found there as well.
*
* This program is based on the popular DKB raytracer version 2.12.
* DKBTrace was originally written by David K. Buck.
* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
*
*****************************************************************************/

#ifndef LATHE_H
#define LATHE_H



/*****************************************************************************
* Global preprocessor definitions
******************************************************************************/

#define LATHE_OBJECT (STURM_OK_OBJECT)

#define LINEAR_SPLINE    1
#define QUADRATIC_SPLINE 2
#define CUBIC_SPLINE     3

/* Generate additional lathe statistics. */

#define LATHE_EXTRA_STATS 1



/*****************************************************************************
* Global typedefs
******************************************************************************/

typedef struct Lathe_Struct LATHE;
typedef struct Lathe_Spline_Struct LATHE_SPLINE;
typedef struct Lathe_Spline_Entry_Struct LATHE_SPLINE_ENTRY;

struct Lathe_Spline_Entry_Struct
{
  DBL r1, r2;          /* Min./Max. radius of segment        */
  DBL h1, h2;          /* Min./Max. height of segment        */
  UV_VECT A, B, C, D;  /* Coefficients of segment            */
};

struct Lathe_Spline_Struct
{
  int References;             /* Count references to this structure. */
  LATHE_SPLINE_ENTRY *Entry;  /* Array of spline segments.           */
};

struct Lathe_Struct
{
  OBJECT_FIELDS
  TRANSFORM *Trans;
  int Spline_Type;         /* Spline type (linear, quadratic ...)  */
  int Number;              /* Number of segments!!!                */
  LATHE_SPLINE *Spline;    /* Pointer to spline array              */
  DBL Height1, Height2;    /* Min./Max. height                     */
  DBL Radius1, Radius2;    /* Min./Max. radius                     */

  //xxx_tb
  UV_VECT *Points;
  //xxx_tb
  int rNumber;
};



/*****************************************************************************
* Global variables
******************************************************************************/




/*****************************************************************************
* Global functions
******************************************************************************/

void  Compute_Lathe_BBox PARAMS((LATHE *Lathe));
void  Compute_Lathe PARAMS((LATHE *Lathe, UV_VECT *P));
LATHE *Create_Lathe PARAMS((void));

#endif
