/*
	POB-File-Format by Thomas Baier April/97


	Description:
	POB-Token-List for producing povray files

	History:
	01.04.97	Version 0.8	First Version, all things implemented, 
					rarly tested

	Comments:

	To Do List:

*/

// Generated Token List

#include "pob_tok.h"

typedef struct
{
	unsigned int pob_token_id;
	char *pob_token_str;
}POB_TOKEN;

POB_TOKEN pob_token_list[LAST_POB_TOKEN] = 
{
	{AA_LEVEL_POB_TOKEN,"aa_level"},
	{AA_THRESHOLD_POB_TOKEN,"aa_threshold"},
	{ABS_POB_TOKEN,"abs"},
	{ACOS_POB_TOKEN,"acos"},
	{ACOSH_POB_TOKEN,"acosh"},
	{ADAPTIVE_POB_TOKEN,"adaptive"},
	{ADC_BAILOUT_POB_TOKEN,"adc_bailout"},
	{AGATE_POB_TOKEN,"agate"},
	{AGATE_TURB_POB_TOKEN,"agate_turb"},
	{ALPHA_POB_TOKEN,"alpha"},
	{AMBIENT_POB_TOKEN,"ambient"},
	{AMBIENT_LIGHT_POB_TOKEN,"ambient_light"},
	{ANGLE_POB_TOKEN,"angle"},
	{APERTURE_POB_TOKEN,"aperture"},
	{ARC_ANGLE_POB_TOKEN,"arc_angle"},
	{AREA_LIGHT_POB_TOKEN,"area_light"},
	{ASIN_POB_TOKEN,"asin"},
	{ASINH_POB_TOKEN,"asinh"},
	{ASSUMED_GAMMA_POB_TOKEN,"assumed_gamma"},
	{ATAN_POB_TOKEN,"atan"},
	{ATAN2_POB_TOKEN,"atan2"},
	{ATANH_POB_TOKEN,"atanh"},
	{ATMOSPHERE_POB_TOKEN,"atmosphere"},
	{ATMOSPHERIC_ATTENUATION_POB_TOKEN,"atmospheric_attenuation"},
	{ATTENUATING_POB_TOKEN,"attenuating"},
	{AVERAGE_POB_TOKEN,"average"},
	{BACKGROUND_POB_TOKEN,"background"},
	{BICUBIC_PATCH_POB_TOKEN,"bicubic_patch"},
	{BLACK_HOLE_POB_TOKEN,"black_hole"},
	{BLOB_POB_TOKEN,"blob"},
	{BLUR_SAMPLES_POB_TOKEN,"blur_samples"},
	{BOUNDED_BY_POB_TOKEN,"bounded_by"},
	{BOX_POB_TOKEN,"box"},
	{BOX_MAPPING_POB_TOKEN,"box_mapping"},
	{BOZO_POB_TOKEN,"bozo"},
	{BREAK_POB_TOKEN,"break"},
	{BRICK_POB_TOKEN,"brick"},
	{BRICK_SIZE_POB_TOKEN,"brick_size"},
	{BRIGHTNESS_POB_TOKEN,"brightness"},
	{BRILLIANCE_POB_TOKEN,"brilliance"},
	{BUMP_MAP_POB_TOKEN,"bump_map"},
	{BUMP_SIZE_POB_TOKEN,"bump_size"},
	{BUMPS_POB_TOKEN,"bumps"},
	{BUMPY1_POB_TOKEN,"bumpy1"},
	{BUMPY2_POB_TOKEN,"bumpy2"},
	{BUMPY3_POB_TOKEN,"bumpy3"},
	{CAMERA_POB_TOKEN,"camera"},
	{CAUSTICS_POB_TOKEN,"caustics"},
	{CEIL_POB_TOKEN,"ceil"},
	{CHECKER_POB_TOKEN,"checker"},
	{CLIPPED_BY_POB_TOKEN,"clipped_by"},
	{COLOR_POB_TOKEN,"color"},
	{COLOR_MAP_POB_TOKEN,"color_map"},
	{COMPONENT_POB_TOKEN,"component"},
	{COMPOSITE_POB_TOKEN,"composite"},
	{CONE_POB_TOKEN,"cone"},
	{CONFIDENCE_POB_TOKEN,"confidence"},
	{CONIC_SWEEP_POB_TOKEN,"conic_sweep"},
	{CONSTANT_POB_TOKEN,"constant"},
	{CONTROL0_POB_TOKEN,"control0"},
	{CONTROL1_POB_TOKEN,"control1"},
	{COS_POB_TOKEN,"cos"},
	{COSH_POB_TOKEN,"cosh"},
	{COUNT_POB_TOKEN,"count"},
	{CRACKLE_POB_TOKEN,"crackle"},
	{CRAND_POB_TOKEN,"crand"},
	{CUBE_POB_TOKEN,"cube"},
	{CUBIC_POB_TOKEN,"cubic"},
	{CUBIC_SPLINE_POB_TOKEN,"cubic_spline"},
	{CYLINDER_POB_TOKEN,"cylinder"},
	{CYLINDRICAL_MAPPING_POB_TOKEN,"cylindrical_mapping"},
	{DECLARE_POB_TOKEN,"declare"},
	{DEFAULT_POB_TOKEN,"default"},
	{DEGREES_POB_TOKEN,"degrees"},
	{DENTS_POB_TOKEN,"dents"},
	{DIFFERENCE_POB_TOKEN,"difference"},
	{DIFFUSE_POB_TOKEN,"diffuse"},
	{DIRECTION_POB_TOKEN,"direction"},
	{DISC_POB_TOKEN,"disc"},
	{DISTANCE_POB_TOKEN,"distance"},
	{DISTANCE_MAXIMUM_POB_TOKEN,"distance_maximum"},
	{DUST_POB_TOKEN,"dust"},
	{DUST_TYPE_POB_TOKEN,"dust_type"},
	{ECCENTRICITY_POB_TOKEN,"eccentricity"},
	{EMITTING_POB_TOKEN,"emitting"},
	{ERROR_BOUND_POB_TOKEN,"error_bound"},
	{EXP_POB_TOKEN,"exp"},
	{EXPONENT_POB_TOKEN,"exponent"},
	{FADE_DISTANCE_POB_TOKEN,"fade_distance"},
	{FADE_POWER_POB_TOKEN,"fade_power"},
	{FALLOFF_POB_TOKEN,"falloff"},
	{FALLOFF_ANGLE_POB_TOKEN,"falloff_angle"},
	{FILTER_POB_TOKEN,"filter"},
	{FINISH_POB_TOKEN,"finish"},
	{FISHEYE_POB_TOKEN,"fisheye"},
	{FLATNESS_POB_TOKEN,"flatness"},
	{FLIP_POB_TOKEN,"flip"},
	{FLOATCONSTANT_POB_TOKEN,"floatconstant"},
	{FLOATFUNCTION_POB_TOKEN,"floatfunction"},
	{FLOOR_POB_TOKEN,"floor"},
	{FOCAL_POINT_POB_TOKEN,"focal_point"},
	{FOG_POB_TOKEN,"fog"},
	{FOG_ALT_POB_TOKEN,"fog_alt"},
	{FOG_OFFSET_POB_TOKEN,"fog_offset"},
	{FOG_TYPE_POB_TOKEN,"fog_type"},
	{FREQUENCY_POB_TOKEN,"frequency"},
	{GIF_POB_TOKEN,"gif"},
	{GLOBAL_SETTINGS_POB_TOKEN,"global_settings"},
	{GLOWING_POB_TOKEN,"glowing"},
	{GRADIENT_POB_TOKEN,"gradient"},
	{GRANITE_POB_TOKEN,"granite"},
	{GRAY_THRESHOLD_POB_TOKEN,"gray_threshold"},
	{HALO_POB_TOKEN,"halo"},
	{HEIGHT_FIELD_POB_TOKEN,"height_field"},
	{HEXAGON_POB_TOKEN,"hexagon"},
	{HF_GRAY_16_POB_TOKEN,"hf_gray_16"},
	{HIERARCHY_POB_TOKEN,"hierarchy"},
	{HOLLOW_POB_TOKEN,"hollow"},
	{HYPERCOMPLEX_POB_TOKEN,"hypercomplex"},
	{IFF_POB_TOKEN,"iff"},
	{IMAGE_MAP_POB_TOKEN,"image_map"},
	{INCIDENCE_POB_TOKEN,"incidence"},
	{INTERPOLATE_POB_TOKEN,"interpolate"},
	{INTERSECTION_POB_TOKEN,"intersection"},
	{INVERSE_POB_TOKEN,"inverse"},
	{IOR_POB_TOKEN,"ior"},
	{IRID_POB_TOKEN,"irid"},
	{IRID_WAVELENGTH_POB_TOKEN,"irid_wavelength"},
	{JITTER_POB_TOKEN,"jitter"},
	{JULIA_FRACTAL_POB_TOKEN,"julia_fractal"},
	{LAMBDA_POB_TOKEN,"lambda"},
	{LATHE_POB_TOKEN,"lathe"},
	{LEOPARD_POB_TOKEN,"leopard"},
	{LIGHT_SOURCE_POB_TOKEN,"light_source"},
	{LINEAR_POB_TOKEN,"linear"},
	{LINEAR_SPLINE_POB_TOKEN,"linear_spline"},
	{LINEAR_SWEEP_POB_TOKEN,"linear_sweep"},
	{LOCATION_POB_TOKEN,"location"},
	{LOG_POB_TOKEN,"log"},
	{LOOK_AT_POB_TOKEN,"look_at"},
	{LOOKS_LIKE_POB_TOKEN,"looks_like"},
	{LOW_ERROR_FACTOR_POB_TOKEN,"low_error_factor"},
	{MANDEL_POB_TOKEN,"mandel"},
	{MAP_TYPE_POB_TOKEN,"map_type"},
	{MARBLE_POB_TOKEN,"marble"},
	{MATERIAL_MAP_POB_TOKEN,"material_map"},
	{MATRIX_POB_TOKEN,"matrix"},
	{MAX_INTERSECTIONS_POB_TOKEN,"max_intersections"},
	{MAX_ITERATION_POB_TOKEN,"max_iteration"},
	{MAX_TRACE_LEVEL_POB_TOKEN,"max_trace_level"},
	{MAX_VALUE_POB_TOKEN,"max_value"},
	{MERGE_POB_TOKEN,"merge"},
	{MESH_POB_TOKEN,"mesh"},
	{METALLIC_POB_TOKEN,"metallic"},
	{MIN_POB_TOKEN,"min"},
	{MINIMUM_REUSE_POB_TOKEN,"minimum_reuse"},
	{MOD_POB_TOKEN,"mod"},
	{MORTAR_POB_TOKEN,"mortar"},
	{NEAREST_COUNT_POB_TOKEN,"nearest_count"},
	{NO_SHADOW_POB_TOKEN,"no_shadow"},
	{NORMAL_POB_TOKEN,"normal"},
	{NORMAL_MAP_POB_TOKEN,"normal_map"},
	{NUMBER_OF_WAVES_POB_TOKEN,"number_of_waves"},
	{OBJECT_POB_TOKEN,"object"},
	{OCTAVES_POB_TOKEN,"octaves"},
	{OFFSET_POB_TOKEN,"offset"},
	{OMEGA_POB_TOKEN,"omega"},
	{OMNIMAX_POB_TOKEN,"omnimax"},
	{ONCE_POB_TOKEN,"once"},
	{ONION_POB_TOKEN,"onion"},
	{OPEN_POB_TOKEN,"open"},
	{ORTHOGRAPHIC_POB_TOKEN,"orthographic"},
	{PANORAMIC_POB_TOKEN,"panoramic"},
	{PATTERN1_POB_TOKEN,"pattern1"},
	{PATTERN2_POB_TOKEN,"pattern2"},
	{PATTERN3_POB_TOKEN,"pattern3"},
	{PERSPECTIVE_POB_TOKEN,"perspective"},
	{PGM_POB_TOKEN,"pgm"},
	{PHASE_POB_TOKEN,"phase"},
	{PHONG_POB_TOKEN,"phong"},
	{PHONG_SIZE_POB_TOKEN,"phong_size"},
	{PI_POB_TOKEN,"pi"},
	{PIGMENT_POB_TOKEN,"pigment"},
	{PIGMENT_MAP_POB_TOKEN,"pigment_map"},
	{PLANAR_MAPPING_POB_TOKEN,"planar_mapping"},
	{PLANE_POB_TOKEN,"plane"},
	{PNG_POB_TOKEN,"png"},
	{POINT_AT_POB_TOKEN,"point_at"},
	{POLY_POB_TOKEN,"poly"},
	{POLYGON_POB_TOKEN,"polygon"},
	{POT_POB_TOKEN,"pot"},
	{POW_POB_TOKEN,"pow"},
	{PPM_POB_TOKEN,"ppm"},
	{PRECISION_POB_TOKEN,"precision"},
	{PRISM_POB_TOKEN,"prism"},
	{PWR_POB_TOKEN,"pwr"},
	{QUADRATIC_SPLINE_POB_TOKEN,"quadratic_spline"},
	{QUADRIC_POB_TOKEN,"quadric"},
	{QUARTIC_POB_TOKEN,"quartic"},
	{QUATERNION_POB_TOKEN,"quaternion"},
	{QUICK_COLOR_POB_TOKEN,"quick_color"},
	{QUILTED_POB_TOKEN,"quilted"},
	{RADIAL_POB_TOKEN,"radial"},
	{RADIANS_POB_TOKEN,"radians"},
	{RADIOSITY_POB_TOKEN,"radiosity"},
	{RADIUS_POB_TOKEN,"radius"},
	{RAINBOW_POB_TOKEN,"rainbow"},
	{RAMP_WAVE_POB_TOKEN,"ramp_wave"},
	{RAND_POB_TOKEN,"rand"},
	{RANGE_POB_TOKEN,"range"},
	{RECIPROCAL_POB_TOKEN,"reciprocal"},
	{RECURSION_LIMIT_POB_TOKEN,"recursion_limit"},
	{REFLECTION_POB_TOKEN,"reflection"},
	{REFRACTION_POB_TOKEN,"refraction"},
	{REPEAT_POB_TOKEN,"repeat"},
	{RGB_POB_TOKEN,"rgb"},
	{RGBF_POB_TOKEN,"rgbf"},
	{RGBFT_POB_TOKEN,"rgbft"},
	{RGBT_POB_TOKEN,"rgbt"},
	{RIGHT_POB_TOKEN,"right"},
	{RIPPLES_POB_TOKEN,"ripples"},
	{ROTATE_POB_TOKEN,"rotate"},
	{ROUGHNESS_POB_TOKEN,"roughness"},
	{SAMPLES_POB_TOKEN,"samples"},
	{SCALE_POB_TOKEN,"scale"},
	{SCALLOP_WAVE_POB_TOKEN,"scallop_wave"},
	{SCATTERING_POB_TOKEN,"scattering"},
	{SHADOWLESS_POB_TOKEN,"shadowless"},
	{SIN_POB_TOKEN,"sin"},
	{SINE_WAVE_POB_TOKEN,"sine_wave"},
	{SINH_POB_TOKEN,"sinh"},
	{SKY_POB_TOKEN,"sky"},
	{SKY_SPHERE_POB_TOKEN,"sky_sphere"},
	{SLICE_POB_TOKEN,"slice"},
	{SLOPE_MAP_POB_TOKEN,"slope_map"},
	{SMOOTH_POB_TOKEN,"smooth"},
	{SMOOTH_TRIANGLE_POB_TOKEN,"smooth_triangle"},
	{SOR_POB_TOKEN,"sor"},
	{SPECULAR_POB_TOKEN,"specular"},
	{SPHERE_POB_TOKEN,"sphere"},
	{SPHERICAL_MAPPING_POB_TOKEN,"spherical_mapping"},
	{SPIRAL_POB_TOKEN,"spiral"},
	{SPIRAL1_POB_TOKEN,"spiral1"},
	{SPIRAL2_POB_TOKEN,"spiral2"},
	{SPOTLIGHT_POB_TOKEN,"spotlight"},
	{SPOTTED_POB_TOKEN,"spotted"},
	{SQR_POB_TOKEN,"sqr"},
	{SQRT_POB_TOKEN,"sqrt"},
	{STRENGTH_POB_TOKEN,"strength"},
	{STURM_POB_TOKEN,"sturm"},
	{SUPERELLIPSOID_POB_TOKEN,"superellipsoid"},
	{SYS_POB_TOKEN,"sys"},
	{TAN_POB_TOKEN,"tan"},
	{TANH_POB_TOKEN,"tanh"},
	{TEST_CAMERA_1_POB_TOKEN,"test_camera_1"},
	{TEST_CAMERA_2_POB_TOKEN,"test_camera_2"},
	{TEST_CAMERA_3_POB_TOKEN,"test_camera_3"},
	{TEST_CAMERA_4_POB_TOKEN,"test_camera_4"},
	{TEXT_POB_TOKEN,"text"},
	{TEXTURE_POB_TOKEN,"texture"},
	{TEXTURE_MAP_POB_TOKEN,"texture_map"},
	{TGA_POB_TOKEN,"tga"},
	{THICKNESS_POB_TOKEN,"thickness"},
	{THRESHOLD_POB_TOKEN,"threshold"},
	{TIGHTNESS_POB_TOKEN,"tightness"},
	{TILE2_POB_TOKEN,"tile2"},
	{TILES_POB_TOKEN,"tiles"},
	{TORUS_POB_TOKEN,"torus"},
	{TRACK_POB_TOKEN,"track"},
	{TRANSFORM_POB_TOKEN,"transform"},
	{TRANSLATE_POB_TOKEN,"translate"},
	{TRANSMIT_POB_TOKEN,"transmit"},
	{TRIANGLE_POB_TOKEN,"triangle"},
	{TRIANGLE_WAVE_POB_TOKEN,"triangle_wave"},
	{TTF_POB_TOKEN,"ttf"},
	{TURB_DEPTH_POB_TOKEN,"turb_depth"},
	{TURBULENCE_POB_TOKEN,"turbulence"},
	{TYPE_POB_TOKEN,"type"},
	{U_STEPS_POB_TOKEN,"u_steps"},
	{ULTRA_WIDE_ANGLE_POB_TOKEN,"ultra_wide_angle"},
	{UNION_POB_TOKEN,"union"},
	{UP_POB_TOKEN,"up"},
	{USE_COLOR_POB_TOKEN,"use_color"},
	{USE_INDEX_POB_TOKEN,"use_index"},
	{V_STEPS_POB_TOKEN,"v_steps"},
	{VAL_POB_TOKEN,"val"},
	{VARIANCE_POB_TOKEN,"variance"},
	{VAXIS_ROTATE_POB_TOKEN,"vaxis_rotate"},
	{VERSION_POB_TOKEN,"version"},
	{VOL_WITH_LIGHT_POB_TOKEN,"vol_with_light"},
	{VOLUME_OBJECT_POB_TOKEN,"volume_object"},
	{VOLUME_RENDERED_POB_TOKEN,"volume_rendered"},
	{WARP_POB_TOKEN,"warp"},
	{WATER_LEVEL_POB_TOKEN,"water_level"},
	{WAVES_POB_TOKEN,"waves"},
	{WIDTH_POB_TOKEN,"width"},
	{WOOD_POB_TOKEN,"wood"},
	{WRINKLES_POB_TOKEN,"wrinkles"},
	{WRINKLE_POB_TOKEN,"wrinkle"}
};
char *get_token_str(unsigned int token_number)
{
    static char *unknown = "unknown_token";

    unsigned int i;
    for(i = 0; i < LAST_POB_TOKEN;i++)
	if(pob_token_list[i]. pob_token_id == token_number)
		return pob_token_list[i].pob_token_str;

    return unknown;
}
