/*
	POB-File-Format by Thomas Baier April/97


	Description:
	POB-System-Token-List

	History:
	01.04.97	Version 0.8	First Version, all things implemented,
					rarly tested

	Comments:

	To Do List:

*/

// Generated Token List

#include "pob_tok1.h"

typedef struct
{
	unsigned int pob_stoken_id;
	char *pob_stoken_str;
}POB_STOKEN;

#define MAX_SYSTEM_POB_TOKEN	(50)

POB_STOKEN pob_stoken_list[MAX_SYSTEM_POB_TOKEN] = 
{
/*00*/ 	{POB_FILESECTION_TAG,"POB_FILESECTION_TAG"},
/*01*/	{POB_POVRAYSECTION_TAG,"POB_POVRAYSECTION_TAG"},
/*02*/	{POB_GLOBALSECTION_TAG,"POB_GLOBALSECTION_TAG"},
/*03*/	{POB_ENVIRONMENTSECTION_TAG,"POB_ENVIRONMENTSECTION_TAG"},	
/*04*/	{POB_CAMERASECTION_TAG,"POB_CAMERASECTION_TAG"},
/*05*/	{POB_MATERIALSECTION_TAG,"POB_MATERIALSECTION_TAG"},
/*06*/	{POB_OBJECTSECTION_TAG,"POB_OBJECTSECTION_TAG"}, 		
/*07*/	{TEXTUREREF_POB_TOKEN,"TEXTUREREF_POB_TOKEN"},		
/*08*/	{PIGMENTREF_POB_TOKEN,"PIGMENTREF_POB_TOKEN"},		
/*09*/	{NORMALREF_POB_TOKEN,"NORMALREF_POB_TOKEN"},		
/*10*/	{FINISHREF_POB_TOKEN,"FINISHREF_POB_TOKEN"},		
/*11*/	{HALOREF_POB_TOKEN,"HALOREF_POB_TOKEN"},		
/*12*/	{SIMPLETEXTURE_POB_TOKEN,"SIMPLETEXTURE_POB_TOKEN"},		
/*13*/	{LAYEREDTEXTURE_POB_TOKEN,"LAYEREDTEXTURE_POB_TOKEN"},	
/*14*/	{MATERIAL_MAPTEXTURE_POB_TOKEN,"MATERIAL_MAPTEXTURE_POB_TOKEN"},	
/*15*/	{CHECKERTEXTURE_POB_TOKEN,"CHECKERTEXTURE_POB_TOKEN"},	
/*16*/	{BRICKTEXTURE_POB_TOKEN,"BRICKTEXTURE_POB_TOKEN"},		
/*17*/	{HEXAGONTEXTURE_POB_TOKEN,"HEXAGONTEXTURE_POB_TOKEN"},	
/*18*/	{PATTERNTEXTURE_POB_TOKEN,"PATTERNTEXTURE_POB_TOKEN"},	
/*19*/	{SIMPLEPIGMENT_POB_TOKEN,"SIMPLEPIGMENT_POB_TOKEN"},		
/*20*/	{CHECKERPIGMENT_POB_TOKEN,"CHECKERPIGMENT_POB_TOKEN"},	
/*21*/	{BRICKPIGMENT_POB_TOKEN,"BRICKPIGMENT_POB_TOKEN"},		
/*22*/	{HEXAGONPIGMENT_POB_TOKEN,"HEXAGONPIGMENT_POB_TOKEN"},	
/*23*/	{BITMAPPIGMENT_POB_TOKEN,"BITMAPPIGMENT_POB_TOKEN"},		
/*24*/	{PATTERNPIGMENT_POB_TOKEN,"PATTERNPIGMENT_POB_TOKEN"},	
/*25*/	{SIMPLENORMAL_POB_TOKEN,"SIMPLENORMAL_POB_TOKEN"},		
/*26*/	{CHECKERNORMAL_POB_TOKEN,"CHECKERNORMAL_POB_TOKEN"},		
/*27*/	{BRICKNORMAL_POB_TOKEN,"BRICKNORMAL_POB_TOKEN"},		
/*28*/	{HEXAGONNORMAL_POB_TOKEN,"HEXAGONNORMAL_POB_TOKEN"},		
/*29*/	{BITMAPNORMAL_POB_TOKEN,"BITMAPNORMAL_POB_TOKEN"},		
/*30*/	{PATTERNNORMAL_POB_TOKEN,"PATTERNNORMAL_POB_TOKEN"},		
/*31*/	{SIMPLEFINISH_POB_TOKEN,"SIMPLEFINISH_POB_TOKEN"},		
/*32*/	{SIMPLEHALO_POB_TOKEN,"SIMPLEHALO_POB_TOKEN"},		
/*33*/	{PATTERN_MOD_POB_TOKEN,"PATTERN_MOD_POB_TOKEN"},		
/*34*/	{WAVE_TYPE_POB_TOKEN,"WAVE_TYPE_POB_TOKEN"},		
/*35*/	{CLASSIC_TURB_WARP_POB_TOKEN,"CLASSIC_TURB_WARP_POB_TOKEN"},	
/*36*/	{REPEAT_WARP_POB_TOKEN,"REPEAT_WARP_POB_TOKEN"},		
/*37*/	{BLACK_HOLE_WARP_POB_TOKEN,"BLACK_HOLE_WARP_POB_TOKEN"},	
/*38*/	{HALO_NO_HALO_POB_TOKEN,"HALO_NO_HALO_POB_TOKEN"},		
/*39*/	{MAPVALUE_POB_TOKEN,"MAPVALUE_POB_TOKEN"},		
/*40*/	{FLAGS_POB_TOKEN,"FLAGS_POB_TOKEN"},			
/*41*/	{BLOBCOMPONENT_POB_TOKEN,"BLOBCOMPONENT_POB_TOKEN"},		
/*42*/	{BLOBMOD_POB_TOKEN,"BLOBMOD_POB_TOKEN"},		
/*43*/  {BLOBSPHERE_POB_TOKEN, "BLOBSPHERE_POB_TOKEN"},
/*44*/  {BLOBCYLINDER_POB_TOKEN, "BLOBCYLINDER_POB_TOKEN"},
/*45*/	{GROUP_POB_TOKEN,"GROUP_POB_TOKEN"},			
/*46*/	{GROUPMOD_POB_TOKEN,"GROUPMOD_POB_TOKEN"},		
/*47*/	{MESHDATA_POB_TOKEN,"MESHDATA_POB_TOKEN"},		
/*48*/	{MESHMOD_POB_TOKEN,"MESHMOD_POB_TOKEN"},		
/*49*/	{POB_MODELLERSECTION_TAG,"POB_MODELLERSECTION_TAG"}
};

char *get_stoken_str(unsigned int stoken_number)
{
    static char *unknown = "unknown_system_token";

    unsigned int i;
    for(i = 0; i < MAX_SYSTEM_POB_TOKEN;i++)
	if(pob_stoken_list[i]. pob_stoken_id == stoken_number)
		return pob_stoken_list[i].pob_stoken_str;

    return unknown;
}
