/* @(#)glib.h 1.5   8/27/96 */

/******************************************************************************
* Threedom: a 3D polygon renderer                                             *
* (C) Copyright 1996 by Philip Stephens                                       *
* (C) Copyright 1996 by the IBM Corporation                                   *
* All Rights Reserved                                                         *
*                                                                             *
* Permission to use, copy, modify, and distribute this software and its       *
* documentation without fee for any non-commerical purpose is hereby granted, *
* provided that the above copyright notice appears on all copies and that     *
* both that copyright notice and this permission notice appear in all         *
* supporting documentation.                                                   *
*                                                                             *
* NO REPRESENTATIONS ARE MADE ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY  *
* PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.       *
* NEITHER PHILIP STEPHENS OR IBM SHALL BE LIABLE FOR ANY DAMAGES SUFFERED BY  *
* THE USE OF THIS SOFTWARE.                                                   *
******************************************************************************/

/*
 * Startup and shutdown functions.
 */
#ifndef	WIN32
extern void graphics_startup(char *program_name,
			     int *display_width, int *display_height,
			     void (*event_proc)(event_record *event),
			     void (*work_proc)(void), void (*quit_proc)(void));
#else
#define STRICT
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
extern void graphics_startup(char *program_name,
			     void (*event_proc)(event_record *event),
			     void (*work_proc)(void), void (*quit_proc)(void),
			     HINSTANCE instance_handle);
#endif
extern void graphics_shutdown(void);

/*
 * Display window and frame buffer functions.
 */
#ifndef	WIN32
extern void create_window(int min_width, int min_height,
			  int max_width, int max_height,
			  char *window_title);
#else
extern void create_window(int window_width, int window_height,
			  char *window_title, int window_state);
#endif
extern fbpixel *create_frame_buffer(int window_width, int window_height);
extern void display_frame_buffer(void);
extern void destroy_frame_buffer(void);

/*
 * Event loop function.
 */
extern void enter_event_loop(void);

/*
 * Colour conversion function.
 */
extern pixel get_pixel(byte r, byte g, byte b);

/*
 * Message display functions.
 */
extern void system_message(char *format, ...);
