/* @(#)main.h 1.5   8/27/96 */

/******************************************************************************
* Threedom: a 3D polygon renderer                                             *
* (C) Copyright 1996 by Philip Stephens                                       *
* (C) Copyright 1996 by the IBM Corporation                                   *
* All Rights Reserved                                                         *
*                                                                             *
* Permission to use, copy, modify, and distribute this software and its       *
* documentation without fee for any non-commerical purpose is hereby granted, *
* provided that the above copyright notice appears on all copies and that     *
* both that copyright notice and this permission notice appear in all         *
* supporting documentation.                                                   *
*                                                                             *
* NO REPRESENTATIONS ARE MADE ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY  *
* PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.       *
* NEITHER PHILIP STEPHENS OR IBM SHALL BE LIABLE FOR ANY DAMAGES SUFFERED BY  *
* THE USE OF THIS SOFTWARE.                                                   *
******************************************************************************/

#include <setjmp.h>

/*
 * Externally visible data structures.
 */
extern char		*program_name;
extern char		**file_path_list;
extern int		paths;
extern fbpixel		*frame_buffer;
extern fbpixel		**fb_row;
extern fixed		*z_buffer;
extern fixed		**zb_row;
extern fixed		z_factor;
extern fixed		*sine;
extern fixed		*cosine;
extern int		window_width;
extern int		window_height;
extern int		pixel_span;
extern int		span_shift;
extern fixed 		view_x;
extern fixed		view_y;
extern fixed		view_z;
extern int 		view_angle_x;
extern int 		view_angle_y;
extern int		angles;
extern fixed		min_px;
extern fixed		max_px;
extern fixed		delta_px;
extern fixed		min_py;
extern fixed		max_py;
extern fixed		delta_py;
extern fixed		half_window_width;
extern fixed		half_window_height;
extern jmp_buf		context;

extern vertex		**vertex_ptr_list;
extern texture		**texture_ptr_list;
extern polygon		**polygon_ptr_list;
extern spoint 		*spoint_list;
extern int		vertices, textures, polygons, spoints;

/*
 * Externally visible functions.
 */
extern void reset_renderer(void);
extern time_ms get_time_ms(void);
