/* @(#)test.c 1.1   8/27/96 */

/******************************************************************************
* WinLib: a simple Windows 95 GUI library                                     *
* (C) Copyright 1996 by Philip Stephens                                       *
* (C) Copyright 1996 by the IBM Corporation                                   *
* All Rights Reserved                                                         *
*                                                                             *
* Permission to use, copy, modify, and distribute this software and its       *
* documentation without fee for any non-commerical purpose is hereby granted, *
* provided that the above copyright notice appears on all copies and that     *
* both that copyright notice and this permission notice appear in all         *
* supporting documentation.                                                   *
*                                                                             *
* NO REPRESENTATIONS ARE MADE ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY  *
* PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.       *
* NEITHER PHILIP STEPHENS OR IBM SHALL BE LIABLE FOR ANY DAMAGES SUFFERED BY  *
* THE USE OF THIS SOFTWARE.                                                   *
******************************************************************************/


#define STRICT
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>
#include <commdlg.h>
#include <stdio.h>
#include <string.h>
#include "winlib.h"
#include "test.h"

/*
 * I don't care to hear about parameters or local variables that
 * aren't used in a function.
 */
#pragma warn -aus
#pragma warn -par

static HWND main_window;
static HWND bitmap_window;
static HWND status_window;
static fast_bitmap *bitmap_ptr;
static RGBQUAD palette[256];

/*************************************
 * Function to create bitmap window. *
 *************************************/

void
create_bitmap_window(HWND window_handle)
{
	int index, row, col;

	/*
	 * Fill in the palette with shades of red.  We don't bother filling in
	 * the first and last 10 entries because they won't be used.
	 */
	for (index = 30; index < 246; index++) {
		palette[index].rgbRed = (BYTE)index;
		palette[index].rgbGreen = 0;
		palette[index].rgbBlue = 0;
	}

	/*
	 * Create the bitmap.
	 */
	bitmap_ptr = CreateFastBitmap(window_handle, 256, 256,
				      (RGBQUAD *)&palette, 216, 30);

	/*
	 * Fill in the bitmap with a 16x16 pattern that displays all 256
	 * colours in the palette.
	 */
	for (row = 0; row < 256; row++)
		for (col = 0; col < 256; col++)
			bitmap_ptr->bits[row * 256 + col] = (BYTE)(((row / 16)
							    << 4) + (col / 16));
}

/**************************************
 * Function to destroy bitmap window. *
 **************************************/

void
destroy_bitmap_window(HWND window_handle)
{
	DestroyFastBitmap(bitmap_ptr);
}

/************************************
 * Function to paint bitmap window. *
 ************************************/

/*
 * IMPORTANT NOTE: It is absolutely essential that you use BeginPaint() and
 * EndPaint() in a paint procedure, otherwise Windows won't call the paint
 * procedures for the remaining windows affected by a WM_PAINT request!
 * Don't ask me *why* this is the case!!  It had me confused for a hell of
 * a long time, wondering why my standard controls weren't been repainted
 * after maximising the main window.  It was all because I'd left out the
 * BeginPaint() and EndPaint() calls in this paint procedure!!
 */
void
paint_bitmap_window(HWND window_handle)
{
	HDC dc;
	PAINTSTRUCT paint_struct;

	dc = BeginPaint(window_handle, &paint_struct);

	DisplayFastBitmap(bitmap_ptr);

	EndPaint(window_handle, &paint_struct);
}

/**********************************************
 * Process a char event in the bitmap window. *
 **********************************************/

void
process_char_event(HWND window_handle, UINT ch, int repeat)
{
	DisplayMessage(status_window, "Key '%c' was entered\r\n", ch);
}

/************************
 * Process a key event. *
 ************************/

void
process_key_event(HWND window_handle, UINT keycode, BOOL keydown, int repeat,
		  UINT flags)
{
	if (keydown)
		DisplayMessage(status_window,
			       "Key with code %d was pressed\r\n", keycode);
	else
		DisplayMessage(status_window,
			       "Key with code %d was released\r\n", keycode);
}

/*************************
 * Process button event. *
 *************************/

void
process_button_event(HWND window_handle, UINT message, int x, int y,
		     UINT flags)
{
	switch(message) {
	case WM_LBUTTONDOWN:
		DisplayMessage(status_window, "Left button was pressed\r\n");
		break;
	case WM_LBUTTONUP:
		DisplayMessage(status_window, "Left button was released\r\n");
		break;
	case WM_LBUTTONDBLCLK:
		DisplayMessage(status_window,
			       "Left button was double clicked\r\n");
		break;
	case WM_RBUTTONDOWN:
		DisplayMessage(status_window, "Right button was pressed\r\n");
		break;
	case WM_RBUTTONUP:
		DisplayMessage(status_window, "Right button was released\r\n");
		break;
	case WM_RBUTTONDBLCLK:
		DisplayMessage(status_window,
			       "Right button was double clicked\r\n");
		break;
	}
}

/***************************************************************
 * Function to throw away a button event in the status window. *
 ***************************************************************/
void
throwaway_button_event(HWND window_handle, UINT message, int x, int y,
		       UINT flags)
{
}

/***************************************
 * Function to create the main window. *
 ***************************************/

/*
 * Callback list for bitmap window.
 */
static event_callbacks bitmap_callback_list = {
	create_bitmap_window,
	destroy_bitmap_window,
	paint_bitmap_window,
	NULL,
	NULL,
	process_button_event,
	NULL,
	NULL,
	NULL
};

/*
 * Callback list for status window.
 */
static event_callbacks status_callback_list = {
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	process_button_event,
	NULL,
	NULL,
	NULL
};

void
create_main_window(HWND window_handle)
{
	bitmap_window = CreateChildWindow(window_handle, 10, 10, 256, 256,
					  WS_BORDER, &bitmap_callback_list);
	status_window = CreateEditControl(window_handle, 280, 60, 300, 206,
					  WS_BORDER | ES_READONLY |
					  ES_WANTRETURN, &status_callback_list);
}

/****************************************
 * Function to destroy the main window. *
 ****************************************/

void
destroy_main_window(HWND window_handle)
{
	PostQuitMessage(0);
}

/**********************************
 * Function to paint main window. *
 **********************************/

void
paint_main_window(HWND window_handle)
{
	HDC dc;
	PAINTSTRUCT paint_struct;
	char *title = "A sample Windows 95 application";
	char *author = "(C) Copyright 1996 by Philip Stephens";

	dc = BeginPaint(window_handle, &paint_struct);

	SetBkMode(dc, TRANSPARENT);
	SetTextColor(dc, RGB(255, 0, 0));
	TextOut(dc, 280, 10, title, strlen(title));
	TextOut(dc, 280, 30, author, strlen(author));

	EndPaint(window_handle, &paint_struct);
}

/***********************************************
 * Function to handle gaining of window focus. *
 ***********************************************/

BOOL
handle_window_focus(HWND window_handle)
{
	SetFocus(window_handle);
	return(InstallFastBitmapPalette(bitmap_ptr));
}

/*************************************************
 * Function to process a command from a control. *
 *************************************************/

void
process_command_event(HWND window_handle, int menu_id, HWND control_handle,
		      UINT code_notify)
{
	char *file_name;

	switch(menu_id) {
	case CM_OPEN:
		if ((file_name = OpenFileDialog("Open Threedom world",
				 "Threedom world (*.w3d)\0*.w3d\0")) != NULL)
			MessageBox(NULL, file_name, "Info", MB_OK);
		break;
	case CM_EXIT:
		PostQuitMessage(0);
		break;
	}
}

/*****************************
 * Main program entry point. *
 *****************************/

/*
 * List of event function handlers for main window.
 */
static event_callbacks callback_list = {
	create_main_window,
	destroy_main_window,
	paint_main_window,
	process_char_event,
	process_key_event,
	process_button_event,
	NULL,
	handle_window_focus,
	process_command_event
};

void
test_proc(void)
{
}

int WINAPI
WinMain(HINSTANCE instance, HINSTANCE previnst, LPSTR comand_line,
		  int window_state)
{
	WinLibInit(instance);
	main_window = CreateMainWindow("Test Application", 600, 320,
				       window_state, "menu", &callback_list);
	if (main_window)
		EnterEventLoop(test_proc);
	WinLibCleanUp();
	return(TRUE);
}
