/* @(#)winlib.h 1.1   8/27/96 */

/******************************************************************************
* WinLib: a simple Windows 95 GUI library                                     *
* (C) Copyright 1996 by Philip Stephens                                       *
* (C) Copyright 1996 by the IBM Corporation                                   *
* All Rights Reserved                                                         *
*                                                                             *
* Permission to use, copy, modify, and distribute this software and its       *
* documentation without fee for any non-commerical purpose is hereby granted, *
* provided that the above copyright notice appears on all copies and that     *
* both that copyright notice and this permission notice appear in all         *
* supporting documentation.                                                   *
*                                                                             *
* NO REPRESENTATIONS ARE MADE ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY  *
* PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.       *
* NEITHER PHILIP STEPHENS OR IBM SHALL BE LIABLE FOR ANY DAMAGES SUFFERED BY  *
* THE USE OF THIS SOFTWARE.                                                   *
******************************************************************************/

/*
 * Definition of structure used by HandleEvent() function.
 */
typedef struct {
	void (*create_fn)(HWND window_handle);
	void (*destroy_fn)(HWND window_handle);
	void (*paint_fn)(HWND window_handle);
	void (*char_fn)(HWND window_handle, UINT ch, int repeat);
	void (*key_fn)(HWND window_handle, UINT keycode, BOOL keydown,
		       int repeat, UINT flags);
	void (*button_fn)(HWND window_handle, UINT message, int x, int y,
			  UINT flags);
	void (*mouse_fn)(HWND window_handle, int x, int y, UINT flags);
	BOOL (*focus_fn)(HWND window_handle);
	void (*command_fn)(HWND window_handle, int menu_id, HWND control_handle,
			   UINT code_notify);
} event_callbacks;

/*
 * Definition of a fast bitmap structure.
 */
typedef struct {
	HWND window_handle;
	BITMAPINFO *bitmap_info;
	LOGPALETTE *palette_info;
	HBITMAP bitmap_handle;
	HPALETTE palette_handle;
	BYTE *bits;
} fast_bitmap;

/*
 * Externally available functions.
 */
extern void
WinLibInit(HINSTANCE instance);

extern void
WinLibCleanUp(void);

extern HWND
CreateMainWindow(LPCSTR window_title, UINT window_width, UINT window_height,
		 UINT window_state, LPCSTR menu_name,
		 event_callbacks *callback_list);

extern HWND
CreateChildWindow(HWND parent_window_handle, UINT x, UINT y,
		  UINT window_width, UINT window_height, UINT window_style,
		  event_callbacks *callback_list);

extern HWND
CreateStaticControl(HWND parent_window_handle, UINT x, UINT y,
		    UINT window_width, UINT window_height, UINT window_style,
		    event_callbacks *callback_list);

extern HWND
CreateEditControl(HWND parent_window_handle, UINT x, UINT y,
		  UINT window_width, UINT window_height, UINT window_style,
		  event_callbacks *callback_list);

extern fast_bitmap *
CreateFastBitmap(HWND window_handle, UINT width, UINT height, RGBQUAD *palette,
		 UINT colours, UINT offset);

extern void
DestroyFastBitmap(fast_bitmap *bitmap_ptr);

extern void
DisplayFastBitmap(fast_bitmap *bitmap_ptr);

extern BOOL
InstallFastBitmapPalette(fast_bitmap *bitmap_ptr);

extern void
DisplayMessage(HWND edit_handle, char *format, ...);

extern void
EnterEventLoop(void (*work_proc_ptr)(void));

extern char *
OpenFileDialog(char *title, char *filter);
