/*
   2D bump mapping
   (c) 1996 maLi/DarkSiDe
   thnx to Malc!
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include "../includes/gfx.h"

#define PAGE_SIZE     64000
#define ENVMAP_SIZE   65536
#define PALETTE_SIZE  768
#define PI            3.141592

char *Virtual_Page;
char *ENVMap;
char *Picture;
int   end_time,start_time,frames = 0;

void Move_BUMP(long newX,long newY)
{
  unsigned char b;
  short x,y;
  int dx,dy,cx,cy,i;
  dx = 0;
  dy = 0;

  for (i = 321;i < 64000;i++) {

    if (dx > 319) {
      dy++;
      dx = 0;
    }

    x = Picture[i+1] - Picture[i-1];
    y = Picture[i] - Picture[i-320];

    b = ENVMap[(x+100)+(y+100)*256];

    cx = newX + dx;
    cy = newY + dy;


    b = (b*ENVMap[cx+cy*256]) >> 6;

    if (cx > 0 && cx < 256 && cy > 0 && cy < 256)
    Virtual_Page[i] = b;

    dx++;
  }
}

void ENVMAP_Preview()
{
  long x,y,xi,yi,i,j;
  yi = 83886;
  xi = 52428;
  y = 0;
  for (j = 0;j < 200;j++) {
    x = 0;
    for (i = 0;i < 320;i++) {
      Virtual_Page[j*320+i] = ENVMap[(x / 65536) + (y / 65536)*256];
      x += xi;
    }
    y += yi;
  }
  Flip_Virtual_Page();
  getch();
}

main()
{
  short x,y,angle;
  FILE *f;
  char *pic_pal,*env_pal,c;
  //allocate all memory for virtual page, picture, environment map and palettes
  Virtual_Page = (char *)malloc(PAGE_SIZE);
  Picture = (char *)malloc(PAGE_SIZE);
  ENVMap = (char *)malloc(ENVMAP_SIZE);
  pic_pal = (char *)malloc(PALETTE_SIZE);
  env_pal = (char *)malloc(PALETTE_SIZE);
  //read picture and its palette from raw file
  f = fopen("picture.raw","rb");
  fread(pic_pal,1,PALETTE_SIZE,f);
  memset(Picture,0,PAGE_SIZE);
  fread(Picture,1,PAGE_SIZE,f);
  fclose(f);
  //read environment map and its palette from raw file
  f = fopen("envmap.raw","rb");
  fread(env_pal,1,PALETTE_SIZE,f);
  memset(ENVMap,0,ENVMAP_SIZE);
  fread(ENVMap,1,ENVMAP_SIZE,f);
  fclose(f);
  //init graphics mode (320x200x256)
  Init_Virtual_Page(Virtual_Page);
  Init_Gfx_Mode();
  Set_Virtual_Page(1);
  //show picture (just for test)
  Set_Palette(pic_pal);
  //memcpy(PHYSICAL_PAGE,Picture,PAGE_SIZE);
  //getch();
  //ENVMAP preview
  //ENVMAP_Preview();
  //wait for keypressed
  angle = 360;
  start_time = clock();
  while (!kbhit()) {
    angle += 5;
    if (angle > 360) angle = 0;
    x = cos(angle*PI/180) * 250;
    y = sin(angle*PI/180) * 80 + 100;
    Clear_Virtual_Page(0);
    Move_BUMP(x-40,y+20);
    Wait_VRetrace();
    VLine(0,199,0,0);
    Flip_Virtual_Page();
    frames++;
  }
  end_time = clock();
  //init text mode
  Init_Text_Mode();
  printf("2d bump mapping by maLi/DarkSiDe - 1996\n");
  printf("E-mail: mtrtnik@info.src.si\n");
  //printf("\n%4.2f frames per second\n",(float)(frames*CLOCKS_PER_SEC)/(end_time - start_time));
  return(1);
}

