#include <stdio.h>
#include <math.h>
#include <time.h>
#include "../includes/gfx.h"

#define RADIUS 32
#define DEPTH  256
#define PI     3.141592

char *texture,*angle,*depth,*vPage;
int end_time,start_time,frames = 0;

int Allocate()
{
  //allocate some memory for texture map, virtual page and some other stuff
  if ((texture = (char *)malloc(65536)) == NULL) return(-1);
  if ((angle = (char *)malloc(PAGE_SIZE)) == NULL) return(-1);
  if ((depth = (char *)malloc(PAGE_SIZE)) == NULL) return(-1);
  if ((vPage = (char *)malloc(PAGE_SIZE)) == NULL) return(-1);
  return(1);
}

int Read_Files()
{
  FILE *f;
  //read texture map - file = "fog.dat"
  if ((f = fopen("fog.dat","rb")) == NULL) {
    printf("Texture map file fog.dat not found in current directory!\n");
    return(-1);
  }
  fread(texture,1,65536,f);
  fclose(f);
  //read angles - file = "angle.dat"
  if ((f = fopen("angle.dat","rb")) == NULL) {
    printf("Data file angle.dat not found in current directory!\n");
    return(-1);
  }
  fread(angle,1,PAGE_SIZE,f);
  fclose(f);
  //read depths - file = "depth.dat"
  if ((f = fopen("depth.dat","rb")) == NULL) {
    printf("Data file depth.dat not found in current directory!\n");
    return(-1);
  }
  fread(depth,1,PAGE_SIZE,f);
  fclose(f);
  return(1);
}

void main()
{
  long x,y,xt,yt,move,roll;
  long ofsY[200];

  if (Allocate() == -1) {
    printf("Failed while allocating memory!\n");
    exit(1);
  }
  if (Read_Files() == -1) exit(1);
  Init_Virtual_Page(vPage);
  Init_Gfx_Mode();
  Set_Virtual_Page(VIRTUAL_PAGE);

  for (x = 1;x < 256;x++) Set_Color(x,0,5,x >> 2);
  for (x = 0;x < 200;x++) ofsY[x] = x*320;
  start_time = clock();
  while (!kbhit()) {
    for (y = 0;y < 200;y++)
    for (x = 0;x < 320;x++) {
      yt = (angle[x+ofsY[y]] + roll) % 256;
      xt = (depth[x+ofsY[y]] + move) % 256;
      vPage[x+ofsY[y]] = texture[xt+(yt << 8)];
    }
    move += 15;
    roll += 15;
    Wait_VRetrace();
    Flip_Virtual_Page();
    frames++;
  }
  end_time = clock();
  Init_Text_Mode();
  printf("3d texture mapped tunnel by maLi/DarkSiDe - 1996\n");
  printf("E-mail: mtrtnik@info.src.si\n");
  //printf("\n%4.2f frames per second\n",(float)(frames*CLOCKS_PER_SEC)/(end_time - start_time));
}
