;=========================================;
;                                         ;
; 3D texture tunnel codec by maLi/FiNeSSe ;
; e-mail: igo.gruden@uni-lj.si            ;
; programming in TASM 3.2                 ;
; date: 18.3.1996                         ;
;                                         ;
;=========================================;
.model large
.386
.stack 100h
.data

fileangle db 'angle.dat',0
filedepth db 'depth.dat',0
filetext  db 'screen1.dat',0
fileboy   db 'sideboy.dat',0
nomemory  db 'not enough memory$'
errfile   db 'file error$'
fhandle   dw ?
angle     dw ?
depth     dw ?
screen    dw ?
boy       dw ?
texture   dw ?
t         dw ?
tt        dw ?
fade1     db ?
greets    db 'TUNNEL1',13,10
          db 'Code: maLi/FiNESSE - 1996$'
y_adder   dw ?
x_adder   dw ?
pal       db 768 dup (0)

include palette1.inc


.code
begin:
        mov ax,@data
        mov ds,ax

;================ A L L O C A T E    M E M O R Y ===============================
        mov ax,0013h
        int 10h

        mov ax,4a00h
        mov bx,1000h
        int 21h
        mov ax,4800h
        mov bx,1000h
        int 21h ;allocate memory for angles
        jc error_nomemory
        mov word ptr ds:[angle],ax ;save segment
        mov ax,4a00h
        mov bx,1000h
        int 21h
        mov ax,4800h
        mov bx,1000h
        int 21h ;allocate memory for depth
        jc error_nomemory
        mov word ptr ds:[depth],ax ;save segment
        mov ax,4a00h
        mov bx,1000h
        int 21h
        mov ax,4800h
        mov bx,1000h
        int 21h ;allocate memory for texture
        jc error_nomemory
        mov word ptr ds:[texture],ax ;save segment
        mov ax,4a00h
        mov bx,1000h
        int 21h
        mov ax,4800h
        mov bx,1000h
        int 21h ;allocate memory for screen
        jc error_nomemory
        mov word ptr ds:[screen],ax ;save segment

        mov ax,4a00h
        mov bx,1000h
        int 21h
        mov ax,4800h
        mov bx,1000h
        int 21h ;allocate memory for boy
        jc error_nomemory
        mov word ptr ds:[boy],ax ;save segment

;============= R E A D    A N G L E     F R O M    F I L E =====================

        mov ax,3d00h
        lea dx,word ptr ds:[fileangle]
        int 21h ;open file
        jc error_file
        mov word ptr ds:[fhandle],ax ;save file handle
        mov bx,word ptr ds:[fhandle]
        push ds
        mov ax,word ptr ds:[angle]
        mov ds,ax
        mov ax,3f00h
        mov cx,0ffffh
        xor dx,dx
        int 21h ;read angles from file to memory
        pop ds
        mov ax,3e00h
        mov bx,word ptr ds:[fhandle]
        int 21h ;close file

;======== R E A D    D E P T H    F R O M    F I L E ===========================

        mov ax,3d00h
        lea dx,word ptr ds:[filedepth]
        int 21h ;open file
        jc error_file
        mov word ptr ds:[fhandle],ax ;save file handle
        mov bx,word ptr ds:[fhandle]
        push ds
        mov ax,word ptr ds:[depth]
        mov ds,ax
        mov ax,3f00h
        xor dx,dx
        mov cx,0ffffh
        int 21h ;read depth from file to memory
        pop ds
        mov ax,3e00h
        mov bx,word ptr ds:[fhandle]
        int 21h ;close file

;======== R E A D    T E X T U R E   F R O M    F I L E ========================

        mov ax,3d00h
        lea dx,word ptr ds:[filetext]
        int 21h ;open file
        jc error_file
        mov word ptr ds:[fhandle],ax ;save file handle
        mov bx,word ptr ds:[fhandle]
        push ds
        mov ax,word ptr ds:[texture]
        mov ds,ax
        mov ax,3f00h
        mov cx,0ffffh
        xor dx,dx
        int 21h ;read depth from file to memory
        pop ds
        mov ax,3e00h
        mov bx,word ptr ds:[fhandle]
        int 21h ;close file

;======== R E A D    S I D E B O Y   F R O M    F I L E ========================

        mov ax,3d00h
        lea dx,word ptr ds:[fileboy]
        int 21h ;open file
        jc error_file
        mov word ptr ds:[fhandle],ax ;save file handle
        mov bx,word ptr ds:[fhandle]
        push ds
        mov ax,word ptr ds:[boy]
        mov ds,ax
        mov ax,3f00h
        mov cx,0ffffh
        xor dx,dx
        int 21h ;read depth from file to memory
        pop ds
        mov ax,3e00h
        mov bx,word ptr ds:[fhandle]
        int 21h ;close file

;====================== M A I N - D O   3 D   T U N E L L ======================

        call setpal

        xor ax,ax
        mov word ptr ds:[x_adder],ax
        mov word ptr ds:[y_adder],ax
        mov t,ax
        mov tt,ax

        mov fade1,al

        main:

        cmp fade1,63
        ja @@nofade

        mov bx,768
        @@zanka:
        mov al,[pal+bx]
        mov ah,[palette+bx]
        cmp al,ah
        jae @@zanka1
        inc al
        mov [pal+bx],al

        @@zanka1:

        dec bx
        jnz @@zanka


        call setpal



        mov al,fade1
        inc al
        mov fade1,al


        @@nofade:

        call do_tunnel
        call vretrace
        call flip

        mov ax,t
        inc ax
        mov t,ax
        cmp ax,180
        jb done1

        mov bx,768

        fade:
        mov al,[pal+bx]
        cmp al,0
        jbe smol
        dec al
        mov [pal+bx],al
        smol:
        dec bx
        jnz fade

        call setpal
        call vretrace

        mov ax,tt
        inc ax
        mov tt,ax

        done1:

        cmp tt,53
        jb main

;=================== D E A L L O C A T E    M E M O R Y ========================

        mov ax,word ptr ds:[angle]
        mov es,ax
        mov ax,4900h
        int 21h ;deallocate memory 4 angle

        mov ax,word ptr ds:[depth]
        mov es,ax
        mov ax,4900h
        int 21h ;deallocate memory 4 depth

        mov ax,word ptr ds:[texture]
        mov es,ax
        mov ax,4900h
        int 21h ;deallocate memory 4 texture

        mov ax,word ptr ds:[screen]
        mov es,ax
        mov ax,4900h
        int 21h ;deallocate memory 4 virtual screen

        mov ax,word ptr ds:[boy]
        mov es,ax
        mov ax,4900h
        int 21h ;deallocate memory 4 boy

        ;mov ax,900h
        ;lea dx,greets
        ;int 21h

        jmp exit

;================= A L L     O V E R  ==========================================

        error_file:
        mov ax,900h
        lea dx,errfile
        int 21h
        jmp exit
        error_nomemory:
        mov ax,900h
        lea dx,nomemory
        int 21h

        exit:

        mov ax,4c00h
        int 21h

;============================ E N D    P R O G Y ===============================




;======================== P R O C E D U R E S ==================================

do_tunnel proc near
          push ax bx cx dx si di bp ds es fs gs

          mov ax,word ptr ds:[screen]
          mov es,ax

          mov ax,word ptr ds:[angle]
          mov fs,ax

          mov ax,word ptr ds:[depth]
          mov gs,ax

          mov ax,word ptr ds:[texture]
          mov ds,ax


          mov bp,word ptr ds:[x_adder]
          add bp,4
          mov word ptr ds:[x_adder],bp

          mov bp,word ptr ds:[y_adder]
          add bp,4
          mov word ptr ds:[y_adder],bp


          xor bx,bx
          doy:
          xor cx,cx
          dox:

          mov di,bx;get y
          shl di,6
          mov si,di
          shl di,2
          add di,si
          add di,cx;add x



          mov ax,fs:[di]

          mov bp,word ptr ds:[x_adder]
          add ax,bp
          and ax,255;texture_x=(angle[x+y*320]+texture_x_adder) and 255

          mov dx,gs:[di]
          mov bp,word ptr ds:[y_adder]
          add dx,bp
          and dx,255;texture_y=(detphs[x+y*320]+texture_y_adder) and 255

          mov si,dx;dx
          shl si,6
          mov bp,si
          shl si,2
          add si,bp
          add si,ax;ax=texture_map[texture_x+texture_y*256]

          mov al,ds:[si]
          cmp al,16
          jbe @@done

          movsb;screen[x+y*320]=al

          @@done:

          inc cx
          cmp cx,320
          jb dox

          inc bx
          cmp bx,200
          jb doy


          mov ax,word ptr cs:[boy];now lets draw boy
          mov fs,ax

          mov cx,20;start from 20 for y

          do_boy_y:

          mov bx,140;and from 140 for x

          do_boy_x:

          mov si,cx
          shl si,6
          mov di,si
          shl si,2
          add si,di
          add si,bx

          mov al,fs:[si];check if color=0
          cmp al,0
          jz done_boy;if it is then dont put this pixel

          mov es:[si+320],al;otherwise put it

          done_boy:

          inc bx
          cmp bx,320;check x
          jb do_boy_x

          inc cx
          cmp cx,200;check y
          jb do_boy_y


          pop gs fs es ds bp di si dx cx bx ax
          ret
          endp


vretrace proc near
         push ax dx
         mov dx,3dah
         vr:
         in al,dx
         and al,8
         jnz vr
         vnr:
         in al,dx
         and al,8
         jz vnr
         pop dx ax
         ret
         endp

flip proc near
     push ax cx si di ds es
     mov ax,word ptr ds:[screen]
     mov ds,ax
     mov ax,0a000h
     mov es,ax
     xor di,di
     xor si,si
     mov cx,16000
     rep movsd
     pop es ds di si cx ax
     ret
     endp

setpal proc near
       push ax cx dx si
       mov dx,3c8h
       xor ax,ax
       out dx,al
       inc dx
       lea si,pal
       mov cx,768
       rep outsb
       pop si dx cx ax
       ret
       endp

end   begin


