// compiled with Borland C++ 3.1 large model
// Copyright (c) 1996 David Bollinger
#define RUBBER_C

#include <conio.h>   //  for getch()
#include <dos.h>     //  for MK_FP()
#include <math.h>
#include <stdio.h>
#include <stdlib.h>

typedef unsigned char uchar;
typedef unsigned int uint;

#include "texture.h"
#include "palette.h"

int Initialize(void);
void Terminate(char *msg);
void SetMode(int mode);
void SetPalette(uchar *palette);
void Demo(void);
void RubberSheeting(void);

float a,b,c,d,e,f,g,h,i,j,k,l;    // the intercepts & coefficients
char *vram;                       // pointer to video ram

//============================================================================
void main(void)
   {
   if (Initialize())
      Demo();
   Terminate("RUBBER.  Copyright (c) 1996 David Bollinger.");
   }

//============================================================================
// starting up and shutting down
//----------------------------------------------------------------------------
int Initialize(void)
   {
   SetMode(19);
   SetPalette(palette);
   vram = (uchar *)MK_FP(0xa000,0);
   return 1;
   }

void Terminate(char *msg)
   {
   SetMode(3);
   if (msg) puts(msg);
   exit(0);
   }

//============================================================================
// graphics stuff
//----------------------------------------------------------------------------
void SetMode(int mode)
   {
   asm   xor   ah, ah
   asm   mov   al, byte ptr mode
   asm   int   10h
   }

void SetPalette(uchar *palette)
   {
   asm   les   dx, dword ptr palette
   asm   mov   bx, 0
   asm   mov   cx, 256
   asm   mov   ax, 0x1012
   asm   int   0x10
   }

//============================================================================
// very low tech, just prove that it works
//----------------------------------------------------------------------------
#define NumDemos  10
float DemoValues[NumDemos][12] = {
      // 0: linear stretch the 128x128 texture to fill 320x200 screen once
      { 64.0,0,128.0/320.0,0,0,0,  64.0,128.0/200.0,0,0,0,0 },

      // 1: same as before but bigger
      { 64.0,0,64.0/320.0,0,0,0,  64.0,64.0/200.0,0,0,0,0 },

      // 2: and even bigger, you get the idea...
      { 64.0,0,32.0/320.0,0,0,0,  64.0,32.0/200.0,0,0,0,0 },

      // 3: ok, now let's try smaller with tiling
      { 0,0,256.0/320.0,0,0,0,  0,256.0/200.0,0,0,0,0 },

      // 4: simple orthogonal rotation by swapping x's and y's
      { 64.0,128.0/200.0,0,0,0,0,  64.0,0,128.0/320.0,0,0,0 },

      // 5: shearing effect by mixing & matching x's and y's
      { 0,1,2,0,0,0,  0,2,1,0,0,0 },

      // 6: let's add some curves!  (remember X^2+Y^2?)
      { 0,0,1,0,0.001,  0,0,1,0,0,0,0.001 },

      // 7: let's add lots of curves!
      { 64.0,0,128.0/320.0,0,0,0.01,  64.0,128.0/200.0,0,0,0,0.01 },

      // 8: silly putty
      { 64.0,0,128.0/320.0,0,0.01,0,  64.0,128.0/200.0,0,0,0.01,0 },

      // 9: lots of wacky stuff, big smile (and BIG nose!) for the finish! <g>
      { 64.0,0.01,128.0/320.0,0.01,0.01,0.01,  64.0,128.0/200.0,0.01,0.01,0.01,0.01 },
   };

void Demo(void)
   {
   int demo;

   for (demo=0; demo<NumDemos; demo++)
      {
      a = DemoValues[demo][0];
      b = DemoValues[demo][1];
      c = DemoValues[demo][2];
      d = DemoValues[demo][3];
      e = DemoValues[demo][4];
      f = DemoValues[demo][5];
      g = DemoValues[demo][6];
      h = DemoValues[demo][7];
      i = DemoValues[demo][8];
      j = DemoValues[demo][9];
      k = DemoValues[demo][10];
      l = DemoValues[demo][11];
      RubberSheeting();
      if (getch() == 27) break;  // [Esc] forces quit instead of advance
      }
   }

//============================================================================
// here's the fun stuff
//----------------------------------------------------------------------------
void RubberSheeting(void)
   {
   long x, y;
   uint u, v;
   uchar *vptr = vram;
   float y2, abydy2, ghyjy2, yx, x2, ey, ky;

   for (y=-100; y<100; y++)
      {
      // this stuff doesn't change in inner loop so precompute it
      y2 = y*y;
      abydy2 = a + b*y + d*y2;
      ghyjy2 = g + h*y + j*y2;
      ey = e*y;
      ky = k*y;
      for (x=-160; x<160; x++)
         {
         // precompute and save a whopping one multiply!
         x2 = x*x;
         // ok, now figure out those texture coordinates!
         u = abydy2 + c*x + ey*x + f*x2;
         u &= 0x7f;
         v = ghyjy2 + i*x + ky*x + l*x2;
         v &= 0x7f;
         // stuff the texture into video memory
         *vptr++ = texture[(v<<7)+u];
         }
      }
   }

//============================================================================
