{$A+,B-,D-,F+,G+,I-,K-,L-,N-,P-,Q-,R-,S-,T-,V-,W-,X+,Y-}
{$M 8192,8192}
PROGRAM BPWinG;

{ - Demonstration of WinG with Borland Pascal
    Written by Lars Fosdal, lfosdal@falcon.no, 11 NOV 1994

    Released to the public domain, 11 NOV 1994

    Based on:

      WinG DLL import unit
        by Matthew R Powenski, dv224@cleveland.Freenet.Edu

      STATIC - A WinG Sample Application (written in C)
        by Robert B. Hess, Microsoft Corp.

      flames.pas from the SWAG libraries (DOS VGA demo)
        by Keith Degrce, ekd0840@bosoleil.ci.umoncton.ca.
                       or 9323767@info.umoncton.ca

    Note: WinG must be installed before this program can be run.
}

USES
 WinTypes, WinProcs, oWindows, oDialogs, WinG;

{$R BPWinG.RES}

{$DEFINE Hot} {Hot or Cold?}
{.DEFINE x2}  {Stretch to 2 x Size (Slower :-( )}

CONST {Image sizes (flames demo doesn't adapt too well, though)}
  ImageX = 320; {Must be a multiple of two}
  ImageY = 200; {ImageX x ImageY must not exceed 64K}
                {(Unless you want to write your own array access methods)}

TYPE
  pScreen = ^TScreen; {Bitmap access table}
  TScreen = RECORD
    CASE Integer OF
      0 : (ptb : ARRAY[-(ImageY-1)..0, 0..ImageX-1] OF Byte);
          {ptb = byte coord [y, x]}
      1 : (ptw : ARRAY[-(ImageY-1)..0, 0..(ImageX DIV 2)-1] OF Word);
          {ptw = word coord [y, x div 2]}
      2 : (pta : ARRAY[0..(ImageY*ImageX)-1] OF Byte);
          {pta = byte array [(y*320)+x]}
  END; {REC TScreen}

  TImage = RECORD {DIB Information}
    bi       : TBitmapInfoHeader;
    aColors  : ARRAY[0..255] OF TRGBQUAD;
    lpScreen :pScreen; {Pointer to Bitmap Bits}
  END; {REC TImage}

  TPalette = RECORD {Palette Information}
    Version : Word;         {set to $0300 (Windows version 3.0)}
    NumberOfEntries : Word; {set to 256}
    aEntries : ARRAY[0..255] OF TPaletteEntry;
  END; {REC TPalette}

  pWinGApp = ^TWinGApp; {OWL Application}
  TWinGApp = OBJECT(TApplication)
    PROCEDURE InitMainWindow; VIRTUAL;
  END; {OBJ TWinGApp}

  pWinGWin = ^TWinGWin; {OWL Window}
  TWinGWin = OBJECT(TWindow)
    hPalApp    : hPalette; {Our palette}
    hdcImage   : hDC;      {Our WinG DC}
    hOldBitmap : hBitmap;  {Ye olde bitmap of the WinG DC must be restored}
    bmp        : pScreen;  {Assistant bitmap pointer}
    CONSTRUCTOR Init(aParent:pWindowsObject; aTitle:pChar);
    DESTRUCTOR Done;                                   VIRTUAL;
    PROCEDURE GetWindowClass(VAR aWndClass:TWndClass); VIRTUAL;
    PROCEDURE SetupWindow;                             VIRTUAL;
    PROCEDURE wmEraseBkGnd(VAR Msg:TMessage);          VIRTUAL wm_First + wm_EraseBkGnd;
    PROCEDURE wmPaletteChanged(VAR Msg:TMessage);      VIRTUAL wm_First + wm_PaletteChanged;
    PROCEDURE wmQueryNewPalette(VAR Msg:TMessage);     VIRTUAL wm_First + wm_QueryNewPalette;
    PROCEDURE wmTimer(VAR Msg:TMessage);               VIRTUAL wm_First + wm_Timer;
    PROCEDURE Paint(PaintDC:hDC; VAR PaintInfo:TPaintStruct); VIRTUAL;
    PROCEDURE About(VAR Msg:TMessage);                 VIRTUAL cm_First + 100;
    PROCEDURE Quit(VAR Msg:TMessage);                  VIRTUAL cm_First + 101;
  END; {OBJ TWinGWin}


{//////////////////////////////////////////////////////////////// TWinGApp ///}

PROCEDURE TWinGApp.InitMainWindow;
BEGIN
  MainWindow:=New(pWinGWin, Init(nil,
{$IFDEF Hot}    'WinG + Pascal = Hot!'));
{$ELSE}         'WinG + Pascal = Cool!'));
{$ENDIF}
END; {PROC TWinGApp.InitMainWindow}


{//////////////////////////////////////////////////////////////// TWinGWin ///}

CONSTRUCTOR TWinGWin.Init(aParent:pWindowsObject; aTitle:pChar);
BEGIN
  Inherited Init(aParent, aTitle);
  Attr.Style:=ws_PopupWindow or ws_Caption;
  Attr.x:=160;
  Attr.y:=110;
  Attr.w:={$IFDEF x2}2* {$ENDIF}ImageX + (2 * GetSystemMetrics(sm_CXBorder));
  Attr.h:={$IFDEF x2}2* {$ENDIF}ImageY + (2 * GetSystemMetrics(sm_CYBorder))
                 + GetSystemMetrics(sm_CYCaption)
                 + GetSystemMetrics(sm_CYMenu);
  Attr.Menu:=LoadMenu(hInstance, pChar('WinG_MNU'));
  hPalApp:=0;
  hdcImage:=0;
  hOldBitmap:=0;
END; {CONS TWinGWin.Init}

DESTRUCTOR TWinGWin.Done;
VAR
  hbm : hBitmap;
BEGIN
  IF Bool(hDCImage)                      {If we have a valid DC handle}
  THEN BEGIN
    hbm:=SelectObject(hdcImage, hOldBitmap); {Restore old bitmap}
    DeleteObject(hBM);                       {Delete our bitmap}
    DeleteDC(hdcImage);                      {Delete our DC}
  END;
  IF Bool(hPalApp)                       {If we have a valid palette handle}
  THEN DeleteObject(hPalApp);                {delete our palette}
  KillTimer(hWindow, 1);                 {Kill our timer}
  Inherited Done;                        {Leave the rest to OWL}
END; {DEST TWinGWin.Done}

PROCEDURE TWinGWin.GetWindowClass(VAR aWndClass:TWndClass);
BEGIN
  Inherited GetWindowClass(aWndClass);
  aWndClass.hIcon:=LoadIcon(hInstance, pChar('WinG_ICO')); {Load our Icon}
END; {PROC TWinGWin.GetWindowClass}

PROCEDURE TWinGWin.SetupWindow;
VAR
  LogicalPalette : TPalette; {Our palette initialization table}
  Image          : TImage;   {Our bitmap initialization table}
  PROCEDURE SetRgb(i,r,g,b:Byte);
  CONST
    c = 4; {Scale up the DOS colors to fit a 24-bit palette}
  BEGIN
    LogicalPalette.aEntries[i].peRed   := r*c;
    LogicalPalette.aEntries[i].peGreen := g*c;
    LogicalPalette.aEntries[i].peBlue  := b*c;
    Image.aColors[i].rgbRed  :=LogicalPalette.aEntries[i].peRed;
    Image.aColors[i].rgbGreen:=LogicalPalette.aEntries[i].peGreen;
    Image.aColors[i].rgbBlue :=LogicalPalette.aEntries[i].peBlue;
    Image.aColors[i].rgbReserved:=0;
    LogicalPalette.aEntries[i].peFlags:=PC_NOCOLLAPSE;
  END;
VAR
  Desktop     : hDC;     {Get the system colors via the Desktop DC}
  i           : Integer; {general purpose}
  hbm         : hBitmap; {Handle to our bitmap}
  Orientation : LongInt; {Indicates top-down, bottom-up bitmaps}
BEGIN
  Inherited SetupWindow;             {Let OWL do it's part}

  Randomize;

  SetTimer(hWindow, 1, 40, nil);     {Create our timer (40ms = 25 paints/sec)}
  FillChar(Image, SizeOf(Image), 0); {Better safe than sorry}

  {Ask WinG about the preferred bitmap format}
  IF WinGRecommendDIBFormat(pBitmapInfo(@Image.Bi))
  THEN BEGIN
    Image.Bi.biBitCount:=8;          {Force to 8 bits per pixel}
    Image.Bi.biCompression:=bi_RGB;  {Force to no compression}
    Orientation:=Image.bi.biHeight;  {Get height}
  END
  ELSE WITH Image.bi              {If WinG failed to initialize our image info}
  DO BEGIN                        {we'll do it ourselves}
    biSize:=SizeOf(TBitmapInfoHeader);
    biPlanes:=1;
    biBitCount:=8;
    biCompression:=bi_RGB;
    biSizeImage:=0;
    biClrUsed:=0;
    biClrImportant:=0;
    Orientation:=1;
  END;
  Image.bi.biWidth:=ImageX;       {Define the image sizes}
  Image.bi.biHeight:=ImageY * Orientation;

  Desktop:=GetDC(0); {Setup our palette init info and get the 20 system colors}
  LogicalPalette.Version:=$0300;
  LogicalPalette.NumberOfEntries:=256;
  GetSystemPaletteEntries(Desktop, 0, 10, LogicalPalette.aEntries);
  GetSystemPaletteEntries(Desktop, 246, 10, LogicalPalette.aEntries[246]);
  ReleaseDC(0, Desktop);

  FOR i:=0 TO 9  {Duplicate the system colors into the bitmap}
  DO BEGIN
    Image.aColors[i].rgbRed  :=LogicalPalette.aEntries[i].peRed;
    Image.aColors[i].rgbGreen:=LogicalPalette.aEntries[i].peGreen;
    Image.aColors[i].rgbBlue :=LogicalPalette.aEntries[i].peBlue;
    Image.aColors[i].rgbReserved:=0;
    LogicalPalette.aEntries[i].peFlags:=0;

    Image.aColors[i+246].rgbRed  :=LogicalPalette.aEntries[i].peRed;
    Image.aColors[i+246].rgbGreen:=LogicalPalette.aEntries[i].peGreen;
    Image.aColors[i+246].rgbBlue :=LogicalPalette.aEntries[i].peBlue;
    Image.aColors[i+246].rgbReserved:=0;
    LogicalPalette.aEntries[i+246].peFlags:=0;
  END;

  FOR i := 1 TO 32 {Create our own color scale}
  DO BEGIN
{$IFDEF Hot} {Build Black->Red->Yellow->White colors}
   SetRgb(i, (i shl 1)-1, 0, 0 );
   SetRgb(i+32, 63, (i shl 1)-1, 0 );
   SetRgb(i+64, 63, 63, (i shl 1)-1 );
   SetRgb(i+96, 63, 63, 63 );
{$ELSE} {Build Black->Blue->Cyan->White}
   SetRgb(i, 0, 0, (i shl 1)-1);
   SetRgb(i+32,  0, (i shl 1)-1, 63 );
   SetRgb(i+64, (i shl 1)-1, 63, 63 );
   SetRgb(i+96, 63, 63, 63 );
{$ENDIF}
  END;

  hPalApp:=CreatePalette(pLogPalette(@LogicalPalette)^); {Create the palette}
  hdcImage:=WinGCreateDC;                                {Get our WinG DC}
  hBM:=WinGCreateBitmap(hdcImage, pBitmapInfo(@Image.Bi), @Image.lpScreen);
    {Create our WinG bitmap}

  bmp:=Image.lpScreen; {Image.lpScreen points to the bitmap data}

  hOldBitmap:=SelectObject(hdcImage, hBM); {Select the bitmap into the DC}
  PatBlt(hDCImage, 0,0, ImageX, ImageY, BLACKNESS); {Paint the bitmap black}
END; {PROC TWinGWin.SetupWindow}

PROCEDURE TWinGWin.wmEraseBkGnd(VAR Msg:TMessage);
BEGIN
  Bool(Msg.Result):=True; {We don't want Windows to erase our background}
END; {FUNC TWinGWin.wmEraseBkGnd}

PROCEDURE TWinGWin.wmPaletteChanged(VAR Msg:TMessage);
BEGIN                           {If some other Windows app has focus and changed}
  IF Msg.wParam=hWindow         {the system colors, we'll update too so that we}
  THEN wmQueryNewPalette(Msg);  {can get the second best choices}
END; {PROC TWinGWin.wmPaletteChanged}

PROCEDURE TWinGWin.wmQueryNewPalette(VAR Msg:TMessage);
{ - Update palette and repaint if changed}
VAR
  DC : hDC;
  ReMappedColors:Word;
BEGIN
  DC:=GetDC(hWindow);
  IF Bool(hPalApp)
  THEN SelectPalette(DC, hPalApp, False);
  ReMappedColors:=RealizePalette(DC);
  ReleaseDC(hWindow, DC);
  IF (ReMappedColors > 0)
  THEN BEGIN
    InvalidateRect(hWindow, nil, True);
    Bool(Msg.Result):=True;
  END
  ELSE Bool(Msg.Result):=False;
END; {PROC TWinGWin.wmQueryNewPalette}

PROCEDURE TWinGWin.wmTimer(VAR Msg:TMessage);
BEGIN
  InvalidateRect(hWindow, nil, False); {Force a repaint}
END; {PROC TWinGWin.wmTimer}

PROCEDURE TWinGWin.Paint(PaintDC:hDC; VAR PaintInfo:TPaintStruct);
VAR
  x,y,
  x2,y2,c : Integer;
BEGIN
  SelectPalette(PaintDC, hPalApp, False); {Select our palette}
  RealizePalette(PaintDC);                {and map it to the system palette}
  WITH bmp^         {With our bitmap bits}
  DO BEGIN
    FOR x := 0 TO 159  {Update the flame bitmap}
    DO BEGIN
      x2:=x shl 1;
      FOR y := 30 TO 101
      DO BEGIN
{$IFDEF Hot}
        y2:=-(y shl 1);
        c := (ptb[y2,x2] + ptb[y2,x2+2] + ptb[y2,x2-2] + ptb[y2-2,x2+2]) shr 2;
        IF c <> 0 THEN dec(c);
        ptw[y2+2, x] := c or (c shl 8);
        ptw[y2+1, x] := c or (c shl 8);
{$ELSE}
        y2:=(y shl 1)+6;
        c := (ptb[y2,x2] + ptb[y2,x2+2] + ptb[y2,x2-2] + ptb[y2+2,x2+2]) shr 2;
        IF c <> 0 THEN dec(c);
        ptw[y2-2, x] := c or (c shl 8);
        ptw[y2-1, x] := c or (c shl 8);
{$ENDIF}
      END;
      ptb[y2,x2] := random(2)*160;
    END;
  END;
{$IFDEF x2}
  WinGStretchBlt(PaintDC, 0,0, 2*ImageX, 2*ImageY, hdcImage, 0,0, ImageX, ImageY);
{$ELSE}
  WinGBitBlt(PaintDC, 0,0, ImageX, ImageY, hdcImage, 0,0);
{$ENDIF}
END; {PROC TWinGWin.Paint}

PROCEDURE TWinGWin.About(VAR Msg:TMessage);
VAR
  Dlg : pDialog;
BEGIN
  New(Dlg, Init(@Self, pChar('WinG_DLG')));
  Dlg^.Execute;
  Dispose(Dlg, Done);
END; {PROC TWinGWin.About}

PROCEDURE TWinGWin.Quit(VAR Msg:TMessage);
BEGIN
  CloseWindow;
END; {PROC TWinGWin.Quit}

VAR
  App : pWinGApp;
BEGIN
  New(App, Init('BPWinG'));
  App^.Run;
  Dispose(App, Done);
END.

