
//local defs
void gldecodePCX(FILE *fp2,int width,int depth,int pos,int bpl);


//DRAW IMAGE FUNCTIONS

int glPutImage(int n,int x,int y)
{
  int a,clipped_width,w=glbmp[n].width,h=glbmp[n].height;
  UCHAR *src,*dst;

  if (!glGetClipInfo(x,y,w,h)) return(0);

  src=glbmp[n].data+(gly1clip*w)+glx1clip;
  dst=glPTR+((gly1clip+y)*glDWw)+x+glx1clip;
  clipped_width=w-glx1clip-glx2clip;

  for(a=gly1clip; a<h-gly2clip; a++) {
    memcpy(dst,src,clipped_width);
    src+=w;
    dst+=glDWw;
  }

  return(0);
}

int glPutImageMasked(int n,int x,int y)
{
  int a,b,clipped_width,w=glbmp[n].width,h=glbmp[n].height;
  UCHAR *src,*dst;

  if (!glGetClipInfo(x,y,w,h)) return(0);

  src=glbmp[n].data+(gly1clip*w)+glx1clip;
  dst=glPTR+((gly1clip+y)*glDWw)+x+glx1clip;
  clipped_width=w-glx1clip-glx2clip;

  for(a=gly1clip; a<h-gly2clip; a++) {
    for(b=0; b<clipped_width; b++) if (src[b]) dst[b]=src[b];
    src+=w;
    dst+=glDWw;
  }

  return(0);
}


//LOADING

//load BMP - return ID or -1 on error
int glLoadBMP(char *filename)
{
	FILE *fp;
   int a,b,n,DWw,w,d;
   int order=0;//1=top-down (if height neg.), 0=upsidedown (normal)
   unsigned int headsize=sizeof(BITMAPINFOHEADER)+(sizeof(RGBQUAD)*256);
   DWORD offset;
   unsigned char *data;

   //get free slot for image to be loaded into
   for(a=0; a<MAXIMAGES; a++) {
     if (glbmp[a].type==0) break;
   }
   if (a==MAXIMAGES) return(-1);//no space
   n=a;

   //open image
	if ((fp = fopen(filename, "rb"))==NULL) return(-1);

	//read in header
   fseek(fp, 14L, SEEK_SET);//skip file header
   if (fread((void *)glBMPinfo,1,headsize,fp)!=headsize)
     {fclose(fp); return(-1);}

   //check header details
   if (glBMPinfo->bmiHeader.biBitCount!=8 || glBMPinfo->bmiHeader.biPlanes!=1 ||
     glBMPinfo->bmiHeader.biCompression!=BI_RGB) {fclose(fp); return(-1);}
   //(only non-compressed BMPs supported)

   //get width
   glbmp[n].width = w = glBMPinfo->bmiHeader.biWidth;
   //get height - check for negative
   d = glBMPinfo->bmiHeader.biHeight;
   if (d<0) {d=-d; order=1;}
   glbmp[n].height = d;
   //get DWORD aligned width - as BMPs are DWORD aligned
   DWw = glDWORDwidth(w);

	//allocate memory for image data - (byte aligned only)
	if ((glbmp[n].data=(UCHAR *)malloc(w*d))==NULL) {fclose(fp); return(-1);}

	//read in data
   fseek(fp, 10, SEEK_SET); fread(&offset,4,1,fp);//get offset to data
	fseek(fp, offset, SEEK_SET);
   //
   if (order==0) {//bottom-up bmp
     for(a=0; a<d; a++) {
       b=d-a-1;
       fseek(fp, offset+(DWw*b), SEEK_SET);
       data=glbmp[n].data+(w*a);
       fread(data,1,w,fp);
     }
   }
   else {//top-down
     for(a=0; a<d; a++) {
       data=glbmp[n].data+(w*a);
       fseek(fp, offset+(DWw*a), SEEK_SET);
       fread(data,1,w,fp);
     }
   }

   //CLOSE file
   fclose(fp);
   //fill in other variables
	glbmp[n].type=1;//filled

   return(n);
}


//load PCX
int glLoadPCX(char *filename)
{
	FILE *fp;
	int a,w,d,bpl,n;

   //get free slot for image to be loaded into
   for(a=0; a<MAXIMAGES; a++) {if (glbmp[a].type==0) break;}
   if (a==MAXIMAGES) return(-1);//no space
   n=a;

   //open image
   if ((fp = fopen(filename, "rb"))==NULL) return(-1);

	//read in header
   if (fread(&glPCXHead,1,128,fp)!=128) {fclose(fp); return(-1);}
   //get width
   glbmp[n].width = w = glPCXHead.xmax-glPCXHead.xmin+1;
   glbmp[n].height = d = glPCXHead.ymax-glPCXHead.ymin+1;

   //check header details
   if (glPCXHead.manufacturer!=10 || glPCXHead.bits_per_pixel!=8 ||
    glPCXHead.version!=5) {fclose(fp); return(1);}

	//get bytes_per_line
	bpl=glPCXHead.bytes_per_line;

	//allocate memory for pcx data
	if ((glbmp[n].data=(UCHAR *)malloc(w*d))==NULL) {
     fclose(fp); return(1);
   }
	//decompress pcx data
	fseek(fp, 128L, SEEK_SET); gldecodePCX(fp,w,d,n,bpl);

   //CLOSE file
   fclose(fp);
   //fill in other variables
	glbmp[n].type=1;//filled

  return(n);
}

void gldecodePCX(FILE *fp2,int width,int depth,int pos,int bpl)
{
   int n,d,j;
   unsigned char c,*p;

   for (d=0; d<depth; d++) {
	  p=glbmp[pos].data+(d*width);//read into image buffer
	  n=0;
	  do {
	    c = (unsigned char)fgetc(fp2);   // Read a character from file

	    if ( c >= 192 ) {    //Check type - step 1
	      j = c - 192;    // Step 2
	      c = (unsigned char)fgetc(fp2);  // Step 3
	      while (j--) {
           if (n<width) p[n++] = c;  //Step 4
           else n++;
         }
	    }
	    else {
         if (n<width) p[n++] = c;
         else n++;
       }
	  } while (n < bpl);    //Until the last byte in this line
   }
}



//DELETE LOADED IMAGE

void glDeleteImage(int n)
{
  //only delete if slot filled
  if (glbmp[n].type!=0) {
    free(glbmp[n].data);
    glbmp[n].type=0;
  }
}



//PALETTE FUNCTIONS

//get BMP palette into a buffer
int glLoadBMPPal(char *filename,glbuffer *buff)
{
	FILE *fp;
   int a,b;
   unsigned int headsize=sizeof(BITMAPINFOHEADER)+(sizeof(RGBQUAD)*256);

   if ((fp=fopen(filename, "rb"))==NULL) return(0);

   //read in header
   fseek(fp, 14L, SEEK_SET);//skip file header
   if (fread((void *)glBMPinfo,1,headsize,fp)!=headsize)
    {fclose(fp); return(0);}

   //check header details
   if (glBMPinfo->bmiHeader.biBitCount!=8 || glBMPinfo->bmiHeader.biPlanes!=1)
     {fclose(fp); return(0);}

   //copy palette from header - into buffer's palette array
   b=0;
   for(a=0; a<256; a++) {
     buff->palette[b]=glBMPinfo->bmiColors[a].rgbRed;
     buff->palette[b+1]=glBMPinfo->bmiColors[a].rgbGreen;
     buff->palette[b+2]=glBMPinfo->bmiColors[a].rgbBlue;
     b+=3;
   }

   //CLOSE
   fclose(fp);

   return(1);
}

//get PCX palette into a buffer
int glLoadPCXPal(char *filename,glbuffer *buff)
{
  FILE *fp;

  //open image
  if ((fp = fopen(filename, "rb"))==NULL) return(0);
  //read palette
  fseek(fp, -768L, SEEK_END); fread(buff->palette, 1, 768, fp);
  //CLOSE file
  fclose(fp);

  return(1);
}


