
//Win95 wingl test program. Draws test images & a target shape - use q,a,z,x to
//move. Tested with Borland C/C++ 5

#include "glmheadr.h"
//#include <windows.h> //(included in glmheader.h)
#include <stdio.h>

#define WWIDTH 640
#define WHEIGHT 480

//FUNCTION DEFS
LRESULT CALLBACK WndProc(HWND,UINT,WPARAM,LPARAM);
int CheckMessage(void);
int DrawScreen(void);

//globals
int FOREGROUND;//TRUE if in foreground
char szProgName[]="wingl test";
int frames,fps,targtic;
DWORD TicCount,TmpTC;

int X,Y,image1,image2;

//global window variables
HDC MainDC;
HWND hWnd;
MSG msg;
HPALETTE wpal,OldPal;

//buffer struct
glbuffer mbuff;


//WIN MAIN FUNCTION
int WINAPI WinMain(HINSTANCE hInst,HINSTANCE hPreInst, LPSTR lpszCmdLine,
  int nCmdShow)
{
  WNDCLASS wcApp;
  RECT wrect;

  X=0; Y=0;

  //Window Class setup
  wcApp.lpszClassName=szProgName;
  wcApp.hInstance=hInst;
  wcApp.lpfnWndProc=WndProc;
  wcApp.hCursor=LoadCursor(NULL,IDC_ARROW);
  wcApp.hIcon=0;
  wcApp.lpszMenuName=0;
  wcApp.hbrBackground=GetStockObject(BLACK_BRUSH);
  wcApp.style=CS_HREDRAW|CS_VREDRAW;
  wcApp.cbClsExtra=0;
  wcApp.cbWndExtra=0;

  if (!RegisterClass(&wcApp)) return(0);

  //work out window dimensions based on client area size
  wrect.left=0; wrect.right=WWIDTH; wrect.top=0; wrect.bottom=WHEIGHT;
  if (AdjustWindowRect(&wrect,WS_OVERLAPPEDWINDOW,FALSE)==FALSE) return(0);
  //create window
  hWnd=CreateWindow(szProgName,"wingl test",
  									WS_OVERLAPPEDWINDOW
                           ,0,0,
                           (int)wrect.right-wrect.left,(int)wrect.bottom-wrect.top,
                           (HWND)NULL,(HMENU)NULL,(HANDLE)hInst,(LPSTR)NULL);

  MainDC=GetDC(hWnd);//get global DC for painting to window

  //Setup graphics
  if (!glInit()) return(0);//init lib.
   //fill in desired buffer dimensions & load palette for it
  mbuff.width=640; mbuff.height=480;
  glLoadBMPPal("test.bmp",&mbuff);
   //make the buffer
  glCreateBuffer(&mbuff,MainDC);
   //set the buffer as the target for drawing
  glSetTarget(&mbuff);
   //create windows palette from buffer's
  wpal=glCreateHPALETTE(&mbuff);

  //load test images
  image1=glLoadBMP("test.bmp");
  image2=glLoadPCX("test.pcx");
  if (image1<0||image2<0) {
    DeleteObject(wpal); ReleaseDC(hWnd,MainDC);
    glKillBuffer(&mbuff); glClose();
    return(0);
  }

  //Show Window
  ShowWindow(hWnd,nCmdShow);
  UpdateWindow(hWnd);

  //setup multimedia timer
  targtic=TicCount=GetTickCount();

  //MAIN LOOP
  do
  {
    //message check
    if (CheckMessage()==1) break;

    TmpTC=GetTickCount();
    if (TmpTC>(DWORD)targtic) {
      targtic+=1000;
      fps=frames; frames=0;
    }

    //if window in foreground (active) -
    //update game & display. Change ticcount value to limit max frame rate
    //(40=25fps)
    if (FOREGROUND&&(TmpTC-TicCount>=10)) {

        TicCount=TmpTC;

        if (GetAsyncKeyState('A')) Y+=2;
        if (GetAsyncKeyState('Z')) X-=2;
        if (GetAsyncKeyState('X')) X+=2;
        if (GetAsyncKeyState('Q')) Y-=2;

        frames++;
        DrawScreen();
    }

  }
  while (1);//loop forever

  //destory objects associated with window
  DeleteObject(wpal);
  ReleaseDC(hWnd,MainDC);
  //destroy buffer & close library
  glKillBuffer(&mbuff);
  glClose();
  return(msg.wParam);
}


//check messages and return 1 on WM_QUIT
int CheckMessage(void)
{
  while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
  {
     if (msg.message == WM_QUIT) return(1);   // the only way out of main loop
     TranslateMessage(&msg);
     DispatchMessage(&msg);
  }
  return(0);
}

//Callback function for messages
LRESULT CALLBACK WndProc(HWND hWnd,UINT messg, WPARAM wParam,LPARAM lParam)
{
  UINT a;

  switch (messg)
  {
    //application entering or leaving the foreground
    case WM_ACTIVATEAPP:
		FOREGROUND = wParam;
      break;

    case WM_PALETTECHANGED:
      if(hWnd == (HWND)wParam) break;
    case WM_QUERYNEWPALETTE:
      OldPal=SelectPalette(MainDC,wpal,FALSE);
      a=RealizePalette(MainDC);
      if (a==0) {
        SelectPalette(MainDC,OldPal,TRUE);
        RealizePalette(MainDC);
      }
      return(a);

    case WM_PAINT:
      DrawScreen();
      ValidateRgn(hWnd,NULL);
      break;

    case WM_DESTROY:
      PostQuitMessage(0);
      break;

    default:
      return(DefWindowProc(hWnd,messg,wParam,lParam));
  }
  return(0);
}

//display test graphics & fps count
int DrawScreen()
{
  char string[5];
  int a;

  glClear(255);

  glPutImage(image1,0,0);
  glPutImageMasked(image2,48,8);

  for(a=2; a<=64; a+=8) glCircle(0,X,Y,a);
  glRectangle(0,X-32,Y-32,64,64);
  glLine(0,X-32,Y-32,X+31,Y+31); glLine(0,X+31,Y-32,X-32,Y+31);

  glDisplayBuffer(MainDC,&mbuff,0,0);

  //frame count (this is drawn direct to screen via GDI function)
  sprintf(string,"%d",fps);
  TextOut(MainDC,50,50,string,strlen(string));

  return(0);
}







