#include "mpeg.h"		/* for typedef's and PROTO macro*/


/* util.c */
void correct_underflow PROTO((void ));
int next_bits PROTO((int num , unsigned int mask ));
char *get_ext_data PROTO((void ));
int next_start_code PROTO((void ));
char *get_extra_bit_info PROTO((void ));

/* video.c */
void init_stats PROTO((void ));
void PrintAllStats PROTO((void ));
double ReadSysClock PROTO((void ));
VidStream *NewVidStream PROTO((int bufLength ));
void DestroyVidStream PROTO((VidStream *astream ));
PictImage *NewPictImage PROTO((unsigned int width , unsigned int height ));
void DestroyPictImage PROTO((PictImage *apictimage ));
VidStream *mpegVidRsrc PROTO((TimeStamp time_stamp , VidStream *vid_stream ));
void ToggleBFlag PROTO((void ));
void TogglePFlag PROTO((void ));

/* parseblock.c */
void ParseReconBlock PROTO((int n ));
void ParseAwayBlock PROTO((int n ));

/* motionvector.c */
void ComputeForwVector PROTO((int *recon_right_for_ptr , int *recon_down_for_ptr ));
void ComputeBackVector PROTO((int *recon_right_back_ptr , int *recon_down_back_ptr ));

/* decoders.c */
void init_tables PROTO((void ));
void decodeDCTDCSizeLum PROTO((unsigned int *value ));
void decodeDCTDCSizeChrom PROTO((unsigned int *value ));
void decodeDCTCoeffFirst PROTO((unsigned int *run , int *level ));
void decodeDCTCoeffNext PROTO((unsigned int *run , int *level ));

/* gdith.c */
void InitColor PROTO((void ));

/* gray.c */
void GrayDitherImage PROTO((unsigned char *lum , unsigned char *cr , unsigned char *cb , unsigned char *out , int h , int w ));

/* jrevdct.c */
void init_pre_idct PROTO((void ));
void j_rev_dct_sparse PROTO((DCTBLOCK data , int pos ));
void j_rev_dct PROTO((DCTBLOCK data ));
void j_rev_dct_sparse PROTO((DCTBLOCK data , int pos ));
void j_rev_dct PROTO((DCTBLOCK data ));

/* 24bit.c */
void InitColorDither PROTO((void ));
void ColorDitherImage PROTO((unsigned char *lum , unsigned char *cr , unsigned char *cb , unsigned char *out , int rows , int cols ));

/* ordered.c */
void InitOrderedDither PROTO((void ));
void OrderedDitherImage PROTO((unsigned char *lum , unsigned char *cr , unsigned char *cb , unsigned char *out , int h , int w ));

/* globals.c */
int dprintf (char *format, ...);
int get_more_data PROTO((unsigned int *buf_start , int max_length , int *length_ptr , unsigned int **buf_ptr ));
void DoDitherImage PROTO((unsigned char *l , unsigned char *Cr , unsigned char *Cb , unsigned char *disp , int h , int w ));
void ExecuteDisplay PROTO((VidStream *vid_stream ));
