;****************************************************************************;
;									     ;
; Name: 	ASPIDEFS.INC						     ;
;									     ;
; Description:	ASPI definitions   (Assembly Language)			     ;
;									     ;
; History  JMS	Version 1.0 4/26/91					     ;
;									     ;
;****************************************************************************;

;****************************************************************************;
;	       %%% INT 21 Function call definitions for AX %%%		     ;
;****************************************************************************;
ASPI_Open	equ	3D00H	;Open the ASPI driver
ASPI_Get_Entry	equ	4402H	;Get the entry point
ASPI_Close	equ	3E00H	;Close the ASPI driver
ASPI_DOSExit	equ	4C00h	;Exit to DOS

;****************************************************************************
; *** SCSI I/O Request Structure ***
;
; Note that all elements in this structure are intended to be stored
; in Intel byte order.	All 32 bit fields have been split into WORD
; fields to avoid confusion.
;****************************************************************************
SRBlock 		STRUC

	_SRCmd		db	?	;Request Command
	_SRStat 	db	?	;Request Status
	_SRHaId 	db	?	;Host Adapter ID #
	_SRFlags	db	?	;Request Flags
			dd	?	;Reserved DWORD
	_SRTarget	db	?	;Target Id
	_SRLun		db	?	;Logical Unit Number
	_SRBufLenLo	dw	?	;Data Allocation Length
	_SRBufLenHi	dw	?	;
	_SRSnsLen	db	?	;Sense Allocation Length
	_SRBufPtrLo	dw	?	;Data Buffer Pointer
	_SRBufPtrHi	dw	?	;
	_SRNextPtrLo	dw	?	;Next request pointer for linking
	_SRNextPtrHi	dw	?	;
	_SRCDBLen	db	?	;CDB Length
	_SRHaStat	db	?	;Host Adapter Status
	_SRTargStat	db	?	;Target Status

	_SRPostOff	dw	?	;POST routine Offset
	_SRPostCS	dw	?	;POST routine CS
	_SRPostRealDS	dw	?	;Real Mode POST DS
	_SRBPtrOff	dw	?	;Segment of SRB pointer
	_SRBPtrSeg	dw	?	;Offset of SRB pointer
			dw	?	;Reserved WORD

	_SRPhysAddrLo	dw	?	;Physical Address of the SRB
	_SRPhysAddrHi	dw	?

	_SRWkSpace	db	22 dup (?) ;Reserved for SCSI Manager Workspace

SRBlock 		ENDS

CDB_SRBBlock		struc
			db	(SIZE SRBlock) dup (?)
	CDBByte 	db	10 dup (?)
CDB_SRBBlock		ends

;****************************************************************************
; *** Other command fields ***
;****************************************************************************
HABlock 		struc			;HA INQUIRY COMMAND
			db	8 dup (?)
_HACount		db	?		;# of Host Adapters
_HAIdNum		db	?		;SCSI Id of the host adapter
_SCSIMgrId		db	?		;SCSI Manager ID String
			db	15 dup (?)
_HAIdString		db	?		;Host Adapter ID String
			db	15 dup (?)
_HAUnique		db	?		;Host Adapter Unique paramters
HABlock 		ends			;HA INQUIRY COMMAND

GDEVBlock		struc			;GET DEVICE TYPE COMMAND
			db	10 dup (?)
_ScsiDevType		db	?		;Peripheral Device Type Byte
GDEVBlock		ends			;GET DEVICE TYPE COMMAND

ABORTBlock		struc			;ABORT SCSI I/O REQUEST
			db	8 dup (?)
_AbortPtrLo		dw	?		;Pointer to SRBlock to Abort
_AbortPtrHi		dw	?
ABORTBlock		ends			;ABORT SCSI I/O REQUEST

BIOSBlock		struc			;GET BIOS DRIVE INFORMATION
			db	10 dup (?)
_BIOSFlags		db	?
_Int13Drive		db	?
_HeadTranslation	db	?
_SectorTranslation	db	?
_BIOSReserved		db	?
BIOSBlock		ends			;GET BIOS DRIVE INFORMATION


;****************************************************************************
; *** Flag Definitions ***
;****************************************************************************
SRB_POST		equ	0001h		;Interrupt POST enable/disable
SRB_LINKED		equ	0002h		;Next SRB field valid/invalid
SRB_DIR_IN		equ	0008h
SRB_DIR_OUT		equ	0010h

;****************************************************************************
; *** Command Definitions ***
;****************************************************************************
HA_INQ			equ	00h
GET_TYPE		equ	01h
EXEC_SIO		equ	02h
ABORT_SRB		equ	03h
RESET_DEV		equ	04h
SET_HAPRMS		equ	05h

;****************************************************************************
; *** SRStat Status values ***
;****************************************************************************
SRB_PENDING		equ	00h
SRB_COMP		equ	01h
SRB_ABORTED		equ	02h
SRB_ABORT_FAIL		equ	03h
SRB_ERR 		equ	04h
INV_SPI_CMD		equ	80h
INV_HA_ID		equ	81h
DEV_NOT_INST		equ	82h

;****************************************************************************
; *** Host Adapter Status ***
;****************************************************************************
HASTAT_OK		equ	00h	;Host adapter did not detect any error
HASTAT_SELTOUT		equ	11h	;Selection Timeout
HASTAT_DO_DU		equ	12h	;Data overrun data underrun
HASTAT_UNXBF		equ	13h	;Unexpected bus free
HASTAT_BUSFAIL		equ	14h	;Target bus phase sequence failure
