/* ----------------------------------------------------------------------- *
 *                                                                         *
 *    (C) Copyright 1996 by:  aiNet                                        *
 *										Trubarjeva 42                                *
 *                            SI-3000 Celje                                *
 *										Slovenia, Europe                             *
 *     All Rights Reserved                                                 *
 *                                                                         *
 *     Subject: Simplified C code for single vector prediction.            *
 *     File:    C header file, 32 bit version                              *
 *                                                                         *
 *     Last revision: 14.10.96                                             *
 *                                                                         *
 * ----------------------------------------------------------------------- */

#ifndef AINETDLL_H
#define AINETDLL_H

#include <windows.h>

#if defined(__cplusplus)
 #define CFN extern "C"
#else
 #define CFN
#endif

/*
   Following lines enable that DLL source code sees functions as __export
   and aplication code as __import (which is your case).
   All functions in 32 bit version use __stdcall calling convention.
*/

/* 32 bit version */
#if defined(__WIN32__)
# if defined(AINETDLL_BLD)
#  define AIDCC __export __stdcall
# else
#  if defined(__BORLANDC__)
#   define AIDCC __import __stdcall
#  else
#   define AIDCC __stdcall
#  endif
# endif
/* 16 bit version */
#else
# if defined(AINETDLL_BLD)
#  define AIDCC FAR PASCAL __export
# else
#   define AIDCC FAR PASCAL
# endif
#endif
/* Constants */
/* ----------------------------------------------------------------------- */

/* Error constants */

#define AIERR_NO_ERROR           0
#define AIERR_PENALTY_ZERO      -1
#define AIERR_NO_IO_VARIABLES   -2
#define AIERR_PENALTY_TOO_SMALL -3
#define AIERR_EMPTY_ROW         -4
#define AIERR_EMPTY_COLUMN      -5
#define AIERR_EQUAL_COLUMN      -6
#define AIERR_CSV_OPEN          -7
#define AIERR_CSV_READ          -8
#define AIERR_MEMORY_ALLOCATION -9
#define AIERR_INVALID_POINTER   -10
#define AIERR_INVALID_INDEX     -11

/* Penalty coefficient constants */

#define PENALTY_STATIC   0
#define PENALTY_DYNAMIC  1
#define PENALTY_NEAREST  2

/* Normalization constants */

#define NORMALIZE_REGULAR   0
#define NORMALIZE_STATISTICAL  1


/* Definitions */
/* ----------------------------------------------------------------------- */

/* The aiVector is simply a pointer to float */

typedef float*  aiVector;

/* The aiModel Structure */

typedef struct aiTagModel{
	float **data;        /* model (vector of model vectors) */
	int nMV;             /* number of model vectors         */
	int nVar;            /* total number of variables       */
	int ni;              /* number of input variables       */
	int* discrete;			/* array of flags                  */
	aiVector n1;			/* normalization / denormalization */
	aiVector n2;			/* ...                             */
} aiModel;

extern const float MISSING;

/* Function prototypes */
/* ----------------------------------------------------------------------- */
#if defined (AI_STATIC_DLL_BINDING)
/*
 * If you want to bind ainetxx.dll statically to your exe (or dll) using
 * ainetxx.lib file, than you must define the AI_STATIC_DLL_BINDING flag
 * before you include ainetdll.h file.
 * It has been reported that ainet16.dll can be easily linked statically
 * with almost any C/C++ compiler.
 *
 * ATTENTION: This is not true with ainet32.dll.
 * ainet32.dll can be statically linked only with Borland C++ 5.0.
 * Any other compiler should load and bind ainet32.dll dynamically.
 */

/* Functions defined in DLL */
/* ----------------------------------------------------------------------- */

CFN int      AIDCC aiRegistration(const char* user,const char* code);
CFN int      AIDCC aiGetVersion(void);
CFN aiModel* AIDCC aiCreateModel(int nMV, int nVar, int nInputVar);
CFN aiModel* AIDCC aiCreateModelFromCSVFile(const char* fileName);
CFN int      AIDCC aiDeleteModel(aiModel* model);
CFN int      AIDCC aiNormalize(aiModel* model, int method);
CFN int      AIDCC aiDenormalize(aiModel* model);
CFN int      AIDCC aiPrediction(aiModel* model, aiVector toPredict,
                           		 float penalty, int method);
CFN int      AIDCC aiGetNumberOfVariables(aiModel* model);
CFN int      AIDCC aiGetNumberOfModelVectors(aiModel* model);
CFN int      AIDCC aiGetNumberOfInputVariables(aiModel* model);
CFN int      AIDCC aiSetDiscreteFlag(aiModel* model, int i, BOOL f);
CFN int      AIDCC aiGetDiscreteFlag(aiModel* model, int i);
CFN int      AIDCC aiSetVariable(aiModel* model, int mv, int v, float value);
CFN float    AIDCC aiGetVariable(aiModel* model, int mv, int v);
CFN int      AIDCC aiGetVariableVB(aiModel* model, int mv, int v,float* value);
CFN DWORD    AIDCC aiGetCSVFileModelSize(const char* fileName);

/*
 * NOTE: Most of above functions return an integer. If the return value
 * is equal to AIERR_NO_ERROR than the function was succesful.
 * A negative value usually indicates an error.
 */

#else /* NO STATIC BINDING - DEFAULT */

/* Typedefs functions defined in DLL */
/* ----------------------------------------------------------------------- */
/*
 * Pointers to functions above. Use these definitions when ainetxx.dll is
 * loaded at run tume, which is the default option.
 * To enable these typedefs, the AI_STATIC_DLL_BINDING flag must NOT be defined
 * before ainetdll.h file is included.
 * Please, see examples to find out how to use ainetxx.dll and dynamic linking.
 */
#if defined(__WIN32__)
# define __call __stdcall
#else
#define __call FAR PASCAL
#endif

typedef int      (__call *t_aiRegistration)(const char* user,const char* code);
typedef int      (__call *t_aiGetVersion)(void);
typedef aiModel* (__call *t_aiCreateModel)(int nMV, int nVar, int nInputVar);
typedef aiModel* (__call *t_aiCreateModelFromCSVFile)(const char* fileName);
typedef int      (__call *t_aiDeleteModel)(aiModel* model);
typedef int      (__call *t_aiNormalize)(aiModel* model, int method);
typedef int      (__call *t_aiDenormalize)(aiModel* model);
typedef int      (__call *t_aiPrediction)(aiModel* model, aiVector toPredict,
                                		      float penalty, int method);
typedef int      (__call *t_aiGetNumberOfVariables)(aiModel* model);
typedef int      (__call *t_aiGetNumberOfModelVectors)(aiModel* model);
typedef int      (__call *t_aiGetNumberOfInputVariables)(aiModel* model);
typedef int      (__call *t_aiSetDiscreteFlag)(aiModel* model, int i, BOOL f);
typedef int      (__call *t_aiGetDiscreteFlag)(aiModel* model, int i);
typedef int      (__call *t_aiSetVariable)(aiModel* model, int mv, int v, float value);
typedef float    (__call *t_aiGetVariable)(aiModel* model, int mv, int v);
typedef int      (__call *t_aiGetVariableVB)(aiModel* model, int mv, int v,float* value);
typedef DWORD    (__call *t_aiGetCSVFileModelSize)(const char* fileName);
#endif /*(AI_STATIC_DLL_BINDING)*/

#endif  /*AINETDLL_H*/

/* ----------------------------------------------------------------------- */
