PROGRAM JOYSTICK;


(*
WRITTEN BY JAMES P. MCADAMS - 25 DECEMBER 1984

PROGRAM DEMONSTRATING THE USE OF TURBO PASCAL TO ACCESS THE
IBM-PC GAME CONTROL ADAPTER. THE TWO FUNCTION CALLS ARE EACH
COMPLETE IN ITSELF. EITHER ONE OR BOTH CAN BE MOVED TO ANY
PROGRAM THAT NEEDS THE USE OF JOYSTICKS OR PADDLES.
*)



VAR
I: INTEGER;
TEMP: BYTE;


   FUNCTION BUTTON_PRESSED (WHICH_ONE: CHAR): BOOLEAN;
   (* RETURN TRUE IF THE BUTTON IS PRESSED *)
   CONST
      JOYPORT = $201; (* LOCATION OF THE GAME PORT *)
   VAR
      MASK: BYTE;
   BEGIN
   IF NOT (WHICH_ONE IN ['A'..'D']) THEN WHICH_ONE := 'A';
   CASE WHICH_ONE OF
      'A': MASK := 16;
      'B': MASK := 32;
      'C': MASK := 64;
      'D': MASK := 128;
      END;
   BUTTON_PRESSED := (PORT [JOYPORT] AND MASK) = 0;
   END; (* BUTTON_PRESSED *)


   FUNCTION JOYSTICK_POS (WHICH_ONE: CHAR): INTEGER;
   (*
   WITH A KRAFT JOYSTICK, VALUES RETURNED ARE IN THE RANGE 4 TO ABOUT
   140. IF YOUR MACHINE RUNS FASTER THAN A STANDARD IBM-PC OR IF YOU
   MODIFY YOUR GAME ADAPTER CARD WITH BIGGER CAPACITORS, YOU WILL
   GET LARGER COUNTS AND YOU MUST MODIFY "MAXCOUNT".

   CALLING A JOYSTICK THAT IS NOT IN USE OR ONE THAT HAS GONE
   OVER-RANGE (COUNT REACHED MAXCOUNT) YIELDS A VALUE OF 0.
   *)
   CONST
      MAXCOUNT =  200; (* MODIFY THIS IF YOU CAN GET LONGER COUNTS     *)
      JOYPORT  = $201; (* FOR INFORMATION ONLY: LOC OF GAME INPUT PORT *)
   VAR
      COUNTER: INTEGER;
      MASK: BYTE;
   BEGIN
   IF NOT (WHICH_ONE IN ['A'..'D']) THEN WHICH_ONE := 'A';
   CASE WHICH_ONE OF
      'A': MASK := 1;
      'B': MASK := 2;
      'C': MASK := 4;
      'D': MASK := 8;
      END;
   (*
   THIS ASSEMBLY CODE CAUSES THE CX REGISTER TO COUNT DOWN FROM "MAXCOUNT"
   TOWARD ZERO. WHEN CX REACHES ZERO OR WHEN THE ONE-SHOT ON THE GAME
   ADAPTER TIMES OUT, THE LOOPING STOPS AND "COUNTER" IS ASSIGNED THE NUMBER
   OF COUNTS THAT TOOK PLACE. MAXCOUNT SHOULD BE CHOSEN SO THAT CX NEVER
   REACHES 0 SO THAT THE USABLE RANGE OF THE JOYSTICK WILL NOT BE LIMITED.
   *)
   INLINE (
      $B9/MAXCOUNT/       (*       MOV CX,MAXCOUNT INITIALIZE DOWN-COUNTER *)
      $BA/JOYPORT/        (*       MOV DX,JOYPORT  PORT ADDR OF JOYSTICKS  *)
      $8A/$A6/MASK/       (*       MOV AH,MASK[BP] MASK FOR DESIRED 1-SHOT *)
      $EE/                (*       OUT DX,AL       START THE ONE-SHOTS     *)
      $EC/                (* READ: IN  AL,DX       READ THE ONESHOTS       *)
      $84/$C4/            (*      TEST AL,AH       CHECK DESIRED ONE-SHOT  *)
      $E0/$FB/            (*    LOOPNZ READ        REPEAT UNTIL TIMED OUT  *)
      $89/$8E/COUNTER);   (*       MOV COUNTER[BP],CX  THIS MAKES CX AVAIL-*)
                          (*                           ABLE TO TURBO       *)
   IF COUNTER = 0
      THEN JOYSTICK_POS := 0 (* OVER-RANGE OR NOT IN USE *)
      ELSE JOYSTICK_POS := MAXCOUNT - COUNTER;
   END; (* JOYSTICK_POS *)


BEGIN    (***** DEMO PROGRAM - MAIN CODE *****)
CLRSCR;
GOTOXY (1, 2);
WRITELN ('JOYSTICKS':10, 'BUTTONS':10);
WRITE   ('A':5, 'B':5, 'A':5, 'B':5);

WHILE TRUE DO (* PRESS CTRL C TO STOP THE PROGRAM *)
   BEGIN
   GOTOXY (1, 5);
   WRITE (JOYSTICK_POS ('A'):5, JOYSTICK_POS ('B'):5);
   IF BUTTON_PRESSED ('A')
      THEN WRITE ('PRES':5)
      ELSE WRITE ('UP':5);
   IF BUTTON_PRESSED ('B')
      THEN WRITE ('PRES':5)
      ELSE WRITE ('UP':5);
   END;
END.
