/*
 *   A simple utility for Multi-user UNIX systems
 *   --------------------------------------------
 *
 *   Written by Steve Woodford, March 19th, 1987.
 *   --------------------------------------------
 *
 *   This is a simple program for finding out who is on your system, where
 *   in the building/s they are and whether or not they are actually at
 *   their VDU's.
 *
 *   It takes as the standard input, the output of the who -u command, ie:
 *
 *    A          B              C         D      E
 *
 *   fred     tty003      Apr 23 14:12  0:39   10479
 *
 *   where :
 *
 *          A.  is the login name of the user.
 *          B.  is the line they are on. (My system uses 3 digit nos.)
 *          C.  Date and Time the user logged in. (Not used here).
 *          D.  This is the time elapsed since there was any activity on
 *              the line.  This could be '.' for activity within the last
 *              minute, 'OLD' for no activity for 24 hours or over.
 *              Otherwise it is the time in hours and minutes.
 *          E.  The procces number of the user's login shell. (Not used here)
 *
 *   The program uses two files, /usr/lib/ttystates and /usr/lib/ttylocations.
 *
 *   The first contains lines of text which are to be printed for every 10
 *   minutes that there has been no activity on the user's line. ie. from 1
 *   to 9 minutes, the program will print the first line, from 10 to 19
 *   minutes, it will print the second line and so on.  There doesn't have to
 *   be as many lines as there are 10 minute segments in 24 hours, as a 
 *   'compiled in' default is used in this case.
 *
 *   The second file is used to describe where each tty line is.  Each line
 *   consists of 2 fields, the first being the name of the line - eg. tty000.
 *   The second is a description of where the VDU is,
 *   eg:
 *       tty000 in the front room.
 *
 *   Two example files could be:
 *
 *   # cat /usr/lib/ttystates
 *
 *   thinking
 *   getting bored
 *   yawning
 *   dropping off
 *   drowsing
 *   asleep
 *   sound asleep
 *   snoring gently
 *   snoring loudly
 *   losing consciousness
 *   unconscious
 *   comatose
 *   dead to the world
 *
 *   # cat /usr/lib/ttylocations
 *
 *   tty000 on the console.
 *   tty001 on the incoming Modem. (ie. Who knows where!!)
 *   tty002 in reception.
 *   tty003 in the Engineer's workshop.
 *   tty004 at his desk.
 *
 *   So the example used above of user fred would be printed as:
 *
 *   fred is dropping off in the Engineer's workshop.
 *
 *   To avoid a lot of programming hassle with pipes etc, the program has two
 *   files, a one line shell script and the actual object file.  The shell
 *   script consists simply of:
 *
 *   who -u|/etc/where.obj
 *
 *   on my system I have called the shell script 'where' and the object
 *   'where.obj'.  Both in /etc.  They can obviously be put anywhere in $PATH.
 *
 *   Finally, this program has not been made fully 'idiot-proof' and could also
 *   be improved in terms of layout and efficiency. I didn't have time to
 *   improve it!! (At least that's my excuse!!)
 *
 */
#include <stdio.h>

main ()
{
    char c,logname[16], d[50], time[6];
    char tty[8], ttytest[8], min[3];
    int hour, mn, index, i;
    FILE *statstrm, *ttystrm, *fopen();

/* The top of the loop for each user. */

    while (( c=getchar()) != EOF )
    {
        ungetc(c,stdin);

/* Ok, so this is inefficient !!!! Opening each time around the loop!! */

        if (( statstrm=fopen("/usr/lib/ttystates", "r")) == NULL )
        {
            fprintf(stderr,"where: can't open /usr/lib/ttystates.\n");
            exit(1);
        }
        if (( ttystrm=fopen("/usr/lib/ttylocations", "r")) == NULL )
        {
            fprintf(stderr,"where: can't open /usr/lib/ttylocations.\n");
            exit(1);
        }
/*
Change this line if the output of the who -u command is different from above.
The char array 'd' is used to skip over unwanted fields.
*/
        scanf("%s %s %s %s %s %s %s",logname,tty,d,d,d,time,d);
        /* Skip to start of next line. */
        while ((c=getchar()) != '\n');
        /* Output 'user is' */
        printf("%s is",logname);
/*
Now split the time since activity into the three different types. First 'OLD'.
Note the 'compiled in' string for OLD.
*/
        if (strcmp(time, "OLD") == 0) printf(" decomposing");
/*
Seperate hours and minutes. (Ok, more inefficiency!!)
And print text if valid hours and minutes.
*/
        if ((time[2] == ':') || (time[1] == ':'))
        {
            hour = atoi(time);
            min[0] = time[3];
            if (time[1]=':') min[0] = time[2];
            min[1] = '\0';
            mn = atoi(min);
/*
Combine hours and minutes to form index into /usr/lib/ttystates.
*/
            index = (6 * hour) + mn;
/*
Skip to start of line to print for this length of time.
*/
            for (i=0; i<index; i++) while (((c=fgetc(statstrm)) != '\n') && ( c != EOF ));
/*
Get the next byte from the file.
*/
            c=fgetc(statstrm);
            ungetc(c,statstrm);
/*
Put it back and if it is EOF, print 'compiled in' default for running out of
text in /usr/lib/ttylocations.
*/
            if (c== EOF ) printf(" pushing up the daisies");
/*
Otherwise, print the relevant line of text.
*/
            else
            {
                putchar(' ');
                while ((c=fgetc(statstrm)) != '\n') putchar(c);
            }
        }
        while ((c=fgetc(ttystrm)) != EOF)
/*
Now the loop to scan /usr/lib/ttylocations to find and print the correct entry.
*/
        {
            ungetc(c,ttystrm);
            fscanf(ttystrm,"%s", ttytest);
/*
Get line name into ttytest and compare with line that current user is on.
If they match then print the text following the line name.
If not, skip the line.
*/
            if (strcmp(tty,ttytest) == 0) while ((putchar(fgetc(ttystrm))) != '\n');
            else while ((c=fgetc(ttystrm)) != '\n');
        }
        fclose(statstrm);
/*
Close the files - All this inefficiency !!
*/
        fclose(statstrm);
        fclose(ttystrm);
    }
}
  fclose(statstrm);
/*
Close the files - All this ineff