
	.title	'CCITT'
	.option XREF
*;
*;***********************************************************
*;***********************************************************
*; This is the source module for a half-duplex CCITT
*; compatible 32-kbps ADPCM speech system. The transmitter
*; assumes that log-PCM data will be available at each
*; interrupt (every 125 microseconds) in the lower 8 bits of
*; the data bus via I/O port 1 and it supplies ADPCM data on
*; the lower 4 bits of the bus via port 2. The receiver does
*; the inverse.  An interrupt in this case is determined by
*; polling the BIO line, with a low signal level signifying
*; the presence of a new data sample.
*;
*; The 'R' reset function in the CCITT spec is implemented
*; with a hardware reset. At the time of reset, it is
*; assumed that the operating mode has been established and
*; input via the upper two bits of the data bus.  The bit
*; condition is read from port 0 so as not to disrupt any
*; pending data sample on either of the other two ports.
*; Since it is anticipated that the mode pins will be
*; selected and maintained in a manner similar to a hardwire
*; selection, the actual port from which the mode is read
*; is arbitrary.
*;
*;**********************************************************
*;
*; System I/O channel assignments
*;
ADC:	.set	1	; codec input
DAC:	.set	1	; codec output
CCITT:	.set	2	; adpcm output/input
CTL:	.set	0	; control input to select mode
*;			; 0000 = mulaw transmitter
*;			; 4000 = mulaw receiver
*;			; 8000 = alaw transmitter
*;			; C000 = alaw receiver
*;
*;**********************************************************
*
	.sect	"AORG0"
*;
	B	RESET	; power-up reset
*;
*;**********************************************************
*; INTERRUPT HANDLING ROUTINE -- SYSTEM HANDLES CODEC
*; SAMPLES ON A SAMPLE BY SAMPLE BASIS.
*;**********************************************************
*;
INTRPT	B	INTRPT
*;
	.page
*;
*;  MU-LAW TRANSMITTER
*;
XMTMU	IN	SCRACH,ADC  ; input mu-law PCM
*;
*; patch to stop simulation
*;
	LAC	SCRACH
	SUB	ONE,8
STOP2	BGEZ	STOP2
*;
	CALL	SIGDIF
*;
*;**********************************************************
*; MU-LAW TO LINEAR PCM EXPANSION
*;
*;	INPUT:	MU-LAW PCM SAMPLE  -- S  (SCRACH)
*;
*;	OUTPUT: LINEAR PCM SAMPLE  -- SL (SAMPLE)
*;
*;	NOTATION:  S  -- 8b SM (Q4)
*;		   SL -- 14b TC (Q0)
*;
*;**********************************************************
*;
*;		  S    +--------+  SL
*;	       ------->| EXPAND |------->
*;		       +--------+
*;
*;**********************************************************
*;
EXPNDU	LAC	SCRACH,8    ; seee mmmm 0000 0000
	XOR	KFF00	    ; SEEE MMMM 0000 0000
	SACL	TEMP1	    ; save value for PCM sign
	AND	M32767	    ; 0EEE MMMM 0000 0000
	SACH	TEMP2,4     ; save exponent value
	AND	M4095	    ; 0000 MMMM 0000 0000
	ADD	BIAS,7	    ; 0001 MMMM 1000 0000
	SACL	SCRACH
	LAC	TEMP1
	SACH	TEMP1	    ; sign = FFFF or 0000
	LACK	SBASE
	ADD	TEMP2,1     ; calculate PCM shift address
	CALA
	SUB	BIAS,12 ; 0000000X XXXXXXXX XXXX0000 00000000
	SACH	SAMPLE,4
	LAC	SAMPLE	    ; 000X XXXX XXXX XXXX
	XOR	TEMP1	    ; pos - no change : neg - 1's compl
	SUB	TEMP1	    ; pos - no change : neg - 2's compl
	SACL	SAMPLE
*;
*; Now convert PCM value in SAMPLE to ADPCM value in I
*;
	CALL	AQUAN
	SACL	I
	OUT	I,CCITT     ; output ADPCM
	CALL	PRDICT
MULAWX	BIOZ	XMTMU	    ; wait for next sample
	B	MULAWX
*;
SBASE	LAC	SCRACH,5  ; 00000000 0000001M MMM10000 00000000
	RET
	LAC	SCRACH,6  ; 00000000 000001MM MM100000 00000000
	RET
	LAC	SCRACH,7  ; 00000000 00001MMM M1000000 00000000
	RET
	LAC	SCRACH,8  ; 00000000 0001MMMM 10000000 00000000
	RET
	LAC	SCRACH,9  ; 00000000 001MMMM1 00000000 00000000
	RET
	LAC	SCRACH,10 ; 00000000 01MMMM10 00000000 00000000
	RET
	LAC	SCRACH,11 ; 00000000 1MMMM100 00000000 00000000
	RET
	LAC	SCRACH,12 ; 00000001 MMMM1000 00000000 00000000
	RET
	.page
*;
*;  A-LAW TRANSMITTER
*;
XMTA	IN	SCRACH,ADC  ; input A-law PCM
*;
*; patch to stop simulation
*;
	LAC	SCRACH
	SUB	ONE,8
STOP4	BGEZ	STOP4
*;
	CALL	SIGDIF
*;
*;**********************************************************
*; A-LAW TO LINEAR PCM EXPANSION
*;
*;	INPUT:	A-LAW PCM SAMPLE  -- S	(SCRACH)
*;
*;	OUTPUT: LINEAR PCM SAMPLE  -- SL (SAMPLE)
*;
*;	NOTATION:  S  -- 8b SM (Q4)
*;		   SL -- 14b TC (Q0)
*;
*;**********************************************************
*;
*;		  S    +--------+  SL
*;	       ------->| EXPAND |------->
*;		       +--------+
*;
*;**********************************************************
*;
EXPNDA	LAC	SCRACH,8    ; sEEE MMMM 0000 0000
	XOR	K32768	    ; SEEE MMMM 0000 0000
	SACL	TEMP1	    ; save value for PCM sign
	AND	M32767	    ; 0EEE MMMM 0000 0000
	SACH	TEMP2,4     ; save exponent value
	AND	M4095	    ; 0000 MMMM 0000 0000
	SACL	SCRACH
	LAC	TEMP1
	SACH	TEMP1	    ; sign = FFFF or 0000
	LACK	SBASEA
	ADD	TEMP2,2     ; calculate PCM shift address
	CALA
	SACH	SAMPLE,4
	LAC	SAMPLE	    ; 000X XXXX XXXX XXXX
	XOR	TEMP1	    ; pos - no change : neg - 1's compl
	SUB	TEMP1	    ; pos - no change : neg - 2's compl
	SACL	SAMPLE
*;
*; Now convert PCM value in SAMPLE to ADPCM value in I
*;
	CALL	AQUAN
	SACL	I
	OUT	I,CCITT     ; output ADPCM
	CALL	PRDICT
ALAWX	BIOZ	XMTA	    ; wait for next sample
	B	ALAWX
*;
SBASEA	LAC	SCRACH,6  ; 00000000 000000MM MM000000 00000000
	ADD	ONE,13	  ; 00000000 000000MM MM100000 00000000
	RET
	NOP
	LAC	SCRACH,6  ; 00000000 000001MM MM100000 00000000
	ADD	BIASA,6   ; 00000000 000001MM MM100000 00000000
	RET
	NOP
	LAC	SCRACH,7  ; 00000000 00000MMM M0000000 00000000
	ADD	BIASA,7   ; 00000000 00001MMM M1000000 00000000
	RET
	NOP
	LAC	SCRACH,8  ; 00000000 0000MMMM 00000000 00000000
	ADD	BIASA,8   ; 00000000 0001MMMM 10000000 00000000
	RET
	NOP
	LAC	SCRACH,9  ; 00000000 000MMMM0 00000000 00000000
	ADD	BIASA,9   ; 00000000 001MMMM1 00000000 00000000
	RET
	NOP
	LAC	SCRACH,10 ; 00000000 00MMMM00 00000000 00000000
	ADD	BIASA,10  ; 00000000 01MMMM10 00000000 00000000
	RET
	NOP
	LAC	SCRACH,11 ; 00000000 0MMMM000 00000000 00000000
	ADD	BIASA,11  ; 00000000 1MMMM100 00000000 00000000
	RET
	NOP
	LAC	SCRACH,12 ; 00000000 MMMM0000 00000000 00000000
	ADD	BIASA,12  ; 00000001 MMMM1000 00000000 00000000
	RET
	.page
*;
*;  MU-LAW RECEIVER
*;
RCVMU	IN	I,CCITT     ; input ADPCM
*;
*; stop simulation if i>255
*;
	LAC	I
	SUB	ONE,8
STOP1	BGEZ	STOP1
*;
	CALL	SIGDIF
*;
	LAC	I	    ; determine magnitude of ADPCM
	SACL	IM
	XOR	M15
	SUB	ONE,3
	SACH	SIGN
	BGEZ	DO32KU
	ADD	ONE,3
	SACL	IM
*;
*; compute pcm output
*;
DO32KU	CALL	PRDICT
*;
*;**********************************************************
*; LINEAR TO U-LAW PCM COMPRESSION/U-LAW TO LINEAR EXPANSION
*;
*;	INPUT:	LINEAR PCM SAMPLE  -- SR
*;
*;	OUTPUT: A-LAW PCM SAMPLE   -- SP  (SCRACH)
*;		LINEAR PCM SAMPLE  -- SLX (SAMPLE)
*;
*;	NOTATION:  SR  -- 16b TC (Q0)
*;		   SP  -- 8b SM (Q4)
*;		   SLX -- 14b TC (Q0)
*;
*;**********************************************************
*;
*;	SR   +----------+	SP    +--------+  SLX
*;    ------>| COMPRESS |-----*------>| EXPAND |------->
*;	     +----------+     |       +--------+
*;			      | 		  SP
*;			      +------------------------>
*;
*;**********************************************************
*;
	LAC	SR	    ; get reconstructed signal
*;
*; compress--convert to pcm
*;
CMPRSU	SACH	SIGN	    ; save sign of SR
	ABS
	ADD	BIAS	    ; add bias
	SACL	SCRACH	    ; save biased PCM value
	SUB	ONE,9	    ; exp = 7 - 4 or 3 - 0
	BGEZ	SCL427
SCL023	ADD	THREE,7     ; exp = 3 - 2 or 1 - 0
	BGEZ	SCL223
SCL021	ADD	ONE,6	    ; exp = 1 or 0
	BGEZ	SCALE1
SCALE0	LAC	M15,1	    ; exp = 0
	AND	SCRACH	    ; mask for mantissa
	SACL	SCRACH
	ADD	BIAS
	SACL	SAMPLE	    ; biased quantized value
	LAC	SCRACH,15
	LARK	0,0
	B	FINI
SCALE1	LAC	M15,2	    ; exp = 1
	AND	SCRACH	    ; mask for mantissa
	SACL	SCRACH
	ADD	BIAS,1
	SACL	SAMPLE	    ; biased quantized value
	LAC	SCRACH,14
	LARK	0,1
	B	FINI
SCL223	SUB	ONE,7	    ; exp = 3 or 2
	BGEZ	SCALE3
SCALE2	LAC	M15,3	    ; exp = 2
	AND	SCRACH	    ; mask for mantissa
	SACL	SCRACH
	ADD	BIAS,2
	SACL	SAMPLE	    ; biased quantized value
	LAC	SCRACH,13
	LARK	0,2
	B	FINI
SCALE3	LAC	M15,4	    ; exp = 3
	AND	SCRACH	    ; mask for mantissa
	SACL	SCRACH
	ADD	BIAS,3
	SACL	SAMPLE	    ; biased quantized value
	LAC	SCRACH,12
	LARK	0,3
	B	FINI
SCL427	SUB	THREE,9     ; exp = 7 - 6 or 5 - 4
	BGEZ	SCL627
SCL425	ADD	ONE,10	    ; exp = 5 or 4
	BGEZ	SCALE5
SCALE4	LAC	M15,5	    ; exp = 4
	AND	SCRACH	    ; mask for mantissa
	SACL	SCRACH
	ADD	BIAS,4
	SACL	SAMPLE	    ; biased quantized value
	LAC	SCRACH,11
	LARK	0,4
	B	FINI
SCALE5	LAC	M15,6	    ; exp = 5
	AND	SCRACH	    ; mask for mantissa
	SACL	SCRACH
	ADD	BIAS,5
	SACL	SAMPLE	    ; biased quantized value
	LAC	SCRACH,10
	LARK	0,5
	B	FINI
SCL627	SUB	ONE,11	    ; exp = 7 or 6
	BGEZ	SCALE7
SCALE6	LAC	M15,7	    ; exp = 6
	AND	SCRACH	    ; mask for mantissa
	SACL	SCRACH
	ADD	BIAS,6
	SACL	SAMPLE	    ; biased quantized value
	LAC	SCRACH,9
	LARK	0,6
	B	FINI
SCALE7	SUB	ONE,12	    ; exp = 7
	BLZ	NORMAL	    ; mag > 8191 ?
SATCH	LAC	K63,7
	SACL	SAMPLE	    ; save max biased quantized value
	LACK	127	    ; set maximum mulaw magnitude
	B	CLNUP
NORMAL	LAC	M15,8
	AND	SCRACH	    ; mask for mantissa
	SACL	SCRACH
	ADD	BIAS,7
	SACL	SAMPLE	    ; biased quantized value
	LAC	SCRACH,8
	LARK	0,7
FINI	SACH	SCRACH	    ; save normalized mantissa
	LAC	SCRACH
	SAR	0,TEMP1
	ADD	TEMP1,4     ; add exponent
CLNUP	ADD	SIGN,7
	AND	M255
	SACL	SCRACH	    ; signed magnitude of mulaw-PCM
	LAC	SAMPLE	    ; remove bias from quantized value
	SUB	BIAS
	XOR	SIGN
	SUB	SIGN
	SACL	SAMPLE	    ; 2's complement of quantized sample
*;
	CALL	AQUAN
*;
	CALL	SYNC
*;
	XOR	M255	    ; flip bits for transmission
	SACL	SCRACH
	OUT	SCRACH,DAC  ; output mu-law PCM
MULAWR	BIOZ	RCVMU	    ; wait for next sample
	B	MULAWR
	.page
*;
*;  A-LAW RECEIVER
*;
RCVA	IN	I,CCITT     ; input ADPCM
*;
*; stop simulation if i>255
*;
	LAC	I
	SUB	ONE,8
STOP3	BGEZ	STOP3
*;
	CALL	SIGDIF
*;
	LAC	I	    ; determine magnitude of ADPCM
	SACL	IM
	XOR	M15
	SUB	ONE,3
	SACH	SIGN
	BGEZ	DO32KA
	ADD	ONE,3
	SACL	IM
*;
*; compute pcm output
*;
DO32KA	CALL	PRDICT
*;
*;**********************************************************
*; LINEAR TO A-LAW PCM COMPRESSION/A-LAW TO LINEAR EXPANSION
*;
*;	INPUT:	LINEAR PCM SAMPLE  -- SR
*;
*;	OUTPUT: A-LAW PCM SAMPLE   -- SP  (SCRACH)
*;		LINEAR PCM SAMPLE  -- SLX (SAMPLE)
*;
*;	NOTATION:  SR  -- 16b TC (Q0)
*;		   SP  -- 8b SM (Q4)
*;		   SLX -- 14b TC (Q0)
*;
*;**********************************************************
*;
*;	SR   +----------+	SP    +--------+  SLX
*;    ------>| COMPRESS |-----*------>| EXPAND |------->
*;	     +----------+     |       +--------+
*;			      | 		  SP
*;			      +------------------------>
*;
*;**********************************************************
*;
	LAC	SR	    ; get reconstructed signal
*;
*; compress--convert to pcm
*;
CMPRSA	SACH	SIGN	    ; save sign of SR
	ABS
	ADD	SIGN	    ; add 1 for negative vals
	SACL	SCRACH	    ; save PCM value
	SUB	ONE,9	    ; exp = 7 - 4 or 3 - 0
	BGEZ	SCL4T7
SCL0T3	ADD	THREE,7     ; exp = 3 - 2 or 1 - 0
	BGEZ	SCL2T3
SCL0T1	ADD	ONE,6	    ; exp = 1 or 0
	BGEZ	SCAL1A
SCAL0A	LAC	M15,2	    ; exp = 0
	AND	SCRACH	    ; mask for mantissa
	SACL	SCRACH
	ADD	ONE,1
	SACL	SAMPLE	    ; quantized value
	LAC	SCRACH,14
	LARK	0,0
	B	FINISH
SCAL1A	LAC	M15,2	    ; exp = 1
	AND	SCRACH	    ; mask for mantissa
	SACL	SCRACH
	ADD	BIAS,1
	SACL	SAMPLE	    ; quantized value
	LAC	SCRACH,14
	LARK	0,1
	B	FINISH
SCL2T3	SUB	ONE,7	    ; exp = 3 or 2
	BGEZ	SCAL3A
SCAL2A	LAC	M15,3	    ; exp = 2
	AND	SCRACH	    ; mask for mantissa
	SACL	SCRACH
	ADD	BIAS,2
	SACL	SAMPLE	    ; quantized value
	LAC	SCRACH,13
	LARK	0,2
	B	FINISH
SCAL3A	LAC	M15,4	    ; exp = 3
	AND	SCRACH	    ; mask for mantissa
	SACL	SCRACH
	ADD	BIAS,3
	SACL	SAMPLE	    ; quantized value
	LAC	SCRACH,12
	LARK	0,3
	B	FINISH
SCL4T7	SUB	THREE,9     ; exp = 7 - 6 or 5 - 4
	BGEZ	SCL6T7
SCL4T5	ADD	ONE,10	    ; exp = 5 or 4
	BGEZ	SCAL5A
SCAL4A	LAC	M15,5	    ; exp = 4
	AND	SCRACH	    ; mask for mantissa
	SACL	SCRACH
	ADD	BIAS,4
	SACL	SAMPLE	    ; quantized value
	LAC	SCRACH,11
	LARK	0,4
	B	FINISH
SCAL5A	LAC	M15,6	    ; exp = 5
	AND	SCRACH	    ; mask for mantissa
	SACL	SCRACH
	ADD	BIAS,5
	SACL	SAMPLE	    ; quantized value
	LAC	SCRACH,10
	LARK	0,5
	B	FINISH
SCL6T7	SUB	ONE,11	    ; exp = 7 or 6
	BGEZ	SCAL7A
SCAL6A	LAC	M15,7	    ; exp = 6
	AND	SCRACH	    ; mask for mantissa
	SACL	SCRACH
	ADD	BIAS,6
	SACL	SAMPLE	    ; quantized value
	LAC	SCRACH,9
	LARK	0,6
	B	FINISH
SCAL7A	SUB	ONE,12	    ; exp = 7
	BLZ	NORMLA	    ; mag > 8191 ?
SATCHA	LAC	K63,7
	SACL	SAMPLE	    ; save maximum quantized value
	LACK	127	    ; save maximum alaw magnitude
	B	CLNUPA
NORMLA	LAC	M15,8
	AND	SCRACH	    ; mask for mantissa
	SACL	SCRACH
	ADD	BIAS,7
	SACL	SAMPLE	    ; quanitzed value
	LAC	SCRACH,8
	LARK	0,7
FINISH	SACH	SCRACH	    ; save normalized mantissa
	LAC	SCRACH
	SAR	0,TEMP1
	ADD	TEMP1,4     ; add exponent
CLNUPA	ADD	SIGN,7
	AND	M255
	SACL	SCRACH	    ; signed magnitude of alaw-PCM
	LAC	SAMPLE
	XOR	SIGN
	SUB	SIGN
	SACL	SAMPLE	    ; 2's complement of quantized sample
*;
	CALL	AQUAN
*;
	CALL	SYNC
*;
	XOR	M0080	    ; flip bits for transmission
	SACL	SCRACH
	OUT	SCRACH,DAC  ; output A-law PCM
ALAWR	BIOZ	RCVA	    ; wait for next sample
	B	ALAWR
	.page
*;
*;**********************************************************
*; SYNCHRONOUS CODING ADJUSTMENT
*;
*;	INPUT:	LOG PCM SAMPLE	   -- SP  (SCRACH)
*;		RECEIVED ADPCM	   -- I
*;		REGENERATED ADPCM  -- ID  (TEMP1)
*;
*;	OUTPUT: ADJUSTED LOG PCM   -- SD  (SCRACH)
*;
*;	NOTATION:  I   -- 4b SM (Q0)
*;		   ID  -- 4b SM (Q0)
*;		   SP  -- 8b SM (Q4)
*;		   SD  -- 8b SM (Q4)
*;
*;**********************************************************
*;
*;		    I	 +------+
*;		  ------>|	|
*;		    ID	 |	|   SD
*;		  ------>| SYNC |-------->
*;		    SP	 |	|
*;		  ------>|	|
*;			 +------+
*;
*;**********************************************************
*;
SYNC	XOR	EIGHT
	SACL	TEMP1	    ; flip the polarity bit in ID
	LAC	ONE,3
	XOR	I	    ; flip the polarity bit in I
	SUB	TEMP1	    ; IM - ID
	BLZ	IDGTIM	    ; ID > IM ... -
	BZ	IDEQIM	    ; ID = IM
IDLTIM	LAC	SCRACH	    ; ID < IM ... +
	SUB	M127
	BGZ	SUBONE
	BZ	MAXPOS
	ADD	ONE,7	    ; SD = SP + 1 : 0 <= SP < 127
	RET
MAXPOS	LACK	127	    ; SD = 127	  : SP = 127
	RET
SUBONE	SUB	ONE
	BZ	ANOMLE	    ; SD = 0	  : SP = 128
	ADD	M127	    ; SD = SP + 1 : 255 >= SP > 128
ANOMLE	RET
IDGTIM	LAC	SCRACH
	SUB	ONE,7
	BGEZ	ADDONE
	ADD	M127	    ; SD = SP - 1 : 0 < SP <= 127
	BLZ	ANOMLY
	RET
ADDONE	SUB	M127
	BGEZ	MAXNEG
	ADD	ONE,8	    ; SD = SP - 1 : 255 > SP >= 128
	RET
MAXNEG	LACK	255	    ; SD = 255	  : SP = 255
	RET
ANOMLY	LACK	128	    ; SD = 128	  : SP = 0
	RET
IDEQIM	LAC	SCRACH	    ; SD = SP
	RET
	.page
