unit DisAsm;

interface

uses
  Windows, SysUtils;

Const
      // 6-Bit Opcode
      nem : array[0..63] of String =
       ('special','regimm','j','jal','beq','bne','blez','bgtz',
        'addi','addiu','slti','sltiu','andi','ori','xori','lui',
        'cop0','cop1','cop2',#0,'beql','bnel','blezl','bgtzl',
        'daddi','daddiu','ldl','ldr',#0,#0,#0,#0,
        'lb','lh','lwl','lw','lbu','lhu','lwr','lwu',
        'sb','sh','swl','sw','sdl','sdr','swr','cache',
        'll','lwc1','lwc2',#0,'lld','ldc1','ldc2','ld',
        'sc','swc1','swc2',#0,'scd','sdc1','sdc2','sd');

      nem_mode : array[0..63] of shortint =
      (0,0,2,2,4,4,5,5,
       4,4,4,4,4,4,4,10,
       0,0,0,-1,4,4,5,5,
       4,4,4,4,-1,-1,-1,-1,
       4,4,4,4,4,4,4,4,
       4,4,4,4,4,4,4,0,
       4,4,4,-1,4,4,4,4,
       4,4,4,-1,4,4,4,4);

      // 6-bit special funct
      special : array[0..63] of String =
       ('sll',#0,'srl','sra','sllv',#0,'srlv','srav',
        'jr','jalr',#0,#0,'syscall','break',#0,'sync',
        'mfhi','mthi','mflo','mtlo','dsllv',#0,'dsrlv','dsrav',
        'mult','multu','div','divu','dmult','dmultu','ddiv','ddivu',
        'add','addu','sub','subu','and','or','xor','nor',
        #0,#0,'slt','sltu','dadd','daddu','dsub','dsubu',
        'tge','tgeu','tlt','tltu','teq',#0,'tne',#0,
        'dsll',#0,'dsrl','dsra','dsll32',#0,'dsrl32','dsra32');

      special_mode : array[0..63] of shortint =
        (7,-1,7,7,3,-1,3,3,
         9,8,-1,-1,0,0,-1,0,
         11,12,11,12,3,-1,3,3,
         6,6,6,6,6,6,6,6,
         3,3,3,3,3,3,3,3,
         -1,-1,3,4,3,3,3,3,
         6,6,6,6,6,-1,6,-1,
         7,-1,7,7,7,-1,7,7);

      // 5-bit RT of regimm table a-181
      regimm : array[0..31] of String =
        ('bltz','bgez','bltzl','bgezl',#0,#0,#0,#0,
         'tgei','tgeiu','tlti','tltiu','teqi',#0,'tnei',#0,
         'bltzal','bgezal','bltzall','bgezall',#0,#0,#0,#0,
         #0,#0,#0,#0,#0,#0,#0,#0);

      reg_mode : array[0..31] of shortint =
       (5,5,5,5,-1,-1,-1,-1,
        5,5,5,5,5,-1,5,-1,
        5,5,5,5,-1,-1,-1,-1,
        -1,-1,-1,-1,-1,-1,-1,-1);

      copzrs : array[0..15] of String =
       ('mf','dmf','cf',#0,'mt','dmt','ct',#0,
         'bc',#0,#0,#0,#0,#0,#0,#0);

      copzrt : array[0..7] of String =
       ('bcf','bct','bcfl','bctl',#0,#0,#0,#0);

      cp0 : array[0..31] of String =
        (#0,'tlbr','tlbwi',#0,#0,#0,'tlbwr',#0,
         'tlbp',#0,#0,#0,#0,#0,#0,#0,
         #0,#0,#0,#0,#0,#0,#0,#0,
         'eret',#0,#0,#0,#0,#0,#0,#0);


type
  tDISASM = class
  private
    { Private-Deklarationen }
  public
    // I-Type (Immediate) / J-Type (Jump) / R-Type (Register)
    procedure Set_Buff(Buffer : DWORD);
    procedure Set_Opcode(Src : DWORD);        // All Types 6-bit operation code
    procedure Set_RS(Src : DWORD);            // I-Type & R-Type 5-bit source register
    procedure Set_RT(Src : DWORD);            // I-Type & R-Type 5-bit target register
    procedure Set_Immediate(Src : DWORD);     // I-Type 16-bit immediate
    procedure Set_Target(Src : DWORD);       // J-Type 26-bit jump target address
    procedure Set_RD(Src : DWORD);            // R-Type 5-bit destination register
    procedure Set_SA(Src : DWORD);            // R-Type 5-bit shift amount
    procedure Set_Funct(Src : DWORD);         // R-Type 6-bit function field
    function Get_Opcode : Byte;         // All Types 6-bit operation code
    function Get_RS : Byte;             // I-Type & R-Type 5-bit source register
    function Get_RT : Byte;             // I-Type & R-Type 5-bit target register
    function Get_Immediate : Word;      // I-Type 16-bit immediate
    function Get_Target : DWORD;        // J-Type 26-bit jump target address
    function Get_RD : Byte;             // R-Type 5-bit destination register
    function Get_SA : Byte;             // R-Type 5-bit shift amount
    function Get_Funct : Byte;          // R-Type 6-bit function field
    function Get_Line : String;
    function Get_Line_Formated : String;
  end;

var
     Buff : DWORD;                       // RAW 32 Bit DWORD

implementation

procedure tDISASM.Set_Buff(Buffer : DWORD);
begin
 Buff := Buffer;
end;

procedure tDISASM.Set_Opcode(Src : DWORD);
begin
 Buff := Buff xor (Src shl 26);
end;

procedure tDISASM.Set_RS(Src : DWORD);
begin
 Buff := Buff xor (Src shl 21);
end;

procedure tDISASM.Set_RT(Src : DWORD);
begin
 Buff := Buff xor (Src shl 16);
end;

procedure tDISASM.Set_Immediate(Src : DWORD);
begin
 Buff := Buff xor Src;
end;

procedure tDISASM.Set_Target(Src : DWORD);
begin
 Buff := Buff xor Src;
end;

procedure tDISASM.Set_RD(Src : DWORD);
begin
 Buff := Buff xor (Src shl 11);
end;

procedure tDISASM.Set_SA(Src : DWORD);
begin
 Buff := Buff xor (Src shl 6);
end;

procedure tDISASM.Set_Funct(Src : DWORD);
begin
 Buff := Buff xor Src;
end;

function tDISASM.Get_Funct : Byte;
begin
 Get_Funct := Buff and $3F;
end;

function tDISASM.Get_Opcode : Byte;
begin
 Get_Opcode := Buff and $FC000000 shr 26;
end;

function tDISASM.Get_Target : Dword;
begin
 Get_Target := Buff and $3FFFFFF;
end;

function tDISASM.Get_RS : Byte;
begin
 Get_RS := Buff and $3E00000 shr 21;
end;

function tDISASM.Get_RT : Byte;
begin
 Get_RT := Buff and $1F0000 shr 16;
end;

function tDISASM.Get_RD : Byte;
begin
 Get_RD := Buff and $F800 shr 11;
end;

function tDISASM.Get_Immediate : Word;
begin
 Get_Immediate := Buff and $FFFF;
end;

function tDISASM.Get_SA : Byte;
begin
 Get_SA := Buff and $7C0 shr 6;
end;

function tDISASM.Get_Line : String;
var Temp : String;
begin
 case nem_mode[Get_Opcode] of
   -1 : Temp := 'DD '+IntToHex(Buff,8);
    2 : Temp := nem[Get_Opcode]+' '+IntToHex(Get_Target,8);
    3 : Temp := nem[Get_Opcode]+' '+IntToStr(Get_RD)+' '+IntToStr(Get_RS)+' '+IntToStr(Get_RT);
    4 : Temp := nem[Get_Opcode]+' '+IntToStr(Get_RT)+' '+IntToStr(Get_RS)+' '+IntToHex(Get_Immediate,4);
    5 : Temp := nem[Get_Opcode]+' '+IntToStr(Get_RS)+' '+IntToHex(Get_Immediate,4);
    6 : Temp := nem[Get_Opcode]+' '+IntToStr(Get_RT)+' '+IntToStr(Get_RS);
    7 : Temp := nem[Get_Opcode]+' '+IntToStr(Get_RD)+' '+IntToStr(Get_RT)+' '+IntToStr(Get_SA);
    8 : Temp := nem[Get_Opcode]+' '+IntToStr(Get_RD)+' '+IntToStr(Get_RS);
    9 : Temp := nem[Get_Opcode]+' '+IntToStr(Get_RS);
   10 : Temp := nem[Get_Opcode]+' '+IntToStr(Get_RT)+' '+IntToHex(Get_Immediate,4);
   11 : Temp := nem[Get_Opcode]+' '+IntToStr(Get_RD);
   12 : Temp := nem[Get_Opcode]+' '+IntToStr(Get_RS);
    0 : Case Get_Opcode of
           0 : Case special_mode[Get_Funct] of
                 -1 : Temp := 'DD '+IntToHex(Buff,8);
                  2 : Temp := special[Get_Funct]+' '+IntToHex(Get_Target,8);
                  3 : Temp := special[Get_Funct]+' '+IntToStr(Get_RD)+' '+IntToStr(Get_RS)+' '+IntToStr(Get_RT);
                  4 : Temp := special[Get_Funct]+' '+IntToStr(Get_RT)+' '+IntToStr(Get_RS)+' '+IntToHex(Get_Immediate,4);
                  5 : Temp := special[Get_Funct]+' '+IntToStr(Get_RS)+' '+IntToHex(Get_Immediate,4);
                  6 : Temp := special[Get_Funct]+' '+IntToStr(Get_RT)+' '+IntToStr(Get_RS);
                  7 : Temp := special[Get_Funct]+' '+IntToStr(Get_RD)+' '+IntToStr(Get_RT)+' '+IntToStr(Get_SA);
                  8 : Temp := special[Get_Funct]+' '+IntToStr(Get_RD)+' '+IntToStr(Get_RS);
                  9 : Temp := special[Get_Funct]+' '+IntToStr(Get_RS);
                 10 : Temp := special[Get_Funct]+' '+IntToStr(Get_RT)+' '+IntToHex(Get_Immediate,4);
                 11 : Temp := special[Get_Funct]+' '+IntToStr(Get_RD);
                 12 : Temp := special[Get_Funct]+' '+IntToStr(Get_RS);
                 else Temp := special[Get_Funct];
               end; // of Special
           1 : begin
                if reg_mode[Get_RT]=5 then Temp := regimm[Get_RT]+' '+IntToStr(Get_RS)+' '+IntToHex(Get_Immediate,4)
                 else Temp := 'DD '+IntToHex(Buff,8);
               end;
           else Temp := nem[Get_Opcode];
        end; // of Get_Opcode
 end; // of Opcode
 Get_Line := Temp;
end;

function tDISASM.Get_Line_Formated : String;
var Temp : String;
const
      Pos1 = 1;
      Pos2 = 8;
      Pos3 = 12;
      Pos4 = 16;
begin
 Temp := '            ';
 case nem_mode[Get_Opcode] of
   -1 : begin
         insert('DD',Temp,Pos1);
         insert('0x'+IntToHex(Buff,8),Temp,Pos2);
        end;
    2 : begin
         insert(nem[Get_Opcode],Temp,Pos1);
         insert('0x'+IntToHex(Get_Target,8),Temp,Pos2);
        end;
    3 : begin
         insert(nem[Get_Opcode],Temp,Pos1);
         insert('D'+IntToStr(Get_RD),Temp,Pos2);
         insert('S'+IntToStr(Get_RS),Temp,Pos3);
         insert('T'+IntToStr(Get_RT),Temp,Pos4);
        end;
    4 : begin
         insert(nem[Get_Opcode],Temp,Pos1);
         insert('T'+IntToStr(Get_RT),Temp,Pos2);
         insert('S'+IntToStr(Get_RS),Temp,Pos3);
         insert('0x'+IntToHex(Get_Immediate,4),Temp,Pos4);
        end;
    5 : begin
         insert(nem[Get_Opcode],Temp,Pos1);
         insert('S'+IntToStr(Get_RS),Temp,Pos2);
         insert('0x'+IntToHex(Get_Immediate,4),Temp,Pos3);
        end;
    6 : begin
         insert(nem[Get_Opcode],Temp,Pos1);
         insert('T'+IntToStr(Get_RT),Temp,Pos2);
         insert('S'+IntToStr(Get_RS),Temp,Pos3);
        end;
    7 : begin
         insert(nem[Get_Opcode],Temp,Pos1);
         insert('D'+IntToStr(Get_RD),Temp,Pos2);
         insert('T'+IntToStr(Get_RT),Temp,Pos3);
         insert(','+IntToStr(Get_SA),Temp,Pos4);
        end;
    8 : begin
         insert(nem[Get_Opcode],Temp,Pos1);
         insert('D'+IntToStr(Get_RD),Temp,Pos2);
         insert('S'+IntToStr(Get_RS),Temp,Pos3);
        end;
    9 : begin
         insert(nem[Get_Opcode],Temp,Pos1);
         insert('S'+IntToStr(Get_RS),Temp,Pos2);
        end;
   10 : begin
         insert(nem[Get_Opcode],Temp,Pos1);
         insert('T'+IntToStr(Get_RT),Temp,Pos2);
         insert('0x'+IntToHex(Get_Immediate,4),Temp,Pos3);
        end;
   11 : begin
         insert(nem[Get_Opcode],Temp,Pos1);
         insert('D'+IntToStr(Get_RD),Temp,Pos2);
        end;
   12 : begin
         insert(nem[Get_Opcode],Temp,Pos1);
         insert('S'+IntToStr(Get_RS),Temp,Pos3);
        end;
    0 : Case Get_Opcode of
           0 : Case special_mode[Get_Funct] of
                 -1 : begin
                       insert('DD',Temp,Pos1);
                       insert('0x'+IntToHex(Buff,8),Temp,Pos2);
                      end;
                  2 : begin
                       insert(special[Get_Funct],Temp,Pos1);
                       insert('0x'+IntToHex(Get_Target,8),Temp,Pos2);
                      end;
                  3 : begin
                       insert(special[Get_Funct],Temp,Pos1);
                       insert('D'+IntToStr(Get_RD),Temp,Pos2);
                       insert('S'+IntToStr(Get_RS),Temp,Pos3);
                       insert('T'+IntToStr(Get_RT),Temp,Pos4);
                      end;
                  4 : begin
                       insert(special[Get_Funct],Temp,Pos1);
                       insert('T'+IntToStr(Get_RT),Temp,Pos2);
                       insert('S'+IntToStr(Get_RS),Temp,Pos3);
                       insert('0x'+IntToHex(Get_Immediate,4),Temp,Pos4);
                      end;
                  5 : begin
                       insert(special[Get_Funct],Temp,Pos1);
                       insert('S'+IntToStr(Get_RS),Temp,Pos2);
                       insert('0x'+IntToHex(Get_Immediate,4),Temp,Pos3);
                      end;
                  6 : begin
                       insert(special[Get_Funct],Temp,Pos1);
                       insert('T'+IntToStr(Get_RT),Temp,Pos2);
                       insert('S'+IntToStr(Get_RS),Temp,Pos3);
                      end;
                  7 : begin
                       insert(special[Get_Funct],Temp,Pos1);
                       insert('D'+IntToStr(Get_RD),Temp,Pos2);
                       insert('T'+IntToStr(Get_RT),Temp,Pos3);
                       insert(','+IntToStr(Get_SA),Temp,Pos4);
                      end;
                  8 : begin
                       insert(special[Get_Funct],Temp,Pos1);
                       insert('D'+IntToStr(Get_RD),Temp,Pos2);
                       insert('S'+IntToStr(Get_RS),Temp,Pos3);
                      end;
                  9 : begin
                       insert(special[Get_Funct],Temp,Pos1);
                       insert('S'+IntToStr(Get_RS),Temp,Pos2);
                      end;
                 10 : begin
                       insert(special[Get_Funct],Temp,Pos1);
                       insert('T'+IntToStr(Get_RT),Temp,Pos2);
                       insert('0x'+IntToHex(Get_Immediate,4),Temp,Pos3);
                      end;
                 11 : begin
                       insert(special[Get_Funct],Temp,Pos1);
                       insert('D'+IntToStr(Get_RD),Temp,Pos2);
                      end;
                 12 : begin
                       insert(special[Get_Funct],Temp,Pos1);
                       insert('S'+IntToStr(Get_RS),Temp,Pos2);
                      end;
                 else insert(special[Get_Funct],Temp,Pos1);
               end; // of Special
           1 : begin
                if reg_mode[Get_RT]=5 then
                 begin
                  insert(regimm[Get_RT],Temp,Pos1);
                  insert('S'+IntToStr(Get_RS),Temp,Pos2);
                  insert('0x'+IntToHex(Get_Immediate,4),Temp,Pos3);
                 end
                else
                 begin
                  insert('DD',Temp,Pos1);
                  insert('0x'+IntToHex(Buff,8),Temp,Pos2);
                 end;
               end;
           else insert(nem[Get_Opcode],Temp,Pos1);
        end; // of Get_Opcode
 end; // of Opcode
 Get_Line_Formated := Temp;
end;

end.
