*
* Sample program to demonstrate DASM operation - Plays the HI/LOW game.
*
* You can assemble and run this using the ASMCF assembler and EMCF simulator
* from the Micro-C Embedded compiler test drive (MC???EMB.ZIP) if you like.
*
* A binary image file (HILOW.BIN) is provided, as well as sample symbol (.DEF)
* and comment (.CMT) files. You can re-generate the .BIN file from the .HEX
* file produced by ASMCF with: HEXFMT HILOW.HEX -bt W=HILOW.BIN
*
* The HILOW.DEF file was initially created with DISCF HILOW.BIN -D W=HILOW.DEF
* then manually edited to change symbol names, define data blocks etc.
* The HILOW.CMT file was created manually. These files would normally be
* created, adjusted and "tweeked" as you learn more about the program that
* you are disassembling, until you have final information comparable to that
* contained in these example files.
*
* To disassemble the final file to a listing format source:
*
*    DISCF HILOW.BIN D=HILOW.DEF C=HILOW.CMT A=1000 >HILOW.LST
*
* Get get a file you can re-assemble, add a "-A" option.
*
	ORG	$1000
* First, set initial stack pointer
HILOW	LD	#*		Stack grows backward from here
	TAS			Set initial SP
* Reset target number @ try counter, then prompt with point of game
	CLR			Get zero
	ST	TARGET		Reset target
	ST	TRIES		Reset try counter
	CALL	WRMSG		Output a message
	FCB	$0A,$0D		New line
	FCCZ	"Pick a number between 0 and 65535"
* Get a guess from the user
hilo1	CALL	WRLFCR		New line
	CALL	WRMSG		Output message
	FCCZ	"Please enter guess?" Get message
	CALL	GETNUM		Get a number
	JNZ	hilo2		Incase we happen to hit zero
	DEC			Translate to 65535
hilo2	TAI			Save for later
* Defer setting target number until *AFTER* first guess, so that
* the random number generator will have a change to do it's thing.
	LD	TARGET		Get target value
	SJNZ	hilo3		Don't reset
	LD	RAND		Get random value
	ST	TARGET		Set target value
hilo3	TIA			Get value back
* Check validity of guess
	CMP	TARGET		Does it match?
	SJNZ	hilo6		We found it
	ULT			Is it less than
	SJNZ	hilo4		We are lower
* Guessed too high
	CALL	WRMSG		Output message
	FCCZ	"Too high!"
	SJMP	hilo5		And go again
* Guessed too low
hilo4	CALL	WRMSG		Output message
	FCCZ	"Too low!"
hilo5	LD	TRIES		Get try count
	INC			Advance
	ST	TRIES		Resave
	SJMP	hilo1		Do next try
* He found it! Tell him how many tries & reset
hilo6	CALL	WRMSG		Output
	FCCZ	"Guessed it in "
	LD	TRIES		Get try count
	CALL	WRNUM		Output number
	CALL	WRMSG		Another message
	FCCZ	" tries!"
	JMP	HILOW		Restart
*
* Get a number, return in ACC
*
GETNUM	CALL	WRLFCR		New line
	CLR			Get zero
	PUSHA			Save working number
getn1	LDB	#$0D		Get return
	CALL	WRCHR		Output
	LD	0,S		Get current value
	CALL	WRNUM		Output
	CALL	WRSPC		Clear last digit
	CALL	RDCHR		Get input
	TAI			Save copy
	CMP	#$0D		Enter?
	SJNZ	getn4		Handle it
	TIA			Restore number
	CMP	#$08		Backspace
	SJNZ	getn3		Handle it
	TIA			Get number back
	SUBB	#'0'		Comvert to binary
	TAI			Save for later
	CMP	#10		Are we over
	ULT			In range?
	SJNZ	getn2		Yes, handle it
	LDB	#7		Get beep
	CALL	WRCHR		Output
	SJMP	getn1		And proceed
* Digit entered - add to number
getn2	LD	0,S		Get number
	MULB	#10		Make room for digit
	ADAI			Add to index
	STI	0,S		Resave new value
	SJMP	getn1		And proceed
* Backspace - remove lowest digit
getn3	LD	0,S		Get number
	DIVB	#10		Hack off low digit
	ST	0,S		Resave
	SJMP	getn1		And proceed
* Enter, newline & exit
getn4	CALL	WRLFCR		New line
	LD	S+		Get value
	RET
*
* Display number in ACC
*
WRNUM	LDI	#0		Get zero
	PUSHI			Mark start
wrnum1	DIVB	#10		Divide number by 10
	TAI			Save result
	ALT			Get remainder
	ADDB	#'0'		Convert to ASCII
	PUSHA			Save on stack
	TIA			Get number back
	SJNZ	wrnum1		Keep going
wrnum2	LD	S+		Get value to display
	SJZ	goret		End of line - exit
	CALL	WRCHR		output
	SJMP	wrnum2		Do next digit
*
* Read character from console.
*
* While waiting, continuously increment RAND variable
* to generate pseudo-random number.
*
RDCHR	LD	RAND		Get value
	INC			Increment
	ST	RAND		Resave
	IN	0		Read console port
	INC			Test for character
	SJZ	RDCHR		Wait for character
	DEC			Restore proper character
	RET
*
* Write message (PC) to console
*
WRMSG	LDI	S+		Get string pointer
	CALL	WRSTR		Output the string
	PUSHI			Set new return address
	RET			Execute at end of string
*
* Write string (INDEX) to console
*
WRSTR	LDB	I		Get char
	LEAI	1,I		Advance to next
	SJZ	goret		End, exit
	CALL	WRCHR		Output it
	SJMP	WRSTR		And continue
*
* Write a space to the console
*
WRSPC	LDB	#' '		Get space
	SJMP	WRCHR		Output
*
* Write line-feed/carriage return to console
*
WRLFCR	LDB	#$0A		Get LF
	CALL	WRCHR		Output
	LDB	#$0D		Get CR
*
* Output 'raw' character to console: putchr(c)
*
WRCHR	OUT	0		Write to console
goret	RET
*
* DATA areas
*
RAND	RMB	2		pseudo-Random number
TARGET	RMB	2		Target value we are looking for
TRIES	RMB	2		Count of # tries
