;===========================================================================
;INSTCMD.ASM
;
;Installable Command module. Allows you to extend or customise DOS by
;installing memory-resident command handlers. You can add new commands,
;or change the behaviour of existing ones (including Dos internal
;commands).
;
;Code released to the Public Domain, Darryl Luff 1995.
;
;===========================================================================

MODEL TINY
IDEAL
JUMPS
LOCALS

GROUP dgroup _TEXT, _DATA, BoosterSeg

CAPTUREINT  = 2Fh

DEBUGMSG_   = 0     ;1 to enable debugging messages
FAKETSR_    = 0     ;1 to avoid TSR call and do dummy Inst cmd calls,

COMMANDARGS equ 80h ;offset of command line arguments

INCLUDE "INSTCMD.INC"
INCLUDE "UTILS.INC"

;Installable command functions
;-----------------------------
icFUNC  = 0AEh      ;The INT 2Fh function that DOS calls.
icCHECK = 0AE00h    ;check if command is installed
icEXEC  = 0AE01h    ;execute the command

CODESEG
    EXTRN   cmd_Install:Near, cmd_Check:Near, cmd_Exec:Near, cmd_Mux:Near
    EXTRN   cmd_Setup:Near, cmd_Shutdown:Near
    PUBLIC  disabled, muxFunc, muxSig

    STARTUPCODE
    push cs
    pop ds
    jmp Booster

;resident data
disabled        db  0
int2FInstalled  db  0
myPSP           dw  ?
muxFunc         db  ?   ;'I'
muxSig          dw  ?   ;'IC'

oldInt2F        dw  ?,?

IF DEBUGMSG_
; DEBUGGING MESSAGES
    Capture2F    db 'Int 2Fh captured', CR, LF, '$'
    Release2F    db 'Int 2Fh released', CR, LF, '$'
    SetTSRPSP    db 'Switching to TSR''s PSP', CR, LF, '$'
    SetTSRParent db 'Setting TSR''s parent', CR, LF, '$'
    SetTSRTerm   db 'Setting TSR''s termination address', CR, LF, '$'
    TerminateTSR db 'Terminating TSR', CR, LF, '$'
ENDIF

IF FAKETSR_
    ;dummy command lines
    BADCMD      db  128, 5, 'BADDY'
    BADCMDLINE  db  128, 10, 'baddy jack'

    GOODCMD     db  128, 5, 'GOODY'
    GOODCMDLINE db  128, 10, 'goody fred'
ENDIF

Chain2F:
    jmp [dword ptr cs:oldInt2F]

Int2FHandler:
    cmp [cs:disabled], 1
    je Chain2F

    cmp ax, icCHECK
    je CheckCmd

    cmp ax, icEXEC
    je ExecCmd

    cmp ah, [cs:muxFunc]
    jne Chain2F
    cmp bx, [cs:muxSig]
    jne Chain2F

    ;call is for us
    cmp al, muxINSTCHK
    je doInstallCheck
    cmp al, muxREMOVE
    je doDeinstallCheck

    ;unknown function - call user-defined routine
    call cmd_Mux    ;sets al (return code)
    mov cx, [cs:muxSig]
    mov bx, cs
    iret

doInstallCheck:
    mov al, muxOK
    mov cx, [cs:muxSig]
    mov bx, [cs:myPSP]  ;TSR's PSP
    iret

doDeinstallCheck:
    push ds
    push es

    ;check if interrupts have been changed
    mov ax, 352Fh
    int 21h
    cmp bx, offset Int2FHandler
    jne Cant2F
    mov ax, es
    mov bx, cs
    cmp ax, bx
    jne Cant2F

    ;de-install int 2F handler
    lds dx, [dword ptr cs:oldInt2F]
    mov ax, 252Fh
    int 21h

    IF DEBUGMSG_
        push cs
        pop ds
        Write Release2F
    ENDIF
    mov [cs:Int2FInstalled], 0

Cant2F:
    mov [cs:Disabled], 1

    mov al, muxOK
    cmp [cs:int2FInstalled], 0
    je Out2F

Cant:
    mov al, muxFAIL
Out2F:
    cmp al, muxFAIL
    je @@NoGood
      call cmd_Shutdown
      mov al, muxOK
      jnc @@L1
        mov al, muxFAIL
      @@L1:
      jmp cuOut

    @@NoGood:
    call cmd_Shutdown
    mov al, muxFAIL

    cuOut:
    mov cx, [cs:muxSig]
    mov bx, [cs:myPSP]      ;PSP
    pop es
    pop ds
    iret

CheckCmd:
    ;save regs
    push ds
    push es
    push dx
    push bx
    push si

    ;check string with command
    call cmd_Check
    jc NotUs

    ;restore regs and return
    pop si
    pop bx
    pop dx
    pop es
    pop ds

    mov al, 0FFh    ;mark command as ours
    iret

    Notus:
    pop si
    pop bx
    pop dx
    pop es
    pop ds
    jmp Chain2F

ExecCmd:
    ;save regs
    push ds
    push es
    push dx
    push bx
    push si

    call cmd_Exec

    pop si
    pop bx
    pop dx
    pop es
    pop ds

    iret
ENDS

SEGMENT BoosterSeg Byte Public 'CODE'
PUBLIC Booster
Booster:
    call cmd_Setup
    ;get PSP
    mov ah, 62h
    int 21h
    mov [cs:myPSP], bx
    mov ds, bx              ;ds = PSP seg

    ;convert buffer to upper case
    mov si, 81h
    mov cl, [80h]
    xor ch, ch
    push cx
    UpStr       ;convert cx chars at ds:si to upper case
    pop cx

    mov si, COMMANDARGS
    lodsb
    mov cl, al
    xor ch, ch      ;cx = characters in command line
    cmp cx, 0
    jne CheckArgs
    jmp ShowTitle

CheckArgs:
      lodsb
      cmp al, '-'
      je CheckSwitch
      cmp al, '/'
      je CheckSwitch
    caNext:
    loop CheckArgs
    jmp ShowTitle

CheckSwitch:
    lodsb
    dec cx
    cmp al, 'R'
    je Remove
    cmp al, 'U'
    je Remove
    jmp caNext

Remove: ;check if a copy is installed, and terminate it.
    mov ah, [cs:muxFunc]
    mov al, muxREMOVE
    mov bx, [cs:muxSig]
    int 2fh             ;check for install and remove

    cmp cx, [cs:muxSig]
    jne NotInstalled

    cmp al, muxOK
    je CanRemove

    ;installed, but can't remove
    push cs
    pop ds
    Write CantRemoveMsg
    mov ax, 4c01h
    int 21h

CanRemove:
    ;is there, bx should equal PSP of TSR.
    cmp bx, [cs:muxSig]
    je NotInstalled

    ;bx holds PSP of TSR.
    mov es, bx

    ;set TSR's parent to us
    mov ax, [cs:myPSP]
    mov [word ptr es:pspPARENT], ax
    IF DEBUGMSG_
        push ds
        push cs
        pop ds
        Write SetTSRParent
        pop ds
    ENDIF

    ;set TSR's termination address
    mov ax, cs
    mov [word ptr es:pspTERMINATE+2], ax
    mov ax, offset TSRRemoveEntry
    mov [word ptr es:pspTERMINATE], ax
    IF DEBUGMSG_
        push ds
        push cs
        pop ds
        Write SetTSRTerm
        pop ds
    ENDIF

    ;set current PSP to the TSR
    mov bx, es
    mov ah, 50h
    int 21h
    IF DEBUGMSG_
        push ds
        push cs
        pop ds
        Write SetTSRPSP
        Write TerminateTSR
        pop ds
    ENDIF

    ;terminate the TSR
    mov ax, 4c00h
    int 21h

    ;if control returns here, OOPS!
    push cs
    pop ds
    Write ShitMsg

    ;set PSP back to here
    push cs
    pop bx
    mov ah, 50h

    ;exit and hope for the best
    mov ax, 4C01h
    int 21h

TSRRemoveEntry: ;after the TSR de-installs, control returns here
    ;now the TSR is removed, exit normally
    push cs
    pop ds
    Write TSRGoneMsg

    ;set PSP back to here
    push cs
    pop bx
    mov ah, 50h

    mov ax, 4c00h
    int 21h

NotInstalled:
    push cs
    pop ds
    Write NotThereMsg
    mov ax, 4c01h
    int 21h

ShowTitle:
    push cs
    pop ds
    jmp Install

Help:
    push cs
    pop ds
    mov ax, 4c00h
    int 21h

Install:
    ;check if already installed
    mov ah, [cs:muxFunc]
    mov al, muxINSTCHK
    mov bx, [cs:muxSig]
    IF NOT FAKETSR_
      int CAPTUREINT          ;check for install and remove
    ENDIF

    cmp cx, [cs:muxSig]
    jne NotThere

    push cs
    pop ds
    Write IsInstalledMsg    ;already installed, abort.
    mov ax, 4C02h
    int 21h

NotThere:
    push cs
    pop ds

    call cmd_Install
    jnc InstallIt
        mov ax, 4C04h
        int 21h

    InstallIt:
    ;disable first
    mov [disabled], 1

    ;free environment seg
    mov ax, [myPSP]
    mov es, ax      ;psp segment
    mov ax, [es:pspENVSEG]
    mov es, ax
    mov ah, 49h
    int 21h

    ;store original handler
    mov ax, 3500h + CAPTUREINT
    int 21h
    mov [oldInt2F], bx
    mov ax, es
    mov [oldInt2F+2], ax

    ;setup new handler
    mov ax, 2500h + CAPTUREINT
    mov dx, offset Int2FHandler
    int 21h
    mov [cs:int2FInstalled], 1
    IF DEBUGMSG_
        push cs
        pop ds
        Write Capture2F
    ENDIF

    ;re-enable
    mov [cs:disabled], 0

    IF FAKETSR_
      ;do a dummy call.
      TrashRegs
      mov ax, cs
      mov ds, ax
      mov es, ax
      mov bx, offset BADCMDLINE
      mov si, offset BADCMD
      mov ax, icCHECK
      int CAPTUREINT
      cmp al, 0FFh
      jne @@Next
        mov ax, icEXEC
        int CAPTUREINT
      @@Next:
      ;now try good one
      TrashRegs
      mov ax, cs
      mov ds, ax
      mov es, ax
      mov bx, offset GOODCMDLINE
      mov si, offset GOODCMD
      mov ax, icCHECK
      int CAPTUREINT
      cmp al, 0FFh
      jne @@Next2
        mov ax, icEXEC
        int CAPTUREINT
      @@Next2:

      ;put the interrupt back
      lds dx, [dword ptr oldInt2F]
      mov ax, 2500h + CAPTUREINT
      int 21h

      IF DEBUGMSG_
        push cs
        pop ds
        Write Release2F
      ENDIF

      mov ax, 4C01h
      int 21h
    ELSE
      ;calculate memory to save.
      mov dx, offset Booster
      mov cl, 4
      shr dx, cl        ;convert to paragraphs
      add dx, 10h       ;add some for PSP
      inc dx            ;and some for luck!
      mov ax, 3100h
      int 21h
    ENDIF

@@GetOut:
    mov ah, 4Ch
    int 21h

CantRemoveMsg   db  'Program can''t be removed. It has been de-activated.'
                db  CR, LF, '$'

NotThereMsg db  'Program is not installed.', CR, LF, '$'

IsInstalledMsg  db  'Program is already installed - aborting!', CR, LF, '$'

ShitMsg     db  'This isn''t supposed to happen!', CR, LF
            db  'If you see this message, something is terribly wrong', CR, LF
            db  'with this program!', CR, LF, '$'

TSRGoneMsg  db  'Program unloaded.', CR, LF, '$'
ENDS BoosterSeg
END

