; SaveCMOS - A program to save an image of the CMOS into CMOS.IMG
;
; Written by Inbar Raz, released to the public domain.

        model   tiny
        .code

        org     00100h

Start:  jmp     Begin

CMOSSize        dw      ?
Handle          dw      ?
FileName        db      'CMOS.IMG', 0

Begin:  mov     ah,03Ch
        xor     cx,cx           ; No attribute
        mov     dx,offset FileName
        int     021h

        mov     Handle,ax

        mov     CMOSSize,040h

        ; First, check wether we have 64 or 128 CMOS cells

        mov     al,080h
        call    ReadCmos
        mov     ah,al
        mov     al,0C0h
        call    ReadCmos

        cmp     al,ah
        je      GotSize

        mov     al,001h
        call    ReadCmos
        mov     ah,al
        add     al,0C1h
        call    ReadCmos

        cmp     al,ah
        je      GotSize

        mov     CMOSSize,080h

        ; Now we got the CMOS size determined. Read it.

GotSize:

        xor     bx,bx

NextCell:

        mov     al,bl
        call    ReadCmos
        mov     byte ptr [bx+offset CMOSBuffer],al

        inc     bx
        cmp     bx,CMOSSize
        jne     NextCell

        ; Reading the CMOS is done. Write it.

        mov     ah,040h
        mov     bx,Handle
        mov     cx,CMOSSize
        mov     dx,offset CMOSBuffer
        int     021h

        mov     ah,03Eh
        int     021h

        ; Exit program

Exit:   mov     ah,04Ch
        int     021h

;
;                              SUBROUTINE
;
;
; This procedure reads a CMOS register in AL. Value is put back in AL.
;

ReadCmos        proc    near

                xchg    bx,bx
                out     70h,al

                jcxz    short $+2
                jcxz    short $+2

                xchg    bx,bx
                in      al,71h

                jcxz    short $+2
                jcxz    short $+2

                retn

ReadCmos        endp

CMOSBuffer      Label   Byte

        end     Start

---------------------------------= cut here =---------------------------------

; LoadCMOS - A program to load an image of the CMOS from CMOS.IMG
;
; Written by Inbar Raz, released to the public domain.

        model   tiny
        .code

        org     00100h

Start:  jmp     Begin

CMOSSize        dw      ?
Handle          dw      ?
FileName        db      'CMOS.IMG', 0

Begin:  mov     ax,03D00h
        mov     dx,offset FileName
        int     021h

        mov     bx,ax
        mov     ah,03Fh
        mov     cx,0FFFFh
        mov     dx,offset CMOSBuffer
        int     021h

        mov     CMOSSize,ax             ; Actual bytes read

        mov     ah,03Eh
        int     021h

        xor     bx,bx

NextCell:

        mov     al,bl
        mov     ah,byte ptr [bx+offset CMOSBuffer]
        call    WriteCmos

        inc     bx
        cmp     bx,CMOSSize
        jne     NextCell

        ; Exit program

Exit:   mov     ah,04Ch
        int     021h

;
;                              SUBROUTINE
;
;
; This procedure writes a CMOS register in AL, with the value in AH.
;

WriteCmos       proc    near

                nop

                out     70h,al                  ; port 70h, CMOS addr,bit7=NMI

                jcxz    short $+2
                jcxz    short $+2

                xchg    al,ah
                out     71h,al                  ; port 71h, CMOS data

                jcxz    short $+2
                jcxz    short $+2

                retn

WriteCmos       endp


CMOSBuffer      Label   Byte

        end     Start

