; From Robert Pouliot - Findfile, leaves path/filename in buffer.
;
        MODEL small,C
        STACK 100h
        JUMPS
        p286
        IDEAL

CODESEG

start:
        mov ax,@data
        mov ds,ax
        mov si,OFFSET File
        mov di,OFFSET buffer
        call FindFile C, si, di
        mov ax,4C00h
        int 21h

PROC    FindFile
ARG     FileName:WORD,Dest:WORD

        push es si di

        push ds
        pop es
        mov di,OFFSET level
        mov cx,11
        xor ax,ax
        rep stosw               ; The init, level=0, tab=all 0...

        mov ah,2Fh
        int 21h                 ; Get DTA in ES:BX

@@LP1:
        mov ah,4Eh              ; FindFirst
        mov cx,32               ; All+ attrib: Archive
        mov dx,[FileName]
        int 21h
        jnc @@Trouve            ; FileFound? Yep, let's go...
@@LP02:
        mov ah,4Eh              ; FindFirst
        mov cx,30h              ; All+ attrib: Archive, Directory
        mov dx,OFFSET DirName
        int 21h
        jc @@Back
@@LP2:
        cmp [BYTE es:bx+1Eh],'.'        ; Is dir '.' or '..'
        je @@Cont2                      ; Yep, so skip that...
        test [BYTE es:bx+15h],16        ; Is this a directory?
        jnz @@Cont1                     ; Yep, so continue...
@@Cont2:
        mov ah,4Fh              ; FindNext
        int 21h
        jc @@Back               ; Error, no more files...
        jmp @@LP2               ; Go check file (or dir)...
@@Cont1:
        mov si,[level]          ; Get level number...
        add si,si               ; Double it...
        mov cx,[tab+si]         ; Get the nth element...
@@LP3:
        jcxz @@Found            ; Is it the 1st? or 0 to search...
        mov ah,4Fh
        int 21h                 ; FindNext
        jc @@Back               ; Error, go back...
        test [BYTE es:bx+15h],16        ; Is it dir?
        jz @@LP3                ; Nop, so loop...
        dec cx
        jnz @@LP3               ; 1 thing left to check...
@@Found:
        inc [tab+si]            ; Increase, the nth number to check...
        inc [level]             ; 1 level more...

        push ds
        push es
        pop ds
        mov dx,bx
        mov ah,3Bh      ; Change to dir...
        add dx,1Eh
        int 21h
        pop ds
        jmp @@LP1
@@Back:
        cmp [level],0   ; Level is 0 now?
        je @@Bad        ; Yep, so it's the end, not found...
        mov si,[level]  ; Get current level...
        add si,si
        mov [tab+si],0  ; Return nth element to 0...
        dec [level]     ; 1 level less...
        mov ah,3Bh
        mov dx,OFFSET BackDir
        int 21h         ; "CD .."
        jmp @@LP02      ; Continue to search...
@@Bad:
        xor ax,ax       ; Return 0: FALSE
        pop di si es
        ret
@@Trouve:
        mov ah,19h      ; Get current drive...
        int 21h
        mov ah,':'
        add al,'A'      ; Convert AX to 'C:' like...
        mov si,[Dest]   ; Get destination...
        mov [si],ax     ; Store value...
        add si,2
        mov [BYTE si],'\'       ; Store the '\'
        inc si
        mov ah,47h
        int 21h         ; Get current dir in DS:SI...
        cmp [BYTE si],0 ; If it's 0 at SI, it's root dir, so
        je @@PatchName  ; don't add another '\' ex: 'C:\\'
@@FindZero:
        lodsb
        or al,al
        jnz @@FindZero          ; Find the 0...
        mov [BYTE si-1],'\'     ; Add the '\'
@@PatchName:
        mov bx,[FileName]
@@Patch1:
        mov al,[bx]
        mov [si],al
        inc si
        inc bx
        or al,al                ; Patch the filename with 0, at end of
        jnz @@Patch1            ; full filename...

        mov cx,[level]
        mov dx,OFFSET BackDir
@@LP5:
        jcxz @@Fin              ; Return to starting dir...
        mov ah,3Bh
        int 21h
        loop @@LP5
@@Fin:
        mov ax,1                ; Return NON-ZERO: TRUE...
        pop di si es
        ret
        
ENDP    FindFile

DATASEG

file    db "DIR-SRCH.ASM",0
BackDir db '..',0
dirname db '*.*',0
level   dw ?
tab     dw 10 dup (?)
buffer  db 80 dup (?)

END     start

