;
; READCD3.ASM, PROGRAMMED BY JEFFRY JOHNSTON, 1995
;
; SOME CODE FROM 'Peter Norton's Assembly Language Book for the IBM PC,
; REVISED AND EXPANDED', written by Peter Norton and John Socha,
; Copyright 1989 by Brady Books.
;
CODE_SEG        SEGMENT
        ASSUME  CS:CODE_SEG, DS:CODE_SEG ; points CS:xx and DS:xx at CODE_SEG
        ORG     100h                     ; leave space at beginning of program
BEGIN:  JMP     MAIN_PROGRAM            
        USAGE   DB      'Written by Jeffry Johnston, 1995',0Dh,0Ah
                DB      'Usage: READCD3 X:, where X: is the CD-ROM '
                DB      'drive letter.',0Dh,0Ah,'$'
        MSCDEX  DB      'MSCDEX not installed!',0Dh,0Ah,'$'
        OUTLINA DB      'Read CD -- Version 3.00, Programmed by Jeffry Johnston',0
        OUTLINB DB      'CD-ROM Drive= :',0
        OUTLINC DB      'Sector          (2048 bytes), Page ( /8)',0
        OUTLIND DB      ' Home=Beg of disk  End=End of disk  F2=Change sector number',0                                
        OUTLINE DB      ' ESC=Exit  PgDn=Forward  PgUp=Back  F3=Changed CD-ROM   F10=Change drive letter',0        
        OUTLINF DB      '0123456789ABCDEF',0
        OUTLING DB      'Enter CD-ROM Drive ID - [ ]',0          
        OUTLINH DB      'Valid letters are A thru Z.',0          
        OUTLINI DB      'Press ESC to return',0               
        OUTLINJ DB      'End=End of disk',0
        OUTLINK DB      'Enter new sector - [     ]',0          
        OUTLINL DB      'Valid input is A thru F and 0 - 9.',0
        NEWSECT DB      '     ',0
        NEWPOS  DW      0
        CURTOP  DB      ?
        CURBOT  DB      ?
        SECHIGH DW      ?                ; XXXX: space for the sector number
        SECLOW  DW      ?                ; :XXXX space for the sector number
        SECPAGE DB      ?                ; page (1, 2, 3,..., 8)
        DRIVE   DW      ?                ; memory space for the drive number
        LETTER  DB      ?                ; Drive as a letter
        DISPLAY DW      ?                ; pointer to the screen memory        
        LOCY    DB      ?                ; 1-25, used to set position
        LOCX    DB      ?                ; 1-80, used to set position
        LOCATION DW     ?                ; location of cursor (0-1999)
        COLOR   DB      ?                ; Color to print with
        NUMCHAR DB      ?                ;
        PUSHEDOK DB     ?
        ERROROT DB      'Error occured while reading CD-ROM',0
        PATTER1 DB      '',1,'',12,'',1,'',11,'',1,'',11,'',1,'',12
                DB      '',1,'',18,'',1,0
        PATTER2 DB      '',1,'',12,'',1,'',11,'',1,'',11,'',1,'',12
                DB      '',1,'',18,'',1,0
        PATTER3 DB      '',1,'',39,'',1,0
        PATTER4 DB      '',1,' ',39,'',1,0
        PATTER5 DB      '',1,'',39,'',1,0
        TABLE   DB      47h
                DW      OFFSET HOME
                DB      49h
                DW      OFFSET PAGEUP
                ;DB      4Fh        *********************
                ;DW      OFFSET IND *********************
                DB      51h
                DW      OFFSET PAGEDOWN
                DB      3Ch
                DW      OFFSET F2
                DB      3Dh
                DW      OFFSET F3
                DB      44h
                DW      OFFSET F10
                DB      0
;--------d-2F1508-------------------------------------------;                 
;INT 2F - CD-ROM - ABSOLUTE DISK READ                       ;   
;        AX = 1508h                                         ;   
;        ES:BX -> buffer                                    ;   
;        CX = drive number (0=A:)                           ;   
;        SI:DI = starting sector number                     ;   
;        DX = number of sectors to read                     ;   
;Return: CF set on error                                    ;   
;            AL = error code (15=invalid drive,21=not ready);   
;        CF clear if successful                             ;   
;-----------------------------------------------------------;
MAIN_PROGRAM    PROC    NEAR
        Assume  CS:CODE_SEG, DS:nothing
        MOV     AX,1100h
        PUSH    [0DADAh]
        INT     2Fh
        POP     BX
        CMP     AL,0FFh
        JZ      MSCDEX_INSTALLED
        MOV     AH,09
        LEA     DX,MSCDEX
        INT     21h
        INT     20h             ; MSCDEX not installed, so exit
MSCDEX_INSTALLED:
        CALL    GET_COMMAND_LINE        
        CALL    INIT
        JMP     SECTOR_LOOP
MAIN_PROGRAM    ENDP
;--------------------------------------------------------------------------;
;Initializes screen, sets page, gets mono/color, SECHIGH:SECLOW = 0000:0000;
;--------------------------------------------------------------------------;
INIT            PROC    NEAR
        Assume  CS:CODE_SEG, DS:nothing
                                ; Flight Unlimited gives a max sector of
        MOV     SECHIGH,0       ; 3/4343=3h/10F7h=310F7h=200951 sectors,
        MOV     SECLOW,0        ; 200951*2048=411547648410136260 (DIR /S)
        MOV     SECPAGE,49      ; Page 1 (49='1')
        MOV     AX,0003h
        INT     10h             ; 80x25 color mode
        MOV     AX,0500h
        INT     10h             ; Go to display page 0
        INT     11h             ; Get equipment list
        MOV     DISPLAY,0B800h
        AND     AL,30h          
        CMP     AL,30h          ; Is it a mono display?
        JNZ     NOT_MONO
        MOV     DISPLAY,0B000h  ; Yes, change pointer 
NOT_MONO:
        MOV     AH,03h
        MOV     BH,0
        INT     10h             ; Get cursor size (and position)
        MOV     CURTOP,CH
        MOV     CURBOT,CL
        MOV     AX,0103h
        MOV     CH,20h          ; 00100000b (cursor invisible)
        MOV     CL,0
        INT     10h             ; Set text mode cursor shape
        RET
INIT            ENDP        
;--------------------------------------------------;
; Main loop, will keep looping until exit or error ;
;--------------------------------------------------;
SECTOR_LOOP     PROC    NEAR
        Assume  CS:CODE_SEG, DS:nothing
        CALL    SCREEN_OUTLINE
        CALL    READ_SECTOR
        CALL    DISPLAY_SECTOR
        CALL    USER_INPUT
        JMP     SECTOR_LOOP
SECTOR_LOOP     ENDP
;Read CD -- Version 3.00                                                         
;
;CD-ROM Drive=E:                      Sector 0000:0000 (2048 bytes), Page (1/8)                                           
;                                     
;            00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F   0123456789ABCDEF
;          Ŀ    
;     0000  FE 23 FE 25 FE 27 FE 29 FE 2B FE 2D FE 2F FE 31  #%')+-/1 
;     0010  FE 34 FE 36 FE 38 FE 3A FE 3C FE 3E FE 40 FE 42  468:<>@B 
;     0020  FE 44 FE 46 FE 48 FE 4A FE 4C FE 4F FE 51 FE 53  DFHJLOQS 
;     0030  FE 55 FE 57 FE 59 FE 5C FE 5E FE 60 FE 62 FE 64  UWY\^`bd 
;     0040  FE 67 FE 69 FE 6B FE 6D FE 6F FE 72 FE 74 FE 76  gikmortv 
;     0050  FE 79 FE 7B FE 7D FE 7F FE 82 FE 84 FE 86 FE 89  y{} 
;     0060  FE 8B FE 8D FE 90 FE 92 FE 95 FE 97 FE 99 FE 9C   
;     0070  FE 9E FE A1 FE A3 FE A5 FE A8 FE AA FE AD FE AF   
;     0080  FE 00 00 00 00 00 00 00 00 00 00 00 00 01 01 01                  
;     0090  01 01 01 01 01 01 01 01 01 02 02 02 02 02 02 02   
;     00A0  02 02 02 02 02 03 03 03 03 03 03 03 03 03 03 03   
;     00B0  03 04 04 04 04 04 04 04 04 04 04 04 04 05 05 05   
;     00C0  05 05 05 05 05 05 05 05 05 06 06 06 06 06 06 06   
;     00D0  06 06 06 06 06 07 07 07 07 07 07 07 07 07 07 07   
;     00E0  07 00 01 02 03 04 05 06 07 08 09 0A 0B 00 01 02                  
;     00F0  03 04 05 06 07 08 09 0A 0B 00 01 02 03 04 05 06              
;          
; Home=Beg of disk  End=End of disk  F2=Change sector number                                
; ESC=Exit  PgDn=Forward  PgUp=Back  F3=Changed CD-ROM   F10=Change drive letter    
SCREEN_OUTLINE  PROC    NEAR
        Assume  CS:CODE_SEG, DS:nothing
        MOV     AX,0600h
        MOV     BH,07h
        MOV     CX,0
        MOV     DX,184Fh
        INT     10h             ; Clear screen
        MOV     COLOR,47        ; Bright white on green
        MOV     LOCATION,0      ; 1,1  
        MOV     CX,160
        MOV     DL,32
        CALL    WRITE_CHAR_N_TIMES
        MOV     LOCATION,0      ; 1,1       
        LEA     DX,OUTLINA
        CALL    PRINT
        MOV     COLOR,47        ; white on green
        MOV     LOCATION,160    ; 2,1    
        MOV     CX,80
        MOV     DL,196
        CALL    WRITE_CHAR_N_TIMES
        MOV     COLOR,7
        MOV     LOCATION,320    ; 3,1
        LEA     DX,OUTLINB
        CALL    PRINT
        MOV     LOCATION,396    ; 3,39
        LEA     DX,OUTLINC
        CALL    PRINT
        MOV     LOCATION,346    ; 3,14
        MOV     DL,LETTER
        CALL    WRITE_CHAR
        MOV     LOCATION,410    ; 3,46
        MOV     CX,SECHIGH
        MOV     DL,CH
        CALL    WRITE_HEX
        MOV     DL,CL
        CALL    WRITE_HEX
        MOV     LOCATION,418    ; 3,49
        MOV     CX,SECLOW          
        MOV     DL,CH               
        CALL    WRITE_HEX
        MOV     DL,CL
        CALL    WRITE_HEX
        MOV     LOCATION,468    ; 3,75
        MOV     DL,SECPAGE
        CALL    WRITE_CHAR
        MOV     COLOR,31        ; Bright white on blue
        MOV     LOCATION,3680   ; 24,1       
        MOV     CX,160
        MOV     DL,32
        CALL    WRITE_CHAR_N_TIMES
        MOV     COLOR,23        ; white on blue
        MOV     LOCATION,3680   ; 24,1               
        LEA     DX,OUTLIND       
        CALL    PRINT
        MOV     LOCATION,3840   ; 25,1            
        LEA     DX,OUTLINE       
        CALL    PRINT
        MOV     COLOR,24        ; grey on blue ********
        MOV     LOCATION,3718   ; 24,20 ***************              
        LEA     DX,OUTLINJ      ; ********************* 
        CALL    PRINT           ; *********************
        MOV     COLOR,7         ; white
        MOV     LOCATION,980    ; 7,11
        MOV     DL,179
        DOWN_MORE:
        CALL    WRITE_CHAR
        ADD     LOCATION,100
        CALL    WRITE_CHAR
        ADD     LOCATION,38
        CALL    WRITE_CHAR
        ADD     LOCATION,22    
        CMP     LOCATION,3540   ; (23,11)
        JL      DOWN_MORE
        MOV     LOCATION,820    ; 6,11
        LEA     DX,PATTER1
        CALL    WRITE_PATTERN
        MOV     LOCATION,3540   ; 23,11
        LEA     DX,PATTER2
        CALL    WRITE_PATTERN
        MOV     LOCATION,970    ; 7,6
        MOV     BH,0
        MOV     BL,SECPAGE
        SUB     BL,49
        MOV     AX,256
        MUL     BX
        MOV     BX,AX
NEXT_NUM_DOWN:
        MOV     DL,BH
        CALL    WRITE_HEX
        MOV     DL,BL
        CALL    WRITE_HEX
        ADD     BX,16
        ADD     LOCATION,152
        CMP     LOCATION,3380   ; (22,11)
        JL      NEXT_NUM_DOWN                             
        MOV     LOCATION,664    ; 5,13
        MOV     DL,0
NEXT_NUM_ACROSS:
        CALL    WRITE_HEX
        ADD     LOCATION,2
        INC     DL
        CMP     DL,16
        JL      NEXT_NUM_ACROSS
        MOV     LOCATION,764    ; 5,63
        LEA     DX,OUTLINF
        CALL    PRINT
        RET
SCREEN_OUTLINE  ENDP
;---------------------------------------------------;
; WRITE_CHAR                                        ;
; COLOR=color, LOCATION=location, DL=character      ;
;---------------------------------------------------;
WRITE_CHAR      PROC    NEAR    
        Assume  CS:CODE_SEG, DS:nothing
        PUSH    AX
        PUSH    BX
        PUSH    DX
        PUSH    ES
        MOV     AX,DISPLAY
        MOV     ES,AX           ; ES:DI destination (screen)
        MOV     BX,AX
        MOV     DH,COLOR
        MOV     BX,LOCATION
        MOV     ES:[BX],DX      ; Move byte (cool!)
        POP     ES
        POP     DX
        POP     BX
        POP     AX
        RET
WRITE_CHAR      ENDP   
;-----------------------------;
; PRINT                       ;
; DS:DX=Start of ASCIZ string ;
;-----------------------------;
PRINT           PROC    NEAR
        Assume  CS:CODE_SEG, DS:nothing
        PUSH    AX
        PUSH    DX
        PUSH    SI
        PUSHF
        CLD
        MOV     SI,DX           ; DS:SI = Source (DS:DX)
STRING_LOOP:
        LODSB                   ; Puts character into AL
        CMP     AL,0
        JZ      END_OF_STRING
        MOV     DL,AL
        CALL    WRITE_CHAR      ; Print character
        ADD     LOCATION,2
        JMP     STRING_LOOP
END_OF_STRING:
        POPF
        POP     SI
        POP     DX
        POP     AX
        RET
PRINT           ENDP
WRITE_HEX       PROC    NEAR
        Assume  CS:CODE_SEG, DS:nothing
        PUSH    CX
        PUSH    DX
        MOV     DH,DL
        MOV     CX,4
        SHR     DL,CL
        CALL    WRITE_HEX_DIGIT
        ADD     LOCATION,2
        MOV     DL,DH
        AND     DL,0Fh
        CALL    WRITE_HEX_DIGIT
        ADD     LOCATION,2
        POP     DX
        POP     CX
        RET
WRITE_HEX       ENDP
WRITE_HEX_DIGIT PROC    NEAR
        Assume  CS:CODE_SEG, DS:nothing
        PUSH    DX
        CMP     DL,9
        JG      HEX_LETTER
        ADD     DL,48
        JMP     WRITE_DIGIT
HEX_LETTER:
        ADD     DL,55
WRITE_DIGIT:
        CALL    WRITE_CHAR
        POP     DX
        RET
WRITE_HEX_DIGIT ENDP
WRITE_PATTERN   PROC    NEAR
        Assume  CS:CODE_SEG, DS:nothing
        PUSH    AX
        PUSH    CX
        PUSH    DX
        PUSH    SI
        PUSHF
        CLD
        MOV     SI,DX
PATTERN_LOOP:
        LODSB
        CMP     AL,0
        JZ      END_PATTERN
        MOV     DL,AL
        LODSB
        MOV     CL,AL
        MOV     CH,0
        CALL    WRITE_CHAR_N_TIMES
        JMP     PATTERN_LOOP
END_PATTERN:
        POPF
        POP     SI
        POP     DX
        POP     CX
        POP     AX
        RET
WRITE_PATTERN   ENDP
WRITE_CHAR_N_TIMES PROC NEAR   
        Assume  CS:CODE_SEG, DS:nothing
        PUSH    CX
N_TIMES:
        CALL    WRITE_CHAR
        ADD     LOCATION,2
        LOOP    N_TIMES
        POP     CX
        RET
WRITE_CHAR_N_TIMES ENDP
READ_SECTOR     PROC    NEAR
        Assume  CS:CODE_SEG, DS:nothing
        MOV     AX,1508h        ; Function 1508h      
        MOV     CX,DRIVE        ; drive number CX
        MOV     DX,0001h        ; transfer DX sectors
        MOV     SI,SECHIGH
        MOV     DI,SECLOW       ; starting at sector SI:DI
        LEA     BX,SECTOR       ; ES:BX -> SECTOR (where to put the data
                                ;                  in memory)
        INT     2Fh             ; sector read from CD-ROM
        JNC     NO_ERROR 
        CALL    PRINT_ERROR     ; There was an error so display it
NO_ERROR:
        RET                     ; No error or error displayed...
SECTOR_LOOP     ENDP
PRINT_ERROR     PROC    NEAR
        Assume  CS:CODE_SEG, DS:nothing
        MOV     COLOR,4
        MOV     LOCATION,524   ; 4,23
        LEA     DX,ERROROT
        CALL    PRINT
        MOV     COLOR,7
        RET
PRINT_ERROR     ENDP
DISPLAY_SECTOR  PROC    NEAR
        Assume  CS:CODE_SEG, DS:nothing
        MOV     BH,0
        MOV     BL,SECPAGE
        SUB     BL,49
        MOV     AX,256
        MUL     BX
        MOV     BX,AX
        MOV     SI,0
        MOV     DI,0
        MOV     LOCATION,984    ; 7,13
        MOV     CX,1084         ; 7,63
DISP_NEXT_BYTE:
        MOV     DL,SECTOR[BX]
        CALL    WRITE_HEX
        PUSH    LOCATION
        MOV     LOCATION,CX
        CALL    WRITE_CHAR
        POP     LOCATION
        ADD     CX,2
        ADD     LOCATION,2
        INC     BX
        INC     SI
        CMP     SI,16
        JL      DISP_NEXT_BYTE
        ADD     CX,128
        ADD     LOCATION,64
        MOV     SI,0
        ADD     DI,16
        CMP     DI,256
        JL      DISP_NEXT_BYTE
        RET
DISPLAY_SECTOR  ENDP
; Home=Beg of disk  End=End of disk  F2=Change sector number                                
; ESC=Exit  PgDn=Forward  PgUp=Back  F3=Changed CD-ROM   F10=Change drive letter    
USER_INPUT      PROC    NEAR
        Assume  CS:CODE_SEG, DS:nothing
        MOV     AH,02h         
        MOV     BH,0     
        MOV     DX,0 
        INT     10h             ; Go to upper left.
        KEEP_CHECKING:
        CALL    GET_KEYSTROKE
        ; ESC=01h, Home=47h, End=4Fh, PgUp=49h, PgDn=51h 
        ; F2=3Ch, F3=3Dh, F10=44h
        CMP     AH,01h
        JZ      ESCAPE
        LEA     BX,TABLE
SPECIAL_LOOP:
        CMP     BYTE PTR [BX],0
        JZ      KEEP_CHECKING   ; None of the above..
        CMP     AH,[BX]
        JZ      DISPATCH
        ADD     BX,3
        JMP     SPECIAL_LOOP
DISPATCH:
        MOV     PUSHEDOK,0
        INC     BX
        CALL    WORD PTR [BX]
        CMP     PUSHEDOK,1
        JZ      KEEP_CHECKING
        RET
USER_INPUT      ENDP
ESCAPE  PROC    NEAR            ; EXIT
        Assume  CS:CODE_SEG, DS:nothing
        MOV     AX,0103h
        MOV     CH,CURTOP
        MOV     CL,CURBOT
        INT     10h             ; Restore cursor
        MOV     AX,0600h
        MOV     BH,07h
        MOV     CX,0
        MOV     DX,184Fh
        INT     10h             ; Clear screen
        INT     20h             ; EXIT !
ESCAPE  ENDP
;                    22222222233333333334444444444555555555566
;                    12345678901234567890123456789012345678901 
;                    10,21ͻ                   
;                      Enter new sector - [21D0E]                              
;                                                                              
;                      Valid input is A thru F and 0 thru 9.                   
;                      Press ESC to return                                     
;                    15,21ͼ                   
F2      PROC    NEAR            ; Change sector
        Assume  CS:CODE_SEG, DS:nothing
        MOV     NEWPOS,0
        MOV     NEWSECT[0],32
        MOV     NEWSECT[1],32
        MOV     NEWSECT[2],32
        MOV     NEWSECT[3],32
        MOV     NEWSECT[4],32
        CALL    DRAW_BOX
        MOV     LOCATION,1646   ; 11,24
        LEA     DX,OUTLINK
        CALL    PRINT
        MOV     LOCATION,1966   ; 13,24
        LEA     DX,OUTLINL
        CALL    PRINT
DRAW_INPUT:
        MOV     LOCATION,1686   ; 11,44
        LEA     DX,NEWSECT
        CALL    PRINT
INPUT_LOOP:        
        CALL    GET_KEYSTROKE
        CMP     AH,1             
        JNZ     WASNT_ESC       
        RET                     ; ESC, GO BACK 
WASNT_ESC:        
        CMP     AH,1Ch
        JNZ     WASNT_ENTER
        CMP     NEWPOS,5
        JNZ     WASNT_ENTER
        CALL    PROCESS_DATA
        RET
WASNT_ENTER:
        CMP     AH,53h
        JNZ     WASNT_DEL
DELETE: 
        CMP     NEWPOS,0
        JZ      INPUT_LOOP
        DEC     NEWPOS
        MOV     BX,NEWPOS
        MOV     [NEWSECT+BX],32
        JMP     DRAW_INPUT
WASNT_DEL:
        CMP     AH,0Eh
        JZ      DELETE
        CMP     NEWPOS,4
        JG      INPUT_LOOP
        CMP     AL,48
        JL      INPUT_LOOP
        CMP     AL,102
        JG      INPUT_LOOP
        CMP     AL,57
        JG      A_THRU_F
        MOV     BX,NEWPOS
        MOV     [NEWSECT+BX],AL
        INC     NEWPOS
        JMP     DRAW_INPUT
A_THRU_F:
        CMP     AL,97
        JGE     LOWER_CASE
        CMP     AL,70
        JG      INPUT_LOOP
        CMP     AL,65
        JL      INPUT_LOOP
UPPER_CASE:        
        MOV     BX,NEWPOS
        MOV     [NEWSECT+BX],AL
        INC     NEWPOS
        JMP     DRAW_INPUT
LOWER_CASE:        
        SUB     AL,32
        JMP     UPPER_CASE
F2      ENDP
PROCESS_DATA    PROC    NEAR
        Assume  CS:CODE_SEG, DS:nothing
        MOV     DH,0
        MOV     SECLOW,0
        MOV     DL,NEWSECT[0]
        SUB     DL,48
        CMP     DL,17
        JL      ISNT_A_LETTER
        SUB     DL,7
ISNT_A_LETTER:
        MOV     SECHIGH,DX
        MOV     BX,4
        MOV     CX,1
GOODIE_LOOP:        
        MOV     AX,CX
        MOV     DL,NEWSECT[BX]
        SUB     DL,48
        CMP     DL,17
        JL      ISNT_A_LETTER_EITHER
        SUB     DL,7
ISNT_A_LETTER_EITHER:
        MUL     DX
        ADD     SECLOW,AX
        DEC     BX
        MOV     AX,10h
        MUL     CX
        MOV     CX,AX
        CMP     CX,0    ; 10000h=0h, so test for 0
        JNZ     GOODIE_LOOP ; 10h,100h,1000h,10000h(0)!
        RET
PROCESS_DATA    ENDP
F3      PROC    NEAR            ; Reread (changed CD's)
        Assume  CS:CODE_SEG, DS:nothing
        RET
F3      ENDP
DRAW_BOX PROC   NEAR
        Assume  CS:CODE_SEG, DS:nothing
        MOV     COLOR,79        ; Bright white on red
        MOV     LOCATION,1480   ; 10,21
        LEA     DX,PATTER3
        CALL    WRITE_PATTERN
        MOV     CX,4
        MOV     LOCATION,1640   ; 11,21 
        LEA     DX,PATTER4
DRIVE_BOX:
        CALL    WRITE_PATTERN
        ADD     LOCATION,78   
        LOOP    DRIVE_BOX       ; -> 14,21
        MOV     LOCATION,2280   ; 15,21
        LEA     DX,PATTER5
        CALL    WRITE_PATTERN
        MOV     LOCATION,2126   ; 14,24
        LEA     DX,OUTLINI
        CALL    PRINT
        RET
DRAW_BOX ENDP
;                    22222222233333333334444444444555555555566
;                    12345678901234567890123456789012345678901 
;                    10,21ͻ                   
;                      Enter CD-ROM Drive ID - [E]                             
;                                                                              
;                      Valid letters are A thru Z.                             
;                      Press ESC to return                                     
;                    15,21ͼ                   
GET_KEYSTROKE   PROC    NEAR
WAITING_FOR_KEY:
        Assume  CS:CODE_SEG, DS:nothing
        MOV     AH,01h
        INT     16h             ; Check for keystroke
        JZ      WAITING_FOR_KEY
        MOV     AH,0
        INT     16h             ; Get keystroke, AH=Scan code
        RET     
GET_KEYSTROKE   ENDP
F10     PROC    NEAR            ; Change drive letter
        Assume  CS:CODE_SEG, DS:nothing
        CALL    DRAW_BOX
        MOV     LOCATION,1646   ; 11,24
        LEA     DX,OUTLING
        CALL    PRINT
        MOV     LOCATION,1966   ; 13,24
        LEA     DX,OUTLINH
        CALL    PRINT
CURRENT_SELECTION:        
        MOV     LOCATION,1696   ; 11,49
        MOV     DL,LETTER
        CALL    WRITE_CHAR
KEY_LOOP:
        CALL    GET_KEYSTROKE
        CMP     AH,1Ch
        JNZ     NOT_ENTER
        MOV     BH,0
        MOV     BL,LETTER
        SUB     BL,65
        MOV     DRIVE,BX
        RET
NOT_ENTER:
        CMP     AH,1
        JNZ     NOT_ESC
        MOV     BX,DRIVE
        ADD     BL,65
        MOV     LETTER,BL
        RET                     ; ESC=GO BACK
NOT_ESC:
        CMP     AL,65
        JL      KEY_LOOP
        CMP     AL,90
        JG      KEY_LOOP
        MOV     LETTER,AL
        JMP     CURRENT_SELECTION
F10     ENDP
HOME    PROC    NEAR            ; Go to beginning of CD
        Assume  CS:CODE_SEG, DS:nothing
        MOV     SECHIGH,0
        MOV     SECLOW,0
        MOV     SECPAGE,49
        RET
HOME    ENDP
PAGEUP  PROC    NEAR            ; decrease sector
        Assume  CS:CODE_SEG, DS:nothing
        CMP     SECPAGE,49
        JZ      PAGE_AT_1       ; Can we just go a page?
        DEC     SECPAGE         ; Yes, decrease page
        RET
PAGE_AT_1:        
        CMP     SECLOW,0        ; No.  Is low word at 0
        JNZ     SECLOW_OK
        CMP     SECHIGH,0       ; Yes.  How about high.
        JNZ     LOW_MO          ; If ZERO, already at lowest sector.
        MOV     PUSHEDOK,1      ; already at lowest sector.
        RET
LOW_MO:        
        DEC     SECHIGH         ; No, so sub one from high
        MOV     SECLOW,0FFFFh   ; and set low to ffff
        JMP     LOWNEXT
SECLOW_OK:
        DEC     SECLOW          ; low word wasnt at 0 so sub 1
LOWNEXT:        
        MOV     SECPAGE,56      ; set page to 8
        RET
PAGEUP  ENDP
IND     PROC    NEAR            ; ???? (Go to end of disk) ????
        Assume  CS:CODE_SEG, DS:nothing
        RET
IND     ENDP
PAGEDOWN PROC   NEAR            ; increase sector
        Assume  CS:CODE_SEG, DS:nothing
        CMP     SECPAGE,56
        JZ      PAGE_AT_8       ; Can we just go a page?
        INC     SECPAGE         ; Yes, INC page
        RET
PAGE_AT_8:        
        CMP     SECLOW,0FFFFh   ; No.  Is low word at ffff?
        JNZ     SECLOW_OK2
        CMP     SECHIGH,0FFFFh  ; Yes.  How about high.
        JNZ     DOHMOE          ; If ZERO, already at highest possible sector.
        MOV     PUSHEDOK,1      ; ALREADY AT HIGHEST POSSIBLE SECTOR..
        RET
DOHMOE:        
        INC     SECHIGH         ; No, so ADD one TO high
        MOV     SECLOW,0000     ; and set low to 0
        JMP     LOWNEXT2
SECLOW_OK2:
        INC     SECLOW          ; low word wasnt at 8 so add 1
LOWNEXT2:        
        MOV     SECPAGE,49      ; set page to 1
        RET
PAGEDOWN        ENDP
GET_COMMAND_LINE        PROC    NEAR
        Assume  CS:CODE_SEG, DS:nothing
        ; Info on command line base:
        ; ex: READSEC ac1d
        ; location xxxx:005D would contain: AC1D (upper case)
        ; location xxxx:0082 would contain: ac1d (as typed from dos)
        MOV     AX,[005Dh]      ; xxxx:005D is where the command line begins
        MOV     LETTER,AL
        MOV     AH,0
        MOV     DRIVE,AX        ; A=65,B=66,...Z=90    
        CMP     DRIVE,65
        JL      DRIVE_LETTER
        CMP     DRIVE,90
        JG      DRIVE_LETTER
        SUB     AX,65           
        MOV     DRIVE,AX        ; A=0000h,B=0001h,C=0002h,E=0004h,S=0012h etc..           
        RET
DRIVE_LETTER:
        MOV     AH,09h
        LEA     DX,USAGE
        INT     21h
        INT     20h
GET_COMMAND_LINE        ENDP
        SECTOR  DB      ?       ; memory space saved for the sector             
CODE_SEG        ENDS
END     BEGIN

