; **********************************
; *** ST21R.ASM, by Chuck Martin ***
; **********************************

; This file assembles under WASM 1.0 to produce ST21R.COM, a TSR which
; forces the Seagate ST21R RLL controller to install itself, along with
; any attached drives, and performs the necessary steps to allow DOS to
; access those drives.  It provides INT 13h support, and uses DOS's own
; built-in disk device driver.  It was written to run under MS-DOS 5.0,
; but will probably work under any version of MS-DOS from 4.0 on.  It will
; probably also work for the Seagate ST21M MFM controller, and possibly
; even the ST22R and ST22M, although the floppy drives on the latter two
; won't be enabled.  The current version only works for one Primary DOS
; partition per drive.  All other partitions will be ignored.

; Before running this program, make sure the LASTDRIVE= statement in your
; CONFIG.SYS file is large enough to accomodate the extra drive(s).  Place
; ST21R.COM in your AUTOEXEC.BAT file as early as possible, before any
; disk caches and before MSCDEX.EXE if you have a CD-ROM drive.


; The following EQUates are pointers to temporary variables used during
; the initialization phase of the TSR which are stored in the PSP.

LAST_PHYS_DR  EQU    26H             ; Offset of last physical drive #
LAST_LOG_DR   EQU    27H             ; Offset of last logical drive #
BUFFERPTR     EQU    28H             ; Offset of word pointer to buffer at
                                     ;    end of program
PARTITION     EQU    2AH             ; Offset of pointer to partition data
                                     ;    within sector buffer


              PROC   NEAR                 ; Make all RETs near RETs


; First, we check if ST21R.COM has already been installed, and if so, we
; don't allow it to try to install itself again.

              PUSH   DS                   ; Save DS
              MOV    AX,0D800H            ; Get RLL BIOS segment in DS
              MOV    DS,AX
              TEST   BYTE [3F8EH],0FFH    ; Is ST21R already installed?
              POP    DS                   ; Restore DS
              JNZ    QUIT                 ; If already installed, we're
                                          ;    done


; The next section of the program is a relocator which moves the whole
; program except for the relocator and installation check down into the
; PSP at offset 32H.

              MOV    AX,OFFSET INIT       ; Push start address of init.
              PUSH   AX                   ;    code on stack
              MOV    CX,OFFSET END - 32H  ; Get size of prog. minus this
                                          ;    routine in CX
              MOV    SI,OFFSET FIRSTBYTE  ; Start of code to be moved
              MOV    DI,32H               ; Move it into PSP
              REP
              MOVSB
              RET

; The RET above is actually overwritten during the move, but is being
; executed out of the prefetch queue, and in the process, it forces the
; prefetch queue to be flushed and reloaded before continuing at INIT.


; QUIT is only executed if ST21R.COM has been found to have already been
; run once so that a second copy won't remain resident.

QUIT          MOV    AX,4C01H             ; Exit with Return Code of 1
              INT    21H


FIRSTBYTE     ORG    32H                  ; Reset WASM's internal PC

; The new INT 13h handler begins here:

INT13         STI                         ; Enable interrupts
              PUSH   DS                   ; Save registers
              PUSH   ES
              PUSH   AX
              MOV    AX,0D800H            ; Get RLL BIOS segment in ES
              MOV    ES,AX
              XOR    AX,AX                ; Set DS to zero
              MOV    DS,AX
              TEST   DL,80H               ; Is this a hard drive?
              JZ     {TOINT13.1}          ; No, go to original handler
              AND    DL,7FH               ; Yes, clear bit 7
              SEG    CS
              CMP    DL,OTHERHDS          ; Is it on 1st controller
                                          ;    (IDE)?
              JB     TOINT13.1HD          ; Yes, turn bit 7 back on and
              SEG    CS                   ;    go to original handler
              SUB    DL,OTHERHDS          ; No, tell RLL handler it's
                                          ;    drive C or D
              OR     DL,80H               ; Turn bit 7 back on
              SEG    CS
              MOV    AX,RLL1              ; Store far pointer to 1st
              MOV    [0104H],AX           ;    RLL parameter table in
              SEG    CS                   ;    INT 41H vector
              MOV    AX,RLL1 + 2
              MOV    [0106H],AX
              SEG    CS
              MOV    AX,RLL2              ; Store far pointer to 2nd
              MOV    [0118H],AX           ;    RLL parameter table in
              SEG    CS                   ;    INT 46H vector
              MOV    AX,RLL2 + 2
              MOV    [011AH],AX
              POP    AX                   ; Restore registers
              POP    ES
              POP    DS
              SEG    CS
              JMP    DWORD INT13.2        ; Jump to RLL INT 13H Handler

{TOINT13.1}   JMPS   TOINT13.1            ; Springboard to orig.
                                          ;    INT 13H handler

TOINT13.1HD   OR     DL,80H               ; Turn bit 7 of drive # on
              SEG    CS
              MOV    AX,IDE1              ; Store far pointer to 1st
              MOV    [0104H],AX           ;    IDE parameter table in
              SEG    CS                   ;    INT 41H vector
              MOV    AX,IDE1 + 2
              MOV    [0106H],AX
              SEG    CS
              MOV    AX,IDE2              ; Store far pointer to 2nd
              MOV    [0118H],AX           ;    IDE parameter table in
              SEG    CS                   ;    INT 41H vector
              MOV    AX,IDE2 + 2
              MOV    [011AH],AX
TOINT13.1     POP    AX                   ; Restore registers
              POP    ES
              POP    DS
              SEG    CS                   ; Jump to original INT 13h
              JMP    DWORD INT13.1        ;    handler


OTHERHDS      DB     0               ; # of HDs on 1st controller

INT13.1       DW     0,0             ; Far ptr. to orig. (IDE) INT 13H
                                     ;    handler
INT13.2       DW     0,0             ; Far ptr. to ST21R (RLL) INT 13H
                                     ;    handler

IDE1          DW     0,0             ; Far ptr. to 1st IDE parameter table
IDE2          DW     0,0             ; Far ptr. to 2nd IDE parameter table

RLL1          DW     0,0             ; Far ptr. to 1st RLL parameter table
RLL2          DW     0,0             ; Far ptr. to 2nd RLL parameter table

DRIVEDATA     DW     -1,-1           ; RLL drive data table
              DB     0,0             ; Physical unit #, logical drive #
                                     ; ----------------------------------
              DW     200H            ; Beginning of BPB, bytes per sector
              DB     0FFH            ; Sectors per cluster (FF = unknown)
              DW     1               ; Reserved sectors
              DB     2               ; # of FATs
              DW     200H            ; # of root directory entries = 512
              DW     0               ; Total # of sectors Ŀ
              DB     0F8H            ; Media descriptor for HD 
              DW     0               ; Sectors per FAT         
              DW     0               ; Sectors per track       
              DW     0               ; # of heads              
              DW     0,0             ; # of hidden sectors     
              DW     0,0             ; # of sectors if 0 above  End BPB
                                     ; ---------------------------------
              DB     0               ; Bit 6: 0 = 12 bit FAT
                                     ;        1 = 16 bit FAT
              DB     0,0             ; Device-open count
              DB     5               ; Device type (5 = HD)
              DW     0221H           ; Bit flags for drive
              DW     0               ; # of cylinders
              DS     19H             ; BPB for highest capacity supported
              DW     0,0,0           ; Reserved
              DB     0FFH            ; Last track accessed
              DW     1               ; Always 1 for DOS 5+
              DW     0               ; Partition start cylinder
              DB     'NO NAME    ',0 ; Volume label, null terminated
              DW     0,0             ; Serial #
              DB     'FAT12   ',0    ; Filesystem type, null terminated

              DS     21H             ; RLL Drive Parameter Block (DPB)


; This is where the initialization phase of the program begins, and is the
; entry point where control is passed after the initial relocation into
; the PSP at offset 32H.

INIT          PUSH   DS                   ; Save DS and ES
              PUSH   ES
              MOV    AX,0D800H            ; Get RLL BIOS segment in ES
              MOV    ES,AX
              XOR    AX,AX
              MOV    DS,AX                ; Set DS to zero
              SEG    ES                   ; Restore memory locations
              MOV    [3F8CH],AL           ;    altered by ST21R error
              SEG    ES                   ;    routine, retrieving total
              XCHG   [3F80H],AL           ;    # of HDs in the process
              SUB    AL,[0475H]           ; Subtract # of IDE HDs, which
              SEG    ES                   ;    leaves the # of RLL HDs
              MOV    [3F8EH],AL           ; Store it in ST21R data area
              MOV    AL,[0475H]           ; Save # of IDE HDs
              SEG    CS
              MOV    OTHERHDS,AL
              SEG    ES
              ADD    AL,[3F8EH]           ; Add # of RLL HDs
              MOV    [0475H],AL           ; Save total in BIOS data area
              MOV    AX,[0104H]           ; Save far pointer to 1st IDE
              SEG    CS                   ;    parameter table (found in
              MOV    IDE1,AX              ;    INT 41H vector)
              MOV    AX,[0106H]
              SEG    CS
              MOV    IDE1 + 2,AX
              MOV    AX,[0118H]           ; Save far pointer to 2nd IDE
              SEG    CS                   ;    parameter table (found in
              MOV    IDE2,AX              ;    INT 46H vector)
              MOV    AX,[011AH]
              SEG    CS
              MOV    IDE2 + 2,AX
              PUSH   WORD [4EH]           ; Save DOS' INT 13h handler
              PUSH   WORD [4CH]           ;    on stack
              PUSH   CS                   ; Push far pointer to where
              MOV    AX,OFFSET CONTINUE   ;    we want to return after
              PUSH   AX                   ;    installation is complete
              DB     60H                  ; PUSHA (ST21R needs this
              CLD                         ;    to finish installation)
              PUSH   DS                   ; Save DS and ES
              PUSH   ES
              MOV    AX,CS                ; Save 512 bytes from
              MOV    ES,AX                ;    0000:7C00 so ST21R can
              MOV    SI,7C00H             ;    use this area as a
              MOV    DI,OFFSET END        ;    temporary buffer
              MOV    CX,100H
              REP
              MOVSW
              POP    DS                   ; Restore DS and ES, but in
              POP    ES                   ;    reverse order (for ST21R)
              JMP    01BAH,0D800H         ; Force ST21R to install itself
                                          ; Return to CONTINUE when done

; After the ST21R has finished installing itself, it will return here.
; Now all we have to do is tie up the loose ends, change the INT 13h
; vector to our own handler, and make DOS aware of the new drive(s).

CONTINUE      PUSH   DS                   ; Save DS and ES
              PUSH   ES
              MOV    AX,CS                ; Restore 512 bytes back to
              MOV    DS,AX                ;    0000:7C00
              MOV    SI,OFFSET END
              MOV    DI,7C00H
              MOV    CX,100H
              REP
              MOVSW
              POP    DS                   ; Restore DS and ES in reverse
              POP    ES                   ;    order
              MOV    AX,[0104H]           ; Save far pointer to 1st RLL
              SEG    CS                   ;    parameter table (found in
              MOV    RLL1,AX              ;    INT 41H vector)
              MOV    AX,[0106H]
              SEG    CS
              MOV    RLL1 + 2,AX
              MOV    AX,[0118H]           ; Save far pointer to 2nd RLL
              SEG    CS                   ;    parameter table (found in
              MOV    RLL2,AX              ;    INT 46H vector)
              MOV    AX,[011AH]
              SEG    CS
              MOV    RLL2 + 2,AX
              MOV    AX,[4CH]             ; Save RLL INT 13h handler
              SEG    CS
              MOV    INT13.2,AX
              MOV    AX,[4EH]
              SEG    CS
              MOV    INT13.2 + 2,AX
              POP    WORD [4CH]           ; Restore DOS' INT 13h handler
              POP    WORD [4EH]           ;    from stack

; The following section of code will hook INT 13h without disabling the
; filter(s) inserted ahead of the original BIOS handler by DOS.  If the
; INT 13h handler is hooked in any other way, the system will likely halt
; with a Memory Allocation Error after formatting a drive.

              MOV    AH,13H               ; Get addr. to restore INT 13h
              INT    2FH                  ;    to on system halt or warm
                                          ;    boot in ES:BX and old
                                          ;    INT 13h handler in DS:DX
              SEG    CS
              MOV    INT13.1,DX           ; Save old INT 13h handler
              SEG    CS
              MOV    INT13.1 + 2,DS
              MOV    AX,CS                ; Point DS:DX to new INT 13h
              MOV    DS,AX                ;    handler (leave ES:BX as
              MOV    DX,OFFSET INT13      ;    it was)
              MOV    AH,13H               ; Give these addresses back to
              INT    2FH                  ;    DOS

; Our new INT 13h handler is now active, and can be used to access all
; hard drives.  DOS is still unaware that the new drives exist, however.

              MOV    AX,0803H             ; Get pointer to first drive
              INT    2FH                  ;    data table in DS:DI
NEXTTABLE     MOV    AX,[DI + 4]          ; Get physical drive # in AL,
                                          ;    logical drive # in AH
              LDS    DI,[DI]              ; Get pointer to next table
              INC    DI                   ; If the offset is 0FFFFh,
              JZ     FOUNDLAST            ;    then exit this loop
              DEC    DI
              JMPS   NEXTTABLE            ; Else, repeat
FOUNDLAST     SEG    CS                   ; Save last physical drive
              MOV    WORD [LAST_PHYS_DR],AX ;  and last logical drive
              MOV    BX,OFFSET END        ; Place sector buffer at end
              SEG    CS                   ;    of code
              MOV    [BUFFERPTR],BX       ;
              MOV    BX,OFFSET DRIVEDATA  ; Set up first RLL HD
              CALL   PRIDOSSETUP
              SEG    ES
              MOV    AL,[3F8EH]           ; How many RLL HDs are there?
              DEC    AL
              JZ     DONE                 ; If only one, we're done
              CALL   PRIDOSSETUP          ; Else, set up the other RLL HD
DONE          POP    ES                   ; Restore DS and ES
              POP    DS
              SEG    CS
              MOV    ES,[2CH]             ; Free environment block
              MOV    AH,49H
              INT    21H
              MOV    DX,BX                ; Get end of resident portion
              DEC    DX                   ;    and convert to paragraphs
              DB     0C1H,0EAH,4          ; SHR DX,4
              INC    DX
              MOV    AX,3100H             ; Terminate and Stay Resident
              INT    21H                  ;    (TSR)


; The PRIDOSSETUP subroutine searches for the first Primary DOS Partition,
; and if one is found, a logical drive is created.

PRIDOSSETUP   PUSH   ES                   ; Save ES
              MOV    AX,CS                ; Point DS and ES to this
              MOV    DS,AX                ;    segment
              MOV    ES,AX
              MOV    WORD [PARTITION],01BEH ; Start with 1st partition
              MOV    [BX + 2],CS          ; Ptr. to next table = CS:FFFF
              INC    BYTE [LAST_PHYS_DR]  ; Add 1 to last physical drive #
NEXTPART      MOV    DL,[LAST_PHYS_DR]    ; Get last phys. drive # in DL
              MOV    DI,BX                ; Save table offset in DI
              MOV    AX,0201H             ; Prepare to read 1 sector
              MOV    CX,1                 ; Start at track 0 sector 1
              XOR    DH,DH                ; Head 0
              MOV    BX,[BUFFERPTR]       ; Point BX to sector buffer
              INT    13H                  ; Read Master Boot Record
              MOV    SI,[PARTITION]       ; Point SI to partition data
              MOV    AL,[BX + SI + 4]     ; Get File System ID in AL
              CMP    AL,1                 ; Is this a Primary DOS
              JE     SHIFTUP              ;    partition (System ID =
              CMP    AL,4                 ;    1, 4, or 6)?  Make room for
              JE     SHIFTUP              ;    another table and DPB if so
              CMP    AL,6
              JE     SHIFTUP
              MOV    BX,DI                ; Not a Primary DOS partition,
                                          ;    so get table offset back
                                          ;    in BX
              ADD    WORD [PARTITION],10H ; Point to next partition
              CMP    WORD [PARTITION],01FEH ; Is there another partition?
              JNE    NEXTPART             ; Loop if yes
              POP    ES                   ; Else restore ES and return to
              RET                         ;    main program


; The following section of the program shifts the unused table, Drive
; Parameter Block (DPB), and all the code which follows it (the part that
; doesn't stay resident after the initialization is finished), plus the
; sector buffer which follows the code, and which currently contains the
; Master Boot Record, up by 85H bytes, which is the size of the table and
; DPB, effectively creating a second unused table and DPB.  This upward
; shift of code and data is repeated for each valid DOS partition.

SHIFTUP       PUSH   SI                   ; Save SI
              MOV    SI,BX                ; Point SI to end of sector
              ADD    SI,200H              ;    buffer (200H bytes past
              MOV    CX,SI                ;    end of code)
              SUB    CX,DI                ; CX = # of bytes to shift
              PUSH   DI                   ; Save DI
              LEA    DI,[SI + 85H]        ; Shift it up 85H bytes (size of
              ADD    BX,85H               ;    table + DPB)
              MOV    [BUFFERPTR],BX       ; Adjust sector buffer pointer
              MOV    DX,BX                ; Point DX to shifted offset of
              SUB    DX,OFFSET END - OFFSET RETURN ;    RETURN
              PUSH   DX                   ; Save it on stack for RET
              STD                         ; Shift begins at top
              REP                         ; Do the shift (shifts table,
              MOVSB                       ;    DPB, Init code, and buffer)
              RET                         ; Return to new offset of RETURN

RETURN        CLD                         ; CLD avoids problems with DOS
              POP    DI                   ;    batch file handling
              POP    SI                   ; Restore SI and DI
              MOV    BP,SP                ; Adjust address for return from
              ADD    WORD [BP + 2],85H    ;    SETUP routine (on stack)
              CMP    AL,1                 ; Is System ID = 1?
              JE     FAT12                ; Skip FAT16 setup if so
FAT16         MOV    BYTE [DI + 1FH],40H  ; Set 16 bit FAT flag bit
              MOV    BYTE [DI + 5FH],'6'  ; Change 'FAT12' to 'FAT16'
FAT12         MOV    DL,[LAST_PHYS_DR]    ; Get last phys. drive # in DL
              MOV    [DI + 4],DL          ; Store it in table
              INC    BYTE [LAST_LOG_DR]   ; Add 1 to last logical drive #
              MOV    AL,[LAST_LOG_DR]     ; Load it into AL
              MOV    [DI + 5],AL          ; Store it in table
              MOV    AH,8
              INT    13H                  ; Get disk drive parameters
              AND    CL,3FH               ; Mask sectors/track
              MOV    [DI + 13H],CL        ; Write sectors/track in BPB
              INC    DH                   ; Convert maximum head # to
                                          ;    # of heads
              MOV    [DI + 15H],DH        ; Write # of heads in BPB
              MOV    AX,[BX + SI + 8]     ; Get 1st partition sector in
              MOV    DX,[BX + SI + 0AH]   ;    DX:AX
              MOV    [DI + 17H],AX        ; Save in table as # of hidden
              MOV    [DI + 19H],DX        ;    sectors
              MOV    CX,[BX + SI + 6]     ; Get partition ending cyl.
              DB     0C0H,0E9H,6          ; SHR CL,6
              XCHG   CH,CL
              MOV    AX,[BX + SI + 2]     ; Get partition starting cyl.
              DB     0C0H,0E8H,6          ; SHR AL,6
              XCHG   AH,AL
              SUB    CX,AX                ; Difference + 1 is total # of
              INC    CX                   ;    cylinders in partition
              MOV    [DI + 25H],CX        ; Store # of cylinders in table
              MOV    [DI + 49H],AX        ; Store starting cyl. in table
              MOV    AX,[BX + SI + 0CH]   ; Get # of sectors in partition
              MOV    DX,[BX + SI + 0EH]   ;    in DX:AX
              XCHG   BX,DI                ; BX=table offset, DI=buffer
                                          ;    offset
              PUSH   SI                   ; Save SI for later
              MOV    SI,0Eh               ; Offset 8 of BPB in table
              OR     DX,DX                ; Sectors in partition > 65535?
              JZ     SMALLDRIVE           ; Store in offset 8 of BPB if so
              MOV    SI,1DH               ; Else, store in offsets 15h
              MOV    [BX + SI],DX         ;    and 17h (dword) of BPB
              DEC    SI
              DEC    SI
SMALLDRIVE    MOV    [BX + SI],AX         ; Store low word of # of sectors
              TEST   BYTE [BX + 1FH],40H  ; 12 or 16 bit FAT?
              JNZ    CALCFAT16            ; Jump for 16, continue for 12

; The following section calculates the size of the FAT in sectors for a
; 12 bit FAT, and the section following that, beginning at CALCFAT16,
; calculates the size of the FAT in sectors for a 16 bit FAT.  Both
; calculations end with common code beginning at ENDFATSIZE.  The 12 bit
; FAT size is calculated using the following formula:
;
;      size = 3 x (total sectors - hidden sectors - 10H)/2006H
;
; The 16 bit FAT size is calculated using the following formula:
;
;      size = (total sectors - hidden sectors - root directory sectors
;             + (sectors/cluster x 2))/((256 x sectors/cluster) + 2)
;
; Upon entry, DX:AX contains the total number of sectors in the partition,
; but the value in DX is ignored for the 12 bit FAT calculation because it
; is always 0.  Before calculating the FAT size, the cluster size must be
; calculated.  For a 12 bit FAT, this is always 8 sectors/cluster.

              MOV    BYTE [BX + 8],8      ; 12 bit cluster size = 8, store
                                          ;    it in table
                                          ; AX contains total # of sectors
              SUB    AX,[BX + 17H]        ; Subtract hidden sectors
              SUB    AX,10H               ; Subtract 10H (16 decimal)
              MOV    CX,3                 ; Multiply by 3
              MUL    CX
              MOV    CX,2006H             ; Divide by 2006H (8198 decimal)
              JMPS   ENDFATSIZE           ; Jump to common code
CALCFAT16     PUSH   DX                   ; Save high word of # of sectors
              OR     AX,AX                ; Calculate cluster size from:
              JNZ    EVEN64K              ;    size = (# of sectors)/64k
              INC    DX                   ;    (fractions are rounded up,
EVEN64K       CMP    DL,4                 ;    4k minimum cluster size)
              JNB    STORECLUSIZE
              MOV    DL,4
STORECLUSIZE  MOV    [BX + 8],DL          ; Store cluster size in table
              MOV    CX,DX                ; Transfer cluster size to CX
              POP    DX                   ; Retrieve high word of total
                                          ;    sectors in DX, low word is
                                          ;    in AX
              SUB    AX,[BX + 17H]        ; Subtract hidden sectors
              SBB    DX,[BX + 19H]
              SUB    AX,20H               ; Subtract root dir. sectors
              SBB    DX,0
              ADD    AX,CX                ; Add cluster size x 2
              ADC    DX,0
              ADD    AX,CX
              ADC    DX,0
              XCHG   CH,CL                ; Multiply cluster size by 256
                                          ;    for denominator (this works
                                          ;    because CH is always 0)
              ADD    CX,2                 ; Add 2 to denominator
ENDFATSIZE    DIV    CX                   ; Perform division
              OR     DX,DX                ; Round up any fraction to next
              JZ     STOREFATSIZE         ;    whole number
              INC    AX
STOREFATSIZE  MOV    [BX + 11H],AX        ; Store size of FAT in table
              PUSH   DI
              LEA    SI,[BX + 6]          ; Copy BPB info to 2nd BPB (BPB
              LEA    DI,[BX + 27H]        ;    for highest capacity
              MOV    CX,19H               ;    supported)
              REP
              MOVSB
              POP    DI
              POP    SI
              XCHG   BX,DI
              MOV    DH,[BX + SI + 1]     ; Get partition 1 starting hd.,
              MOV    CX,[BX + SI + 2]     ;    sector, and cylinder
              MOV    DL,[DI + 4]          ; Get drive # from table
              MOV    AX,0201H             ; Prepare to read 1 sector
              INT    13H                  ; Read partition 1 boot sector
              CMP    WORD [BX + 1FEH],0AA55H ; Is partition formatted?
              MOV    BX,DI                ; Get table offset back in BX
              JNE    ADDTABLE             ; Skip next section if partition
                                          ;    is unformatted
              ADD    DI,4BH               ; Copy volume label from boot
              MOV    SI,[BUFFERPTR]       ;    record to table
              ADD    SI,2BH
              MOV    CX,0BH
              REP
              MOVSB
              INC    DI                   ; Copy volume serial # from boot
              SUB    SI,0FH               ;    record to table
              MOV    CX,2
              REP
              MOVSW
              MOV    WORD [BX + 23H],21H  ; Set bit flags for drive
              MOV    DI,BX                ; Move table offset to DI
ADDTABLE      MOV    AX,0801H             ; Append table to chain of
              INT    2FH                  ;    tables
              MOV    BX,DI                ; Get table offset back in BX
              LEA    BP,[BX + 64H]        ; Point BP to buffer for DPB
              LEA    SI,[BX + 6]          ; Point SI to BPB in table
              MOV    AH,53H               ; Translate BPB to DPB
              INT    21H
              MOV    AX,[BX + 5]          ; Get logical drive #
              MOV    [BP],AX              ; Store it in DPB as drive #
              MOV    [BP + 1],AX          ; Store it in DPB as unit #
                                          ;    within device driver
              MOV    DX,BX                ; Save table offset in DX
              MOV    AH,52H               ; Get pointer to List of
              INT    21H                  ;    Lists (LoL) in ES:BX
              SEG    ES                   ; Get pointer to 1st DPB
              LDS    SI,[BX]              ;    in DS:SI
              LDS    DI,[SI + 13H]        ; Get far pointer to device
              SEG    CS                   ;    driver header in DS:DI
              MOV    [BP + 13H],DI        ; Store it in DPB
              SEG    CS
              MOV    [BP + 15H],DS
              MOV    AX,0FFFFH            ; Set pointer to next DPB to
              SEG    CS                   ;    FFFF:FFFF
              MOV    [BP + 19H],AX
              SEG    CS
              MOV    [BP + 1BH],AX
              XCHG   BX,DX                ; Get table offset back in BX
              SEG    CS                   ;    (save LoL pointer in DX)
              MOV    AL,[BX + 5]          ; Get logical drive number
              ADD    AL,41H               ; Convert to ASCII (0=A, etc.)
              XCHG   BX,DX                ; Get LoL pointer back in BX
              SEG    ES                   ; Get pointer to Current
              LDS    SI,[BX + 16H]        ;    Directory Structure (CDS)
NEXTCDS       CMP    AL,[SI]              ; Is this the right entry?
              JE     FOUNDCDS             ; Yes, exit loop
              ADD    SI,58H               ; No, go to next entry
              JMPS   NEXTCDS
FOUNDCDS      MOV    [SI + 45H],BP        ; Store DPB pointer in CDS
              MOV    [SI + 47H],CS
              SEG    ES                   ; Change # of blk devices
              INC    BYTE [BX + 20H]      ;    installed
              LDS    SI,[SI - 13H]        ; Change "pointer to next DPB"
              MOV    [SI + 19H],BP        ;    in previous DPB
              MOV    [SI + 1BH],CS
              MOV    BX,DX                ; Get table offset back in BX
              SUB    AL,41H               ; Convert ASCII drive to
              MOV    DL,AL                ;    logical drive # in DL
              MOV    AX,5F07H             ; Enable drive
              INT    21H
              ADD    BX,85H               ; Point BX to next table
ENDSETUP      POP    ES                   ; Restore ES and return to main
              RET                         ;    program

END           ENDP
